/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.Annotation;
import gov.noaa.pmel.sgt.dm.Annote;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;

public class AnnotationCartesianRenderer
extends CartesianRenderer {
    private Annotation data_ = null;

    public AnnotationCartesianRenderer(CartesianGraph cg, Annotation annotation, Attribute attr) {
        this.cg_ = cg;
        this.data_ = annotation;
    }

    @Override
    public Attribute getAttribute() {
        return null;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public SGTData getData() {
        return this.data_;
    }

    @Override
    public SGTData getDataAt(Point pt) {
        Rectangle bnds;
        Iterator iter;
        SGTData data = null;
        Annote note = null;
        if (this.data_.hasLine()) {
            iter = this.data_.getLineIterator();
            while (iter.hasNext()) {
                note = (Annote)iter.next();
                bnds = note.getBounds(this.cg_);
                if (!note.getBounds(this.cg_).contains(pt)) continue;
                return note;
            }
        }
        if (this.data_.hasPoint()) {
            iter = this.data_.getPointIterator();
            while (iter.hasNext()) {
                note = (Annote)iter.next();
                bnds = note.getBounds(this.cg_);
                if (!bnds.contains(pt)) continue;
                return note;
            }
        }
        if (this.data_.hasText()) {
            iter = this.data_.getTextIterator();
            while (iter.hasNext()) {
                note = (Annote)iter.next();
                bnds = note.getBounds(this.cg_);
                if (!bnds.contains(pt)) continue;
                return note;
            }
        }
        if (this.data_.hasOval()) {
            iter = this.data_.getOvalIterator();
            while (iter.hasNext()) {
                note = (Annote)iter.next();
                bnds = note.getBounds(this.cg_);
                if (!bnds.contains(pt)) continue;
                return note;
            }
        }
        if (this.data_.hasRect()) {
            iter = this.data_.getRectIterator();
            while (iter.hasNext()) {
                note = (Annote)iter.next();
                bnds = note.getBounds(this.cg_);
                if (!bnds.contains(pt)) continue;
                return note;
            }
        }
        return data;
    }

    @Override
    public void drawDynamicData(Graphics g) {
        if (this.data_.isDynamic()) {
            this.drawAnnotation(g);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (!this.data_.isDynamic()) {
            this.drawAnnotation(g);
        }
    }

    private void drawAnnotation(Graphics g) {
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.data_.hasLine()) {
            Iterator iter = this.data_.getLineIterator();
            while (iter.hasNext()) {
                Annote.Line pLine = (Annote.Line)iter.next();
                SGTLine line = pLine.getLine();
                LineAttribute attr = pLine.getAttribute();
                if (!attr.isVisible()) continue;
                this.renderLine(g2, line, attr);
            }
        }
        if (this.data_.hasPoint()) {
            Iterator iter = this.data_.getPointIterator();
            while (iter.hasNext()) {
                Annote.Point pPoint = (Annote.Point)iter.next();
                SGTPoint point = pPoint.getPoint();
                PointAttribute attr = pPoint.getAttribute();
                if (!attr.isVisible()) continue;
                this.renderPoint(g2, point, attr);
            }
        }
        if (this.data_.hasText()) {
            Iterator iter = this.data_.getTextIterator();
            while (iter.hasNext()) {
                Annote.Text pText = (Annote.Text)iter.next();
                SGLabel text = pText.getText();
                SoTPoint location = pText.getLocation();
                this.renderText(g2, location, text);
            }
        }
        if (this.data_.hasOval()) {
            Iterator iter = this.data_.getOvalIterator();
            while (iter.hasNext()) {
                Annote.Oval pOval = (Annote.Oval)iter.next();
                SoTPoint pt1 = pOval.getUpperLeft();
                SoTPoint pt2 = pOval.getLowerRight();
                LineAttribute attr = pOval.getLineAttribute();
                Color color = pOval.getFillColor();
                if (!attr.isVisible()) continue;
                this.renderOval(g2, pt1, pt2, attr, color);
            }
        }
        if (this.data_.hasRect()) {
            Iterator iter = this.data_.getRectIterator();
            while (iter.hasNext()) {
                Annote.Rect pRect = (Annote.Rect)iter.next();
                SoTPoint pt1 = pRect.getUpperLeft();
                SoTPoint pt2 = pRect.getLowerRight();
                LineAttribute attr = pRect.getLineAttribute();
                Color color = pRect.getFillColor();
                if (!attr.isVisible()) continue;
                this.renderRect(g2, pt1, pt2, attr, color);
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip(rect);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("AnnotationCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    private void renderOval(Graphics2D g2, SoTPoint pt1, SoTPoint pt2, LineAttribute attr, Color color) {
        Stroke stroke = this.getStrokeFromLineAttribute(attr);
        float xPt1 = (float)this.cg_.getXUtoD2(pt1.getX());
        float yPt1 = (float)this.cg_.getYUtoD2(pt1.getY());
        float xPt2 = (float)this.cg_.getXUtoD2(pt2.getX());
        float yPt2 = (float)this.cg_.getYUtoD2(pt2.getY());
        float width = xPt2 - xPt1;
        float height = yPt2 - yPt1;
        Ellipse2D.Float oval = new Ellipse2D.Float(xPt1, yPt1, width, height);
        Paint savedPaint = g2.getPaint();
        Stroke savedStroke = g2.getStroke();
        Color savedColor = g2.getColor();
        if (color != null) {
            g2.setPaint(color);
            g2.fill(oval);
        }
        if (stroke != null) {
            g2.setStroke(stroke);
            g2.setColor(attr.getColor());
            g2.draw(oval);
        }
        g2.setPaint(savedPaint);
        g2.setStroke(savedStroke);
        g2.setColor(savedColor);
    }

    private void renderRect(Graphics2D g2, SoTPoint pt1, SoTPoint pt2, LineAttribute attr, Color color) {
        Stroke stroke = this.getStrokeFromLineAttribute(attr);
        float xPt1 = (float)this.cg_.getXUtoD2(pt1.getX());
        float yPt1 = (float)this.cg_.getYUtoD2(pt1.getY());
        float xPt2 = (float)this.cg_.getXUtoD2(pt2.getX());
        float yPt2 = (float)this.cg_.getYUtoD2(pt2.getY());
        float width = xPt2 - xPt1;
        float height = yPt2 - yPt1;
        Rectangle2D.Float rect = new Rectangle2D.Float(xPt1, yPt1, width, height);
        Paint savedPaint = g2.getPaint();
        Stroke savedStroke = g2.getStroke();
        Color savedColor = g2.getColor();
        if (color != null) {
            g2.setPaint(color);
            g2.fill(rect);
        }
        if (stroke != null) {
            g2.setStroke(stroke);
            g2.setColor(attr.getColor());
            g2.draw(rect);
        }
        g2.setPaint(savedPaint);
        g2.setStroke(savedStroke);
        g2.setColor(savedColor);
    }

    private void renderLine(Graphics2D g2, SGTLine line, LineAttribute attr) {
        LineCartesianRenderer lcr = new LineCartesianRenderer(this.cg_, line, attr);
        lcr.draw(g2);
    }

    private void renderPoint(Graphics2D g, SGTPoint point, PointAttribute attr) {
        PointCartesianRenderer pcr = new PointCartesianRenderer(this.cg_, point, attr);
        pcr.draw(g);
    }

    private void renderText(Graphics2D g, SoTPoint loc, SGLabel text) {
        double xp = loc.getX().isTime() ? this.cg_.getXUtoP(loc.getX().getLongTime()) : this.cg_.getXUtoP(((Number)loc.getX().getObjectValue()).doubleValue());
        double yp = loc.getY().isTime() ? this.cg_.getYUtoP(loc.getY().getLongTime()) : this.cg_.getYUtoP(((Number)loc.getY().getObjectValue()).doubleValue());
        text.setLocationP(new Point2D.Double(xp, yp));
        text.setLayer(this.cg_.getLayer());
        try {
            text.draw(g);
        }
        catch (LayerNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private Stroke getStrokeFromLineAttribute(LineAttribute attr) {
        BasicStroke stroke = null;
        if (attr == null) {
            return stroke;
        }
        switch (attr.getStyle()) {
            case 2: {
                stroke = new BasicStroke(attr.getWidth());
                break;
            }
            case 1: {
                float[] dashes = new float[]{4.0f, 4.0f};
                stroke = new BasicStroke(1.0f, 2, 0, 10.0f, dashes, 0.0f);
                break;
            }
            case 6: {
                float[] arr = attr.getDashArray();
                if (arr == null || arr.length <= 1) {
                    stroke = new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit());
                    break;
                }
                stroke = new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit(), attr.getDashArray(), attr.getDashPhase());
                break;
            }
        }
        return stroke;
    }

    @Override
    public void removeData() {
        this.data_ = null;
    }
}

