/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AttributeChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public abstract class Attribute
implements Serializable {
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private boolean batch_ = false;
    private boolean local_ = true;
    private boolean modified_ = false;
    private boolean visible_ = true;
    protected String id_ = "";

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    public void setId(String id) {
        this.id_ = id;
    }

    public String getId() {
        return this.id_;
    }

    public void setBatch(boolean batch) {
        this.setBatch(batch, true);
    }

    public void setBatch(boolean batch, boolean local) {
        this.batch_ = batch;
        this.local_ = local;
        if (!batch && this.modified_) {
            this.firePropertyChange("batch", Boolean.TRUE, Boolean.FALSE);
        }
    }

    public boolean isBatch() {
        return this.batch_;
    }

    public void setVisible(boolean visible) {
        boolean save = this.visible_;
        this.visible_ = visible;
        this.firePropertyChange("visible", new Boolean(save), new Boolean(visible));
    }

    public boolean isVisible() {
        return this.visible_;
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.batch_) {
            this.modified_ = true;
            return;
        }
        AttributeChangeEvent ace = new AttributeChangeEvent(this, name, oldValue, newValue, this.local_);
        this.changes_.firePropertyChange(ace);
        this.modified_ = false;
    }

    protected void firePropertyChange(PropertyChangeEvent evt) {
        this.changes_.firePropertyChange(evt);
    }
}

