/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimeRange;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AxisTransform
implements Transform {
    protected PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final long serialVersionUID = -1577305732337537031L;
    protected double p1_;
    protected double p2_;
    protected double u1_;
    protected double u2_;
    protected long t1_;
    protected long t2_;
    protected boolean space_;
    protected String ident_;

    public AxisTransform() {
        this(0.0, 1.0, 0.0, 1.0);
    }

    public AxisTransform(double p1, double p2, double u1, double u2) {
        this.p1_ = p1;
        this.p2_ = p2;
        this.u1_ = u1;
        this.u2_ = u2;
        this.space_ = true;
        this.computeTransform();
        this.ident_ = "space transform";
    }

    public AxisTransform(Range2D pr, Range2D ur) {
        this(pr.start, pr.end, ur.start, ur.end);
    }

    public AxisTransform(double p1, double p2, GeoDate t1, GeoDate t2) {
        this.p1_ = p1;
        this.p2_ = p2;
        this.t1_ = t1.getTime();
        this.t2_ = t2.getTime();
        this.space_ = false;
        this.computeTransform();
        this.ident_ = "time transform";
    }

    public AxisTransform(double p1, double p2, long t1, long t2) {
        this.p1_ = p1;
        this.p2_ = p2;
        this.t1_ = t1;
        this.t2_ = t2;
        this.space_ = false;
        this.computeTransform();
        this.ident_ = "time transform";
    }

    public AxisTransform(Range2D pr, TimeRange tr) {
        this(pr.start, pr.end, tr.start, tr.end);
    }

    public AxisTransform(Range2D pr, SoTRange str) {
        if (str.isTime()) {
            this.t1_ = str.getStart().getLongTime();
            this.t2_ = str.getEnd().getLongTime();
            this.space_ = false;
        } else {
            this.u1_ = ((SoTRange.Double)str).start;
            this.u2_ = ((SoTRange.Double)str).end;
            this.space_ = true;
        }
        this.setRangeP(pr);
        this.computeTransform();
    }

    @Override
    public void setRangeP(double p1, double p2) {
        if (this.p1_ != p1 || this.p2_ != p2) {
            Range2D tempOld = new Range2D(this.p1_, this.p2_);
            this.p1_ = p1;
            this.p2_ = p2;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeP", tempOld, new Range2D(this.p1_, this.p2_));
        }
    }

    public void setId(String id) {
        this.ident_ = id;
    }

    public String getId() {
        return this.ident_;
    }

    @Override
    public void setRangeP(Range2D prange) {
        this.setRangeP(prange.start, prange.end);
    }

    @Override
    public Range2D getRangeP() {
        return new Range2D(this.p1_, this.p2_);
    }

    @Override
    public void setRangeU(double u1, double u2) {
        if (this.u1_ != u1 || this.u2_ != u2) {
            Range2D tempOld = new Range2D(this.u1_, this.u2_);
            this.u1_ = u1;
            this.u2_ = u2;
            this.space_ = true;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeU", tempOld, new Range2D(this.u1_, this.u2_));
        }
    }

    @Override
    public void setRangeU(Range2D urange) {
        this.setRangeU(urange.start, urange.end);
    }

    @Override
    public Range2D getRangeU() {
        return new Range2D(this.u1_, this.u2_);
    }

    public void setRangeU(GeoDate gt1, GeoDate gt2) {
        this.setRangeU(gt1.getTime(), gt2.getTime());
    }

    public void setRangeU(long t1, long t2) {
        if (this.t1_ != t1 || this.t2_ != t2) {
            SoTRange.Time tempOld = new SoTRange.Time(this.t1_, this.t2_);
            this.t1_ = t1;
            this.t2_ = t2;
            this.space_ = false;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeU", tempOld, new SoTRange.Time(this.t1_, this.t2_));
        }
    }

    public void setRangeU(TimeRange trange) {
        this.setRangeU(trange.start, trange.end);
    }

    public TimeRange getTimeRangeU() {
        return new TimeRange(new GeoDate(this.t1_), new GeoDate(this.t2_));
    }

    public void setRangeU(SoTRange str) {
        if (str.isTime()) {
            this.setRangeU(str.getStart().getLongTime(), str.getEnd().getLongTime());
        } else {
            this.setRangeU((Double)str.getStartObject(), (Double)str.getEndObject());
        }
    }

    public SoTRange getSoTRangeU() {
        if (this.space_) {
            return new SoTRange.Double(this.u1_, this.u2_);
        }
        return new SoTRange.Time(this.t1_, this.t2_);
    }

    public boolean isSpace() {
        return this.space_;
    }

    public boolean isTime() {
        return !this.space_;
    }

    abstract double getTransP(GeoDate var1);

    abstract double getTransP(long var1);

    abstract GeoDate getTimeTransU(double var1);

    abstract long getLongTimeTransU(double var1);

    abstract void computeTransform();

    abstract AxisTransform copy();

    public abstract double getTransP(SoTValue var1);

    public abstract SoTValue getSoTTransU(double var1);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }
}

