/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLevelsAccess;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.util.Range2D;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class CLIndexedColorMap
extends ColorMap
implements Cloneable,
PropertyChangeListener,
IndexedColor,
ContourLevelsAccess {
    protected Color[] colors_;
    protected ContourLevels cl_ = null;

    public CLIndexedColorMap(int[] red, int[] green, int[] blue) {
        this.colors_ = new Color[red.length];
        for (int indx = 0; indx < red.length; ++indx) {
            this.colors_[indx] = new Color(red[indx], green[indx], blue[indx]);
        }
    }

    public CLIndexedColorMap(float[] red, float[] green, float[] blue) {
        this.colors_ = new Color[red.length];
        for (int indx = 0; indx < red.length; ++indx) {
            this.colors_[indx] = new Color(red[indx], green[indx], blue[indx]);
        }
    }

    public CLIndexedColorMap(Color[] colors) {
        this.colors_ = colors;
    }

    @Override
    public ColorMap copy() {
        ColorMap newMap;
        try {
            newMap = (ColorMap)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newMap = new CLIndexedColorMap(this.colors_);
        }
        return newMap;
    }

    @Override
    public Color getColorByIndex(int indx) {
        int index = indx;
        if (index < 0) {
            index = 0;
        }
        if (index >= this.colors_.length) {
            index = this.colors_.length - 1;
        }
        return this.colors_[index];
    }

    public Color getColorByCLIndex(int indx) {
        if (this.cl_ != null) {
            try {
                return this.getColor(this.cl_.getLevel(indx));
            }
            catch (ContourLevelNotFoundException cfnf) {
                return this.colors_[this.colors_.length - 1];
            }
        }
        return Color.white;
    }

    @Override
    public Color getColor(double val) {
        double ival = val;
        int indx = this.cl_.getIndex(ival) + 1;
        if (indx < 0) {
            indx = 0;
        }
        if (indx > this.colors_.length - 1) {
            indx = this.colors_.length - 1;
        }
        return this.colors_[indx];
    }

    @Override
    public Range2D getRange() {
        return this.cl_.getRange();
    }

    @Override
    public void setColor(int index, Color colr) {
        this.setColor(index, colr.getRed(), colr.getGreen(), colr.getBlue());
    }

    @Override
    public void setColor(int indx, int red, int green, int blue) {
        if (indx < 0 || indx > this.colors_.length) {
            return;
        }
        Color newColor = new Color(red, green, blue);
        if (!this.colors_[indx].equals(newColor)) {
            Color tempOld = this.colors_[indx];
            this.colors_[indx] = newColor;
            this.firePropertyChange("color", tempOld, newColor);
        }
    }

    @Override
    public int getMaximumIndex() {
        return this.colors_.length - 1;
    }

    @Override
    public void setContourLevels(ContourLevels cl) {
        if (this.cl_ == null || !this.cl_.equals(cl)) {
            ContourLevels tempOld = this.cl_;
            this.cl_ = cl;
            this.firePropertyChange("contourLevels", tempOld, this.cl_);
        }
    }

    @Override
    public ContourLevels getContourLevels() {
        return this.cl_;
    }

    @Override
    public boolean equals(ColorMap cm) {
        if (cm == null || !(cm instanceof CLIndexedColorMap)) {
            return false;
        }
        if (this.cl_ == null || !this.cl_.equals(((CLIndexedColorMap)cm).cl_)) {
            return false;
        }
        if (this.colors_.length != ((CLIndexedColorMap)cm).colors_.length) {
            return false;
        }
        for (int i = 0; i < this.colors_.length; ++i) {
            if (this.colors_[i].equals(((CLIndexedColorMap)cm).colors_[i])) continue;
            return false;
        }
        return true;
    }
}

