/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.beans.MapTransform;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import java.util.Vector;

public class CartesianGraph
extends Graph {
    protected Vector xAxis_ = new Vector(2, 2);
    protected Vector yAxis_ = new Vector(2, 2);
    protected AxisTransform xTransform_;
    protected AxisTransform yTransform_;
    protected boolean clipping_ = false;
    protected Range2D xClipRange_;
    protected Range2D yClipRange_;
    protected SoTRange.Time tClipRange_;
    protected MapTransform mapTransform_ = null;
    private CartesianRenderer renderer_;

    public CartesianGraph() {
        this("");
    }

    public CartesianGraph(String id) {
        this(id, new LinearTransform(0.0, 1.0, 0.0, 1.0), new LinearTransform(0.0, 1.0, 0.0, 1.0));
    }

    public CartesianGraph(String id, AxisTransform xt, AxisTransform yt) {
        super(id);
        this.xTransform_ = xt;
        if (this.xTransform_ != null) {
            this.xTransform_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.xTransform_));
        }
        this.yTransform_ = yt;
        if (this.yTransform_ != null) {
            this.yTransform_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.yTransform_));
        }
    }

    @Override
    public Graph copy() {
        throw new MethodNotImplementedError();
    }

    public void setData(SGTData data, Attribute attr) {
        this.renderer_ = CartesianRenderer.getRenderer(this, data, attr);
        data.addPropertyChangeListener(new WeakPropertyChangeListener(this, data));
        data.setGraph(this);
    }

    public CartesianRenderer getRenderer() {
        return this.renderer_;
    }

    public void setRenderer(CartesianRenderer rend) {
        this.renderer_ = rend;
    }

    @Override
    public void drawDynamicData(Graphics g) {
        if (this.renderer_ != null) {
            this.renderer_.drawDynamicData(g);
        }
    }

    @Override
    public void draw(Graphics g) {
        Enumeration it;
        if (this.renderer_ != null) {
            this.renderer_.draw(g);
        }
        if (!this.xAxis_.isEmpty()) {
            it = this.xAxis_.elements();
            while (it.hasMoreElements()) {
                ((Axis)it.nextElement()).draw(g);
            }
        }
        if (!this.yAxis_.isEmpty()) {
            it = this.yAxis_.elements();
            while (it.hasMoreElements()) {
                ((Axis)it.nextElement()).draw(g);
            }
        }
    }

    public void setClip(double xmin, double xmax, double ymin, double ymax) {
        if (this.xTransform_.isSpace() && this.yTransform_.isSpace()) {
            this.clipping_ = true;
            this.xClipRange_ = new Range2D(xmin, xmax);
            this.yClipRange_ = new Range2D(ymin, ymax);
        } else {
            this.clipping_ = false;
        }
    }

    public void setClip(GeoDate tmin, GeoDate tmax, double min, double max) {
        if (this.xTransform_.isTime() || this.yTransform_.isTime()) {
            this.clipping_ = true;
            this.tClipRange_ = new SoTRange.Time(tmin.getTime(), tmax.getTime());
            if (this.xTransform_.isTime()) {
                this.yClipRange_ = new Range2D(min, max);
            } else {
                this.xClipRange_ = new Range2D(min, max);
            }
        } else {
            this.clipping_ = false;
        }
    }

    public void setClip(long tmin, long tmax, double min, double max) {
        if (this.xTransform_.isTime() || this.yTransform_.isTime()) {
            this.clipping_ = true;
            this.tClipRange_ = new SoTRange.Time(tmin, tmax);
            if (this.xTransform_.isTime()) {
                this.yClipRange_ = new Range2D(min, max);
            } else {
                this.xClipRange_ = new Range2D(min, max);
            }
        } else {
            this.clipping_ = false;
        }
    }

    public void setClip(SoTRange xr, SoTRange yr) {
        if (xr.isTime() || yr.isTime()) {
            SoTRange.Double dub;
            long tend;
            long tstart;
            if (xr.isTime()) {
                tstart = xr.getStart().getLongTime();
                tend = xr.getEnd().getLongTime();
                dub = (SoTRange.Double)yr;
            } else {
                tstart = yr.getStart().getLongTime();
                tend = yr.getEnd().getLongTime();
                dub = (SoTRange.Double)xr;
            }
            this.setClip(tstart, tend, dub.start, dub.end);
        } else {
            this.setClip(xr.getStart().getDouble(), xr.getEnd().getDouble(), yr.getStart().getDouble(), yr.getEnd().getDouble());
        }
    }

    public void setClipping(boolean clip) {
        this.clipping_ = clip;
    }

    public boolean isClipping() {
        return this.clipping_;
    }

    public void addXAxis(String id, Axis axis) {
        if (id.length() != 0) {
            axis.setId(id);
        }
        this.addXAxis(axis);
    }

    public void addXAxis(Axis axis) {
        axis.setOrientation(0);
        axis.setGraph(this);
        this.xAxis_.addElement(axis);
    }

    public Axis getXAxis(int index) {
        return (Axis)this.xAxis_.get(index);
    }

    public Axis getXAxis(String id) {
        if (!this.xAxis_.isEmpty()) {
            Enumeration it = this.xAxis_.elements();
            while (it.hasMoreElements()) {
                Axis ax = (Axis)it.nextElement();
                if (!ax.getId().equals(id)) continue;
                return ax;
            }
            return null;
        }
        return null;
    }

    public boolean removeXAxis(String id) {
        if (!this.xAxis_.isEmpty()) {
            Enumeration it = this.xAxis_.elements();
            while (it.hasMoreElements()) {
                Axis ax = (Axis)it.nextElement();
                if (!ax.getId().equals(id)) continue;
                return this.xAxis_.removeElement(ax);
            }
            return false;
        }
        return false;
    }

    public boolean removeXAxis(Axis axis) {
        if (!this.xAxis_.isEmpty()) {
            Enumeration it = this.xAxis_.elements();
            while (it.hasMoreElements()) {
                Axis ax = (Axis)it.nextElement();
                if (!ax.equals(axis)) continue;
                return this.xAxis_.removeElement(ax);
            }
            return false;
        }
        return false;
    }

    public void removeAllXAxes() {
        this.xAxis_.removeAllElements();
    }

    public int getNumberXAxis() {
        return this.xAxis_.size();
    }

    public Enumeration xAxisElements() {
        return this.xAxis_.elements();
    }

    public void addYAxis(String id, Axis axis) {
        if (id.length() != 0) {
            axis.setId(id);
        }
        this.addYAxis(axis);
    }

    public void addYAxis(Axis axis) {
        axis.setOrientation(1);
        axis.setGraph(this);
        this.yAxis_.addElement(axis);
    }

    public Axis getYAxis(int index) {
        return (Axis)this.yAxis_.get(index);
    }

    public Axis getYAxis(String id) {
        if (!this.yAxis_.isEmpty()) {
            Enumeration it = this.yAxis_.elements();
            while (it.hasMoreElements()) {
                Axis ax = (Axis)it.nextElement();
                if (!ax.getId().equals(id)) continue;
                return ax;
            }
            return null;
        }
        return null;
    }

    public boolean removeYAxis(String id) {
        if (!this.yAxis_.isEmpty()) {
            Enumeration it = this.yAxis_.elements();
            while (it.hasMoreElements()) {
                Axis ax = (Axis)it.nextElement();
                if (!ax.getId().equals(id)) continue;
                return this.yAxis_.removeElement(ax);
            }
            return false;
        }
        return false;
    }

    public boolean removeYAxis(Axis axis) {
        if (!this.yAxis_.isEmpty()) {
            Enumeration it = this.yAxis_.elements();
            while (it.hasMoreElements()) {
                Axis ax = (Axis)it.nextElement();
                if (!ax.equals(axis)) continue;
                return this.yAxis_.removeElement(ax);
            }
            return false;
        }
        return false;
    }

    public void removeAllYAxes() {
        this.yAxis_.removeAllElements();
    }

    public int getNumberYAxis() {
        return this.yAxis_.size();
    }

    public Enumeration yAxisElements() {
        return this.yAxis_.elements();
    }

    public void setXTransform(AxisTransform xfrm) {
        this.xTransform_ = xfrm;
        this.xTransform_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.xTransform_));
    }

    public AxisTransform getXTransform() {
        return this.xTransform_;
    }

    public void setYTransform(AxisTransform xfrm) {
        this.yTransform_ = xfrm;
        this.yTransform_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.yTransform_));
    }

    public AxisTransform getYTransform() {
        return this.yTransform_;
    }

    @Override
    Object getObjectAt(Point pt) {
        SGLabel lab;
        Rectangle bnds;
        Axis ax;
        Enumeration it;
        if (!this.xAxis_.isEmpty()) {
            it = this.xAxis_.elements();
            while (it.hasMoreElements()) {
                ax = (Axis)it.nextElement();
                bnds = ax.getBounds();
                if (bnds.contains(pt)) {
                    return ax;
                }
                lab = ax.getTitle();
                if (lab == null || lab.getLayer() == null || !(bnds = lab.getBounds()).contains(pt)) continue;
                return lab;
            }
        }
        if (!this.yAxis_.isEmpty()) {
            it = this.yAxis_.elements();
            while (it.hasMoreElements()) {
                ax = (Axis)it.nextElement();
                bnds = ax.getBounds();
                if (bnds.contains(pt)) {
                    return ax;
                }
                lab = ax.getTitle();
                if (lab == null || !(bnds = lab.getBounds()).contains(pt)) continue;
                return lab;
            }
        }
        return null;
    }

    public double getXUtoP(double u) {
        return this.xTransform_.getTransP(u);
    }

    public int getXUtoD(double u) {
        if (Double.isNaN(u)) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getXPtoD(this.xTransform_.getTransP(u));
    }

    public double getXUtoD2(double u) {
        if (Double.isNaN(u)) {
            return u;
        }
        return this.getLayer().getXPtoD2(this.xTransform_.getTransP(u));
    }

    public double getXUtoP(GeoDate t) {
        return this.xTransform_.getTransP(t);
    }

    public double getXUtoP(long t) {
        return this.xTransform_.getTransP(t);
    }

    public int getXUtoD(GeoDate t) {
        if (t == null) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getXPtoD(this.xTransform_.getTransP(t));
    }

    public int getXUtoD(long t) {
        if (t == Long.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getXPtoD(this.xTransform_.getTransP(t));
    }

    public double getXUtoD2(GeoDate t) {
        if (t == null) {
            return Double.NaN;
        }
        return this.getLayer().getXPtoD2(this.xTransform_.getTransP(t));
    }

    public double getXUtoD2(long t) {
        if (t == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return this.getLayer().getXPtoD2(this.xTransform_.getTransP(t));
    }

    public int getXUtoD(SoTValue val) {
        if (val.isTime()) {
            return this.getXUtoD(val.getLongTime());
        }
        return this.getXUtoD(((SoTValue.Double)val).getValue());
    }

    public int getYUtoD(SoTValue val) {
        if (val.isTime()) {
            return this.getYUtoD(val.getLongTime());
        }
        return this.getYUtoD(((SoTValue.Double)val).getValue());
    }

    public double getXUtoD2(SoTValue val) {
        if (val.isTime()) {
            return this.getXUtoD2(val.getLongTime());
        }
        return this.getXUtoD2(((SoTValue.Double)val).getValue());
    }

    public double getYUtoD2(SoTValue val) {
        if (val.isTime()) {
            return this.getYUtoD2(val.getLongTime());
        }
        return this.getYUtoD2(((SoTValue.Double)val).getValue());
    }

    public double getXUtoP(SoTValue val) {
        if (val.isTime()) {
            return this.getXUtoP(val.getLongTime());
        }
        return this.getXUtoP(((SoTValue.Double)val).getValue());
    }

    public double getYUtoP(SoTValue val) {
        if (val.isTime()) {
            return this.getYUtoP(val.getLongTime());
        }
        return this.getYUtoP(((SoTValue.Double)val).getValue());
    }

    public SoTValue getXPtoSoT(double p) {
        if (this.xTransform_.isTime()) {
            return new SoTValue.Time(this.xTransform_.getLongTimeTransU(p));
        }
        return new SoTValue.Double(this.xTransform_.getTransU(p));
    }

    public double getXPtoU(double p) {
        return this.xTransform_.getTransU(p);
    }

    public GeoDate getXPtoTime(double p) {
        return this.xTransform_.getTimeTransU(p);
    }

    public long getXPtoLongTime(double p) {
        return this.xTransform_.getLongTimeTransU(p);
    }

    public SoTPoint getPtoU(Point2D.Double loc) {
        SoTValue xv = this.xTransform_.isTime() ? new SoTValue.Time(this.getXPtoLongTime(loc.x)) : new SoTValue.Double(this.getXPtoU(loc.x));
        SoTValue yv = this.yTransform_.isTime() ? new SoTValue.Time(this.getYPtoLongTime(loc.y)) : new SoTValue.Double(this.getYPtoU(loc.y));
        return new SoTPoint(xv, yv);
    }

    public double getYUtoP(double u) {
        return this.yTransform_.getTransP(u);
    }

    public int getYUtoD(double u) {
        if (Double.isNaN(u)) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getYPtoD(this.yTransform_.getTransP(u));
    }

    public double getYUtoD2(double u) {
        if (Double.isNaN(u)) {
            return u;
        }
        return this.getLayer().getYPtoD2(this.yTransform_.getTransP(u));
    }

    public double getYUtoP(GeoDate t) {
        return this.yTransform_.getTransP(t);
    }

    public double getYUtoP(long t) {
        if (t == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return this.yTransform_.getTransP(t);
    }

    public int getYUtoD(GeoDate t) {
        if (t == null) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getYPtoD(this.yTransform_.getTransP(t));
    }

    public int getYUtoD(long t) {
        if (t == Long.MAX_VALUE) {
            return Integer.MIN_VALUE;
        }
        return this.getLayer().getYPtoD(this.yTransform_.getTransP(t));
    }

    public double getYUtoD2(GeoDate t) {
        if (t == null) {
            return Double.NaN;
        }
        return this.getLayer().getYPtoD2(this.yTransform_.getTransP(t));
    }

    public double getYUtoD2(long t) {
        if (t == Long.MAX_VALUE) {
            return Double.NaN;
        }
        return this.getLayer().getYPtoD2(this.yTransform_.getTransP(t));
    }

    public SoTValue getYPtoSoT(double p) {
        if (this.yTransform_.isTime()) {
            return new SoTValue.Time(this.yTransform_.getLongTimeTransU(p));
        }
        return new SoTValue.Double(this.yTransform_.getTransU(p));
    }

    public double getYPtoU(double p) {
        return this.yTransform_.getTransU(p);
    }

    public GeoDate getYPtoTime(double p) {
        return this.yTransform_.getTimeTransU(p);
    }

    public long getYPtoLongTime(double p) {
        return this.yTransform_.getLongTimeTransU(p);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dynamicDataModified")) {
            this.dynamicModified("CartesianGraph: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
        } else {
            this.modified("CartesianGraph: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
        }
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return this.renderer_.getDataAt(pt);
    }

    public Rectangle getBounds() {
        Range2D xRange = this.xTransform_.getRangeP();
        Range2D yRange = this.yTransform_.getRangeP();
        int x = this.layer_.getXPtoD(xRange.start);
        int y = this.layer_.getYPtoD(yRange.end);
        int width = this.layer_.getXPtoD(xRange.end) - x;
        int height = this.layer_.getYPtoD(yRange.start) - y;
        return new Rectangle(x, y, width, height);
    }

    public SoTDomain getDomain() {
        SoTRange xRange = this.xTransform_.getSoTRangeU();
        SoTRange yRange = this.yTransform_.getSoTRangeU();
        return new SoTDomain(xRange, yRange);
    }

    public boolean isMapTransform() {
        return this.mapTransform_ != null;
    }

    public MapTransform getMapTransform() {
        return this.mapTransform_;
    }

    public void setMapTransform(MapTransform mapTransform) {
        this.mapTransform_ = mapTransform;
    }
}

