/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.AnnotationCartesianRenderer;
import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.GeometryAttribute;
import gov.noaa.pmel.sgt.GeometryCartesianRenderer;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.VectorCartesianRenderer;
import gov.noaa.pmel.sgt.dm.Annotation;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.GeometryCollection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGeometry;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTPoint;
import gov.noaa.pmel.sgt.dm.SGTVector;
import java.awt.Graphics;
import java.awt.Point;
import java.beans.PropertyChangeListener;

public abstract class CartesianRenderer
implements PropertyChangeListener {
    protected CartesianGraph cg_;

    public static CartesianRenderer getRenderer(CartesianGraph cg, SGTData dmo, Attribute attr) {
        if (dmo instanceof SGTPoint) {
            return new PointCartesianRenderer(cg, (SGTPoint)dmo, (PointAttribute)attr);
        }
        if (dmo instanceof SGTLine) {
            return new LineCartesianRenderer(cg, (SGTLine)dmo, (LineAttribute)attr);
        }
        if (dmo instanceof SGTGrid) {
            return new GridCartesianRenderer(cg, (SGTGrid)dmo, (GridAttribute)attr);
        }
        if (dmo instanceof SGTVector) {
            return new VectorCartesianRenderer(cg, (SGTVector)dmo, (VectorAttribute)attr);
        }
        if (dmo instanceof SGTGeometry) {
            GeometryCollection gc = new GeometryCollection("Wrapper for Geometry Object");
            gc.add((SGTGeometry)dmo);
            return new GeometryCartesianRenderer(cg, gc, (GeometryAttribute)attr);
        }
        if (dmo instanceof Collection) {
            Object fe = ((Collection)dmo).firstElement();
            if (fe instanceof SGTPoint) {
                return new PointCartesianRenderer(cg, (Collection)dmo, (PointAttribute)attr);
            }
            if (fe instanceof SGTGeometry) {
                return new GeometryCartesianRenderer(cg, (GeometryCollection)dmo, (GeometryAttribute)attr);
            }
            if (fe instanceof SGTLine) {
                return new LineCartesianRenderer(cg, (Collection)dmo, (LineAttribute)attr);
            }
            if (fe instanceof SGTVector) {
                return new VectorCartesianRenderer(cg, (Collection)dmo, (VectorAttribute)attr);
            }
        } else if (dmo instanceof Annotation) {
            return new AnnotationCartesianRenderer(cg, (Annotation)dmo, null);
        }
        return null;
    }

    public abstract void drawDynamicData(Graphics var1);

    public abstract void draw(Graphics var1);

    public abstract Attribute getAttribute();

    public abstract CartesianGraph getCartesianGraph();

    public JPane getPane() {
        return this.cg_.getPane();
    }

    public void modified(String mess) {
        if (this.cg_ != null) {
            this.cg_.modified(mess);
        }
    }

    public void dynamicModified(String mess) {
        if (this.cg_ != null) {
            this.cg_.dynamicModified(mess);
        }
    }

    public SGTData getDataAt(int x, int y) {
        return this.getDataAt(new Point(x, y));
    }

    public abstract SGTData getDataAt(Point var1);

    public abstract SGTData getData();

    public abstract void removeData();
}

