/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Ruler;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class ColorKey
implements Cloneable,
DataKey,
PropertyChangeListener {
    private SGLabel title_ = null;
    private String ident_;
    private Layer layer_;
    private Ruler scale_ = new Ruler();
    private int valign_;
    private int halign_;
    private int orient_;
    private int style_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private Point2D.Double porigin_;
    private Dimension2D psize_;
    private double[] insets_ = new double[]{0.05, 0.15, 0.05, 0.15};
    private double barWidth_ = 0.2;
    private ColorMap cm_ = null;
    public static final int PLAIN_LINE = 0;
    public static final int RAISED = 1;
    public static final int NO_BORDER = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;

    public ColorKey() {
        this(new Rectangle2D.Double(), 2, 0);
    }

    public ColorKey(Rectangle2D.Double pr, int valign, int halign) {
        this(new Point2D.Double(pr.x, pr.y), new Dimension2D(pr.width, pr.height), valign, halign);
    }

    public ColorKey(Point2D.Double pt, Dimension2D size, int valign, int halign) {
        this.porigin_ = pt;
        this.psize_ = size;
        this.valign_ = valign;
        this.halign_ = halign;
        this.orient_ = 1;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.style_ = 0;
    }

    @Override
    public LayerChild copy() {
        ColorKey newKey;
        try {
            newKey = (ColorKey)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newKey = new ColorKey();
        }
        return newKey;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public JPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    public void setColorMap(ColorMap cm) {
        if (this.cm_ == null || !this.cm_.equals(cm)) {
            this.cm_ = cm;
            if (this.cm_ != null) {
                this.cm_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.cm_));
                this.modified("ColorKey: setColorMap()");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addGraph(CartesianRenderer rend, SGLabel label) throws IllegalArgumentException {
        ColorMap cm = null;
        if (rend instanceof GridCartesianRenderer) {
            GridAttribute ga = (GridAttribute)((GridCartesianRenderer)rend).getAttribute();
            cm = ga.getColorMap();
        } else {
            if (!(rend instanceof LineCartesianRenderer)) throw new IllegalArgumentException("Renderer is not a GridCartesianRenderer");
            if (!((SGTLine)((LineCartesianRenderer)rend).getData()).hasAssociatedData()) throw new IllegalArgumentException("Renderer is not a GridCartesianRenderer");
            LineAttribute la = (LineAttribute)((LineCartesianRenderer)rend).getAttribute();
            cm = la.getAssociatedDataCmap();
        }
        if (cm == null) {
            return;
        }
        this.setColorMap(cm);
        this.setTitle(label);
    }

    @Override
    public void removeGraph(CartesianRenderer rend) throws IllegalArgumentException {
    }

    public ColorMap getColorMap() {
        return this.cm_;
    }

    @Override
    public void setBorderStyle(int style) {
        if (this.style_ != style) {
            this.style_ = style;
            this.modified("LineKey: setBorderStyle()");
        }
    }

    public int getBorderStyle() {
        return this.style_;
    }

    @Override
    public void setAlign(int vert, int horz) {
        if (this.valign_ != vert || this.halign_ != horz) {
            this.valign_ = vert;
            this.halign_ = horz;
            this.modified("ColorKey: setAlign()");
        }
    }

    public void setOrientation(int orient) {
        if (this.orient_ != orient) {
            this.orient_ = orient;
            this.modified("ColorKey: setOrientation()");
        }
    }

    public int getOrientation() {
        return this.orient_;
    }

    @Override
    public void setVAlign(int vert) {
        if (this.valign_ != vert) {
            this.valign_ = vert;
            this.modified("ColorKey: setVAlign()");
        }
    }

    @Override
    public void setHAlign(int horz) {
        if (this.halign_ != horz) {
            this.halign_ = horz;
            this.modified("ColorKey: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    @Override
    public void setLocationP(Point2D.Double loc) {
        if (this.porigin_.x != loc.x || this.porigin_.y != loc.y) {
            this.porigin_.x = loc.x;
            this.porigin_.y = loc.y;
            this.modified("ColorKey: setLocationP()");
        }
    }

    public void setSizeP(Dimension2D d) {
        if (this.psize_.width != d.width || this.psize_.height != d.height) {
            this.psize_.width = d.width;
            this.psize_.height = d.height;
            this.modified("ColorKey: setSizeP()");
        }
    }

    @Override
    public void setBoundsP(Rectangle2D.Double r) {
        this.setLocationP(new Point2D.Double(r.x, r.y));
        this.setSizeP(new Dimension2D(r.width, r.height));
    }

    public Rectangle2D.Double getBoundsP() {
        return new Rectangle2D.Double(this.porigin_.x, this.porigin_.y, this.psize_.width, this.psize_.height);
    }

    @Override
    public Rectangle getBounds() {
        int x = this.layer_.getXPtoD(this.porigin_.x);
        int y = this.layer_.getYPtoD(this.porigin_.y);
        int width = this.layer_.getXPtoD(this.porigin_.x + this.psize_.width) - x;
        int height = this.layer_.getYPtoD(this.porigin_.y - this.psize_.height) - y;
        switch (this.halign_) {
            case 2: {
                x -= width;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y -= height;
                break;
            }
            case 1: {
                y -= height / 2;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        switch (this.halign_) {
            case 2: {
                x += width;
                break;
            }
            case 1: {
                x += width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y += height;
                break;
            }
            case 1: {
                y += height / 2;
            }
        }
        double xp = this.layer_.getXDtoP(x);
        double yp = this.layer_.getYDtoP(y);
        if (this.porigin_.x != xp || this.porigin_.y != yp) {
            this.porigin_.x = xp;
            this.porigin_.y = yp;
            this.modified("ColorKey: setBounds()");
        }
    }

    public void setTitle(SGLabel title) {
        if (this.title_ == null || !this.title_.equals(title)) {
            this.title_ = title;
            this.modified("ColorKey: setTitle()");
        }
    }

    public SGLabel getTitle() {
        return this.title_;
    }

    public Ruler getRuler() {
        return this.scale_;
    }

    @Override
    public void draw(Graphics g) {
        double delta;
        if (!this.visible_) {
            return;
        }
        double ptop = this.insets_[0];
        double pbottom = this.insets_[2];
        double pleft = this.insets_[1];
        double pright = this.insets_[3];
        double xp = this.porigin_.x;
        double yp = this.porigin_.y;
        switch (this.halign_) {
            case 2: {
                xp -= this.psize_.width;
                break;
            }
            case 1: {
                xp -= this.psize_.width / 2.0;
            }
        }
        switch (this.valign_) {
            case 0: {
                yp -= this.psize_.height;
                break;
            }
            case 1: {
                yp -= this.psize_.height / 2.0;
            }
        }
        Rectangle bounds = this.getBounds();
        g.setColor(Color.black);
        switch (this.style_) {
            case 0: {
                g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                break;
            }
            case 1: {
                break;
            }
        }
        if (this.cm_ == null) {
            return;
        }
        Range2D uRange = this.cm_.getRange();
        if (Double.isNaN(uRange.delta)) {
            Range2D rnge = Graph.computeRange(uRange.start, uRange.end, 10);
            delta = rnge.delta;
        } else {
            delta = uRange.delta;
        }
        if (this.orient_ == 1) {
            this.drawBar(g, xp + pleft, yp + this.psize_.height - ptop, this.psize_.width - pleft - pright, this.psize_.height - ptop - pbottom);
            this.scale_.setOrientation(1);
            this.scale_.setLayer(this.layer_);
            this.scale_.setTitle(this.title_);
            this.scale_.setTicPosition(1);
            this.scale_.setLabelPosition(1);
            this.scale_.setBoundsP(new Rectangle2D.Double(xp + pleft, yp + this.psize_.height - ptop - this.barWidth_, this.psize_.width - pleft - pright, this.psize_.height - ptop - pbottom));
            this.scale_.setRangeU(new Range2D(uRange.start, uRange.end, delta));
            this.scale_.draw(g);
        } else {
            this.drawBar(g, xp + pleft, yp + pbottom, this.psize_.width - pleft - pright, this.psize_.height - ptop - pbottom);
            this.scale_.setOrientation(2);
            this.scale_.setLayer(this.layer_);
            this.scale_.setTitle(this.title_);
            this.scale_.setTicPosition(0);
            this.scale_.setLabelPosition(0);
            this.scale_.setBoundsP(new Rectangle2D.Double(xp + pleft + this.barWidth_, yp + pbottom, this.psize_.width - pleft - pright, this.psize_.height - ptop - pbottom));
            this.scale_.setRangeU(new Range2D(uRange.start, uRange.end, delta));
            this.scale_.draw(g);
        }
    }

    void drawBar(Graphics g, double plocx, double plocy, double pwidth, double pheight) {
        Range2D uRange = this.cm_.getRange();
        if (this.orient_ == 1) {
            int dBarHeight = this.layer_.getYPtoD(plocy - this.barWidth_) - this.layer_.getYPtoD(plocy);
            LinearTransform sTrans = new LinearTransform(plocx, plocx + pwidth, uRange.start, uRange.end);
            int yloc = this.layer_.getYPtoD(plocy);
            int xloc = this.layer_.getXPtoD(sTrans.getTransP(uRange.start));
            int xend = this.layer_.getXPtoD(sTrans.getTransP(uRange.end));
            for (int i = xloc; i <= xend; ++i) {
                g.setColor(this.cm_.getColor(sTrans.getTransU(this.layer_.getXDtoP(i))));
                g.fillRect(i, yloc, 1, dBarHeight);
            }
        } else {
            int yend;
            int dBarWidth = this.layer_.getXPtoD(plocx + this.barWidth_) - this.layer_.getXPtoD(plocx);
            LinearTransform sTrans = new LinearTransform(plocy, plocy + pheight, uRange.start, uRange.end);
            int xloc = this.layer_.getXPtoD(plocx);
            int yloc = this.layer_.getYPtoD(sTrans.getTransP(uRange.start));
            for (int i = yend = this.layer_.getYPtoD(sTrans.getTransP(uRange.end)); i <= yloc; ++i) {
                g.setColor(this.cm_.getColor(sTrans.getTransU(this.layer_.getYDtoP(i))));
                g.fillRect(xloc, i, dBarWidth, 1);
            }
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible_ != visible) {
            this.visible_ = visible;
            this.modified("ColorKey: setVisible()");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("ColorKey: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public void setColumns(int col) {
    }

    @Override
    public void setLineLengthP(double len) {
    }

    @Override
    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }
}

