/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.GeometryParameterAttribute;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.dm.GeometryParameter;
import java.awt.Color;
import java.awt.Font;

public class GeometryAttribute
extends Attribute {
    private int fillMark_ = 45;
    private double fillMarkHeightP_ = 0.1;
    private boolean markOutline_ = false;
    private Color markOutlineColor_ = Color.black;
    private Color defaultFillColor_ = Color.lightGray;
    private ColorMap fillColor_ = null;
    private boolean drawOutline_ = true;
    private LineAttribute outlineAttr_ = new LineAttribute(0, Color.black);
    private boolean drawLabel_ = false;
    private int labelPosition_ = 2;
    private Font labelFont_ = null;
    private Color labelColor_ = Color.black;
    private double labelHeightP_ = 0.1;
    private Color boxColor_ = new Color(1.0f, 1.0f, 1.0f, 0.8f);
    private double boxGrowBy_ = 0.2;
    private boolean drawBox_ = false;
    private boolean geometrySimplified_ = false;
    private double simplifyDistanceTolerance_ = -1.0;
    private GeometryParameter[] gParameter_;
    private GeometryParameterAttribute[] gpAttribute_;
    public static final int CENTERED = 0;
    public static final int N = 1;
    public static final int NE = 2;
    public static final int E = 3;
    public static final int SE = 4;
    public static final int S = 5;
    public static final int SW = 6;
    public static final int W = 7;
    public static final int NW = 8;

    public GeometryAttribute() {
    }

    public GeometryAttribute(ColorMap cmap) {
        this.fillColor_ = cmap;
    }

    public GeometryAttribute(ColorMap cmap, LineAttribute outline) {
        this(cmap);
        this.outlineAttr_ = outline;
    }

    public GeometryAttribute(Color fill) {
        this.defaultFillColor_ = fill;
    }

    public GeometryAttribute(Color fill, LineAttribute outline) {
        this(fill);
        this.outlineAttr_ = outline;
    }

    public GeometryAttribute(int mark) {
        this.fillMark_ = mark;
    }

    public GeometryAttribute(GeometryParameter[] gParam, GeometryParameterAttribute[] gTrans) {
        if (gParam.length != gTrans.length) {
            throw new IllegalArgumentException("Arrays must be the same length.");
        }
        this.gParameter_ = gParam;
        this.gpAttribute_ = gTrans;
    }

    public GeometryAttribute copy() {
        GeometryAttribute newGeom;
        try {
            newGeom = (GeometryAttribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGeom = new GeometryAttribute();
        }
        return newGeom;
    }

    public GeometryParameter[] getGeometryParameters() {
        return this.gParameter_;
    }

    public GeometryParameterAttribute[] getGeometryParameterAttributes() {
        return this.gpAttribute_;
    }

    public GeometryParameterAttribute getGeometryParameterAttribute(GeometryParameter gParam) {
        return this.gpAttribute_[this.findGeometryParameterIndex(gParam)];
    }

    public int getGeometryParameterAttributeSize() {
        if (this.gpAttribute_ == null) {
            return 0;
        }
        return this.gpAttribute_.length;
    }

    public int findGeometryParameterIndex(GeometryParameter gParam) {
        for (int i = 0; i < this.gParameter_.length; ++i) {
            if (this.gParameter_[i] != gParam) continue;
            return i;
        }
        return -1;
    }

    public void setGeometryParameterAttribute(GeometryParameter gParam, GeometryParameterAttribute gpAttr) {
        int index = this.findGeometryParameterIndex(gParam);
        GeometryParameterAttribute gpOld = null;
        if (index < 0) {
            throw new IllegalArgumentException("GeometryParameter not found.");
        }
        gpOld = this.gpAttribute_[index];
        if (gpOld == null || !gpOld.equals(gpAttr)) {
            this.gpAttribute_[index] = gpAttr;
            this.firePropertyChange("GeometryParameterAttribute", gpOld, gpAttr);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GeometryAttribute)) {
            return false;
        }
        GeometryAttribute attr = (GeometryAttribute)obj;
        if (!this.id_.equals(attr.getId()) || !this.defaultFillColor_.equals(attr.getDefaultFillColor()) || this.fillMark_ != attr.getFillMark() || this.fillMarkHeightP_ != attr.getFillMarkHeightP() || this.drawOutline_ != attr.isDrawOutline() || this.drawLabel_ != attr.isDrawLabel()) {
            return false;
        }
        if (this.fillColor_ != null && !this.fillColor_.equals(attr.getFillColor())) {
            return false;
        }
        if (this.drawOutline_ && !this.outlineAttr_.equals(attr.getOutlineAttribute())) {
            return false;
        }
        if (this.drawLabel_) {
            if (this.labelFont_ == null) {
                if (attr.getLabelFont() != null) {
                    return false;
                }
            } else {
                if (attr.getLabelFont() == null) {
                    return false;
                }
                if (!this.labelFont_.equals(attr.getLabelFont())) {
                    return false;
                }
            }
            if (this.labelColor_ == null) {
                if (attr.getLabelColor() != null) {
                    return false;
                }
            } else {
                if (attr.getLabelColor() == null) {
                    return false;
                }
                if (!this.labelColor_.equals(attr.getLabelColor())) {
                    return false;
                }
            }
            if (this.labelPosition_ != attr.getLabelPosition() || this.labelHeightP_ != attr.getLabelHeightP()) {
                return false;
            }
        }
        if (this.gpAttribute_.length > 0) {
            if (this.gpAttribute_.length != attr.getGeometryParameterAttributeSize()) {
                return false;
            }
            for (int i = 0; i < this.gParameter_.length; ++i) {
                GeometryParameter gParam = this.gParameter_[i];
                if (this.gpAttribute_[i].equals(attr.getGeometryParameterAttribute(gParam))) continue;
                return false;
            }
        }
        return true;
    }

    public Color getDefaultFillColor() {
        return this.defaultFillColor_;
    }

    public boolean isDrawLabel() {
        return this.drawLabel_;
    }

    public boolean isDrawOutline() {
        return this.drawOutline_;
    }

    public ColorMap getFillColor() {
        return this.fillColor_;
    }

    public int getFillMark() {
        return this.fillMark_;
    }

    public Color getLabelColor() {
        return this.labelColor_;
    }

    public Font getLabelFont() {
        return this.labelFont_;
    }

    public double getLabelHeightP() {
        return this.labelHeightP_;
    }

    public int getLabelPosition() {
        return this.labelPosition_;
    }

    public LineAttribute getOutlineAttribute() {
        return this.outlineAttr_;
    }

    public void setDefaultFillColor(Color c) {
        if (!this.defaultFillColor_.equals(c)) {
            Color tempOld = this.defaultFillColor_;
            this.defaultFillColor_ = c;
            this.firePropertyChange("defaultFillColor", tempOld, this.defaultFillColor_);
        }
    }

    public void setDrawLabel(boolean dl) {
        if (this.drawLabel_ != dl) {
            Boolean tempOld = new Boolean(this.drawLabel_);
            this.drawLabel_ = dl;
            this.firePropertyChange("drawLabel", tempOld, new Boolean(this.drawLabel_));
        }
    }

    public void setDrawOutline(boolean draw) {
        if (this.drawOutline_ != draw) {
            Boolean tempOld = new Boolean(this.drawOutline_);
            this.drawOutline_ = draw;
            this.firePropertyChange("drawOutline", tempOld, new Boolean(this.drawOutline_));
        }
    }

    public void setFillColor(ColorMap cmap) {
        if (this.fillColor_ == null || !this.fillColor_.equals(cmap)) {
            ColorMap tempOld = this.fillColor_;
            this.fillColor_ = cmap;
            this.firePropertyChange("fillColor", tempOld, this.fillColor_);
        }
    }

    public void setFillMark(int mark) {
        if (this.fillMark_ != mark) {
            Integer tempOld = new Integer(this.fillMark_);
            this.fillMark_ = mark;
            this.firePropertyChange("fillMark", tempOld, new Integer(this.fillMark_));
        }
    }

    public void setLabelColor(Color c) {
        if (!this.labelColor_.equals(c)) {
            Color tempOld = this.labelColor_;
            this.labelColor_ = c;
            this.firePropertyChange("labelColor", tempOld, this.labelColor_);
        }
    }

    public void setLabelFont(Font font) {
        if (this.labelFont_ == null || !this.labelFont_.equals(font)) {
            Font tempOld = this.labelFont_;
            this.labelFont_ = font;
            this.firePropertyChange("labelFont", tempOld, this.labelFont_);
        }
    }

    public void setLabelHeightP(double hght) {
        if (this.labelHeightP_ != hght) {
            Double tempOld = new Double(this.labelHeightP_);
            this.labelHeightP_ = hght;
            this.firePropertyChange("labelHeightP", tempOld, new Double(this.labelHeightP_));
        }
    }

    public void setLabelPosition(int pos) {
        if (this.labelPosition_ != pos) {
            Integer tempOld = new Integer(this.labelPosition_);
            this.labelPosition_ = pos;
            this.firePropertyChange("labelPosition", tempOld, new Integer(this.labelPosition_));
        }
    }

    public void setOutlineAttribute(LineAttribute attr) {
        if (!this.outlineAttr_.equals(attr)) {
            LineAttribute tempOld = this.outlineAttr_;
            this.outlineAttr_ = attr;
            this.firePropertyChange("outlineAttribute", tempOld, this.outlineAttr_);
        }
    }

    public double getFillMarkHeightP() {
        return this.fillMarkHeightP_;
    }

    public void setFillMarkHeightP(double markh) {
        if (this.fillMarkHeightP_ != markh) {
            Double tempOld = new Double(this.fillMarkHeightP_);
            this.fillMarkHeightP_ = markh;
            this.firePropertyChange("fillMarkHeightP", tempOld, new Double(this.fillMarkHeightP_));
        }
    }

    public boolean isMarkOutline() {
        return this.markOutline_;
    }

    public Color getMarkOutlineColor() {
        return this.markOutlineColor_;
    }

    public void setMarkOutline(boolean markOutline) {
        if (this.markOutline_ != markOutline) {
            Boolean old = new Boolean(this.markOutline_);
            this.markOutline_ = markOutline;
            this.firePropertyChange("markOutline", old, new Boolean(this.markOutline_));
        }
    }

    public void setMarkOutlineColor(Color markOutlineColor) {
        if (!this.markOutlineColor_.equals(markOutlineColor)) {
            Color old = this.markOutlineColor_;
            this.markOutlineColor_ = markOutlineColor;
            this.firePropertyChange("markOutlineColor", old, this.markOutlineColor_);
        }
    }

    public Color getBoxColor() {
        return this.boxColor_;
    }

    public void setBoxColor(Color boxColor) {
        if (this.boxColor_ == null || !this.boxColor_.equals(boxColor)) {
            Color tempOld = this.boxColor_;
            this.boxColor_ = boxColor;
            this.firePropertyChange("boxColor", tempOld, this.boxColor_);
        }
    }

    public double getBoxGrowBy() {
        return this.boxGrowBy_;
    }

    public void setBoxGrowBy(double boxGrowBy) {
        if (this.boxGrowBy_ != boxGrowBy) {
            double temp = this.boxGrowBy_;
            this.boxGrowBy_ = boxGrowBy;
            this.firePropertyChange("boxGrowBy", temp, this.boxGrowBy_);
        }
    }

    public boolean isDrawBox() {
        return this.drawBox_;
    }

    public void setDrawBox(boolean drawBox) {
        if (this.drawBox_ != drawBox) {
            boolean temp = this.drawBox_;
            this.drawBox_ = drawBox;
            this.firePropertyChange("drawBox", temp, this.drawBox_);
        }
    }

    public boolean isGeometrySimplified() {
        return this.geometrySimplified_;
    }

    public void setGeometrySimplified(boolean geometrySimplified) {
        if (this.geometrySimplified_ != geometrySimplified) {
            Boolean old = new Boolean(this.markOutline_);
            this.geometrySimplified_ = geometrySimplified;
            this.firePropertyChange("geometrySimplified", old, new Boolean(this.geometrySimplified_));
        }
    }

    public double getSimplifyDistanceTolerance() {
        return this.simplifyDistanceTolerance_;
    }

    public void setSimplifyDistanceTolerance(double simplifyDistanceTolerance) {
        if (this.simplifyDistanceTolerance_ != simplifyDistanceTolerance) {
            double temp = this.simplifyDistanceTolerance_;
            this.simplifyDistanceTolerance_ = simplifyDistanceTolerance;
            this.firePropertyChange("simplifyDistanceTolerance", temp, this.simplifyDistanceTolerance_);
        }
    }
}

