/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.BooleanLookup;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ColorTableLookup;
import gov.noaa.pmel.sgt.DoubleTableLookup;
import gov.noaa.pmel.sgt.GeomColor;
import gov.noaa.pmel.sgt.GeometryAttribute;
import gov.noaa.pmel.sgt.GeometryParameterAttribute;
import gov.noaa.pmel.sgt.GeometryTransform;
import gov.noaa.pmel.sgt.IntegerTableLookup;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.SGTUtil;
import gov.noaa.pmel.sgt.dm.GeometryCollection;
import gov.noaa.pmel.sgt.dm.GeometryParameter;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGeometry;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class GeometryCartesianRenderer
extends CartesianRenderer {
    private GeometryCollection collection_ = null;
    private GeometryAttribute attr_ = null;

    public GeometryCartesianRenderer(CartesianGraph cg) {
        this(cg, null, null);
    }

    public GeometryCartesianRenderer(CartesianGraph cg, GeometryCollection data) {
        this(cg, data, null);
    }

    public GeometryCartesianRenderer(CartesianGraph cg, GeometryCollection data, GeometryAttribute attr) {
        this.cg_ = cg;
        this.collection_ = data;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
        }
    }

    @Override
    public void drawDynamicData(Graphics g) {
        if (this.collection_.isDynamic()) {
            this.drawGeometry(g);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (!this.collection_.isDynamic()) {
            this.drawGeometry(g);
        }
    }

    private void drawGeometry(Graphics g) {
        GeometryAttribute attr;
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        double distanceTolerance = -1.0;
        int pointCount = 0;
        int simplifyPointCount = 0;
        if (this.attr_ == null) {
            attr = new GeometryAttribute(2);
            attr.setDefaultFillColor(this.cg_.layer_.getPane().getComponent().getForeground());
        } else {
            attr = this.attr_;
        }
        if (attr.isGeometrySimplified()) {
            if (attr.getSimplifyDistanceTolerance() < 0.0) {
                double dx = Math.abs(this.cg_.getXPtoU(this.cg_.getLayer().getXDtoP(1)) - this.cg_.getXPtoU(this.cg_.getLayer().getXDtoP(2)));
                double dy = Math.abs(this.cg_.getYPtoU(this.cg_.getLayer().getYDtoP(1)) - this.cg_.getYPtoU(this.cg_.getLayer().getYDtoP(2)));
                distanceTolerance = Math.min(dx, dy) * 0.5;
            } else {
                distanceTolerance = attr.getSimplifyDistanceTolerance();
            }
        }
        PlotMark pm = new PlotMark(attr);
        ColorMap cmap = attr.getFillColor();
        Color defColor = attr.getDefaultFillColor();
        GeometryParameter[] gParameters = attr.getGeometryParameters();
        GeometryParameterAttribute[] gpAttributes = attr.getGeometryParameterAttributes();
        boolean hasGeomParamAttr = attr.getGeometryParameterAttributeSize() > 0;
        Enumeration li = this.collection_.elements();
        while (li.hasMoreElements()) {
            SGTGeometry geom = (SGTGeometry)li.nextElement();
            Color fill = SGTUtil.copyColor(defColor);
            Color outline = SGTUtil.copyColor(attr.getOutlineAttribute().getColor());
            Color mOutline = SGTUtil.copyColor(pm.getOutlineColor());
            boolean outlineVisible = attr.isDrawOutline();
            double labelSize = attr.getLabelHeightP();
            Color labelColor = attr.getLabelColor();
            boolean labelVisible = attr.isDrawLabel();
            double mSize = pm.getMarkHeightP();
            int mCode = pm.getMark();
            if (cmap != null && geom.hasValue()) {
                fill = cmap.getColor(geom.getValue());
            }
            boolean visible = true;
            if (hasGeomParamAttr) {
                int alpha = 0;
                block14: for (int i = 0; i < gParameters.length; ++i) {
                    double value = geom.getValue(i);
                    GeometryParameter gParam = gParameters[i];
                    GeometryParameterAttribute gpAttr = gpAttributes[i];
                    switch (gParam) {
                        case LabelVisible: {
                            if (!(gpAttr instanceof BooleanLookup)) continue block14;
                            labelVisible = ((BooleanLookup)gpAttr).getValue(value);
                            continue block14;
                        }
                        case LabelSize: {
                            if (gpAttr instanceof GeometryTransform) {
                                labelSize = ((GeometryTransform)gpAttr).getTransP(value);
                                continue block14;
                            }
                            if (!(gpAttr instanceof DoubleTableLookup)) continue block14;
                            labelSize = ((DoubleTableLookup)gpAttr).getValue(value);
                            continue block14;
                        }
                        case LabelColor: {
                            if (gpAttr instanceof ColorMap) {
                                labelColor = SGTUtil.copyColor(((ColorMap)gpAttr).getColor(value));
                                continue block14;
                            }
                            if (gpAttr instanceof GeomColor) {
                                labelColor = SGTUtil.copyColor((GeomColor)gpAttr);
                                continue block14;
                            }
                            if (!(gpAttr instanceof ColorTableLookup)) continue block14;
                            labelColor = SGTUtil.copyColor(((ColorTableLookup)gpAttr).getValue(value));
                            continue block14;
                        }
                        case MarkOutlineVisible: {
                            if (!(gpAttr instanceof BooleanLookup)) continue block14;
                            outlineVisible = ((BooleanLookup)gpAttr).getValue(value);
                            continue block14;
                        }
                        case Visible: {
                            if (!(gpAttr instanceof BooleanLookup) || ((BooleanLookup)gpAttr).getValue(value)) continue block14;
                            visible = false;
                            continue block14;
                        }
                        case FillColor: {
                            alpha = fill.getAlpha();
                            if (gpAttr instanceof ColorMap) {
                                fill = ((ColorMap)gpAttr).getColor(value);
                                fill = SGTUtil.copyColor(fill, alpha);
                                continue block14;
                            }
                            if (gpAttr instanceof GeomColor) {
                                fill = SGTUtil.copyColor((GeomColor)gpAttr, alpha);
                                continue block14;
                            }
                            if (!(gpAttr instanceof ColorTableLookup)) continue block14;
                            fill = ((ColorTableLookup)gpAttr).getValue(value);
                            fill = SGTUtil.copyColor(fill, alpha);
                            continue block14;
                        }
                        case FillTransparency: {
                            if (gpAttr instanceof GeometryTransform) {
                                alpha = (int)((GeometryTransform)gpAttr).getTransP(value);
                            } else if (gpAttr instanceof DoubleTableLookup) {
                                alpha = (int)((DoubleTableLookup)gpAttr).getValue(value);
                            } else if (gpAttr instanceof IntegerTableLookup) {
                                alpha = ((IntegerTableLookup)gpAttr).getValue(value);
                            }
                            fill = SGTUtil.copyColor(fill, alpha);
                            continue block14;
                        }
                        case LineColor: {
                            Color clr;
                            alpha = outline.getAlpha();
                            int mAlpha = mOutline.getAlpha();
                            if (gpAttr instanceof ColorMap) {
                                clr = ((ColorMap)gpAttr).getColor(value);
                                outline = SGTUtil.copyColor(clr, alpha);
                                mOutline = SGTUtil.copyColor(clr, mAlpha);
                                continue block14;
                            }
                            if (gpAttr instanceof GeomColor) {
                                outline = SGTUtil.copyColor((GeomColor)gpAttr, alpha);
                                mOutline = SGTUtil.copyColor((GeomColor)gpAttr, mAlpha);
                                continue block14;
                            }
                            if (!(gpAttr instanceof ColorTableLookup)) continue block14;
                            clr = ((ColorTableLookup)gpAttr).getValue(value);
                            outline = SGTUtil.copyColor(clr, alpha);
                            mOutline = SGTUtil.copyColor(clr, mAlpha);
                            continue block14;
                        }
                        case LineTransparency: {
                            if (gpAttr instanceof GeometryTransform) {
                                alpha = (int)((GeometryTransform)gpAttr).getTransP(value);
                            } else if (gpAttr instanceof DoubleTableLookup) {
                                alpha = (int)((DoubleTableLookup)gpAttr).getValue(value);
                            } else if (gpAttr instanceof IntegerTableLookup) {
                                alpha = ((IntegerTableLookup)gpAttr).getValue(value);
                            }
                            outline = SGTUtil.copyColor(outline, alpha);
                            mOutline = SGTUtil.copyColor(mOutline, alpha);
                            continue block14;
                        }
                        case MarkCode: {
                            if (gpAttr instanceof DoubleTableLookup) {
                                mCode = (int)((DoubleTableLookup)gpAttr).getValue(value);
                                continue block14;
                            }
                            if (!(gpAttr instanceof IntegerTableLookup)) continue block14;
                            mCode = ((IntegerTableLookup)gpAttr).getValue(value);
                            continue block14;
                        }
                        case MarkSize: {
                            if (gpAttr instanceof GeometryTransform) {
                                mSize = ((GeometryTransform)gpAttr).getTransP(value);
                                continue block14;
                            }
                            if (!(gpAttr instanceof DoubleTableLookup)) continue block14;
                            mSize = ((DoubleTableLookup)gpAttr).getValue(value);
                        }
                    }
                }
            }
            if (!visible) continue;
            if (geom.getGeometry() instanceof Point) {
                if (hasGeomParamAttr) {
                    pm.setMarkHeightP(mSize);
                    pm.setMark(mCode);
                    pm.setOutlineColor(mOutline);
                    pm.setOutline(outlineVisible);
                }
                g.setColor(fill);
                if (!attr.isVisible()) continue;
                this.drawPoint(g, geom, pm);
                if (!labelVisible) continue;
                this.drawLabel(g, geom, mSize, attr.getLabelPosition(), labelSize, labelColor, attr.getLabelFont(), attr.isDrawBox(), attr.getBoxColor(), attr.getBoxGrowBy());
                continue;
            }
            if (geom.getGeometry() instanceof Polygon || geom.getGeometry() instanceof LineString) {
                LineAttribute olAttr = attr.getOutlineAttribute();
                if (hasGeomParamAttr) {
                    olAttr.setColor(outline);
                }
                if (!attr.isVisible()) continue;
                Geometry gm = geom.getGeometry();
                if (attr.isGeometrySimplified()) {
                    int pts = gm.getNumPoints();
                    pointCount += pts;
                    if (pts > 4) {
                        gm = TopologyPreservingSimplifier.simplify(gm, distanceTolerance);
                    }
                    simplifyPointCount += gm.getNumPoints();
                }
                GeneralPath gp = this.getGeneralPath(gm);
                this.drawPolygon((Graphics2D)g, gp, fill);
                if (attr.isDrawOutline()) {
                    this.drawOutline((Graphics2D)g, gp, olAttr);
                }
                if (!attr.isDrawLabel()) continue;
                this.drawLabel(g, geom, attr);
                continue;
            }
            if (!(geom.getGeometry() instanceof MultiPolygon) && !(geom.getGeometry() instanceof MultiLineString)) continue;
            LineAttribute olAttr = attr.getOutlineAttribute();
            if (hasGeomParamAttr) {
                olAttr.setColor(outline);
            }
            if (!attr.isVisible()) continue;
            Geometry mp = geom.getGeometry();
            if (attr.isGeometrySimplified()) {
                int pts = mp.getNumPoints();
                pointCount += pts;
                if (pts > 4) {
                    mp = TopologyPreservingSimplifier.simplify(mp, distanceTolerance);
                }
                simplifyPointCount += mp.getNumPoints();
            }
            for (int k = 0; k < mp.getNumGeometries(); ++k) {
                Geometry gm = mp.getGeometryN(k);
                GeneralPath gp = this.getGeneralPath(gm);
                this.drawPolygon((Graphics2D)g, gp, fill);
                if (attr.isDrawOutline()) {
                    this.drawOutline((Graphics2D)g, gp, olAttr);
                }
                if (!attr.isDrawLabel()) continue;
                this.drawLabel(g, geom, attr);
            }
        }
        if (attr.isGeometrySimplified()) {
            // empty if block
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip(rect);
    }

    GeneralPath getGeneralPath(Geometry geom) {
        GeneralPath gp = new GeneralPath();
        Coordinate[] coords = geom.getCoordinates();
        if (coords.length > 0) {
            gp.moveTo((float)coords[0].x, (float)coords[0].y);
            for (int i = 1; i < coords.length; ++i) {
                gp.lineTo((float)coords[i].x, (float)coords[i].y);
            }
        }
        return gp;
    }

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public SGTData getDataAt(java.awt.Point pt) {
        return null;
    }

    @Override
    public SGTData getData() {
        return this.collection_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("GeometryCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    private void drawOutline(Graphics2D g, GeneralPath gp, LineAttribute attr) {
        Layer ly = this.cg_.getLayer();
        double ax = ly.getXSlope() * ((LinearTransform)this.cg_.getXTransform()).getSlope();
        double bx = ly.getXSlope() * ((LinearTransform)this.cg_.getXTransform()).getOffset() + ly.getXOffset();
        double ay = -ly.getYSlope() * ((LinearTransform)this.cg_.getYTransform()).getSlope();
        double by = ly.getYOffset() - ly.getYSlope() * ((LinearTransform)this.cg_.getYTransform()).getOffset();
        GeneralPath gpnew = new GeneralPath();
        gpnew.setWindingRule(gp.getWindingRule());
        PathIterator pIter = gp.getPathIterator(null);
        float[] coords = new float[6];
        while (!pIter.isDone()) {
            int type = pIter.currentSegment(coords);
            switch (type) {
                case 4: {
                    gpnew.closePath();
                    break;
                }
                case 3: {
                    float[] nCoords = this.transformOutline(coords, 3, ax, bx, ay, by);
                    gpnew.curveTo(nCoords[0], nCoords[1], nCoords[2], nCoords[3], nCoords[4], nCoords[5]);
                    break;
                }
                case 1: {
                    float[] nCoords = this.transformOutline(coords, 1, ax, bx, ay, by);
                    gpnew.lineTo(nCoords[0], nCoords[1]);
                    break;
                }
                case 0: {
                    float[] nCoords = this.transformOutline(coords, 1, ax, bx, ay, by);
                    gpnew.moveTo(nCoords[0], nCoords[1]);
                    break;
                }
                case 2: {
                    float[] nCoords = this.transformOutline(coords, 2, ax, bx, ay, by);
                    gpnew.quadTo(nCoords[0], nCoords[1], nCoords[2], nCoords[3]);
                }
            }
            pIter.next();
        }
        Stroke saveStroke = g.getStroke();
        Stroke stroke = this.getStroke(attr);
        if (stroke != null) {
            g.setStroke(stroke);
        }
        Color saveColor = g.getColor();
        g.setColor(attr.getColor());
        g.draw(gpnew);
        g.setStroke(saveStroke);
        g.setColor(saveColor);
    }

    float[] transformOutline(float[] in, int pnts, double ax, double bx, double ay, double by) {
        float[] out = new float[6];
        for (int i = 0; i < pnts; ++i) {
            out[i] = (float)(ax * (double)in[i] + bx);
            out[i + 1] = (float)(ay * (double)in[i + 1] + by);
        }
        return out;
    }

    public Stroke getStroke(LineAttribute attr) {
        BasicStroke stroke = null;
        switch (attr.getStyle()) {
            case 2: {
                stroke = new BasicStroke(attr.getWidth());
                break;
            }
            case 1: {
                float[] dashes = new float[]{4.0f, 4.0f};
                stroke = new BasicStroke(0.0f, 2, 0, 10.0f, dashes, 0.0f);
                break;
            }
            case 6: {
                float[] arr = attr.getDashArray();
                if (arr == null || arr.length <= 1) {
                    stroke = new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit());
                    break;
                }
                stroke = new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit(), attr.getDashArray(), attr.getDashPhase());
                break;
            }
            default: {
                stroke = new BasicStroke(0.0f);
            }
        }
        return stroke;
    }

    private void drawPolygon(Graphics2D g, GeneralPath gp, Color fill) {
        Layer ly = this.cg_.getLayer();
        double ax = ly.getXSlope() * ((LinearTransform)this.cg_.getXTransform()).getSlope();
        double bx = ly.getXSlope() * ((LinearTransform)this.cg_.getXTransform()).getOffset() + ly.getXOffset();
        double ay = -ly.getYSlope() * ((LinearTransform)this.cg_.getYTransform()).getSlope();
        double by = ly.getYOffset() - ly.getYSlope() * ((LinearTransform)this.cg_.getYTransform()).getOffset();
        AffineTransform saveTrans = g.getTransform();
        AffineTransform aTrans = g.getTransform();
        aTrans.translate(bx, by);
        aTrans.scale(ax, ay);
        g.setTransform(aTrans);
        g.setPaint(fill);
        g.fill(gp);
        g.setTransform(saveTrans);
    }

    private void drawPoint(Graphics g, SGTGeometry point, PlotMark pm) {
        if (pm.getMark() == 0) {
            return;
        }
        Geometry geom = point.getGeometry();
        Coordinate coord = null;
        if (!(geom instanceof Point)) {
            return;
        }
        coord = geom.getCoordinate();
        int xp = this.cg_.getXUtoD(coord.x);
        int yp = this.cg_.getYUtoD(coord.y);
        if (xp == Integer.MIN_VALUE || yp == Integer.MIN_VALUE) {
            return;
        }
        pm.paintMark(g, this.cg_.getLayer(), xp, yp);
    }

    private void drawLabel(Graphics g, SGTGeometry point, GeometryAttribute attr) {
        this.drawLabel(g, point, attr, attr.getFillMarkHeightP());
    }

    private void drawLabel(Graphics g, SGTGeometry point, GeometryAttribute attr, double markHeight) {
        this.drawLabel(g, point, markHeight, attr.getLabelPosition(), attr.getLabelHeightP(), attr.getLabelColor(), attr.getLabelFont(), attr.isDrawBox(), attr.getBoxColor(), attr.getBoxGrowBy());
    }

    private void drawLabel(Graphics g, SGTGeometry point, double markHeight, int labelPosition, double labelHeightP, Color labelColor, Font labelFont, boolean drawBox, Color boxColor, double boxGrowBy) {
        int halign;
        int valign;
        double loff = 0.0;
        Layer ly = this.cg_.getLayer();
        Geometry geom = point.getGeometry();
        Coordinate coord = null;
        if (geom instanceof Point) {
            loff = markHeight / 2.0 * 0.8;
            coord = geom.getCoordinate();
        } else if (geom instanceof Polygon || geom instanceof LineString) {
            loff = 0.0;
            coord = geom.getCentroid().getCoordinate();
        } else if (geom instanceof MultiPolygon || geom instanceof MultiLineString) {
            loff = 0.0;
            coord = geom.getCentroid().getCoordinate();
        }
        double xp = this.cg_.getXUtoP(coord.x);
        double yp = this.cg_.getYUtoP(coord.y);
        double xl = 0.0;
        double yl = 0.0;
        double angleoff = Math.sqrt(loff * loff / 2.0);
        switch (labelPosition) {
            case 0: {
                valign = 1;
                halign = 1;
                break;
            }
            case 1: {
                valign = 2;
                halign = 1;
                yl = loff;
                break;
            }
            default: {
                valign = 2;
                halign = 0;
                yl = angleoff;
                xl = angleoff;
                break;
            }
            case 3: {
                valign = 1;
                halign = 0;
                xl = loff;
                break;
            }
            case 4: {
                valign = 0;
                halign = 0;
                yl = -angleoff;
                xl = angleoff;
                break;
            }
            case 5: {
                valign = 0;
                halign = 1;
                yl = -loff;
                break;
            }
            case 6: {
                valign = 0;
                halign = 2;
                yl = -angleoff;
                xl = -angleoff;
                break;
            }
            case 7: {
                valign = 1;
                halign = 2;
                xl = -loff;
                break;
            }
            case 8: {
                valign = 2;
                halign = 2;
                yl = angleoff;
                xl = -angleoff;
            }
        }
        SGLabel pl = new SGLabel("point", point.getLabel(), labelHeightP, new Point2D.Double(xp + xl, yp + yl), valign, halign);
        pl.setColor(labelColor);
        pl.setFont(labelFont);
        if (drawBox) {
            pl.setDrawBox(true);
            pl.setBoxColor(boxColor);
            pl.setBoxGrowBy(boxGrowBy);
        }
        pl.setLayer(ly);
        try {
            pl.draw(g);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void removeData() {
        this.collection_.removePropertyChangeListener(this.cg_);
        this.collection_ = null;
    }
}

