/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.GeometryParameterAttribute;
import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.util.Range2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class GeometryTransform
implements Transform,
GeometryParameterAttribute {
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private double p1_;
    private double p2_;
    private double u1_;
    private double u2_;
    private double at_;
    private double bt_;
    private double a_;
    private double b_;

    public GeometryTransform() {
        this(0.0, 1.0, 0.0, 1.0);
    }

    public GeometryTransform(double p1, double p2, double u1, double u2) {
        this.p1_ = p1;
        this.p2_ = p2;
        this.u1_ = u1;
        this.u2_ = u2;
        this.computeTransform();
    }

    public GeometryTransform(Range2D pr, Range2D ur) {
        this(pr.start, pr.end, ur.start, ur.end);
    }

    void computeTransform() {
        double denom = this.u1_ - this.u2_;
        if (denom == 0.0) {
            this.a_ = 1.0;
            this.b_ = 0.0;
        } else {
            this.a_ = (this.p1_ - this.p2_) / denom;
            this.b_ = this.p1_ - this.a_ * this.u1_;
        }
    }

    public String toString() {
        return "GeometryTransform: " + this.a_ + ", " + this.b_ + "; " + this.at_ + ", " + this.bt_;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }

    @Override
    public Range2D getRangeP() {
        return new Range2D(this.p1_, this.p2_);
    }

    @Override
    public Range2D getRangeU() {
        return new Range2D(this.u1_, this.u2_);
    }

    @Override
    public double getTransP(double u) {
        return this.a_ * u + this.b_;
    }

    @Override
    public double getTransU(double p) {
        return (p - this.b_) / this.a_;
    }

    @Override
    public void setRangeP(double p1, double p2) {
        if (this.p1_ != p1 || this.p2_ != p2) {
            Range2D tempOld = new Range2D(this.p1_, this.p2_);
            this.p1_ = p1;
            this.p2_ = p2;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeP", tempOld, new Range2D(this.p1_, this.p2_));
        }
    }

    @Override
    public void setRangeP(Range2D prange) {
        this.setRangeP(prange.start, prange.end);
    }

    @Override
    public void setRangeU(double u1, double u2) {
        if (this.u1_ != u1 || this.u2_ != u2) {
            Range2D tempOld = new Range2D(this.u1_, this.u2_);
            this.u1_ = u1;
            this.u2_ = u2;
            this.computeTransform();
            this.changes_.firePropertyChange("rangeU", tempOld, new Range2D(this.u1_, this.u2_));
        }
    }

    @Override
    public void setRangeU(Range2D urange) {
        this.setRangeU(urange.start, urange.end);
    }
}

