/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GridAttribute
extends Attribute
implements Cloneable,
PropertyChangeListener {
    private static final long serialVersionUID = 3822340406728567524L;
    private ColorMap cmap_;
    private ContourLevels clev_;
    private int style_;
    public static final int RASTER = 0;
    public static final int AREA_FILL = 1;
    public static final int CONTOUR = 2;
    public static final int RASTER_CONTOUR = 3;
    public static final int AREA_FILL_CONTOUR = 4;

    public GridAttribute() {
        this(0, null);
    }

    public GridAttribute(int style, ColorMap cmap) {
        this.style_ = style;
        this.cmap_ = cmap;
        if (this.cmap_ != null) {
            this.cmap_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.cmap_));
        }
    }

    public GridAttribute(ContourLevels clev) {
        this.style_ = 2;
        this.cmap_ = null;
        this.clev_ = clev;
    }

    public void setContourLevels(ContourLevels clev) {
        if (this.clev_ == null || !this.clev_.equals(clev)) {
            ContourLevels tempOld = this.clev_;
            this.clev_ = clev;
            this.firePropertyChange("contourLevels", tempOld, this.clev_);
        }
    }

    public ContourLevels getContourLevels() {
        return this.clev_;
    }

    public GridAttribute copy() {
        GridAttribute newGrid;
        try {
            newGrid = (GridAttribute)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new GridAttribute();
        }
        return newGrid;
    }

    public void setStyle(int st) {
        if (this.style_ != st) {
            Integer tempOld = new Integer(this.style_);
            this.style_ = st;
            this.firePropertyChange("style", tempOld, new Integer(this.style_));
        }
    }

    public int getStyle() {
        return this.style_;
    }

    public boolean isRaster() {
        return this.style_ == 0 || this.style_ == 3;
    }

    public boolean isContour() {
        return this.style_ == 2 || this.style_ == 3 || this.style_ == 4;
    }

    public boolean isAreaFill() {
        return this.style_ == 1 || this.style_ == 4;
    }

    public ColorMap getColorMap() {
        return this.cmap_;
    }

    public void setColorMap(ColorMap cmap) {
        if (this.cmap_ == null && cmap == null) {
            return;
        }
        if (this.cmap_ == null || !this.cmap_.equals(cmap)) {
            ColorMap tempOld = this.cmap_;
            this.cmap_ = cmap;
            this.firePropertyChange("colorMap", tempOld, this.cmap_);
            this.cmap_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.cmap_));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }
}

