/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ContourLevelNotFoundException;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.DefaultContourLineAttribute;
import gov.noaa.pmel.sgt.Format;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.IndexedColor;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.contour.Contour;
import gov.noaa.pmel.sgt.contour.ContourLine;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class GridCartesianRenderer
extends CartesianRenderer {
    private SGTGrid grid_;
    private GridAttribute attr_ = null;
    private Contour con_ = null;

    private void drawRaster(Graphics g) {
        double[] yp;
        int ySize;
        int count;
        double[] xp;
        int xSize;
        GeoDate[] tValues;
        if (this.grid_.isXTime()) {
            if (this.grid_.getTimeArray().length <= 2) {
                return;
            }
            if (this.grid_.hasXEdges()) {
                tValues = this.grid_.getTimeEdges();
                xSize = tValues.length;
                xp = new double[xSize];
                for (count = 0; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD2(tValues[count]);
                }
            } else {
                tValues = this.grid_.getTimeArray();
                xSize = tValues.length;
                xp = new double[xSize + 1];
                xp[0] = this.cg_.getXUtoD2(tValues[0].subtract(tValues[1].subtract(tValues[0]).divide(2.0)));
                for (count = 1; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD2(tValues[count - 1].add(tValues[count]).divide(2.0));
                }
                xp[xSize] = this.cg_.getXUtoD2(tValues[xSize - 1].add(tValues[xSize - 1].subtract(tValues[xSize - 2]).divide(2.0)));
            }
        } else {
            double[] xValues;
            if (this.grid_.getXArray().length <= 2) {
                return;
            }
            if (this.grid_.hasXEdges()) {
                xValues = this.grid_.getXEdges();
                xSize = xValues.length;
                xp = new double[xSize];
                for (count = 0; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD2(xValues[count]);
                }
            } else {
                xValues = this.grid_.getXArray();
                xSize = xValues.length;
                xp = new double[xSize + 1];
                xp[0] = this.cg_.getXUtoD2(xValues[0] - (xValues[1] - xValues[0]) * 0.5);
                for (count = 1; count < xSize; ++count) {
                    xp[count] = this.cg_.getXUtoD2((xValues[count - 1] + xValues[count]) * 0.5);
                }
                xp[xSize] = this.cg_.getXUtoD2(xValues[xSize - 1] + (xValues[xSize - 1] - xValues[xSize - 2]) * 0.5);
            }
        }
        if (this.grid_.isYTime()) {
            if (this.grid_.getTimeArray().length <= 2) {
                return;
            }
            if (this.grid_.hasYEdges()) {
                tValues = this.grid_.getTimeEdges();
                ySize = tValues.length;
                yp = new double[ySize];
                for (count = 0; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD2(tValues[count]);
                }
            } else {
                tValues = this.grid_.getTimeArray();
                ySize = tValues.length;
                yp = new double[ySize + 1];
                yp[0] = this.cg_.getYUtoD2(tValues[0].subtract(tValues[1].subtract(tValues[0]).divide(2.0)));
                for (count = 1; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD2(tValues[count - 1].add(tValues[count]).divide(2.0));
                }
                yp[ySize] = this.cg_.getYUtoD2(tValues[ySize - 1].add(tValues[ySize - 1].subtract(tValues[ySize - 2]).divide(2.0)));
            }
        } else {
            double[] yValues;
            if (this.grid_.getYArray().length <= 2) {
                return;
            }
            if (this.grid_.hasYEdges()) {
                yValues = this.grid_.getYEdges();
                ySize = yValues.length;
                yp = new double[ySize];
                for (count = 0; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD2(yValues[count]);
                }
            } else {
                yValues = this.grid_.getYArray();
                ySize = yValues.length;
                yp = new double[ySize + 1];
                yp[0] = this.cg_.getYUtoD2(yValues[0] - (yValues[1] - yValues[0]) * 0.5);
                for (count = 1; count < ySize; ++count) {
                    yp[count] = this.cg_.getYUtoD2((yValues[count - 1] + yValues[count]) * 0.5);
                }
                yp[ySize] = this.cg_.getYUtoD2(yValues[ySize - 1] + (yValues[ySize - 1] - yValues[ySize - 2]) * 0.5);
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        double[] gValues = this.grid_.getZArray();
        int drawcount = 0;
        Color lastColor = null;
        Rectangle2D.Float lastRect = null;
        boolean lastColorDrawn = false;
        Rectangle2D.Float rect = null;
        Color color = null;
        count = 0;
        for (int i = 0; i < xSize; ++i) {
            lastColor = null;
            lastColorDrawn = true;
            for (int j = 0; j < ySize; ++j) {
                double val = gValues[count];
                if (!Double.isNaN(val)) {
                    color = this.attr_.getColorMap().getColor(val);
                    rect = this.createRect(xp[i], yp[j], xp[i + 1], yp[j + 1]);
                    if (lastColor != null && lastColor.equals(color)) {
                        lastRect.add(rect);
                    } else {
                        if (lastColor != null) {
                            lastColorDrawn = true;
                            g2.setColor(lastColor);
                            g2.fill(lastRect);
                            ++drawcount;
                        }
                        lastColor = color;
                        lastRect = rect;
                        lastColorDrawn = false;
                    }
                } else {
                    if (lastRect != null) {
                        lastColorDrawn = true;
                        g2.setColor(lastColor);
                        g2.fill(lastRect);
                        ++drawcount;
                    }
                    lastColor = null;
                    lastRect = null;
                    rect = null;
                }
                ++count;
            }
            if (lastColorDrawn) {
                if (rect == null) continue;
                g2.setColor(color);
                g2.fill(rect);
                ++drawcount;
                continue;
            }
            if (lastRect == null) continue;
            g2.setColor(lastColor);
            g2.fill(lastRect);
            ++drawcount;
        }
    }

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    public void setAttribute(GridAttribute attr) {
        this.attr_ = attr;
        this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
    }

    private Rectangle2D.Float createRect(double x1, double y1, double x2, double y2) {
        float height;
        float y;
        float width;
        float x;
        if (x1 < x2) {
            x = (float)x1;
            width = (float)(x2 - x1);
        } else {
            x = (float)x2;
            width = (float)(x1 - x2);
        }
        if (y1 < y2) {
            y = (float)y1;
            height = (float)(y2 - y1);
        } else {
            y = (float)y2;
            height = (float)(y1 - y2);
        }
        return new Rectangle2D.Float(x, y, width + 0.5f, height + 0.5f);
    }

    public GridCartesianRenderer(CartesianGraph cg) {
        this(cg, null, null);
    }

    public GridCartesianRenderer(CartesianGraph cg, SGTGrid data) {
        this(cg, data, null);
    }

    public GridCartesianRenderer(CartesianGraph cg, SGTGrid grid, GridAttribute attr) {
        this.cg_ = cg;
        this.grid_ = grid;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
        }
    }

    @Override
    public void drawDynamicData(Graphics g) {
        if (this.grid_.isDynamic()) {
            this.drawGrid(g);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (!this.grid_.isDynamic()) {
            this.drawGrid(g);
        }
    }

    private void drawGrid(Graphics g) {
        if (!this.attr_.isVisible()) {
            return;
        }
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        if (this.attr_.isRaster()) {
            this.drawRaster(g);
        }
        if (this.attr_.isAreaFill()) {
            double[] x = this.xArrayP();
            double[] y = this.yArrayP();
            double[] z = this.grid_.getZArray();
            int nx = x.length;
            int ny = y.length;
            double[] xt = new double[5];
            double[] yt = new double[5];
            double[] zt = new double[5];
            for (int i = 0; i < nx - 1; ++i) {
                for (int j = 0; j < ny - 1; ++j) {
                    xt[0] = x[i];
                    yt[0] = y[j];
                    zt[0] = z[j + i * ny];
                    xt[1] = x[i + 1];
                    yt[1] = y[j];
                    zt[1] = z[j + (i + 1) * ny];
                    xt[2] = x[i + 1];
                    yt[2] = y[j + 1];
                    zt[2] = z[j + 1 + (i + 1) * ny];
                    xt[3] = xt[0];
                    yt[3] = yt[2];
                    zt[3] = z[j + 1 + i * ny];
                    xt[4] = xt[0];
                    yt[4] = yt[0];
                    zt[4] = zt[0];
                    this.fillSquare(g, xt, yt, zt);
                }
            }
        }
        if (this.attr_.isContour()) {
            Range2D range = this.computeRange(10);
            this.con_ = new Contour(this.cg_, this.grid_, this.attr_.getContourLevels());
            ContourLevels clevels = this.con_.getContourLevels();
            for (int i = 0; i < clevels.size(); ++i) {
                try {
                    double val = clevels.getLevel(i);
                    DefaultContourLineAttribute attr = clevels.getDefaultContourLineAttribute(i);
                    if (!attr.isAutoLabel()) continue;
                    Format format = attr.getLabelFormat().length() <= 0 ? new Format(Format.computeFormat(range.start, range.end, attr.getSignificantDigits())) : new Format(attr.getLabelFormat());
                    String label = format.form(val);
                    attr.setLabelText(label);
                    continue;
                }
                catch (ContourLevelNotFoundException yt) {
                    // empty catch block
                }
            }
            this.con_.generateContourLines();
            this.con_.generateContourLabels(g);
            Enumeration elem = this.con_.elements();
            while (elem.hasMoreElements()) {
                ContourLine cl = (ContourLine)elem.nextElement();
                cl.draw(g);
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip(rect);
    }

    private void fillSquare(Graphics g, double[] x, double[] y, double[] z) {
        ContourLevels clevels = this.attr_.getContourLevels();
        IndexedColor cmap = (IndexedColor)((Object)this.attr_.getColorMap());
        double[] xpoly = new double[20];
        double[] ypoly = new double[20];
        double zmin = Math.min(z[0], z[1]);
        double zmax = Math.max(z[0], z[1]);
        for (int i = 2; i <= 3; ++i) {
            zmin = Math.min(zmin, z[i]);
            zmax = Math.max(zmax, z[i]);
        }
        if (Double.isNaN(zmax)) {
            return;
        }
        int maxindex = clevels.getMaximumIndex();
        for (int cindex = -1; cindex <= maxindex; ++cindex) {
            double zlevp1;
            double zlev;
            try {
                zlev = cindex == -1 ? -1.7976931348623157E308 : clevels.getLevel(cindex);
                zlevp1 = cindex == maxindex ? Double.MAX_VALUE : clevels.getLevel(cindex + 1);
            }
            catch (ContourLevelNotFoundException e) {
                break;
            }
            Color col = cmap.getColorByIndex(cindex + 1);
            if (zmin > zlevp1 || zmax < zlev) continue;
            if (zmin >= zlev && zmax <= zlevp1) {
                this.fillPolygon(g, col, x, y, 4);
                return;
            }
            int npoly = -1;
            for (int j = 0; j < 4; ++j) {
                double f;
                if (z[j] < zlev) {
                    if (z[j + 1] > zlevp1) {
                        f = (z[j] - zlev) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        continue;
                    }
                    if (!(z[j + 1] >= zlev) || !(z[j + 1] <= zlevp1)) continue;
                    f = (z[j] - zlev) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    xpoly[++npoly] = x[j + 1];
                    ypoly[npoly] = y[j + 1];
                    continue;
                }
                if (z[j] > zlevp1) {
                    if (z[j + 1] < zlev) {
                        f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        f = (z[j] - zlev) / (z[j] - z[j + 1]);
                        xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                        ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                        continue;
                    }
                    if (!(z[j + 1] >= zlev) || !(z[j + 1] <= zlevp1)) continue;
                    f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    xpoly[++npoly] = x[j + 1];
                    ypoly[npoly] = y[j + 1];
                    continue;
                }
                if (z[j + 1] > zlevp1) {
                    f = (z[j] - zlevp1) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    continue;
                }
                if (z[j + 1] < zlev) {
                    f = (z[j] - zlev) / (z[j] - z[j + 1]);
                    xpoly[++npoly] = x[j] - f * (x[j] - x[j + 1]);
                    ypoly[npoly] = y[j] - f * (y[j] - y[j + 1]);
                    continue;
                }
                xpoly[++npoly] = x[j + 1];
                ypoly[npoly] = y[j + 1];
            }
            this.fillPolygon(g, col, xpoly, ypoly, npoly + 1);
        }
    }

    private void fillPolygon(Graphics g, Color c, double[] x, double[] y, int npoints) {
        Layer layer = this.cg_.getLayer();
        int[] xt = new int[20];
        int[] yt = new int[20];
        g.setColor(c);
        for (int i = 0; i < npoints; ++i) {
            xt[i] = layer.getXPtoD(x[i]);
            yt[i] = layer.getYPtoD(y[i]);
        }
        g.fillPolygon(xt, yt, npoints);
    }

    private double[] xArrayP() {
        double[] p;
        if (this.grid_.isXTime()) {
            GeoDate[] t = this.grid_.getTimeArray();
            p = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                p[i] = this.cg_.getXUtoP(t[i]);
            }
        } else {
            double[] x = this.grid_.getXArray();
            p = new double[x.length];
            for (int i = 0; i < x.length; ++i) {
                p[i] = this.cg_.getXUtoP(x[i]);
            }
        }
        return p;
    }

    private double[] yArrayP() {
        double[] p;
        if (this.grid_.isYTime()) {
            GeoDate[] t = this.grid_.getTimeArray();
            p = new double[t.length];
            for (int i = 0; i < t.length; ++i) {
                p[i] = this.cg_.getYUtoP(t[i]);
            }
        } else {
            double[] y = this.grid_.getYArray();
            p = new double[y.length];
            for (int i = 0; i < y.length; ++i) {
                p[i] = this.cg_.getYUtoP(y[i]);
            }
        }
        return p;
    }

    private Range2D computeRange(int levels) {
        double zmin = Double.POSITIVE_INFINITY;
        double zmax = Double.NEGATIVE_INFINITY;
        double[] array = this.grid_.getZArray();
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            zmin = Math.min(zmin, array[i]);
            zmax = Math.max(zmax, array[i]);
        }
        Range2D range = Graph.computeRange(zmin, zmax, levels);
        return range;
    }

    public SGTGrid getGrid() {
        return this.grid_;
    }

    @Override
    public SGTData getData() {
        return this.grid_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.grid_ != null && this.grid_.isDynamic()) {
            this.dynamicModified("GridCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
        } else {
            this.modified("GridCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
        }
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return null;
    }

    @Override
    public void removeData() {
        this.con_ = null;
        this.grid_ = null;
    }
}

