/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerControl;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.MethodNotImplementedError;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.Selectable;
import gov.noaa.pmel.sgt.ZoomRectangle;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.swing.Draggable;
import gov.noaa.pmel.sgt.swing.ReShapeable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.JLayeredPane;
import javax.swing.Scrollable;

public class JPane
extends JLayeredPane
implements Scrollable,
Printable {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int SPECIFIED_LOCATION = -1;
    public static final int TO_FIT = 0;
    public static final int DEFAULT_SCALE = 1;
    public static final int SHRINK_TO_FIT = 2;
    public static String SGTVersion = "4.0";
    private int horizBlockIncrement = -1;
    private int vertBlockIncrement = -1;
    private int horizUnitIncrement = 1;
    private int vertUnitIncrement = 1;
    private String ident_;
    private Dimension lastPaneSize_;
    private Image offscreen_;
    private Dimension pagesize_;
    private Point pageOrigin_ = new Point(0, 0);
    private boolean printer_ = false;
    private int halign_ = 1;
    private int valign_ = 1;
    private int printMode_ = 2;
    private Object selectedobject_;
    private Object old_selectedobject_ = null;
    private Rectangle selectedRect_;
    private Rectangle zoom_rect_ = new Rectangle(0, 0, 0, 0);
    private Rectangle old_zoom_rect_ = null;
    private Point zoom_start_ = new Point(0, 0);
    private Point old_zoom_start_ = null;
    private boolean in_zoom_ = false;
    private boolean in_select_ = false;
    private boolean in_move_ = false;
    private boolean moved_ = false;
    private boolean draggable_ = false;
    private boolean reShapeable_ = false;
    private boolean moveable_ = false;
    private Point move_ref_;
    private boolean batch_ = false;
    private boolean modified_ = false;
    private boolean dynamicModified_ = false;
    private boolean ignoreModified_ = false;
    private boolean mouseEventsEnabled_ = true;
    private double zoom_ = 1.0;
    private ZoomRectangle zoomRectangle_ = null;
    private PropertyChangeSupport changes_ = null;
    private long lastTimeBitBlit = 0L;
    private long lastTimeDraw = 0L;
    private double bitBlitRate = 0.0;
    private double drawRate = 0.0;
    private final Object paneLock_ = new Object();

    public JPane(String id, Dimension size) {
        this.ident_ = id;
        this.lastPaneSize_ = size;
        this.changes_ = new PropertyChangeSupport(this);
        this.setSize(size);
        this.enableEvents(56L);
        this.setOpaque(true);
        this.setDoubleBuffered(false);
    }

    public JPane() {
        this(new String(""), new Dimension(50, 50));
    }

    public static String getVersion() {
        return SGTVersion;
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof LayerControl) {
            ((LayerControl)((Object)comp)).setPane(this);
        }
        return super.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        if (comp instanceof LayerControl) {
            ((LayerControl)((Object)comp)).setPane(this);
        }
        return super.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        super.add(comp, constraints);
        if (comp instanceof LayerControl) {
            ((LayerControl)((Object)comp)).setPane(this);
        }
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);
        if (comp instanceof LayerControl) {
            ((LayerControl)((Object)comp)).setPane(this);
        }
    }

    @Override
    public Component add(String name, Component comp) {
        if (comp instanceof LayerControl) {
            ((LayerControl)((Object)comp)).setPane(this);
        }
        return super.add(name, comp);
    }

    public void moveLayerUp(Layer lyr) throws LayerNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void moveLayerUp(String id) throws LayerNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void moveLayerDown(Layer lyr) throws LayerNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void moveLayerDown(String id) throws LayerNotFoundException {
        throw new MethodNotImplementedError();
    }

    @Override
    public void processMouseEvent(MouseEvent event) {
        if (!this.processMouseEventLocally(event)) {
            super.processMouseEvent(event);
        }
    }

    @Override
    public void processMouseMotionEvent(MouseEvent event) {
        if (!this.processMouseMotionEventLocally(event)) {
            super.processMouseMotionEvent(event);
        }
    }

    public Object[] getObjectsAt(Point pt) {
        return this.getObjectsAt(pt.x, pt.y);
    }

    public Component getComponent() {
        return this;
    }

    public void setBatch(boolean batch) {
        this.setBatch(batch, "");
    }

    public void setScrollableBlockIncrement(int horiz, int vert) {
        this.horizBlockIncrement = horiz;
        this.vertBlockIncrement = vert;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            if (this.horizBlockIncrement <= 0) {
                return this.getVisibleRect().width;
            }
            return this.horizBlockIncrement;
        }
        if (this.vertBlockIncrement <= 0) {
            return this.getVisibleRect().height;
        }
        return this.vertBlockIncrement;
    }

    public void setScrollableUnitIncrement(int horiz, int vert) {
        this.horizUnitIncrement = horiz;
        this.vertUnitIncrement = vert;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            if (this.horizUnitIncrement <= 0) {
                return 1;
            }
            return this.horizUnitIncrement;
        }
        if (this.vertUnitIncrement <= 0) {
            return 1;
        }
        return this.vertUnitIncrement;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        this.drawPage(g, pf);
        return 0;
    }

    public void drawPage(Graphics g, PageFormat pf, boolean scale) {
        if (scale) {
            this.drawPage(g, pf);
        } else {
            this.drawPage(g, pf.getImageableWidth(), pf.getImageableHeight());
        }
    }

    public void drawPdf(Graphics2D g2, float x, float y, float width, float height) {
        Dimension d = this.getSize();
        Point pageOrigin = null;
        pageOrigin = this.getPageOrigin();
        if (pageOrigin == null) {
            pageOrigin = new Point(0, 0);
        }
        double scale = 1.0;
        double dx = x;
        double dy = y;
        double yf = (double)height / d.getHeight();
        double xf = (double)width / d.getWidth();
        if (xf < yf) {
            scale = xf;
        } else if (xf > yf) {
            scale = yf;
        }
        g2.clipRect(-1000, -1000, 2000, 2000);
        g2.translate(dx += ((double)width - scale * d.getWidth()) / 2.0, dy += ((double)height - scale * d.getHeight()) / 2.0);
        g2.scale(scale, scale);
        this.drawPage((Graphics)g2, width, height);
    }

    protected void drawPage(Graphics g, PageFormat pf) {
        Dimension d = this.getSize();
        Point pageOrigin = null;
        pageOrigin = this.getPageOrigin();
        if (pageOrigin == null) {
            pageOrigin = new Point(0, 0);
        }
        Graphics2D g2 = (Graphics2D)g;
        double scale = 1.0;
        double dx = pf.getImageableX();
        double dy = pf.getImageableY();
        int scaleMode = this.getPageScaleMode();
        if (scaleMode == 0 || scaleMode == 2) {
            double yf = pf.getImageableHeight() / d.getHeight();
            double xf = pf.getImageableWidth() / d.getWidth();
            if (xf < yf) {
                scale = xf;
            } else if (xf > yf) {
                scale = yf;
            }
            if (scaleMode == 2 && scale > 1.0) {
                scale = 1.0;
            }
        }
        switch (this.getPageHAlign()) {
            default: {
                dx += (pf.getImageableWidth() - scale * d.getWidth()) / 2.0;
                break;
            }
            case 2: {
                dx += pf.getImageableWidth() - scale * d.getWidth();
                break;
            }
            case 0: {
                break;
            }
            case -1: {
                dx += (double)pageOrigin.x;
            }
        }
        switch (this.getPageVAlign()) {
            default: {
                break;
            }
            case 2: {
                dy += pf.getImageableHeight() - scale * d.getHeight();
                break;
            }
            case 1: {
                dy += (pf.getImageableHeight() - scale * d.getHeight()) / 2.0;
                break;
            }
            case -1: {
                dy += (double)pageOrigin.y;
            }
        }
        g.clipRect(-1000, -1000, 2000, 2000);
        g2.translate(dx, dy);
        g2.scale(scale, scale);
        this.drawPage(g, pf.getImageableWidth(), pf.getImageableHeight());
    }

    public void setZoom(double zoom) {
        if (zoom <= 0.01 || zoom > 100.0) {
            throw new RuntimeException("JPane.zoom: Invalid zoom factor:" + zoom);
        }
        this.zoom_ = zoom;
    }

    double getZoom() {
        return this.zoom_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void draw(Graphics g) {
        Object object = this.paneLock_;
        synchronized (object) {
            this.ignoreModified_ = true;
            this.printer_ = false;
            boolean op = this.isOpaque();
            Rectangle clip = this.getBounds();
            if (this.offscreen_ == (Image)null) {
                this.offscreen_ = this.createImage(clip.width, clip.height);
            } else if (clip.width != this.lastPaneSize_.width || clip.height != this.lastPaneSize_.height) {
                this.offscreen_ = this.createImage(clip.width, clip.height);
            }
            this.lastPaneSize_ = clip.getSize();
            Graphics goff = this.offscreen_.getGraphics();
            ((Graphics2D)goff).scale(this.zoom_, this.zoom_);
            goff.setClip(0, 0, clip.width, clip.height);
            this.drawLayers(goff);
            this.setOpaque(false);
            g.drawImage(this.offscreen_, 0, 0, this);
            this.setOpaque(op);
            this.drawDynamicData(g);
            this.drawDraggableItems(g);
            this.modified_ = false;
            this.dynamicModified_ = false;
            this.ignoreModified_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void draw(Graphics g, int width, int height) {
        Object object = this.paneLock_;
        synchronized (object) {
            this.ignoreModified_ = true;
            if (g instanceof PrintGraphics) {
                this.printer_ = true;
                this.pagesize_ = ((PrintGraphics)((Object)g)).getPrintJob().getPageDimension();
            } else {
                this.printer_ = false;
                this.pagesize_ = null;
            }
            g.setClip(0, 0, width, height);
            this.drawLayers(g);
            this.drawDynamicData(g);
            this.drawDraggableItems(g);
            this.modified_ = false;
            this.dynamicModified_ = false;
            this.ignoreModified_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawPage(Graphics g, double width, double height) {
        Object object = this.paneLock_;
        synchronized (object) {
            this.ignoreModified_ = true;
            this.printer_ = true;
            Color saved = g.getColor();
            g.setColor(this.getBackground());
            Rectangle r = this.getBounds();
            g.fillRect(r.x, r.y, r.width, r.height);
            g.setColor(saved);
            this.drawLayers(g);
            this.drawDynamicData(g);
            this.drawDraggableItems(g);
            this.modified_ = false;
            this.dynamicModified_ = false;
            this.ignoreModified_ = false;
            this.printer_ = false;
        }
    }

    void drawLayers(Graphics g) {
        if (!this.printer_) {
            if (this.isOpaque()) {
                Rectangle r = this.getBounds();
                g.setColor(this.getBackground());
                g.fillRect(0, 0, r.width, r.height);
            }
            g.setColor(this.getForeground());
        }
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                if (comps[i] instanceof Layer) {
                    ((Layer)comps[i]).draw(g);
                    continue;
                }
                if (!(comps[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)comps[i])).draw(g);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    void drawDraggableItems(Graphics g) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                if (!(comps[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)comps[i])).drawDraggableItems(g);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    void drawDynamicData(Graphics g) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                if (comps[i] instanceof Layer) {
                    ((Layer)comps[i]).drawDynamicData(g);
                    continue;
                }
                if (!(comps[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)comps[i])).drawDynamicData(g);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        boolean op = this.isOpaque();
        Dimension isze = this.getSize();
        if (isze.width != this.lastPaneSize_.width || isze.height != this.lastPaneSize_.height) {
            this.offscreen_ = null;
        }
        if (this.offscreen_ != null && !this.modified_) {
            this.setOpaque(false);
            g.drawImage(this.offscreen_, 0, 0, this);
            this.drawDynamicData(g);
            this.drawDraggableItems(g);
            this.setOpaque(op);
            long delta = System.currentTimeMillis() - this.lastTimeBitBlit;
            this.lastTimeBitBlit = System.currentTimeMillis();
            this.bitBlitRate = 1.0 / ((double)delta / 1000.0);
        } else {
            this.draw(g);
            long delta = System.currentTimeMillis() - this.lastTimeDraw;
            this.lastTimeDraw = System.currentTimeMillis();
            this.drawRate = 1.0 / ((double)delta / 1000.0);
        }
        if (this.in_zoom_) {
            this.zoomRectangle_.paintComponent(g);
        }
        this.modified_ = false;
        this.dynamicModified_ = false;
    }

    public double getBitBlitRate() {
        return this.bitBlitRate;
    }

    public double getDrawRate() {
        return this.drawRate;
    }

    public String getId() {
        return this.ident_;
    }

    public void setId(String id) {
        this.ident_ = id;
    }

    public void setPageAlign(int vert, int horz) {
        this.valign_ = vert;
        this.halign_ = horz;
    }

    public void setPageVAlign(int vert) {
        this.valign_ = vert;
    }

    public void setPageHAlign(int horz) {
        this.halign_ = horz;
    }

    public int getPageVAlign() {
        return this.valign_;
    }

    public int getPageHAlign() {
        return this.halign_;
    }

    public void setPageOrigin(Point p) {
        this.pageOrigin_ = p;
    }

    public Point getPageOrigin() {
        return this.pageOrigin_;
    }

    public boolean isPrinter() {
        return this.printer_;
    }

    public Dimension getPageSize() {
        return this.pagesize_;
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.lastPaneSize_ = d;
        this.offscreen_ = null;
    }

    public Layer getFirstLayer() {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Layer) {
                return (Layer)comps[i];
            }
            if (!(comps[i] instanceof Panel)) continue;
            Layer layer = ((Panel)comps[i]).getFirstDataGroupLayer();
            if (layer != null) {
                return layer;
            }
            layer = ((Panel)comps[i]).getLabelLayer();
            if (layer != null) {
                return layer;
            }
            layer = ((Panel)comps[i]).getLegendLayer();
            if (layer == null) continue;
            return layer;
        }
        return null;
    }

    public Layer getLayer(String id) throws LayerNotFoundException {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Layer) {
                if (!((Layer)comps[i]).getId().equals(id)) continue;
                return (Layer)comps[i];
            }
            if (!(comps[i] instanceof Panel) || !((Panel)comps[i]).hasLayer(id)) continue;
            return ((Panel)comps[i]).getLayer(id);
        }
        throw new LayerNotFoundException();
    }

    public Layer getLayerFromDataId(String id) throws LayerNotFoundException {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Layer) {
                if (!((Layer)comps[i]).isDataInLayer(id)) continue;
                return (Layer)comps[i];
            }
            if (!(comps[i] instanceof Panel) || !((Panel)comps[i]).isDataInPanel(id)) continue;
            return ((Panel)comps[i]).getLayerFromDataId(id);
        }
        throw new LayerNotFoundException();
    }

    public Object getSelectedObject() {
        return this.selectedobject_;
    }

    public void setSelectedObject(Object obj) {
        this.old_selectedobject_ = this.selectedobject_;
        this.selectedobject_ = obj;
    }

    public Rectangle getZoomBounds() {
        return this.zoom_rect_;
    }

    public Rectangle getLastZoomBounds() {
        return this.old_zoom_rect_;
    }

    public Point getZoomStart() {
        return this.zoom_start_;
    }

    public Point getLastZoomStart() {
        return this.old_zoom_start_;
    }

    public Object getObjectAt(int x, int y) {
        Object obj = null;
        Component[] comps = this.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Layer ? (obj = ((Layer)comps[i]).getObjectAt(x, y, false)) != null : comps[i] instanceof Panel && (obj = ((Panel)comps[i]).getObjectAt(x, y, false)) != null)) continue;
                return obj;
            }
        }
        return obj;
    }

    public Object[] getObjectsAt(int x, int y) {
        Vector<Object> obList = new Vector<Object>();
        Object obj = null;
        Component[] comps = this.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(x, y, false);
                    if (obj == null) continue;
                    obList.addElement(obj);
                    continue;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(x, y, false)) == null) continue;
                obList.addElement(obj);
            }
        }
        return obList.toArray();
    }

    boolean processMouseEventLocally(MouseEvent e) {
        ScaledMouseEvent event = new ScaledMouseEvent(e);
        boolean event_handled = false;
        if (!this.mouseEventsEnabled_) {
            return event_handled;
        }
        if (event.getID() == 500) {
            event_handled = this.Pane_MouseClicked(event);
        } else if (event.getID() == 501) {
            event_handled = this.Pane_MouseDown(event);
        } else if (event.getID() == 502) {
            event_handled = this.Pane_MouseUp(event);
        }
        return event_handled;
    }

    boolean processMouseMotionEventLocally(MouseEvent e) {
        ScaledMouseEvent event = new ScaledMouseEvent(e);
        boolean event_handled = false;
        if (!this.mouseEventsEnabled_) {
            return event_handled;
        }
        if (event.getID() == 506) {
            event_handled = this.Pane_MouseDrag(event);
        } else if (event.getID() == 503) {
            event_handled = this.Pane_MouseMoved(event);
        }
        return event_handled;
    }

    private boolean Pane_MouseClicked(ScaledMouseEvent event) {
        Selectable savedobj = null;
        int mod = event.getModifiers();
        if ((mod & 0x10) == 0) {
            return false;
        }
        this.in_zoom_ = false;
        this.in_select_ = false;
        Graphics g = this.getScaledGraphics();
        if (!this.moved_ && this.selectedobject_ instanceof Selectable && ((Selectable)this.selectedobject_).isSelected()) {
            savedobj = (Selectable)this.selectedobject_;
            if (this.moveable_) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            g.setXORMode(this.getBackground());
            g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
            g.setPaintMode();
            savedobj.setSelected(false);
            this.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        this.selectedobject_ = null;
        Component[] comps = this.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                Object obj;
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(event.getX(), event.getY());
                    if (obj == null) continue;
                    this.selectedobject_ = obj;
                    break;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(event.getX(), event.getY(), false)) == null) continue;
                this.selectedobject_ = obj;
                break;
            }
            if (this.selectedobject_ instanceof Selectable) {
                if (!this.selectedobject_.equals(savedobj) && ((Selectable)this.selectedobject_).isSelectable()) {
                    ((Selectable)this.selectedobject_).setSelected(true);
                    this.in_select_ = true;
                    if (!this.in_move_) {
                        this.selectedRect_ = new Rectangle(((Selectable)this.selectedobject_).getBounds());
                        if (this.moveable_) {
                            g.setColor(Color.red);
                        } else {
                            g.setColor(Color.blue);
                        }
                        g.setXORMode(this.getBackground());
                        g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                        g.setPaintMode();
                    }
                    this.in_move_ = false;
                    this.changes_.firePropertyChange("objectSelected", this.old_selectedobject_, this.selectedobject_);
                }
            } else if (this.selectedobject_ != null) {
                this.changes_.firePropertyChange("objectSelected", this.old_selectedobject_, this.selectedobject_);
            }
        }
        return false;
    }

    private boolean Pane_MouseMoved(ScaledMouseEvent event) {
        if (this.in_select_) {
            if (this.selectedRect_.contains(event.getX(), event.getY())) {
                this.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            return true;
        }
        Component[] comps = this.getComponents();
        boolean found = false;
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                Object obj;
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(event.getX(), event.getY());
                    if (obj == null || !(obj instanceof ReShapeable)) continue;
                    found = true;
                    this.setCursor(Cursor.getPredefinedCursor(((ReShapeable)obj).getCursor(event.getMouseEvent())));
                    break;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(event.getX(), event.getY(), false)) == null || !(obj instanceof ReShapeable)) continue;
                found = true;
                this.setCursor(Cursor.getPredefinedCursor(((ReShapeable)obj).getCursor(event.getMouseEvent())));
                break;
            }
        }
        if (!found) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        return false;
    }

    private boolean Pane_MouseDown(ScaledMouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return false;
        }
        this.old_zoom_rect_ = new Rectangle(this.zoom_rect_);
        this.old_zoom_start_ = new Point(this.zoom_start_);
        this.zoom_rect_.x = 0;
        this.zoom_rect_.y = 0;
        this.zoom_rect_.width = 0;
        this.zoom_rect_.height = 0;
        Graphics g = this.getScaledGraphics();
        boolean ignoreSelected = false;
        if (this.selectedobject_ != null) {
            boolean bl = ignoreSelected = this.selectedobject_ instanceof Draggable || this.selectedobject_ instanceof ReShapeable;
        }
        if (event.isShiftDown()) {
            this.in_zoom_ = true;
            this.zoom_start_.x = event.getX();
            this.zoom_start_.y = event.getY();
            this.zoomRectangle_ = new ZoomRectangle(event);
            this.zoom_rect_ = this.zoomRectangle_.getRectangle();
            this.add((Component)this.zoomRectangle_, JLayeredPane.DRAG_LAYER);
            return true;
        }
        if (event.isControlDown()) {
            return false;
        }
        if (!ignoreSelected && this.in_select_ && this.moveable_ && this.selectedRect_.contains(event.getX(), event.getY())) {
            this.in_move_ = true;
            this.moved_ = false;
            this.move_ref_ = new Point(event.getX(), event.getY());
            return true;
        }
        if (!ignoreSelected && this.in_select_ && !this.moveable_ && this.selectedRect_.contains(event.getX(), event.getY())) {
            this.in_move_ = false;
            this.moved_ = false;
            return true;
        }
        this.selectedobject_ = null;
        Component[] comps = this.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                Object obj;
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(event.getX(), event.getY());
                    if (obj == null) continue;
                    this.selectedobject_ = obj;
                    break;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(event.getX(), event.getY(), false)) == null) continue;
                this.selectedobject_ = obj;
                break;
            }
            if (this.selectedobject_ instanceof Selectable && ((Selectable)this.selectedobject_).isSelectable()) {
                this.draggable_ = this.selectedobject_ instanceof Draggable;
                this.reShapeable_ = this.selectedobject_ instanceof ReShapeable;
                this.moveable_ = this.selectedobject_ instanceof Moveable ? ((Moveable)this.selectedobject_).isMoveable() : false;
                this.in_move_ = this.moveable_ || this.draggable_ || this.reShapeable_;
                this.moved_ = false;
                if (this.reShapeable_) {
                    ((ReShapeable)this.selectedobject_).reset();
                }
                ((Selectable)this.selectedobject_).setSelected(false);
                this.selectedRect_ = new Rectangle(((Selectable)this.selectedobject_).getBounds());
                if (!this.draggable_ && !this.reShapeable_ && this.moveable_) {
                    g.setColor(Color.red);
                    g.setXORMode(this.getBackground());
                    g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                    g.setPaintMode();
                }
                if (!this.draggable_ && !this.reShapeable_) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                }
                this.move_ref_ = new Point(event.getX(), event.getY());
                return true;
            }
        }
        this.in_zoom_ = true;
        this.zoom_start_.x = event.getX();
        this.zoom_start_.y = event.getY();
        this.zoomRectangle_ = new ZoomRectangle(event);
        this.zoom_rect_ = this.zoomRectangle_.getRectangle();
        this.add(this.zoomRectangle_);
        this.revalidate();
        return true;
    }

    private boolean Pane_MouseDrag(ScaledMouseEvent event) {
        boolean handled = false;
        Graphics g = this.getScaledGraphics();
        if (this.in_zoom_) {
            handled = true;
            this.zoomRectangle_.setVisible(false);
            this.repaint(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width + 2, this.zoom_rect_.height + 2);
            this.zoomRectangle_.zoomTo(event);
            this.zoomRectangle_.setVisible(true);
            this.zoom_rect_ = this.zoomRectangle_.getRectangle();
            this.revalidate();
        } else if (this.in_move_) {
            Rectangle rect;
            handled = true;
            this.moved_ = true;
            if (!this.draggable_ && !this.reShapeable_ && this.moveable_) {
                g.setColor(Color.red);
                g.setXORMode(this.getBackground());
                g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
            } else if (this.draggable_) {
                ((LayerChild)this.selectedobject_).setVisible(false);
                rect = ((LayerChild)this.selectedobject_).getRepaintBounds();
                this.repaint(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
            } else if (this.reShapeable_) {
                ((LayerChild)this.selectedobject_).setVisible(false);
                rect = ((LayerChild)this.selectedobject_).getRepaintBounds();
                this.repaint(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
            }
            this.selectedRect_.x += event.getX() - this.move_ref_.x;
            this.selectedRect_.y += event.getY() - this.move_ref_.y;
            if (!this.draggable_ && !this.reShapeable_ && this.moveable_) {
                g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                g.setPaintMode();
            } else if (this.draggable_) {
                try {
                    ((LayerChild)this.selectedobject_).setVisible(true);
                    ((Draggable)this.selectedobject_).setLocation(new Point(this.selectedRect_.x, this.selectedRect_.y), false);
                    ((LayerChild)this.selectedobject_).draw(g);
                }
                catch (LayerNotFoundException rect2) {}
            } else if (this.reShapeable_) {
                try {
                    ((LayerChild)this.selectedobject_).setVisible(true);
                    Point dx = new Point(event.getX() - this.move_ref_.x, event.getY() - this.move_ref_.y);
                    Point loc = new Point(this.selectedRect_.x, this.selectedRect_.y);
                    ((ReShapeable)this.selectedobject_).adjustShape(event.e_, loc, dx, false);
                    ((LayerChild)this.selectedobject_).draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
            this.move_ref_ = new Point(event.getX(), event.getY());
        }
        return handled;
    }

    private boolean Pane_MouseUp(ScaledMouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return false;
        }
        Graphics g = this.getScaledGraphics();
        if (this.in_zoom_) {
            this.in_zoom_ = false;
            this.zoom_rect_ = this.zoomRectangle_.getRectangle();
            this.remove(this.zoomRectangle_);
            this.zoomRectangle_ = null;
            this.revalidate();
            this.changes_.firePropertyChange("zoomRectangle", this.old_zoom_rect_, this.zoom_rect_);
            return false;
        }
        if (this.in_move_ && this.moved_) {
            if (!this.draggable_ && !this.reShapeable_ && this.moveable_) {
                g.setColor(Color.red);
                g.setXORMode(this.getBackground());
                g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                g.setPaintMode();
            }
            Point loc = new Point(this.selectedRect_.x, this.selectedRect_.y);
            if (this.draggable_) {
                ((Draggable)this.selectedobject_).setLocation(loc);
                this.paintComponent(g);
            } else if (this.moveable_) {
                ((Moveable)this.selectedobject_).setLocation(loc);
                this.modified_ = true;
                this.repaint();
            } else if (this.reShapeable_) {
                Point dx = new Point(0, 0);
                ((ReShapeable)this.selectedobject_).adjustShape(event.e_, loc, dx, true);
                this.paintComponent(g);
            }
            this.in_move_ = false;
            this.in_select_ = false;
            this.moved_ = false;
            this.draggable_ = false;
            this.moveable_ = false;
            this.reShapeable_ = false;
            ((Selectable)this.selectedobject_).setSelected(false);
            this.setCursor(Cursor.getPredefinedCursor(0));
            return true;
        }
        return false;
    }

    private Graphics getScaledGraphics() {
        Graphics2D g2 = null;
        g2 = (Graphics2D)this.getGraphics();
        g2.scale(this.zoom_, this.zoom_);
        return g2;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.lastPaneSize_.width, this.lastPaneSize_.height);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.lastPaneSize_.width, this.lastPaneSize_.height);
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    public void setBatch(boolean batch, String msg) {
        this.batch_ = batch;
        if (!this.batch_ && (this.modified_ || this.dynamicModified_)) {
            this.repaint();
        }
    }

    public boolean isBatch() {
        return this.batch_;
    }

    void setIgnoreModified(boolean ig) {
        this.ignoreModified_ = ig;
    }

    void clearModified() {
        this.modified_ = false;
    }

    public void setModified(boolean mod, String mess) {
        if (this.ignoreModified_) {
            return;
        }
        this.modified_ = mod;
        if (this.modified_ && !this.batch_) {
            this.repaint();
        }
    }

    public boolean isModified() {
        return this.modified_;
    }

    void clearDynamicModified() {
        this.dynamicModified_ = false;
    }

    public void setDynamicModified(boolean mod, String mess) {
        if (this.ignoreModified_) {
            return;
        }
        this.dynamicModified_ = mod;
        if (this.dynamicModified_ && !this.batch_) {
            this.repaint();
        }
    }

    public boolean isDynamicModified() {
        return this.dynamicModified_;
    }

    public void setMouseEventsEnabled(boolean enable) {
        this.mouseEventsEnabled_ = enable;
    }

    public boolean isMouseEventsEnabled() {
        return this.mouseEventsEnabled_;
    }

    public void setPageScaleMode(int mode) {
        this.printMode_ = mode;
    }

    public int getPageScaleMode() {
        return this.printMode_;
    }

    public Object getPaneLock() {
        return this.paneLock_;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    public void dispose() {
        this.offscreen_ = null;
    }

    class ScaledMouseEvent {
        MouseEvent e_;

        ScaledMouseEvent(MouseEvent e) {
            this.e_ = e;
        }

        MouseEvent getMouseEvent() {
            return this.e_;
        }

        int getID() {
            return this.e_.getID();
        }

        int getModifiers() {
            return this.e_.getModifiers();
        }

        int getX() {
            return (int)((double)this.e_.getX() / JPane.this.zoom_);
        }

        int getY() {
            return (int)((double)this.e_.getY() / JPane.this.zoom_);
        }

        boolean isShiftDown() {
            return this.e_.isShiftDown();
        }

        boolean isControlDown() {
            return this.e_.isControlDown();
        }
    }
}

