/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.Format;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.SpaceAxis;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;

public class LatitudeAxis
extends SpaceAxis
implements Cloneable {
    static final double TIC_GAP = 0.05;
    static final double TIC_RATIO = 1.3;
    static final double LABEL_RATIO = 1.1;
    private boolean labelQuadrant_ = true;

    public LatitudeAxis() {
        this("");
    }

    public LatitudeAxis(String id) {
        super(id);
    }

    @Override
    public Axis copy() {
        LatitudeAxis newAxis;
        try {
            newAxis = (LatitudeAxis)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newAxis = new LatitudeAxis();
        }
        newAxis.registeredAxes_ = new Vector(2, 2);
        newAxis.registeredTransforms_ = new Vector(2, 2);
        return newAxis;
    }

    @Override
    public void draw(Graphics g) {
        double delta = this.uRange_.delta;
        SGLabel title = this.getTitle();
        if (!this.visible_) {
            return;
        }
        if (Double.isNaN(delta)) {
            delta = Graph.computeRange((Range2D)this.uRange_, (int)10).delta;
        }
        if (title != null) {
            title.setLayer(this.graph_.getLayer());
        }
        if (this.lineColor_ == null) {
            g.setColor(this.graph_.getLayer().getPane().getComponent().getForeground());
        } else {
            g.setColor(this.lineColor_);
        }
        Format format = this.computeFormat();
        if (this.orientation_ == 0) {
            double ytitle;
            double yt;
            int vertalign;
            int i;
            double yp;
            int yloc;
            if (this.uLocation_ == null) {
                yloc = this.graph_.getYUtoD(this.tLocation_.t);
                yp = this.graph_.getYUtoP(this.tLocation_.t);
            } else {
                yloc = this.graph_.getYUtoD(this.uLocation_.y);
                yp = this.graph_.getYUtoP(this.uLocation_.y);
            }
            int xloc = this.graph_.getXUtoD(this.uRange_.start);
            int xend = this.graph_.getXUtoD(this.uRange_.end);
            g.drawLine(xloc, yloc, xend, yloc);
            double dir = delta > 0.0 ? 1.0 : -1.0;
            double xt = (double)((int)(this.uRange_.start / delta + (dir * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * delta;
            if (dir * xt < dir * this.uRange_.start) {
                xt += delta;
            }
            int istop = (int)((this.uRange_.end - xt) / delta + 1.0E-5);
            double x = xt;
            double xp = this.graph_.getXUtoP(x);
            this.drawSmallXTics(g, x, this.uRange_.start, -delta, yp);
            this.drawXTic(g, xp, yp, this.largeTicHeight_);
            for (i = 0; i < istop; ++i) {
                this.drawSmallXTics(g, x, this.uRange_.end, delta, yp);
                xp = this.graph_.getXUtoP(x += delta);
                this.drawXTic(g, xp, yp, this.largeTicHeight_);
            }
            this.drawSmallXTics(g, x, this.uRange_.end, delta, yp);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 0) {
                vertalign = 2;
                yt = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + 1.3 * this.largeTicHeight_ : yp + 0.05;
                ytitle = yt + 1.1 * this.labelHeight_;
            } else {
                vertalign = 0;
                yt = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - 1.3 * this.largeTicHeight_ : yp - 0.05;
                ytitle = yt - 1.1 * this.labelHeight_;
            }
            x = dir * this.uRange_.start <= 0.0 && dir * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (delta * (double)this.labelInterval_) - 1.0E-5)) * delta * (double)this.labelInterval_ : xt;
            istop = (int)((this.uRange_.end - x) / (delta * (double)this.labelInterval_) + 1.0E-5);
            for (i = 0; i <= istop; ++i) {
                xt = this.graph_.getXUtoP(x);
                String labelText = this.generateLabel(format, x);
                SGLabel label = new SGLabel("coordinate", labelText, new Point2D.Double(xt, yt));
                label.setAlign(vertalign, 1);
                label.setOrientation(0);
                label.setFont(this.labelFont_);
                label.setColor(this.labelColor_);
                label.setHeightP(this.labelHeight_);
                label.setLayer(this.graph_.getLayer());
                try {
                    label.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                x += delta * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double xtitle = (this.uRange_.end + this.uRange_.start) * 0.5;
                yt = ytitle;
                xt = this.graph_.getXUtoP(xtitle);
                title.setLocationP(new Point2D.Double(xt, yt));
                title.setAlign(vertalign, 1);
                title.setOrientation(0);
                try {
                    title.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        } else {
            double xtitle;
            double xt;
            int ylabOrient;
            int horzalign;
            int vertalign;
            int i;
            double xp;
            int xloc;
            if (this.uLocation_ == null) {
                xloc = this.graph_.getXUtoD(this.tLocation_.t);
                xp = this.graph_.getXUtoP(this.tLocation_.t);
            } else {
                xloc = this.graph_.getXUtoD(this.uLocation_.x);
                xp = this.graph_.getXUtoP(this.uLocation_.x);
            }
            int yloc = this.graph_.getYUtoD(this.uRange_.start);
            int yend = this.graph_.getYUtoD(this.uRange_.end);
            g.drawLine(xloc, yloc, xloc, yend);
            double dir = delta > 0.0 ? 1.0 : -1.0;
            double yt = (double)((int)(this.uRange_.start / delta + (dir * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * delta;
            if (dir * yt < dir * this.uRange_.start) {
                yt += delta;
            }
            int istop = (int)((this.uRange_.end - yt) / delta + 1.0E-5);
            double y = yt;
            double yp = this.graph_.getYUtoP(y);
            this.drawSmallYTics(g, xp, y, this.uRange_.start, -delta);
            this.drawYTic(g, xp, yp, this.largeTicHeight_);
            for (i = 0; i < istop; ++i) {
                this.drawSmallYTics(g, xp, y, this.uRange_.end, delta);
                yp = this.graph_.getYUtoP(y += delta);
                this.drawYTic(g, xp, yp, this.largeTicHeight_);
            }
            this.drawSmallYTics(g, xp, y, this.uRange_.end, delta);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 1) {
                if (this.yLabelOrientation_ == 1) {
                    vertalign = 2;
                    horzalign = 1;
                    ylabOrient = 1;
                } else {
                    vertalign = 1;
                    horzalign = 2;
                    ylabOrient = 0;
                }
                xt = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - 1.3 * this.largeTicHeight_ : xp - 0.05;
                xtitle = xt - 1.1 * this.labelHeight_;
            } else {
                if (this.yLabelOrientation_ == 1) {
                    vertalign = 0;
                    horzalign = 1;
                    ylabOrient = 1;
                } else {
                    vertalign = 1;
                    horzalign = 0;
                    ylabOrient = 0;
                }
                xt = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + 1.3 * this.largeTicHeight_ : xp + 0.05;
                xtitle = xt + 1.1 * this.labelHeight_;
            }
            y = dir * this.uRange_.start <= 0.0 && dir * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (delta * (double)this.labelInterval_) - 1.0E-5)) * delta * (double)this.labelInterval_ : yt;
            istop = (int)((this.uRange_.end - y) / (delta * (double)this.labelInterval_) + 1.0E-5);
            double maxwidth = 0.0;
            for (i = 0; i <= istop; ++i) {
                yt = this.graph_.getYUtoP(y);
                String labelText = this.generateLabel(format, y);
                SGLabel label = new SGLabel("coordinate", labelText, new Point2D.Double(xt, yt));
                label.setAlign(vertalign, horzalign);
                label.setOrientation(ylabOrient);
                label.setFont(this.labelFont_);
                label.setColor(this.labelColor_);
                label.setHeightP(this.labelHeight_);
                label.setLayer(this.graph_.getLayer());
                try {
                    label.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                maxwidth = Math.max(maxwidth, label.getBoundsP().width);
                y += delta * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double ytitle = (this.uRange_.end + this.uRange_.start) * 0.5;
                yt = this.graph_.getYUtoP(ytitle);
                xt = xtitle;
                if (this.yLabelOrientation_ == 0) {
                    xt = this.labelPosition_ == 1 ? (xt -= maxwidth) : (xt += maxwidth);
                }
                title.setLocationP(new Point2D.Double(xt, yt));
                title.setAlign(vertalign, 1);
                title.setOrientation(1);
                try {
                    title.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Rectangle getBounds() {
        int height;
        int y;
        int x;
        int width;
        if (this.orientation_ == 0) {
            int xd = this.graph_.getXUtoD(this.uRange_.start);
            double yp = this.uLocation_ == null ? this.graph_.getYUtoP(this.tLocation_.t) : this.graph_.getYUtoP(this.uLocation_.y);
            width = this.graph_.getXUtoD(this.uRange_.end) - xd;
            x = xd;
            double ymin = yp;
            double ymax = yp;
            if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                ymax += this.largeTicHeight_;
            }
            if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                ymin -= this.largeTicHeight_;
            }
            if (this.labelPosition_ == 0) {
                ymax = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? ymax + -0.30000000000000004 * this.largeTicHeight_ + this.labelHeight_ : ymax + 0.05 + this.labelHeight_;
            } else if (this.labelPosition_ == 1) {
                ymin = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? ymin - -0.30000000000000004 * this.largeTicHeight_ - this.labelHeight_ : ymin - 0.05 - this.labelHeight_;
            }
            y = this.graph_.getLayer().getYPtoD(ymax);
            height = this.graph_.getLayer().getYPtoD(ymin) - y;
        } else {
            int yd = this.graph_.getYUtoD(this.uRange_.start);
            double xp = this.uLocation_ == null ? this.graph_.getXUtoP(this.tLocation_.t) : this.graph_.getXUtoP(this.uLocation_.x);
            y = this.graph_.getYUtoD(this.uRange_.end);
            height = yd - y;
            double xmin = xp;
            double xmax = xp;
            if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                xmax += this.largeTicHeight_;
            }
            if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                xmin -= this.largeTicHeight_;
            }
            if (this.labelPosition_ == 0) {
                xmax = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xmax + -0.30000000000000004 * this.largeTicHeight_ + this.labelHeight_ : xmax + 0.05 + this.labelHeight_;
            } else if (this.labelPosition_ == 1) {
                xmin = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xmin - -0.30000000000000004 * this.largeTicHeight_ - this.labelHeight_ : xmin - 0.05 - this.labelHeight_;
            }
            x = this.graph_.getLayer().getXPtoD(xmin);
            width = this.graph_.getLayer().getXPtoD(xmax) - x;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
    }

    public void setLabelQuadrant(boolean label) {
        if (this.labelQuadrant_ != label) {
            this.labelQuadrant_ = label;
            this.modified("LatitudeAxis: setLabelQuadrant()");
        }
    }

    public boolean isLabelQuadrant() {
        return this.labelQuadrant_;
    }

    private Format computeFormat() {
        Format format = null;
        format = this.labelFormat_.length() <= 0 ? new Format(Format.computeFormat(this.uRange_.start, this.uRange_.end, this.sigDigits_)) : new Format(this.labelFormat_);
        return format;
    }

    private String generateLabel(Format format, double value) {
        String label;
        if (this.labelQuadrant_) {
            double x = Math.abs(value);
            label = format.form(x);
            if (value > 0.0) {
                label = label + "N";
            } else if (value < 0.0) {
                label = label + "S";
            }
        } else {
            label = format.form(value);
        }
        return label;
    }
}

