/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ChildNotFoundException;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerControl;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import gov.noaa.pmel.sgt.LineKey;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.PointCartesianRenderer;
import gov.noaa.pmel.sgt.PointCollectionKey;
import gov.noaa.pmel.sgt.VectorKey;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.Draggable;
import gov.noaa.pmel.sgt.swing.ReShapeable;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Layer
extends Component
implements Cloneable,
LayerControl {
    private String ident_;
    private Graph graph_;
    private Vector children_;
    private double pWidth_;
    private double pHeight_;
    private double ax_;
    private double ay_;
    private int xoff_;
    private int yoff_;
    private double xoff2_;
    private double yoff2_;
    protected JPane pane_;

    private void computeScale() {
        Rectangle pbnds = this.pane_.getBounds();
        Rectangle bnds = this.getBounds();
        if (this.pane_.isPrinter()) {
            this.ay_ = this.ax_ = 72.0;
            this.xoff2_ = ((double)bnds.width - this.ax_ * this.pWidth_) / 2.0 + (double)bnds.x;
            this.yoff2_ = (double)bnds.height - ((double)bnds.height - this.ay_ * this.pHeight_) / 2.0 + (double)bnds.y;
        } else {
            this.ax_ = (double)bnds.width / this.pWidth_;
            this.ay_ = (double)bnds.height / this.pHeight_;
            if (this.ax_ > this.ay_) {
                this.ax_ = this.ay_;
            } else if (this.ay_ > this.ax_) {
                this.ay_ = this.ax_;
            }
            this.xoff2_ = ((double)bnds.width - this.ax_ * this.pWidth_) / 2.0 + (double)bnds.x - (double)pbnds.x;
            this.yoff2_ = (double)bnds.height - ((double)bnds.height - this.ay_ * this.pHeight_) / 2.0 + (double)bnds.y - (double)pbnds.y;
        }
        this.xoff_ = (int)(this.xoff2_ + 0.5);
        this.yoff_ = (int)(this.yoff2_ + 0.5);
    }

    private String showParent(Container cont) {
        if (cont == null) {
            return "<< no parent >>";
        }
        String className = cont.getClass().getName();
        String name = cont.getName();
        return className + ": " + name;
    }

    @Override
    public void setSize(Dimension sze) {
        super.setSize(sze);
        this.computeScale();
        this.modified("Layer: setSize(Dimension)");
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.computeScale();
        this.modified("Layer: setSize(int,int)");
    }

    @Override
    public void setLocation(Point pt) {
        super.setLocation(pt);
        this.computeScale();
        this.modified("Layer: setLocation(Point)");
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.computeScale();
        this.modified("Layer: setLocation(int,int)");
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.computeScale();
        this.modified("Layer.setBounds(" + x + ", " + y + ", " + w + ", " + h + ")");
    }

    @Override
    public void setBounds(Rectangle bnds) {
        super.setBounds(bnds);
        this.computeScale();
        this.modified("Layer: setBounds(Rectangle)");
    }

    public int getXPtoD(double xp) {
        return (int)(this.ax_ * xp + 0.5) + this.xoff_;
    }

    public int getYPtoD(double yp) {
        return this.yoff_ - (int)(this.ay_ * yp + 0.5);
    }

    public double getXPtoD2(double xp) {
        return this.ax_ * xp + this.xoff2_;
    }

    public double getYPtoD2(double yp) {
        return this.yoff2_ - this.ay_ * yp;
    }

    public double getXSlope() {
        return this.ax_;
    }

    public double getYSlope() {
        return this.ay_;
    }

    public double getXOffset() {
        return this.xoff2_;
    }

    public double getYOffset() {
        return this.yoff2_;
    }

    public double getXDtoP(int xd) {
        return ((double)xd - this.xoff2_) / this.ax_;
    }

    public double getYDtoP(int yd) {
        return (this.yoff2_ - (double)yd) / this.ay_;
    }

    public Layer(String id) {
        this(id, new Dimension2D(1.0, 1.0));
    }

    public Layer(String id, Dimension2D psize) {
        this.ident_ = id;
        this.pWidth_ = psize.width;
        this.pHeight_ = psize.height;
        this.children_ = new Vector(5, 5);
    }

    public Layer() {
        this("");
    }

    public Layer copy() {
        Layer newLayer;
        try {
            newLayer = (Layer)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLayer = new Layer(this.ident_, new Dimension2D(this.pWidth_, this.pHeight_));
        }
        newLayer.children_ = new Vector(5, 5);
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild newChild = ((LayerChild)it.nextElement()).copy();
                newLayer.addChild(newChild);
            }
        }
        if (this.graph_ != (Graph)null) {
            Graph newGraph = this.graph_.copy();
            newLayer.setGraph(newGraph);
        }
        return newLayer;
    }

    @Override
    public void draw(Graphics g) throws PaneNotFoundException {
        if (this.pane_ == null) {
            throw new PaneNotFoundException();
        }
        this.computeScale();
        if (this.graph_ != (Graph)null) {
            this.graph_.draw(g);
        }
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild child = (LayerChild)it.nextElement();
                if (child instanceof Draggable || child instanceof ReShapeable) continue;
                try {
                    child.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        }
    }

    @Override
    public void drawDynamicData(Graphics g) throws PaneNotFoundException {
        if (this.pane_ == null) {
            throw new PaneNotFoundException();
        }
        this.computeScale();
        if (this.graph_ != (Graph)null) {
            this.graph_.drawDynamicData(g);
        }
    }

    @Override
    public void drawDraggableItems(Graphics g) throws PaneNotFoundException {
        if (this.pane_ == null) {
            throw new PaneNotFoundException();
        }
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild child = (LayerChild)it.nextElement();
                if (!(child instanceof Draggable) && !(child instanceof ReShapeable)) continue;
                try {
                    child.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        }
    }

    public boolean setGraph(Graph gr) {
        this.graph_ = gr;
        this.graph_.setLayer(this);
        this.modified("Layer: setGraph()");
        return true;
    }

    public Graph getGraph() {
        return this.graph_;
    }

    public void addChild(LayerChild child) {
        child.setLayer(this);
        this.children_.addElement(child);
        this.modified("Layer: addChild()");
    }

    public void removeChild(LayerChild child) throws ChildNotFoundException {
        if (!this.children_.isEmpty()) {
            boolean found = false;
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild chld = (LayerChild)it.nextElement();
                if (!chld.equals(child)) continue;
                this.children_.removeElement(child);
                found = true;
                this.modified("Layer: removeChild(LayerChild)");
            }
            if (!found) {
                throw new ChildNotFoundException();
            }
        } else {
            throw new ChildNotFoundException();
        }
    }

    public void removeChild(String labid) throws ChildNotFoundException {
        if (!this.children_.isEmpty()) {
            boolean found = false;
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild child = (LayerChild)it.nextElement();
                if (!child.getId().equals(labid)) continue;
                this.children_.removeElement(child);
                found = true;
                this.modified("Layer: removeChild(String)");
            }
            if (!found) {
                throw new ChildNotFoundException();
            }
        } else {
            throw new ChildNotFoundException();
        }
    }

    public LayerChild findChild(String id) {
        LayerChild child = null;
        Enumeration it = this.children_.elements();
        while (it.hasMoreElements()) {
            child = (LayerChild)it.nextElement();
            if (!child.getId().equals(id)) continue;
            return child;
        }
        return null;
    }

    public boolean isChildAttached(LayerChild child) {
        boolean found = false;
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild chld = (LayerChild)it.nextElement();
                if (!chld.equals(child)) continue;
                this.children_.removeElement(child);
                found = true;
                break;
            }
        }
        return found;
    }

    public void removeAllChildren() {
        this.children_.removeAllElements();
        this.modified("Layer: removeAllChildren()");
    }

    public LayerChild getChild(String labid) throws ChildNotFoundException {
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild child = (LayerChild)it.nextElement();
                if (!child.getId().equals(labid)) continue;
                return child;
            }
            throw new ChildNotFoundException();
        }
        throw new ChildNotFoundException();
    }

    public Enumeration childElements() {
        return this.children_.elements();
    }

    public Iterator childIterator() {
        return this.children_.iterator();
    }

    public LayerChild[] getChildren() {
        LayerChild[] childs = new LayerChild[]{};
        childs = this.children_.toArray(childs);
        return childs;
    }

    public boolean hasChild(LayerChild child) {
        return this.children_.contains(child);
    }

    public void setSizeP(Dimension2D psize) {
        this.pWidth_ = psize.width;
        this.pHeight_ = psize.height;
        this.computeScale();
        this.modified("Layer: setSizeP()");
    }

    public Dimension2D getSizeP() {
        return new Dimension2D(this.pWidth_, this.pHeight_);
    }

    public Rectangle2D.Double getBoundsP() {
        return new Rectangle2D.Double(0.0, 0.0, this.pWidth_, this.pHeight_);
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public void setPane(JPane p) {
        this.pane_ = p;
        this.computeScale();
        this.modified("Layer: setPane()");
    }

    public JPane getPane() {
        return this.pane_;
    }

    public void modified(String mess) {
        if (this.pane_ != null) {
            this.pane_.setModified(true, mess);
        }
    }

    public void dynamicModified(String mess) {
        if (this.pane_ != null) {
            this.pane_.setDynamicModified(true, mess);
        }
    }

    public Object getObjectAt(int x, int y, boolean check) {
        return this.getObjectAt(new Point(x, y), check);
    }

    public Object getObjectAt(int x, int y) {
        return this.getObjectAt(new Point(x, y), true);
    }

    public Object getObjectAt(Point pt, boolean check) {
        Object obj;
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild child = (LayerChild)it.nextElement();
                if (!child.contains(pt) || check && !child.isSelectable() || !child.isVisible()) continue;
                if (child instanceof LineKey) {
                    return ((LineKey)child).getObjectAt(pt);
                }
                if (child instanceof PointCollectionKey) {
                    return ((PointCollectionKey)child).getObjectAt(pt);
                }
                if (child instanceof VectorKey) {
                    return ((VectorKey)child).getObjectAt(pt);
                }
                return child;
            }
        }
        if (this.graph_ != null && (obj = this.graph_.getObjectAt(pt)) != null) {
            return obj;
        }
        return null;
    }

    public Object[] getObjectsAt(int x, int y, boolean check) {
        Point pt = new Point(x, y);
        Vector<Object> obList = new Vector<Object>();
        Object obj = null;
        if (!this.children_.isEmpty()) {
            Enumeration it = this.children_.elements();
            while (it.hasMoreElements()) {
                LayerChild child = (LayerChild)it.nextElement();
                if (!child.contains(pt) || check && !child.isSelectable() || !child.isVisible()) continue;
                if (child instanceof LineKey) {
                    obj = ((LineKey)child).getObjectAt(pt);
                    if (obj == null) continue;
                    obList.add(obj);
                    continue;
                }
                if (child instanceof PointCollectionKey) {
                    obj = ((PointCollectionKey)child).getObjectAt(pt);
                    if (obj == null) continue;
                    obList.add(obj);
                    continue;
                }
                if (child instanceof VectorKey) {
                    obj = ((VectorKey)child).getObjectAt(pt);
                    if (obj == null) continue;
                    obList.add(obj);
                    continue;
                }
                if (child == null) continue;
                obList.add(child);
            }
        }
        if (this.graph_ != null && (obj = this.graph_.getObjectAt(pt)) != null) {
            obList.add(obj);
        }
        return obList.toArray();
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDataInLayer(String id) {
        if (!(this.graph_ instanceof CartesianGraph)) return false;
        CartesianRenderer cr = ((CartesianGraph)this.graph_).getRenderer();
        if (cr instanceof LineCartesianRenderer) {
            if (!((LineCartesianRenderer)cr).hasCollection()) return ((LineCartesianRenderer)cr).getLine().getId().equals(id);
            Collection co = ((LineCartesianRenderer)cr).getCollection();
            Enumeration it = co.elements();
            while (it.hasMoreElements()) {
                if (!((SGTData)it.nextElement()).getId().equals(id)) continue;
                return true;
            }
            return false;
        } else {
            if (cr instanceof GridCartesianRenderer) {
                return ((GridCartesianRenderer)cr).getGrid().getId().equals(id);
            }
            if (!(cr instanceof PointCartesianRenderer)) return false;
            if (!((PointCartesianRenderer)cr).hasCollection()) return ((PointCartesianRenderer)cr).getPoint().getId().equals(id);
            Collection co = ((PointCartesianRenderer)cr).getCollection();
            Enumeration it = co.elements();
            while (it.hasMoreElements()) {
                if (!((SGTData)it.nextElement()).getId().equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public Object getPaneLock() {
        if (this.pane_ == null) {
            return this;
        }
        return this.pane_.getPaneLock();
    }
}

