/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.StrokeDrawer;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class LineCartesianRenderer
extends CartesianRenderer {
    private LineAttribute attr_ = null;
    private SGTLine line_ = null;
    private Collection collection_ = null;

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawLine(Graphics g, SGTLine line, LineAttribute attr) {
        int[] yp;
        int count;
        int[] xp;
        int size;
        if (line.isXTime()) {
            long[] xTValues = line.getGeoDateArray().getTime();
            size = xTValues.length;
            xp = new int[size];
            for (count = 0; count < size; ++count) {
                xp[count] = this.cg_.getXUtoD(xTValues[count]);
            }
        } else {
            double[] xValues = line.getXArray();
            size = xValues.length;
            xp = new int[size];
            for (count = 0; count < size; ++count) {
                xp[count] = this.cg_.getXUtoD(xValues[count]);
            }
        }
        if (line.isYTime()) {
            long[] yTValues = line.getGeoDateArray().getTime();
            size = yTValues.length;
            yp = new int[size];
            for (count = 0; count < size; ++count) {
                yp[count] = this.cg_.getYUtoD(yTValues[count]);
            }
        } else {
            double[] yValues = line.getYArray();
            size = yValues.length;
            yp = new int[size];
            for (count = 0; count < size; ++count) {
                yp[count] = this.cg_.getYUtoD(yValues[count]);
            }
        }
        int first = 0;
        int lsize = 0;
        int[] xout = new int[size];
        int[] yout = new int[size];
        double[] adata = new double[size];
        double[] assoc = line.getAssociatedData();
        block12: while (first < size) {
            int nout = -1;
            for (count = first; count < size; ++count) {
                if (xp[count] != Integer.MIN_VALUE && yp[count] != Integer.MIN_VALUE) {
                    xout[++nout] = xp[count];
                    yout[nout] = yp[count];
                    if (!line.hasAssociatedData()) continue;
                    adata[nout] = assoc[count];
                    continue;
                }
                if (nout >= 0) break;
            }
            first = count + 1;
            lsize = nout + 1;
            if (lsize <= 0) {
                return;
            }
            boolean hasAssoc = line.hasAssociatedData();
            switch (attr.getStyle()) {
                case 4: {
                    if (line.hasAssociatedData()) {
                        this.drawColorMark(g, xout, yout, adata, lsize, attr);
                        continue block12;
                    }
                    this.drawMark(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 3: {
                    StrokeDrawer.drawHighlight(g, xout, yout, lsize, attr);
                    continue block12;
                }
                case 2: {
                    StrokeDrawer.drawHeavy(g, xout, yout, adata, lsize, attr, hasAssoc);
                    continue block12;
                }
                case 1: {
                    StrokeDrawer.drawDashed(g, xout, yout, adata, lsize, attr, hasAssoc);
                    continue block12;
                }
                case 6: {
                    StrokeDrawer.drawStroke(g, xout, yout, adata, lsize, attr, hasAssoc);
                    continue block12;
                }
                case 5: {
                    if (line.hasAssociatedData()) {
                        this.drawColorMark(g, xout, yout, adata, lsize, attr);
                        break;
                    }
                    this.drawMark(g, xout, yout, lsize, attr);
                }
            }
            LineCartesianRenderer.drawColorLine(g, xout, yout, adata, lsize, attr, hasAssoc);
        }
    }

    static void drawColorLine(Graphics g, int[] xout, int[] yout, double[] data, int len, LineAttribute attr, boolean hasAssoc) {
        if (!hasAssoc) {
            g.drawPolyline(xout, yout, len);
            return;
        }
        int lastx = xout[0];
        int lasty = yout[0];
        ColorMap cmap = attr.getAssociatedDataCmap();
        for (int i = 1; i < len; ++i) {
            g.setColor(cmap.getColor(data[i]));
            int x = xout[i];
            int y = yout[i];
            g.drawLine(lastx, lasty, x, y);
            lastx = x;
            lasty = y;
        }
    }

    private void drawColorMark(Graphics g, int[] xout, int[] yout, double[] data, int len, LineAttribute attr) {
        Layer ly = this.cg_.getLayer();
        ColorMap cmap = attr.getAssociatedDataCmap();
        PlotMark pm = new PlotMark(attr);
        for (int i = 0; i < len; ++i) {
            g.setColor(cmap.getColor(data[i]));
            pm.paintMark(g, ly, xout[i], yout[i]);
        }
    }

    protected void drawMark(Graphics g, int[] xp, int[] yp, int npoints, LineAttribute attr) {
        Layer ly = this.cg_.getLayer();
        PlotMark pm = new PlotMark(attr);
        for (int i = 0; i < npoints; ++i) {
            pm.paintMark(g, ly, xp[i], yp[i]);
        }
    }

    public LineCartesianRenderer(CartesianGraph cg) {
        this(cg, (SGTLine)null, null);
    }

    public LineCartesianRenderer(CartesianGraph cg, SGTLine line) {
        this(cg, line, null);
        this.cg_ = cg;
        this.line_ = line;
    }

    public LineCartesianRenderer(CartesianGraph cg, SGTLine line, LineAttribute attr) {
        this.cg_ = cg;
        this.line_ = line;
        this.attr_ = attr;
    }

    public LineCartesianRenderer(CartesianGraph cg, Collection col, LineAttribute attr) {
        this.cg_ = cg;
        this.collection_ = col;
        this.attr_ = attr;
    }

    @Override
    public void drawDynamicData(Graphics g) {
        if (this.line_ == null) {
            return;
        }
        if (this.line_.isDynamic()) {
            this.drawLine(g);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (this.line_ != null && !this.line_.isDynamic()) {
            this.drawLine(g);
        }
        if (this.collection_ != null) {
            this.drawLine(g);
        }
    }

    private void drawLine(Graphics g) {
        LineAttribute attr;
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        if ((attr = this.attr_ == null ? new LineAttribute(0, this.cg_.getPane().getComponent().getForeground()) : this.attr_).isVisible()) {
            g.setColor(attr.getColor());
            if (this.collection_ == null) {
                this.drawLine(g, this.line_, attr);
            } else {
                Enumeration li = this.collection_.elements();
                while (li.hasMoreElements()) {
                    Object line = li.nextElement();
                    if (!(line instanceof SGTLine)) continue;
                    this.drawLine(g, (SGTLine)line, attr);
                }
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip(rect);
    }

    public void setLineAttribute(LineAttribute l) {
        this.attr_ = l;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
        }
    }

    public LineAttribute getLineAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTLine getLine() {
        return this.line_;
    }

    @Override
    public SGTData getData() {
        return this.line_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("LineCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return null;
    }

    @Override
    public void removeData() {
        this.collection_ = null;
        this.line_ = null;
    }
}

