/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.util.Point2D;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import javax.swing.JComponent;

public class Logo
implements Cloneable,
LayerChild,
Moveable {
    private String ident_;
    private Layer layer_ = null;
    private Point2D.Double porigin_;
    private int valign_;
    private int halign_;
    private Image image_ = null;
    private URL imageURL_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private boolean moveable_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public Logo() {
        this(new Point2D.Double(0.0, 0.0), 2, 0);
    }

    public Logo(Point2D.Double loc, int valign, int halign) {
        this.porigin_ = loc;
        this.valign_ = valign;
        this.halign_ = halign;
        this.ident_ = "";
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.moveable_ = true;
    }

    @Override
    public LayerChild copy() {
        Logo newLogo;
        try {
            newLogo = (Logo)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLogo = new Logo();
        }
        return newLogo;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public boolean isMoveable() {
        return this.moveable_;
    }

    @Override
    public void setMoveable(boolean moveable) {
        this.moveable_ = moveable;
    }

    public void setImageURL(URL url) {
        if (this.imageURL_ == null || !this.imageURL_.equals(url)) {
            this.imageURL_ = url;
            this.modified("Logo: setImageURL()");
        }
    }

    public URL getImageURL() {
        return this.imageURL_;
    }

    public void setImage(Image img) {
        if (this.image_ == null || !this.image_.equals(img)) {
            this.image_ = img;
            this.modified("Logo: setImage()");
        }
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public JPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    public void setAlign(int vert, int horz) {
        if (this.valign_ != vert || this.halign_ != horz) {
            this.valign_ = vert;
            this.halign_ = horz;
            this.modified("Logo: setAlign()");
        }
    }

    public void setVAlign(int vert) {
        if (this.valign_ != vert) {
            this.valign_ = vert;
            this.modified("Logo: setVAlign()");
        }
    }

    public void setHAlign(int horz) {
        if (this.halign_ != horz) {
            this.halign_ = horz;
            this.modified("Logo: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public void setLocationP(Point2D.Double loc) {
        if (this.porigin_ == null || !this.porigin_.equals(loc)) {
            Point2D.Double temp = this.porigin_;
            this.porigin_ = loc;
            this.changes_.firePropertyChange("location", temp, this.porigin_);
            this.modified("Logo: setLocationP()");
        }
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    @Override
    public void draw(Graphics g) {
        Component comp;
        if (!this.visible_) {
            return;
        }
        if (this.imageURL_ != null && this.layer_ != null && this.image_ == null) {
            this.image_ = this.layer_.getPane().getComponent().getToolkit().getImage(this.imageURL_);
            if (this.image_ != null) {
                MediaTracker mt = new MediaTracker(this.layer_.getPane().getComponent());
                try {
                    mt.addImage(this.image_, 0);
                    mt.waitForAll();
                    if (mt.isErrorAny()) {
                        System.err.println("Logo: Error loading image");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("MediaTracker: " + mt.checkAll());
            }
        }
        if ((comp = this.layer_.getPane().getComponent()) instanceof JComponent) {
            ((JComponent)comp).revalidate();
        } else {
            comp.invalidate();
        }
        if (this.image_ != null) {
            Rectangle bnds = this.getBounds();
            g.drawImage(this.image_, bnds.x, bnds.y, this.layer_.getPane().getComponent());
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.image_ != null) {
            int width = this.image_.getWidth(this.layer_.getPane().getComponent());
            int height = this.image_.getHeight(this.layer_.getPane().getComponent());
            int x = this.layer_.getXPtoD(this.porigin_.x);
            int y = this.layer_.getYPtoD(this.porigin_.y);
            switch (this.halign_) {
                case 2: {
                    x -= width;
                    break;
                }
                case 1: {
                    x -= width / 2;
                }
            }
            switch (this.valign_) {
                case 2: {
                    y -= height;
                    break;
                }
                case 1: {
                    y -= height / 2;
                }
            }
            return new Rectangle(x, y, width, height);
        }
        return null;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    @Override
    public Point getLocation() {
        Rectangle bnds = this.getBounds();
        return new Point(bnds.x, bnds.y);
    }

    @Override
    public void setLocation(Point loc) {
        Rectangle bnds = this.getBounds();
        this.setBounds(loc.x, loc.y, bnds.width, bnds.height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        switch (this.halign_) {
            case 2: {
                x += width;
                break;
            }
            case 1: {
                x += width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y += height;
                break;
            }
            case 1: {
                y += height / 2;
            }
        }
        double xp = this.layer_.getXDtoP(x);
        double yp = this.layer_.getYDtoP(y);
        if (this.porigin_.x != xp || this.porigin_.y != yp) {
            Point2D.Double temp = this.porigin_;
            this.porigin_.x = xp;
            this.porigin_.y = yp;
            this.changes_.firePropertyChange("location", temp, new Point2D.Double(xp, yp));
            this.modified("Logo: setBounds()");
        }
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible_ != visible) {
            this.visible_ = visible;
            this.modified("Logo: setVisible()");
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    @Override
    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }
}

