/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.TimeRange;

class MonthYearAxis
implements TimeAxisStyle {
    static final int YEAR_TEST__ = 31;
    static final String defaultMinorLabelFormat__ = "MMM";
    static final String defaultMajorLabelFormat__ = "yyyy";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 2;

    @Override
    public double computeLocation(double prev, double now) {
        return (prev + now) * 0.5;
    }

    @Override
    public void computeDefaults(GeoDate delta) {
        this.defaultMinorLabelInterval_ = delta.getTime() / 86400000L > 240L ? 2 : 1;
    }

    @Override
    public int getMinorValue(GeoDate time) {
        return time.getGMTMonth();
    }

    @Override
    public int getMajorValue(GeoDate time) {
        return time.getGMTYear();
    }

    @Override
    public boolean isRoomForMajorLabel(GeoDate delta) {
        return delta.getTime() / 86400000L > 31L;
    }

    @Override
    public boolean isStartOfMinor(GeoDate time) {
        return time.getGMTMonth() == 1;
    }

    @Override
    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    @Override
    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    @Override
    public int getDefaultNumSmallTics() {
        return 0;
    }

    @Override
    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    @Override
    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    @Override
    public GeoDate getStartTime(TimeRange tRange) {
        GeoDate time = null;
        boolean time_increasing = tRange.end.after(tRange.start);
        try {
            if (time_increasing) {
                time = new GeoDate(tRange.start.getGMTMonth(), 1, tRange.start.getGMTYear(), 0, 0, 0, 0);
                if (!time.equals(tRange.start)) {
                    time.increment(1.0, 2);
                }
            } else {
                time = new GeoDate(tRange.end.getGMTMonth(), 1, tRange.end.getGMTYear(), 0, 0, 0, 0);
                if (!time.equals(tRange.end)) {
                    time.increment(1.0, 2);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return time;
    }

    @Override
    public double getIncrementValue() {
        return 1.0;
    }

    @Override
    public int getIncrementUnits() {
        return 2;
    }

    @Override
    public String toString() {
        return "MonthYearAxis";
    }
}

