/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.GeometryAttribute;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.PointAttribute;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.util.Dimension2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JFrame;

public class PlotMark {
    protected int mark_;
    protected int tableSize_ = 54;
    protected int firstPoint_;
    protected int lastPoint_;
    protected double markHeight_;
    protected int fillMark_ = 44;
    protected boolean outline_ = false;
    protected Color outlineColor_ = Color.black;
    protected boolean fill_ = false;
    protected boolean circle_ = false;
    protected boolean newMark_ = false;
    protected boolean visible_ = true;
    protected static final int[][] markTable = new int[][]{{5, 9}, {11, 15}, {14, 15}, {11, 12}, {26, 31}, {32, 37}, {38, 43}, {44, 49}, {1, 5}, {64, 67}, {5, 15}, {50, 54}, {1, 9}, {55, 63}, {15, 19}, {21, 25}, {50, 53}, {51, 54}, {72, 77}, {84, 98}, {18, 22}, {11, 19}, {64, 66}, {68, 71}, {68, 70}, {78, 83}, {102, 106}, {113, 118}, {119, 124}, {125, 130}, {131, 136}, {105, 110}, {107, 112}, {137, 139}, {99, 106}, {103, 108}, {140, 144}, {140, 147}, {156, 163}, {148, 155}, {170, 183}, {184, 189}, {188, 193}, {164, 169}, {1, 5}, {64, 67}, {55, 63}, {15, 19}, {68, 71}, {164, 169}, {164, 169}, {1, 11}, {12, 15}, {16, 19}};
    protected static final int[] table = new int[]{9, 41, 45, 13, 9, 45, 0, 13, 41, 0, 25, 29, 0, 11, 43, 29, 11, 25, 43, 11, 25, 29, 11, 43, 29, 18, 27, 34, 0, 27, 24, 20, 27, 36, 0, 27, 30, 20, 27, 18, 0, 3, 27, 36, 27, 34, 0, 27, 51, 41, 13, 45, 9, 41, 4, 2, 16, 32, 50, 52, 38, 22, 4, 9, 29, 41, 9, 13, 25, 45, 13, 13, 27, 31, 0, 27, 45, 9, 27, 29, 0, 27, 41, 13, 20, 18, 9, 0, 18, 34, 0, 20, 36, 0, 45, 36, 34, 41, 19, 35, 0, 21, 17, 33, 37, 21, 19, 35, 33, 17, 21, 37, 20, 29, 25, 0, 17, 33, 21, 37, 35, 19, 17, 33, 21, 37, 19, 35, 33, 17, 21, 19, 43, 0, 37, 33, 21, 37, 25, 12, 44, 0, 42, 10, 0, 17, 37, 26, 30, 0, 12, 44, 0, 8, 40, 13, 45, 0, 43, 11, 0, 9, 41, 4, 41, 30, 9, 52, 4, 12, 20, 21, 13, 12, 0, 9, 45, 0, 33, 41, 42, 34, 33, 14, 44, 10, 0, 9, 41, 0, 42, 12, 46, 4, 19, 9, 26, 41, 35, 52, 36, 30, 20, 4, 0, 0, 0, 0, 0, 0};
    protected static final double[][] newMarkTable = new double[][]{{-3.3, -0.9}, {-1.3, 0.5}, {-2.2, 3.0}, {0.0, 1.5}, {2.2, 3.0}, {1.3, 0.5}, {3.3, -0.9}, {0.8, -0.9}, {0.0, -3.0}, {-0.8, -0.9}, {-3.3, -0.9}, {-2.0, 2.0}, {2.0, 0.0}, {-2.0, -2.0}, {-2.0, 2.0}, {-2.0, 0.0}, {2.0, 2.0}, {2.0, -2.0}, {-2.0, 0.0}};

    public PlotMark(LineAttribute attr) {
        this.setLineAttribute(attr);
    }

    public PlotMark(PointAttribute attr) {
        this.setPointAttribute(attr);
    }

    public PlotMark(GeometryAttribute attr) {
        this.setGeometryAttribute(attr);
    }

    public PlotMark(int mark) {
        this.setMark(mark);
        this.markHeight_ = 0.08;
        this.outline_ = false;
        this.outlineColor_ = Color.black;
    }

    public void setPointAttribute(PointAttribute attr) {
        int mark = attr.getMark();
        this.setMark(mark);
        this.markHeight_ = attr.getMarkHeightP() / 8.0;
        this.outline_ = attr.isMarkOutline();
        this.outlineColor_ = attr.getMarkOutlineColor();
        this.visible_ = attr.isVisible();
    }

    public void setLineAttribute(LineAttribute attr) {
        int mark = attr.getMark();
        this.setMark(mark);
        this.markHeight_ = attr.getMarkHeightP() / 8.0;
        this.outline_ = attr.isMarkOutline();
        this.outlineColor_ = attr.getMarkOutlineColor();
        this.visible_ = attr.isVisible();
    }

    public void setGeometryAttribute(GeometryAttribute attr) {
        int mark = attr.getFillMark();
        this.setMark(mark);
        this.markHeight_ = attr.getFillMarkHeightP() / 8.0;
        this.outline_ = attr.isMarkOutline();
        this.outlineColor_ = attr.getMarkOutlineColor();
        this.visible_ = attr.isVisible();
    }

    public void setMark(int mark) {
        if (mark <= 0) {
            mark = 0;
        }
        this.fill_ = mark > this.fillMark_;
        boolean bl = this.circle_ = mark >= 50 && mark < 52;
        if (this.circle_) {
            this.fill_ = mark == 51;
        }
        boolean bl2 = this.newMark_ = mark >= 52;
        if (mark > this.tableSize_) {
            mark = this.tableSize_;
        }
        this.firstPoint_ = markTable[mark - 1][0] - 1;
        this.lastPoint_ = markTable[mark - 1][1];
        this.mark_ = mark;
    }

    public int getMark() {
        return this.mark_;
    }

    public void setMarkHeightP(double mHeight) {
        this.markHeight_ = mHeight / 8.0;
    }

    public double getMarkHeightP() {
        return this.markHeight_ * 8.0;
    }

    public void setOutline(boolean outline) {
        this.outline_ = outline;
    }

    public void setOutlineColor(Color color) {
        this.outlineColor_ = color;
    }

    public boolean isOutline() {
        return this.outline_;
    }

    public Color getOutlineColor() {
        return this.outlineColor_;
    }

    public void paintMark(Graphics g, Layer ly, int xp, int yp) {
        double xscl = ly.getXSlope() * this.markHeight_;
        double yscl = ly.getYSlope() * this.markHeight_;
        this.paintMark(g, xscl, yscl, xp, yp);
    }

    public void paintMark(Graphics g, int xp, int yp) {
        double xscl = this.markHeight_;
        double yscl = this.markHeight_;
        this.paintMark(g, xscl, yscl, xp, yp);
    }

    private void paintMark(Graphics g, double xscl, double yscl, int xp, int yp) {
        int xdOld = 0;
        int ydOld = 0;
        if (!this.visible_) {
            return;
        }
        if (this.circle_) {
            int xt = (int)(xscl * -2.0) + xp;
            int yt = (int)(xscl * -2.0) + yp;
            int w = (int)(xscl * 4.0) - 1;
            if (this.fill_) {
                g.fillOval(xt, yt, w, w);
                if (this.outline_) {
                    Color save = g.getColor();
                    g.setColor(this.outlineColor_);
                    g.drawOval(xt, yt, w, w);
                    g.setColor(save);
                }
            } else {
                g.drawOval(xt, yt, w, w);
            }
            return;
        }
        int[] xl = new int[this.lastPoint_ - this.firstPoint_];
        int[] yl = new int[this.lastPoint_ - this.firstPoint_];
        int i = 0;
        if (this.newMark_) {
            for (int count = this.firstPoint_; count < this.lastPoint_; ++count) {
                xl[i] = (int)(xscl * newMarkTable[count][0]) + xp;
                yl[i] = (int)(yscl * newMarkTable[count][1]) + yp;
                ++i;
            }
        } else {
            boolean penf = false;
            for (int count = this.firstPoint_; count < this.lastPoint_; ++count) {
                int ib = table[count];
                if (ib == 0) {
                    penf = false;
                    continue;
                }
                int movex = (ib >> 3) - 3;
                int movey = -((ib & 7) - 3);
                int xt = (int)(xscl * (double)movex) + xp;
                int yt = (int)(yscl * (double)movey) + yp;
                if (penf) {
                    if (this.fill_) {
                        xl[i] = xt;
                        yl[i] = yt;
                        ++i;
                    } else {
                        g.drawLine(xdOld, ydOld, xt, yt);
                    }
                }
                penf = true;
                xdOld = xt;
                ydOld = yt;
            }
        }
        if (this.fill_) {
            g.fillPolygon(xl, yl, i);
            if (this.outline_) {
                Color save = g.getColor();
                g.setColor(this.outlineColor_);
                g.drawPolygon(xl, yl, i);
                g.setColor(save);
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Plot Marks");
        frame.getContentPane().setLayout(new BorderLayout());
        frame.setSize(500, 750);
        JPane pane = new JPane("Plot Mark Pane", frame.getSize());
        Layer layer = new Layer("Plot Mark Layer", new Dimension2D(5.0, 7.5));
        pane.setBatch(true);
        pane.setLayout(new StackedLayout());
        frame.getContentPane().add((Component)pane, "Center");
        pane.add(layer);
        frame.setVisible(true);
        pane.setBatch(false);
        PlotMark pm = new PlotMark(1);
        pm.setOutline(true);
        pm.setOutlineColor(Color.red);
        Graphics g = pane.getGraphics();
        g.setFont(new Font("Helvetica", 0, 18));
        pm.setMarkHeightP(0.32);
        int w = pane.getSize().width;
        int h = pane.getSize().height;
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.black);
        FontMetrics fm = g.getFontMetrics();
        int hgt = fm.getAscent() / 2;
        int xt = 100;
        int yt = 400;
        int wid = 0;
        int mark = 1;
        block0: for (int j = 0; j < 14; ++j) {
            yt = 45 * j + 100;
            for (int i = 0; i < 4; ++i) {
                xt = 120 * i + 75;
                String label = mark + ":";
                wid = fm.stringWidth(label) + 20;
                g.setColor(Color.blue.brighter());
                g.drawString(label, xt - wid, yt);
                pm.setMark(mark);
                g.setColor(Color.black);
                pm.paintMark(g, layer, xt, yt - hgt);
                if (++mark > 54) continue block0;
            }
        }
    }

    public String toString() {
        return "PlotMark: " + this.mark_;
    }
}

