/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.Moveable;
import gov.noaa.pmel.swing.MRJUtil;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.text.AttributedString;

public class SGLabel
implements Cloneable,
LayerChild,
Moveable,
Serializable {
    private String ident_;
    private boolean selected_;
    private boolean selectable_;
    private boolean moveable_;
    private transient PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int ANGLE = 2;
    private String label_;
    private Color clr_;
    private Font font_;
    private transient Layer layer_;
    private int orient_;
    private int halign_;
    private int valign_;
    private Point dorigin_;
    private Rectangle dbounds_;
    private Point2D.Double porigin_;
    private Rectangle2D.Double pbounds_;
    private Polygon dpolygon_;
    private double angle_;
    private double sinthta_;
    private double costhta_;
    private double height_;
    private boolean visible_;
    private static boolean fixMetrics_ = MRJUtil.fixFontMetrics();
    private int xoff_ = 0;
    private int yoff_ = 0;
    private boolean alwaysAntiAlias_ = true;
    private Rectangle savedBounds_ = null;
    private Point savedLoc_ = null;
    private Color boxColor_ = new Color(1.0f, 1.0f, 1.0f, 0.8f);
    private boolean drawBox_ = false;
    private double boxGrowBy_ = 0.2;

    public SGLabel(String id, String lbl, Point2D.Double loc) {
        this(id, lbl, 0.12, loc, 2, 0);
    }

    public SGLabel(String id, String lbl, double hgt, Point2D.Double loc, int valign, int halign) {
        this.label_ = lbl;
        this.height_ = hgt;
        this.porigin_ = loc;
        this.valign_ = valign;
        this.halign_ = halign;
        this.dbounds_ = new Rectangle();
        this.dorigin_ = new Point(0, 0);
        this.pbounds_ = new Rectangle2D.Double();
        this.ident_ = id;
        this.setOrientation(0);
        this.setAngle(0.0);
        this.setColor(null);
        this.setFont(new Font("Helvetica", 0, 14));
        this.selected_ = false;
        this.selectable_ = true;
        this.setVisible(true);
        this.moveable_ = true;
    }

    @Override
    public LayerChild copy() {
        SGLabel newLabel;
        try {
            newLabel = (SGLabel)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newLabel = new SGLabel(this.ident_, this.getText(), this.getHeightP(), this.getLocationP(), this.getVAlign(), this.getHAlign());
            newLabel.setColor(this.getColor());
            newLabel.setFont(this.getFont());
            if (this.getOrientation() == 2) {
                newLabel.setAngle(this.getAngle());
            }
            newLabel.setOrientation(this.getOrientation());
        }
        return newLabel;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SGLabel)) {
            return false;
        }
        SGLabel sg = (SGLabel)obj;
        if (!this.ident_.equals(sg.getId()) || !this.getText().equals(sg.getText()) || this.getHeightP() != sg.getHeightP() || !this.getLocationP().equals(sg.getLocationP()) || this.getVAlign() != sg.getVAlign() || this.getHAlign() != sg.getHAlign() || this.getColor() != null && !this.getColor().equals(sg.getColor()) || this.getFont() != null && !this.getFont().equals(sg.getFont()) || this.getOrientation() != sg.getOrientation()) {
            return false;
        }
        return this.getOrientation() != 2 || this.getAngle() == sg.getAngle();
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    public void setColor(Color color) {
        Color clr = this.getColor();
        if (clr == null || !clr.equals(color)) {
            this.clr_ = color;
            this.modified("SGLabel: setColor()");
        }
    }

    public void setFont(Font fnt) {
        Font font = this.getFont();
        if (font == null || !font.equals(fnt)) {
            this.font_ = fnt;
            this.modified("SGLabel: setFont()");
        }
    }

    public void setHeightP(double hgt) {
        double height = this.getHeightP();
        if (height != hgt) {
            this.height_ = hgt;
            this.modified("SGLabel: setHeightP()");
        }
    }

    public void setAlign(int vert, int horz) {
        int valign = this.getVAlign();
        int halign = this.getHAlign();
        if (valign != vert || halign != horz) {
            this.setVAlign(vert);
            this.setHAlign(horz);
            this.modified("SGLabel: setAlign()");
        }
    }

    public void setHAlign(int horz) {
        int halign = this.getHAlign();
        if (halign != horz) {
            this.halign_ = horz;
            this.modified("SGLabeo: setHAlign()");
        }
    }

    public void setVAlign(int vert) {
        int valign = this.getVAlign();
        if (valign != vert) {
            this.valign_ = vert;
            this.modified("SGLabel: setVAlign()");
        }
    }

    public void setLocationP(Point2D.Double loc) {
        Point2D.Double porigin = this.getLocationP();
        if (porigin == null || !porigin.equals(loc)) {
            Point2D.Double temp = porigin;
            this.porigin_ = loc;
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.firePropertyChange("location", temp, this.porigin_);
            this.modified("SGLabel: setLocationP()");
        }
    }

    public void setOrientation(int orient) {
        int or = this.getOrientation();
        if (or != orient) {
            if (this.orient_ != orient) {
                if (orient == 0) {
                    this.costhta_ = 1.0;
                    this.sinthta_ = 0.0;
                } else if (orient == 1) {
                    this.costhta_ = 0.0;
                    this.sinthta_ = 1.0;
                }
                this.orient_ = orient;
            }
            this.modified("SGLabel: setOrientation()");
        }
    }

    @Override
    public JPane getPane() {
        return this.getLayer().getPane();
    }

    @Override
    public void modified(String text) {
        Layer layer = this.getLayer();
        if (layer != null) {
            layer.modified(text);
        }
    }

    public void setText(String lbl) {
        String label = this.getText();
        if (label == null || !label.equals(lbl)) {
            this.label_ = lbl;
            this.modified("SGLabel: setText()");
        }
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    public int getHeight() {
        return 0;
    }

    @Override
    public void setLocation(Point loc) {
        Point dloc = this.getLocation();
        if (dloc.x != loc.x || dloc.y != loc.y) {
            Point temp = new Point(dloc.x, dloc.y);
            if (this.layer_ == null) {
                this.savedLoc_ = new Point(loc);
                return;
            }
            this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
            if (this.dbounds_.x != loc.x || this.dbounds_.y != loc.y) {
                this.setBounds(loc.x, loc.y, this.dbounds_.width, this.dbounds_.height);
            }
            if (this.changes_ == null) {
                this.changes_ = new PropertyChangeSupport(this);
            }
            this.changes_.firePropertyChange("location", temp, loc);
        }
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public void setVisible(boolean visible) {
        boolean vis = this.isVisible();
        if (vis != visible) {
            this.visible_ = visible;
            this.modified("SGLabel: setVisible()");
        }
    }

    @Override
    public boolean isMoveable() {
        return this.moveable_;
    }

    @Override
    public void setMoveable(boolean moveable) {
        if (this.moveable_ != moveable) {
            this.moveable_ = moveable;
            this.modified("SGLabel: setMoveable()");
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }

    @Override
    public boolean contains(Point pt) {
        return this.contains(pt.x, pt.y);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    @Override
    public void draw(Graphics g) throws LayerNotFoundException {
        if (this.label_.length() <= 0 || !this.visible_ || g == null) {
            return;
        }
        if (this.layer_ == (Layer)null) {
            throw new LayerNotFoundException();
        }
        this.computeBoundsD(g);
        if (this.clr_ == null) {
            g.setColor(this.layer_.getPane().getComponent().getForeground());
        } else {
            g.setColor(this.clr_);
        }
        if (this.orient_ == 0) {
            int xs = this.dbounds_.x + this.xoff_;
            int ys = this.dbounds_.y + this.yoff_;
            this.drawString(g, xs, ys);
        } else if (this.orient_ == 1) {
            int xs = this.dbounds_.x + this.xoff_;
            int ys = this.dbounds_.y + this.yoff_;
            this.drawString(g, xs, ys);
        } else {
            int xs = this.layer_.getXPtoD(this.porigin_.x);
            int ys = this.layer_.getYPtoD(this.porigin_.y);
            this.drawString(g, xs, ys);
        }
    }

    public String getText() {
        return this.label_;
    }

    public Color getColor() {
        return this.clr_;
    }

    public Font getFont() {
        return this.font_;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer_ = layer;
        if (this.savedBounds_ != null) {
            this.setBounds(this.savedBounds_.x, this.savedBounds_.y, this.savedBounds_.width, this.savedBounds_.height);
            this.savedBounds_ = null;
        }
        if (this.savedLoc_ != null) {
            this.setLocation(this.savedLoc_);
            this.savedLoc_ = null;
        }
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    public int getOrientation() {
        return this.orient_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    public int getVAlign() {
        return this.valign_;
    }

    @Override
    public Point getLocation() {
        if (this.savedLoc_ != null) {
            return this.savedLoc_;
        }
        return this.dorigin_;
    }

    public void setBounds(int x, int y, int width, int height) {
        int yd;
        int xd;
        if (this.layer_ == null) {
            this.savedBounds_ = new Rectangle(x, y, width, height);
            return;
        }
        Graphics g = this.layer_.getPane().getComponent().getGraphics();
        if (g == null) {
            return;
        }
        this.font_ = this.computeFontSize(g);
        FontRenderContext frc = this.getFontRenderContext((Graphics2D)g);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        int theight = (int)tbounds.getHeight();
        int ty = (int)tbounds.getY();
        if (fixMetrics_) {
            ty -= (int)(0.7 * (double)tlayout.getAscent());
        }
        int sascent = (int)tlayout.getAscent();
        if (this.orient_ == 0) {
            int swidth = width;
            xd = x;
            yd = y - ty;
            switch (this.valign_) {
                case 0: {
                    yd -= sascent;
                    break;
                }
                case 1: {
                    yd += ty + theight / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    xd += swidth;
                    break;
                }
                case 1: {
                    xd += swidth / 2;
                    break;
                }
            }
        } else {
            int swidth = height;
            yd = y + height;
            xd = x - ty;
            switch (this.valign_) {
                case 0: {
                    xd -= sascent;
                    break;
                }
                case 1: {
                    xd -= sascent / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    yd -= swidth;
                    break;
                }
                case 1: {
                    yd -= swidth / 2;
                    break;
                }
            }
        }
        if (this.dorigin_.x != xd || this.dorigin_.y != yd) {
            this.dorigin_.x = xd;
            this.dorigin_.y = yd;
            this.porigin_.x = this.layer_.getXDtoP(xd);
            this.porigin_.y = this.layer_.getYDtoP(yd);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.savedBounds_ != null) {
            return this.savedBounds_;
        }
        if (this.layer_ != null) {
            this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        }
        return this.dbounds_;
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public Rectangle2D.Double getBoundsP() {
        this.computeBoundsD(this.layer_.getPane().getComponent().getGraphics());
        return this.pbounds_;
    }

    public void setAngle(double angle) {
        this.angle_ = angle;
        double thta = this.angle_ * Math.PI / 180.0;
        if (Math.abs(thta) < 0.001) {
            this.orient_ = 0;
            this.costhta_ = 1.0;
            this.sinthta_ = 0.0;
        } else if (Math.abs(thta - 90.0) < 0.001) {
            this.orient_ = 1;
            this.costhta_ = 0.0;
            this.sinthta_ = 1.0;
        } else {
            this.orient_ = 2;
            this.costhta_ = Math.cos(thta);
            this.sinthta_ = Math.sin(thta);
        }
    }

    public double getAngle() {
        return this.angle_;
    }

    public double getHeightP() {
        return this.height_;
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    private void computeBoundsD(Graphics g) {
        int[] xt = new int[4];
        int[] yt = new int[4];
        int[] xn = new int[4];
        int[] yn = new int[4];
        if (g == null) {
            return;
        }
        this.font_ = this.computeFontSize(g);
        FontRenderContext frc = this.getFontRenderContext((Graphics2D)g);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        int theight = (int)tbounds.getHeight();
        int twidth = (int)tbounds.getWidth();
        int tx = (int)tbounds.getX();
        int ty = (int)tbounds.getY();
        if (fixMetrics_) {
            ty -= (int)(0.7 * (double)tlayout.getAscent());
        }
        int sascent = (int)tlayout.getAscent();
        int xd = this.layer_.getXPtoD(this.porigin_.x);
        int yd = this.layer_.getYPtoD(this.porigin_.y);
        this.dorigin_.x = xd;
        this.dorigin_.y = yd;
        int xorig = xd;
        int yorig = yd;
        switch (this.valign_) {
            case 0: {
                yd += sascent;
                break;
            }
            case 1: {
                yd -= ty + theight / 2;
                break;
            }
        }
        switch (this.halign_) {
            case 2: {
                xd -= twidth;
                break;
            }
            case 1: {
                xd -= twidth / 2;
                break;
            }
        }
        if (this.orient_ == 0) {
            this.xoff_ = 0;
            this.yoff_ = -ty;
        } else if (this.orient_ == 1) {
            this.xoff_ = -ty;
            this.yoff_ = twidth;
        }
        xt[0] = xd + tx;
        xt[1] = xt[0];
        xt[2] = xt[0] + twidth;
        xt[3] = xt[2];
        yt[0] = yd + ty;
        yt[1] = yt[0] + theight;
        yt[2] = yt[1];
        yt[3] = yt[0];
        for (int i = 0; i < 4; ++i) {
            xn[i] = (int)((double)(xt[i] - xorig) * this.costhta_ + (double)(yt[i] - yorig) * this.sinthta_) + xorig;
            yn[i] = (int)((double)(yt[i] - yorig) * this.costhta_ - (double)(xt[i] - xorig) * this.sinthta_) + yorig;
        }
        this.dpolygon_ = new Polygon(xn, yn, 4);
        this.dbounds_ = this.dpolygon_.getBounds();
        this.pbounds_.x = this.layer_.getXDtoP(this.dbounds_.x);
        this.pbounds_.y = this.layer_.getYDtoP(this.dbounds_.y);
        this.pbounds_.width = this.layer_.getXDtoP(this.dbounds_.x + this.dbounds_.width) - this.pbounds_.x;
        this.pbounds_.height = this.pbounds_.y - this.layer_.getYDtoP(this.dbounds_.y + this.dbounds_.height);
    }

    Font computeFontSize(Graphics g) {
        FontRenderContext frc = this.getFontRenderContext((Graphics2D)g);
        if (g == null) {
            return this.font_;
        }
        int hgt = this.layer_.getXPtoD(this.height_) - this.layer_.getXPtoD(0.0);
        int pt_0 = hgt - 3;
        Font tfont = new Font(this.font_.getName(), this.font_.getStyle(), pt_0);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", tfont, frc) : new TextLayout(this.label_, tfont, frc);
        hgt = (int)(tlayout.getAscent() + tlayout.getDescent());
        double hgt_0 = this.layer_.getXDtoP(hgt) - this.layer_.getXDtoP(0);
        pt_0 = tfont.getSize();
        int pt_1 = (int)((double)pt_0 * (this.height_ / hgt_0));
        for (int count = 1; pt_0 != pt_1 && count < 5; ++count) {
            tfont = new Font(this.font_.getName(), this.font_.getStyle(), pt_1);
            tlayout = this.label_.length() == 0 ? new TextLayout(" ", tfont, frc) : new TextLayout(this.label_, tfont, frc);
            hgt = (int)(tlayout.getAscent() + tlayout.getDescent());
            double hgt_1 = this.layer_.getXDtoP(hgt) - this.layer_.getXDtoP(0);
            double del_0 = Math.abs(this.height_ - hgt_0);
            double del_1 = Math.abs(this.height_ - hgt_1);
            if (Math.abs(pt_0 - pt_1) <= 1 && del_0 > del_1) {
                return tfont;
            }
            pt_0 = pt_1;
            hgt_0 = hgt_1;
            pt_1 = (int)((double)pt_0 * (this.height_ / hgt_0));
        }
        return tfont;
    }

    private void drawString(Graphics g, int x, int y) {
        if (g == null) {
            return;
        }
        float angle = this.orient_ == 0 ? 0.0f : (this.orient_ == 1 ? -90.0f : -((float)this.angle_));
        RenderingHints oldRenderingHints = null;
        Graphics2D g2 = (Graphics2D)g;
        if (angle != 0.0f || this.alwaysAntiAlias_) {
            oldRenderingHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        AffineTransform oldTransform = g2.getTransform();
        AttributedString as = new AttributedString(this.label_);
        as.addAttribute(TextAttribute.FONT, this.font_);
        RoundRectangle2D.Double boxBounds = null;
        if (this.drawBox_) {
            Rectangle2D textBounds = new TextLayout(as.getIterator(), new FontRenderContext(null, true, false)).getBounds();
            double w = textBounds.getWidth();
            double h = textBounds.getHeight();
            double tenP = Math.min(w, h) * this.boxGrowBy_;
            boxBounds = new RoundRectangle2D.Double(textBounds.getX() - tenP, textBounds.getY() - tenP, w + 2.0 * tenP, h + 2.0 * tenP, 2.0 * tenP, 2.0 * tenP);
        }
        g2.translate(x, y);
        g2.rotate(Math.PI * (double)angle / 180.0);
        if (this.drawBox_) {
            Color oldColor = g2.getColor();
            g2.setColor(this.boxColor_);
            g2.fill(boxBounds);
            g2.setColor(oldColor);
        }
        g2.drawString(as.getIterator(), 0, 0);
        g2.setTransform(oldTransform);
        if (angle != 0.0f || this.alwaysAntiAlias_) {
            g2.setRenderingHints(oldRenderingHints);
        }
    }

    public float getStringWidth(Graphics g) {
        if (g == null) {
            return 0.0f;
        }
        this.font_ = this.computeFontSize(g);
        FontRenderContext frc = this.getFontRenderContext((Graphics2D)g);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        return (float)tbounds.getWidth();
    }

    public float getStringHeight(Graphics g) {
        if (g == null) {
            return 0.0f;
        }
        this.font_ = this.computeFontSize(g);
        FontRenderContext frc = this.getFontRenderContext((Graphics2D)g);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        return (float)tbounds.getHeight();
    }

    FontRenderContext getFontRenderContext(Graphics2D g2) {
        if (g2 == null) {
            return null;
        }
        RenderingHints oldRenderingHints = null;
        if (this.angle_ != 0.0 || this.alwaysAntiAlias_) {
            oldRenderingHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.angle_ != 0.0 || this.alwaysAntiAlias_) {
            g2.setRenderingHints(oldRenderingHints);
        }
        return frc;
    }

    public Color getBoxColor() {
        return this.boxColor_;
    }

    public void setBoxColor(Color boxColor) {
        Color clr = this.getBoxColor();
        if (clr == null || !clr.equals(boxColor)) {
            this.boxColor_ = boxColor;
            this.modified("SGLabel: setBoxColor()");
        }
    }

    public boolean isDrawBox() {
        return this.drawBox_;
    }

    public void setDrawBox(boolean drawBox) {
        if (this.drawBox_ != drawBox) {
            this.drawBox_ = drawBox;
            this.modified("SGLabel: setDrawBox()");
        }
    }

    public double getBoxGrowBy() {
        return this.boxGrowBy_;
    }

    public void setBoxGrowBy(double boxGrowBy) {
        if (this.boxGrowBy_ != boxGrowBy) {
            this.boxGrowBy_ = boxGrowBy;
            this.modified("SGLabel: setBoxGrowBy()");
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(SGLabel.class);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor pd = descriptors[i];
                if (!pd.getName().equals("layer")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }
}

