/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimePoint;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;

public abstract class SpaceAxis
extends Axis {
    protected Range2D uRange_;
    protected Point2D.Double uLocation_;
    protected TimePoint tLocation_;
    static final double TIC_GAP = 0.05;
    static final double TIC_RATIO = 1.3;
    static final double LABEL_RATIO = 1.3;

    @Override
    protected void updateRegisteredTransforms() {
        if (!this.registeredTransforms_.isEmpty()) {
            Enumeration it = this.registeredTransforms_.elements();
            while (it.hasMoreElements()) {
                AxisTransform trns = (AxisTransform)it.nextElement();
                trns.setRangeP(this.pRange_);
                trns.setRangeU(this.uRange_);
            }
        }
    }

    @Override
    protected void updateRegisteredAxes() {
        if (!this.registeredAxes_.isEmpty()) {
            Enumeration it = this.registeredAxes_.elements();
            while (it.hasMoreElements()) {
                SpaceAxis ax = (SpaceAxis)it.nextElement();
                ax.setRangeU(this.uRange_);
                ax.setRangeP(this.pRange_);
            }
        }
    }

    protected void drawSmallXTics(Graphics g, double xu, double xtest, double del, double yp) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double yp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + this.smallTicHeight_ : yp;
        double yp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - this.smallTicHeight_ : yp;
        int y0 = this.graph_.getLayer().getYPtoD(yp0);
        int y1 = this.graph_.getLayer().getYPtoD(yp1);
        double smdel = del / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double xt = xu + smdel * (double)i;
            if (!((xtest - xt) / del >= 0.0)) continue;
            int x0 = this.graph_.getXUtoD(xt);
            g.drawLine(x0, y0, x0, y1);
        }
    }

    protected void drawSmallYTics(Graphics g, double xp, double yu, double ytest, double del) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double xp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + this.smallTicHeight_ : xp;
        double xp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - this.smallTicHeight_ : xp;
        int x0 = this.graph_.getLayer().getXPtoD(xp0);
        int x1 = this.graph_.getLayer().getXPtoD(xp1);
        double smdel = del / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double yt = yu + smdel * (double)i;
            if (!((ytest - yt) / del >= 0.0)) continue;
            int y0 = this.graph_.getYUtoD(yt);
            g.drawLine(x0, y0, x1, y0);
        }
    }

    public SpaceAxis() {
        this("");
    }

    public SpaceAxis(String id) {
        super(id);
        this.space_ = true;
        this.numSmallTics_ = 0;
    }

    public void setSignificantDigits(int nsig) {
        if (this.sigDigits_ != nsig) {
            this.sigDigits_ = nsig;
            this.modified("SpaceAxis: setSignificantDigits()");
        }
    }

    public int getSignificantDigits() {
        return this.sigDigits_;
    }

    public void setLabelInterval(int lint) {
        if (this.labelInterval_ != lint) {
            this.labelInterval_ = lint;
            this.modified("SpaceAxis: setLabelInterval()");
        }
    }

    public int getLabelInterval() {
        return this.labelInterval_;
    }

    public void setLabelFormat(String frmt) {
        if (this.labelFormat_ == null || !this.labelFormat_.equals(frmt)) {
            this.labelFormat_ = frmt == null ? "" : frmt;
            this.modified("SpaceAxis: setLabelFormat()");
        }
    }

    public String getLabelFormat() {
        return this.labelFormat_;
    }

    public void setRangeU(Range2D ur) {
        if (this.uRange_ == null || !this.uRange_.equals(ur)) {
            this.uRange_ = ur;
            this.updateRegisteredAxes();
            this.updateRegisteredTransforms();
            this.modified("SpaceAxis: setRangeU()");
        }
    }

    @Override
    public void setRangeU(SoTRange ur) {
        this.setRangeU(new Range2D((Double)ur.getStartObject(), (Double)ur.getEndObject(), (Double)ur.getDeltaObject()));
    }

    public Range2D getRangeU() {
        return this.uRange_;
    }

    @Override
    public SoTRange getSoTRangeU() {
        return new SoTRange.Double(this.uRange_);
    }

    public void setDeltaU(double delta) {
        if (this.uRange_.delta != delta) {
            this.uRange_.delta = delta;
            this.modified("SpaceAxis: setDeltaU()");
        }
    }

    public double getDeltaU() {
        return this.uRange_.delta;
    }

    public void setLocationU(TimePoint uptt) {
        if (this.tLocation_ == null || !this.tLocation_.equals(uptt)) {
            this.tLocation_ = uptt;
            this.uLocation_ = null;
            this.modified("SpaceAxis: setLocationU(TimePoint)");
        }
    }

    public void setLocationU(Point2D.Double upt) {
        if (this.uLocation_ == null || !this.uLocation_.equals(upt)) {
            this.uLocation_ = upt;
            this.tLocation_ = null;
            this.modified("SpaceAxis: setLocationU(Point2D)");
        }
    }

    @Override
    public void setLocationU(SoTPoint upt) {
        if (upt.isXTime() || upt.isYTime()) {
            double x;
            long t;
            if (upt.isXTime()) {
                t = upt.getX().getLongTime();
                x = ((SoTValue.Double)upt.getY()).getValue();
            } else {
                t = upt.getY().getLongTime();
                x = ((SoTValue.Double)upt.getX()).getValue();
            }
            this.setLocationU(new TimePoint(x, new GeoDate(t)));
        } else {
            double x = ((SoTValue.Double)upt.getX()).getValue();
            double y = ((SoTValue.Double)upt.getY()).getValue();
            this.setLocationU(new Point2D.Double(x, y));
        }
    }

    public Point2D.Double getLocationU() {
        return this.uLocation_;
    }

    public TimePoint getTimeLocationU() {
        return this.tLocation_;
    }

    @Override
    public SoTPoint getSoTLocationU() {
        if (this.tLocation_ == null) {
            return new SoTPoint(this.uLocation_.x, this.uLocation_.y);
        }
        if (this.orientation_ == 0) {
            return new SoTPoint(this.tLocation_.t, this.tLocation_.x);
        }
        return new SoTPoint(this.tLocation_.x, this.tLocation_.t);
    }

    @Override
    public abstract void draw(Graphics var1);

    @Override
    public abstract Rectangle getBounds();

    @Override
    public void modified(String mess) {
        if (this.graph_ != null) {
            this.graph_.modified(mess);
        }
    }
}

