/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LineCartesianRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class StrokeDrawer
implements Cloneable {
    public static void drawHeavy(Graphics g, int[] xout, int[] yout, double[] data, int size, LineAttribute attr, boolean hasAssoc) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(attr.getWidth());
        g2.setStroke(stroke);
        LineCartesianRenderer.drawColorLine(g, xout, yout, data, size, attr, hasAssoc);
        g2.setStroke(saved);
    }

    public static void drawDashed(Graphics g, int[] xout, int[] yout, double[] data, int size, LineAttribute attr, boolean hasAssoc) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        float[] dashes = new float[]{4.0f, 4.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 2, 0, 10.0f, dashes, 0.0f);
        g2.setStroke(stroke);
        LineCartesianRenderer.drawColorLine(g, xout, yout, data, size, attr, hasAssoc);
        g2.setStroke(saved);
    }

    public static void drawStroke(Graphics g, int[] xout, int[] yout, double[] data, int size, LineAttribute attr, boolean hasAssoc) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        float[] arr = attr.getDashArray();
        BasicStroke stroke = arr == null || arr.length <= 1 ? new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit()) : new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit(), attr.getDashArray(), attr.getDashPhase());
        g2.setStroke(stroke);
        LineCartesianRenderer.drawColorLine(g, xout, yout, data, size, attr, hasAssoc);
        g2.setStroke(saved);
    }

    public static void drawHighlight(Graphics g, int[] xout, int[] yout, int size, LineAttribute attr) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(2.75f);
        Color col = attr.getColor();
        Color rev = new Color(255 - col.getRed(), 255 - col.getGreen(), 255 - col.getBlue());
        g2.setColor(rev);
        g2.setStroke(stroke);
        g2.drawPolyline(xout, yout, size);
        g2.setColor(col);
        g2.setStroke(saved);
        g2.drawPolyline(xout, yout, size);
    }
}

