/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.DayMonthAxis;
import gov.noaa.pmel.sgt.HourDayAxis;
import gov.noaa.pmel.sgt.LayerNotFoundException;
import gov.noaa.pmel.sgt.MinuteHourAxis;
import gov.noaa.pmel.sgt.MonthYearAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.SecondMinuteAxis;
import gov.noaa.pmel.sgt.TimeAxisStyle;
import gov.noaa.pmel.sgt.YearDecadeAxis;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimePoint;
import gov.noaa.pmel.util.TimeRange;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TimeAxis
extends Axis
implements Cloneable {
    protected TimeRange tRange_;
    protected TimePoint tLocation_;
    protected String minorLabelFormat_;
    protected int minorLabelInterval_ = 2;
    protected String majorLabelFormat_;
    protected int majorLabelInterval_ = 1;
    protected double yminor_;
    protected double ymajor_;
    protected double xminor_;
    protected double xmajor_;
    protected int vertalign_;
    protected TimeAxisStyle txt_;
    protected int axisStyle_;
    static final double TIC_RATIO__ = 1.3;
    static final double TIC_GAP__ = 0.05;
    static final double LABEL_RATIO__ = 1.0;
    static final double MAJOR_LABEL_RATIO__ = 1.25;
    static final double defaultLargeTicHeight__ = 0.1;
    static final double defaultSmallTicHeight__ = 0.05;
    static final int defaultTicPosition__ = 1;
    static final int defaultLabelPosition__ = 1;
    static final double defaultLabelHeight__ = 0.15;
    public static final int AUTO = 0;
    public static final int YEAR_DECADE = 1;
    public static final int MONTH_YEAR = 2;
    public static final int DAY_MONTH = 3;
    public static final int HOUR_DAY = 4;
    public static final int MINUTE_HOUR = 5;
    public static final int SECOND_MINUTE = 6;

    private void setAuto() {
        TimeAxisStyle newStyle = null;
        GeoDate delta = this.tRange_.end.subtract(this.tRange_.start);
        double days = (double)Math.abs(delta.getTime()) / 8.64E7;
        if (days > 1000.0) {
            if (!(this.txt_ instanceof YearDecadeAxis)) {
                newStyle = new YearDecadeAxis();
            }
        } else if (days > 91.0) {
            if (!(this.txt_ instanceof MonthYearAxis)) {
                newStyle = new MonthYearAxis();
            }
        } else if (days > 5.0) {
            if (!(this.txt_ instanceof DayMonthAxis)) {
                newStyle = new DayMonthAxis();
            }
        } else if (days > 0.1666667) {
            if (!(this.txt_ instanceof HourDayAxis)) {
                newStyle = new HourDayAxis();
            }
        } else if (days > 0.002778) {
            if (!(this.txt_ instanceof MinuteHourAxis)) {
                newStyle = new MinuteHourAxis();
            }
        } else if (!(this.txt_ instanceof SecondMinuteAxis)) {
            newStyle = new SecondMinuteAxis();
        }
        if (newStyle != null) {
            this.txt_ = newStyle;
        }
        this.txt_.computeDefaults(delta);
        this.minorLabelFormat_ = this.txt_.getDefaultMinorLabelFormat();
        this.majorLabelFormat_ = this.txt_.getDefaultMajorLabelFormat();
        this.minorLabelInterval_ = this.txt_.getDefaultMinorLabelInterval();
        this.majorLabelInterval_ = this.txt_.getDefaultMajorLabelInterval();
        this.numSmallTics_ = this.txt_.getDefaultNumSmallTics();
    }

    @Override
    protected void updateRegisteredTransforms() {
        if (!this.registeredTransforms_.isEmpty()) {
            Enumeration it = this.registeredTransforms_.elements();
            while (it.hasMoreElements()) {
                AxisTransform trns = (AxisTransform)it.nextElement();
                trns.setRangeP(this.pRange_);
                trns.setRangeU(this.tRange_);
            }
        }
    }

    @Override
    protected void updateRegisteredAxes() {
        if (!this.registeredAxes_.isEmpty()) {
            Enumeration it = this.registeredAxes_.elements();
            while (it.hasMoreElements()) {
                TimeAxis ax = (TimeAxis)it.nextElement();
                ax.setRangeU(this.tRange_);
                ax.setRangeP(this.pRange_);
            }
        }
    }

    protected void setupDraw(double val) {
        if (this.orientation_ == 0) {
            if (this.labelPosition_ == 0) {
                this.vertalign_ = 2;
                this.yminor_ = this.minorLabelInterval_ == 0 ? val : (this.ticPosition_ == 2 || this.ticPosition_ == 0 ? val + 1.3 * this.largeTicHeight_ : val + 0.05);
                this.ymajor_ = this.yminor_ + 1.0 * this.labelHeight_;
            } else {
                this.vertalign_ = 0;
                this.yminor_ = this.minorLabelInterval_ == 0 ? val : (this.ticPosition_ == 2 || this.ticPosition_ == 1 ? val - 1.3 * this.largeTicHeight_ : val - 0.05);
                this.ymajor_ = this.yminor_ - 1.0 * this.labelHeight_;
            }
        } else if (this.labelPosition_ == 1) {
            this.vertalign_ = 2;
            this.xminor_ = this.minorLabelInterval_ == 0 ? val : (this.ticPosition_ == 2 || this.ticPosition_ == 1 ? val - 1.3 * this.largeTicHeight_ : val - 0.05);
            this.xmajor_ = this.xminor_ - 1.0 * this.labelHeight_;
        } else {
            this.vertalign_ = 0;
            this.xminor_ = this.minorLabelInterval_ == 0 ? val : (this.ticPosition_ == 2 || this.ticPosition_ == 0 ? val + 1.3 * this.largeTicHeight_ : val + 0.05);
            this.xmajor_ = this.xminor_ + 1.0 * this.labelHeight_;
        }
    }

    protected void drawMinorLabel(Graphics g, double val, GeoDate time) {
        SGLabel label;
        Color saved = g.getColor();
        if (this.orientation_ == 0) {
            label = new SGLabel("minor", time.toString(this.minorLabelFormat_), new Point2D.Double(val, this.yminor_));
            label.setOrientation(0);
        } else {
            label = new SGLabel("minor", time.toString(this.minorLabelFormat_), new Point2D.Double(this.xminor_, val));
            label.setOrientation(1);
        }
        label.setAlign(this.vertalign_, 1);
        label.setFont(this.labelFont_);
        label.setColor(this.labelColor_);
        label.setHeightP(this.labelHeight_);
        label.setLayer(this.graph_.getLayer());
        try {
            label.draw(g);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        g.setColor(saved);
    }

    protected void drawMajorLabel(Graphics g, double val, GeoDate time) {
        SGLabel label;
        Color saved = g.getColor();
        if (this.orientation_ == 0) {
            label = new SGLabel("major", time.toString(this.majorLabelFormat_), new Point2D.Double(val, this.ymajor_));
            label.setOrientation(0);
        } else {
            label = new SGLabel("major", time.toString(this.majorLabelFormat_), new Point2D.Double(this.xmajor_, val));
            label.setOrientation(1);
        }
        label.setAlign(this.vertalign_, 1);
        label.setFont(this.labelFont_);
        label.setColor(this.labelColor_);
        label.setHeightP(1.25 * this.labelHeight_);
        label.setLayer(this.graph_.getLayer());
        try {
            label.draw(g);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        g.setColor(saved);
    }

    public TimeAxis(int style) {
        this("", style);
    }

    public TimeAxis(String id, int style) {
        super(id);
        this.numSmallTics_ = 0;
        this.space_ = false;
        this.axisStyle_ = style;
        this.txt_ = this.axisStyle_ == 0 || this.axisStyle_ == 2 ? new MonthYearAxis() : (this.axisStyle_ == 1 ? new YearDecadeAxis() : (this.axisStyle_ == 3 ? new DayMonthAxis() : (this.axisStyle_ == 4 ? new HourDayAxis() : new MinuteHourAxis())));
        this.minorLabelFormat_ = this.txt_.getDefaultMinorLabelFormat();
        this.majorLabelFormat_ = this.txt_.getDefaultMajorLabelFormat();
        this.minorLabelInterval_ = this.txt_.getDefaultMinorLabelInterval();
        this.majorLabelInterval_ = this.txt_.getDefaultMajorLabelInterval();
        this.numSmallTics_ = this.txt_.getDefaultNumSmallTics();
        this.largeTicHeight_ = 0.1;
        this.smallTicHeight_ = 0.05;
        this.ticPosition_ = 1;
        this.labelPosition_ = 1;
        this.labelHeight_ = 0.15;
        this.tRange_ = null;
        this.tLocation_ = null;
    }

    @Override
    public Axis copy() {
        TimeAxis newAxis;
        try {
            newAxis = (TimeAxis)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newAxis = new TimeAxis(this.getStyle());
        }
        newAxis.registeredAxes_ = new Vector(2, 2);
        newAxis.registeredTransforms_ = new Vector(2, 2);
        return newAxis;
    }

    public void setLabelFormat(String minor, String major) {
        if (this.minorLabelFormat_ == null || this.majorLabelFormat_ == null || !this.minorLabelFormat_.equals(minor) || !this.majorLabelFormat_.equals(major)) {
            this.minorLabelFormat_ = minor;
            this.majorLabelFormat_ = major;
            this.modified("TimeAxis: setLabelFormat()");
        }
    }

    public void setMinorLabelFormat(String minor) {
        if (this.minorLabelFormat_ == null || !this.minorLabelFormat_.equals(minor)) {
            this.minorLabelFormat_ = minor;
            this.modified("TimeAxis: setMinorLabelFormat()");
        }
    }

    public void setMajorLabelFormat(String major) {
        if (this.majorLabelFormat_ == null || !this.majorLabelFormat_.equals(major)) {
            this.majorLabelFormat_ = major;
            this.modified("TimeAxis: setMajorLabelFormat()");
        }
    }

    public String getMinorLabelFormat() {
        return this.minorLabelFormat_;
    }

    public String getMajorLabelFormat() {
        return this.majorLabelFormat_;
    }

    public void setLabelInterval(int minor, int major) {
        if (this.minorLabelInterval_ != minor || this.majorLabelInterval_ != major) {
            this.minorLabelInterval_ = minor;
            this.majorLabelInterval_ = major;
            this.modified("TimeAxis: setLabelInterval()");
        }
    }

    public void setMinorLabelInterval(int minor) {
        if (this.minorLabelInterval_ != minor) {
            this.minorLabelInterval_ = minor;
            this.modified("TimeAxis: setMinorLabelInterval()");
        }
    }

    public void setMajorLabelInterval(int major) {
        if (this.majorLabelInterval_ != major) {
            this.majorLabelInterval_ = major;
            this.modified("TimeAxis: setMajorLabelInterval()");
        }
    }

    public int getMinorLabelInterval() {
        return this.minorLabelInterval_;
    }

    public int getMajorLabelInterval() {
        return this.majorLabelInterval_;
    }

    public void setStyle(int style) {
        if (this.axisStyle_ != style) {
            this.axisStyle_ = style;
            if (this.axisStyle_ == 0 && this.tRange_ != null) {
                this.setAuto();
            }
            this.modified("TimeAxis: setStyle()");
        }
    }

    public int getStyle() {
        return this.axisStyle_;
    }

    public void setRangeU(TimeRange tr) {
        if (this.tRange_ == null || !this.tRange_.equals(tr)) {
            this.tRange_ = tr;
            if (this.axisStyle_ == 0) {
                this.setAuto();
            }
            this.updateRegisteredAxes();
            this.updateRegisteredTransforms();
            this.modified("TimeAxis: setRangeU()");
        }
    }

    public TimeRange getTimeRangeU() {
        return this.tRange_;
    }

    @Override
    public void setRangeU(SoTRange tr) {
        this.setRangeU(new TimeRange(tr.getStart().getLongTime(), tr.getEnd().getLongTime(), tr.getDelta().getLongTime()));
    }

    @Override
    public SoTRange getSoTRangeU() {
        return new SoTRange.Time(this.tRange_);
    }

    public void setLocationU(TimePoint tp) {
        if (this.tLocation_ == null || !this.tLocation_.equals(tp)) {
            this.tLocation_ = tp;
            this.modified("TimeAxis: setLocationU()");
        }
    }

    @Override
    public void setLocationU(SoTPoint tp) {
        double x;
        long t;
        if (tp.isXTime()) {
            t = tp.getX().getLongTime();
            x = ((SoTValue.Double)tp.getY()).getValue();
        } else {
            t = tp.getY().getLongTime();
            x = ((SoTValue.Double)tp.getX()).getValue();
        }
        this.setLocationU(new TimePoint(x, new GeoDate(t)));
    }

    @Override
    public SoTPoint getSoTLocationU() {
        if (this.orientation_ == 0) {
            return new SoTPoint(this.tLocation_.t, this.tLocation_.x);
        }
        return new SoTPoint(this.tLocation_.x, this.tLocation_.t);
    }

    public TimePoint getLocationU() {
        return this.tLocation_;
    }

    @Override
    public Rectangle getBounds() {
        int height;
        int y;
        int x;
        int width;
        if (this.orientation_ == 0) {
            double yp = this.graph_.getYUtoP(this.tLocation_.x);
            this.setupDraw(yp);
            int xd = this.graph_.getXUtoD(this.tRange_.start);
            width = this.graph_.getXUtoD(this.tRange_.end) - xd;
            x = xd;
            double ymax = yp;
            double ymin = yp;
            if (this.labelPosition_ == 0) {
                ymax = this.ymajor_ + 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                    ymin -= 1.3 * this.largeTicHeight_;
                }
            } else {
                ymin = this.ymajor_ - 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                    ymax += 1.3 * this.largeTicHeight_;
                }
            }
            y = this.graph_.getLayer().getYPtoD(ymax);
            height = this.graph_.getLayer().getYPtoD(ymin) - y;
        } else {
            double xp = this.graph_.getXUtoP(this.tLocation_.x);
            this.setupDraw(xp);
            int yd = this.graph_.getYUtoD(this.tRange_.start);
            y = this.graph_.getYUtoD(this.tRange_.end);
            height = yd - y;
            double xmin = xp;
            double xmax = xp;
            if (this.labelPosition_ == 0) {
                xmax = this.xmajor_ + 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 1) {
                    xmin -= 1.3 * this.largeTicHeight_;
                }
            } else {
                xmin = this.xmajor_ - 1.25 * this.labelHeight_;
                if (this.ticPosition_ == 2 || this.ticPosition_ == 0) {
                    xmax += 1.3 * this.largeTicHeight_;
                }
            }
            x = this.graph_.getLayer().getXPtoD(xmin);
            width = this.graph_.getLayer().getXPtoD(xp) - x;
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.getBounds();
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
    }

    @Override
    public void modified(String mess) {
        if (this.graph_ != null) {
            this.graph_.modified(mess);
        }
    }

    @Override
    public void draw(Graphics g) {
        GeoDate time = new GeoDate();
        GeoDate time_end = new GeoDate();
        GeoDate time_start = new GeoDate();
        if (!this.visible_) {
            return;
        }
        if (this.lineColor_ == null) {
            g.setColor(this.graph_.getLayer().getPane().getComponent().getForeground());
        } else {
            g.setColor(this.lineColor_);
        }
        boolean draw_minor = this.minorLabelInterval_ != 0 && this.labelPosition_ != 2;
        boolean draw_major = this.majorLabelInterval_ != 0 && this.labelPosition_ != 2;
        boolean time_increasing = this.tRange_.end.after(this.tRange_.start);
        time = this.txt_.getStartTime(this.tRange_);
        time_start = new GeoDate(time.getTime());
        time_end = time_increasing ? new GeoDate(this.tRange_.end) : new GeoDate(this.tRange_.start);
        boolean labelDrawn = false;
        if (this.orientation_ == 0) {
            double x;
            int major_val;
            int yloc = this.graph_.getYUtoD(this.tLocation_.x);
            int xloc = this.graph_.getXUtoD(this.tRange_.start);
            int xend = this.graph_.getXUtoD(this.tRange_.end);
            g.drawLine(xloc, yloc, xend, yloc);
            double yp = this.graph_.getYUtoP(this.tLocation_.x);
            double xp = this.graph_.getXUtoP(time);
            this.setupDraw(yp);
            if (this.txt_.isStartOfMinor(time)) {
                this.drawThickXTic(g, xp, yp, (double)1.3f * this.largeTicHeight_);
            } else {
                this.drawXTic(g, xp, yp, this.largeTicHeight_);
            }
            int major_val_old = major_val = this.txt_.getMajorValue(time);
            int minor_val_old = this.txt_.getMinorValue(time);
            double xp_major_old = xp;
            double xp_minor_old = xp;
            GeoDate minor_time_old = new GeoDate(time);
            GeoDate major_time_old = new GeoDate(time);
            time.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            while (time.before(time_end)) {
                xp = this.graph_.getXUtoP(time);
                int minor_val = this.txt_.getMinorValue(time);
                if (this.txt_.isStartOfMinor(time)) {
                    this.drawThickXTic(g, xp, yp, (double)1.3f * this.largeTicHeight_);
                } else {
                    this.drawXTic(g, xp, yp, this.largeTicHeight_);
                }
                if (draw_minor && minor_val_old % this.minorLabelInterval_ == 0) {
                    x = this.txt_.computeLocation(xp_minor_old, xp);
                    this.drawMinorLabel(g, x, minor_time_old);
                }
                if ((major_val = this.txt_.getMajorValue(time)) != major_val_old) {
                    if (draw_major && major_val_old % this.majorLabelInterval_ == 0) {
                        labelDrawn = true;
                        x = (xp_major_old + xp) * 0.5;
                        this.drawMajorLabel(g, x, major_time_old);
                    }
                    xp_major_old = xp;
                    major_val_old = major_val;
                    major_time_old = new GeoDate(time);
                }
                xp_minor_old = xp;
                minor_val_old = minor_val;
                minor_time_old = new GeoDate(time);
                time.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            }
            if (labelDrawn) {
                GeoDate delta;
                if (draw_major && major_val_old % this.majorLabelInterval_ == 0 && this.txt_.isRoomForMajorLabel(delta = time_end.subtract(major_time_old))) {
                    xp = this.graph_.getXUtoP(time_end);
                    x = (xp_major_old + xp) * 0.5;
                    this.drawMajorLabel(g, x, major_time_old);
                }
            } else {
                x = (this.graph_.getXUtoP(time_start) + this.graph_.getXUtoP(time_end)) * 0.5;
                this.drawMajorLabel(g, x, major_time_old);
            }
        } else {
            double y;
            int major_val;
            int xloc = this.graph_.getXUtoD(this.tLocation_.x);
            int yloc = this.graph_.getYUtoD(this.tRange_.start);
            int yend = this.graph_.getYUtoD(this.tRange_.end);
            g.drawLine(xloc, yloc, xloc, yend);
            double xp = this.graph_.getXUtoP(this.tLocation_.x);
            double yp = this.graph_.getYUtoP(time);
            this.setupDraw(xp);
            if (this.txt_.isStartOfMinor(time)) {
                this.drawThickYTic(g, xp, yp, (double)1.3f * this.largeTicHeight_);
            } else {
                this.drawYTic(g, xp, yp, this.largeTicHeight_);
            }
            int major_val_old = major_val = this.txt_.getMajorValue(time);
            int minor_val_old = this.txt_.getMinorValue(time);
            double yp_major_old = yp;
            double yp_minor_old = yp;
            GeoDate minor_time_old = new GeoDate(time);
            GeoDate major_time_old = new GeoDate(time);
            time.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            while (time.before(time_end)) {
                yp = this.graph_.getYUtoP(time);
                int minor_val = this.txt_.getMinorValue(time);
                if (this.txt_.isStartOfMinor(time)) {
                    this.drawThickYTic(g, xp, yp, (double)1.3f * this.largeTicHeight_);
                } else {
                    this.drawYTic(g, xp, yp, this.largeTicHeight_);
                }
                if (draw_minor && minor_val_old % this.minorLabelInterval_ == 0) {
                    y = this.txt_.computeLocation(yp_minor_old, yp);
                    this.drawMinorLabel(g, y, minor_time_old);
                }
                if ((major_val = this.txt_.getMajorValue(time)) != major_val_old) {
                    if (draw_major && major_val_old % this.majorLabelInterval_ == 0) {
                        labelDrawn = true;
                        y = (yp_major_old + yp) * 0.5;
                        this.drawMajorLabel(g, y, major_time_old);
                    }
                    yp_major_old = yp;
                    major_val_old = major_val;
                    major_time_old = new GeoDate(time);
                }
                yp_minor_old = yp;
                minor_val_old = minor_val;
                minor_time_old = new GeoDate(time);
                time.increment(this.txt_.getIncrementValue(), this.txt_.getIncrementUnits());
            }
            if (labelDrawn) {
                GeoDate delta;
                if (draw_major && major_val_old % this.majorLabelInterval_ == 0 && this.txt_.isRoomForMajorLabel(delta = time_end.subtract(major_time_old))) {
                    yp = this.graph_.getYUtoP(time_end);
                    y = (yp_major_old + yp) * 0.5;
                    this.drawMajorLabel(g, y, major_time_old);
                }
            } else {
                y = (this.graph_.getYUtoP(time_start) + this.graph_.getYUtoP(time_end)) * 0.5;
                this.drawMajorLabel(g, y, major_time_old);
            }
        }
    }

    @Override
    public void setTitle(SGLabel title) {
        this.title_ = null;
    }
}

