/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.Transform;
import gov.noaa.pmel.sgt.TransformAccess;
import gov.noaa.pmel.sgt.TransformColor;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.beans.PropertyChangeListener;

public class TransformColorMap
extends ColorMap
implements Cloneable,
PropertyChangeListener,
TransformColor,
TransformAccess {
    private Transform rTrans_ = null;
    private Transform gTrans_ = null;
    private Transform bTrans_ = null;

    public TransformColorMap(Transform rTrans, Transform gTrans, Transform bTrans) {
        this.rTrans_ = rTrans;
        this.rTrans_.setRangeP(0.0, 1.0);
        this.gTrans_ = gTrans;
        this.gTrans_.setRangeP(0.0, 1.0);
        this.bTrans_ = bTrans;
        this.bTrans_.setRangeP(0.0, 1.0);
    }

    @Override
    public ColorMap copy() {
        ColorMap newMap;
        try {
            newMap = (ColorMap)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newMap = null;
        }
        return newMap;
    }

    @Override
    public Color getColor(double val) {
        double ival = val;
        float red = (float)this.rTrans_.getTransP(ival);
        float green = (float)this.gTrans_.getTransP(ival);
        float blue = (float)this.bTrans_.getTransP(ival);
        return new Color(red, green, blue);
    }

    @Override
    public void setRange(Range2D range) {
        this.rTrans_.setRangeU(range);
        this.gTrans_.setRangeU(range);
        this.bTrans_.setRangeU(range);
    }

    @Override
    public Range2D getRange() {
        return this.rTrans_.getRangeU();
    }

    @Override
    public void setColorTransforms(Transform rTrans, Transform gTrans, Transform bTrans) {
        if (!(this.rTrans_.equals(rTrans) && this.gTrans_.equals(gTrans) && this.bTrans_.equals(bTrans))) {
            Transform tempOld = this.rTrans_;
            this.rTrans_ = rTrans;
            this.rTrans_.setRangeP(0.0, 1.0);
            this.firePropertyChange("redColorTransform", tempOld, this.rTrans_);
            tempOld = this.gTrans_;
            this.gTrans_ = gTrans;
            this.gTrans_.setRangeP(0.0, 1.0);
            this.firePropertyChange("greenColorTransform", tempOld, this.gTrans_);
            tempOld = this.bTrans_;
            this.bTrans_ = bTrans;
            this.bTrans_.setRangeP(0.0, 1.0);
            this.firePropertyChange("blueColorTransform", tempOld, this.bTrans_);
            this.rTrans_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.rTrans_));
            this.gTrans_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.gTrans_));
            this.bTrans_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.bTrans_));
        }
    }

    @Override
    public void setRedTransform(Transform red) {
        this.rTrans_ = red;
    }

    @Override
    public Transform getRedTransform() {
        return this.rTrans_;
    }

    @Override
    public void setGreenTransform(Transform green) {
        this.gTrans_ = green;
    }

    @Override
    public Transform getGreenTransform() {
        return this.gTrans_;
    }

    @Override
    public void setBlueTransform(Transform blue) {
        this.bTrans_ = blue;
    }

    @Override
    public Transform getBlueTransform() {
        return this.bTrans_;
    }

    @Override
    public boolean equals(ColorMap cm) {
        if (cm == null || !(cm instanceof TransformColorMap)) {
            return false;
        }
        return this.rTrans_.equals(((TransformColorMap)cm).rTrans_) && this.gTrans_.equals(((TransformColorMap)cm).gTrans_) && this.bTrans_.equals(((TransformColorMap)cm).bTrans_);
    }
}

