/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.PlotMark;
import gov.noaa.pmel.sgt.VectorAttribute;
import gov.noaa.pmel.sgt.dm.Collection;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTVector;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;

public class VectorCartesianRenderer
extends CartesianRenderer {
    private VectorAttribute attr_ = null;
    private SGTVector vector_ = null;
    private Collection collection_ = null;
    private float slope_;
    private float xoff_;
    private float yoff_;

    @Override
    public Attribute getAttribute() {
        return this.attr_;
    }

    private void drawVector(Graphics g, SGTVector vector, VectorAttribute attr) {
        float[] yp;
        int count;
        float[] xp;
        int size;
        Layer ly = this.cg_.getLayer();
        Graphics2D g2 = (Graphics2D)g;
        this.slope_ = (float)ly.getXSlope();
        this.xoff_ = (float)ly.getXOffset();
        this.yoff_ = (float)ly.getYOffset();
        GeneralPath gp = null;
        Stroke savedStroke = g2.getStroke();
        BasicStroke stroke = new BasicStroke(this.attr_.getWidth(), this.attr_.getCapStyle(), this.attr_.getMiterStyle(), this.attr_.getMiterLimit());
        g2.setStroke(stroke);
        float scale = (float)this.attr_.getVectorScale();
        float headScale = (float)this.attr_.getHeadScale() * 0.94386f;
        float fixedScale = (float)((double)headScale * this.attr_.getHeadFixedSize());
        float minSize = (float)this.attr_.getHeadMinSize();
        float maxSize = (float)this.attr_.getHeadMaxSize();
        double angle = this.attr_.getOffsetAngle() * 0.017453293;
        if (vector.isXTime()) {
            GeoDate[] xTValues = vector.getU().getTimeArray();
            size = xTValues.length;
            xp = new float[size];
            for (count = 0; count < size; ++count) {
                xp[count] = (float)this.cg_.getXUtoP(xTValues[count]);
            }
        } else {
            double[] xValues = vector.getU().getXArray();
            size = xValues.length;
            xp = new float[size];
            for (count = 0; count < size; ++count) {
                xp[count] = (float)this.cg_.getXUtoP(xValues[count]);
            }
        }
        if (vector.isYTime()) {
            GeoDate[] yTValues = vector.getU().getTimeArray();
            size = yTValues.length;
            yp = new float[size];
            for (count = 0; count < size; ++count) {
                yp[count] = (float)this.cg_.getYUtoP(yTValues[count]);
            }
        } else {
            double[] yValues = vector.getU().getYArray();
            size = yValues.length;
            yp = new float[size];
            for (count = 0; count < size; ++count) {
                yp[count] = (float)this.cg_.getYUtoP(yValues[count]);
            }
        }
        double[] uValues = vector.getU().getZArray();
        double[] vValues = vector.getV().getZArray();
        int[] xtail = new int[uValues.length];
        int[] ytail = new int[uValues.length];
        count = 0;
        int ny = yp.length;
        for (int i = 0; i < xp.length; ++i) {
            int idx_ny = i * ny;
            for (int j = 0; j < yp.length; ++j) {
                float vy;
                float vx;
                int idx = j + idx_ny;
                if (Double.isNaN(uValues[idx]) || Double.isNaN(vValues[idx])) continue;
                float orgX = this.xPtoD(xp[i]);
                float orgY = this.yPtoD(yp[j]);
                xtail[count] = (int)orgX;
                ytail[count] = (int)orgY;
                double vdx = uValues[idx] * (double)scale;
                double vdy = vValues[idx] * (double)scale;
                if (angle != 0.0) {
                    vx = (float)(vdx * Math.cos(angle) - vdy * Math.sin(angle));
                    vy = (float)(vdy * Math.cos(angle) + vdx * Math.sin(angle));
                } else {
                    vx = (float)vdx;
                    vy = (float)vdy;
                }
                float xphead = xp[i] + vx;
                float yphead = yp[j] + vy;
                gp = new GeneralPath();
                gp.moveTo(orgX, orgY);
                float headX = this.xPtoD(xphead);
                float headY = this.yPtoD(yphead);
                gp.lineTo(headX, headY);
                float vclen = (float)Math.sqrt(vx * vx + vy * vy);
                if ((double)vclen == 0.0) {
                    g.drawLine((int)headX, (int)headY, (int)headX, (int)headY);
                } else if (this.attr_.getVectorStyle() != 0) {
                    float hy2;
                    float hx2;
                    float hy1;
                    float hx1;
                    float tScale;
                    if (this.attr_.getVectorStyle() == 1) {
                        tScale = fixedScale / vclen;
                        hx1 = this.xPtoD(xphead + (-vx - 0.35f * vy) * tScale);
                        hy1 = this.yPtoD(yphead + (-vy + 0.35f * vx) * tScale);
                        hx2 = this.xPtoD(xphead + (-vx + 0.35f * vy) * tScale);
                        hy2 = this.yPtoD(yphead + (-vy - 0.35f * vx) * tScale);
                        gp.moveTo(hx1, hy1);
                        gp.lineTo(headX, headY);
                        gp.lineTo(hx2, hy2);
                    } else {
                        tScale = vclen >= maxSize ? maxSize * headScale / vclen : (vclen <= minSize ? minSize * headScale / vclen : headScale);
                        hx1 = this.xPtoD(xphead + (-vx - 0.35f * vy) * tScale);
                        hy1 = this.yPtoD(yphead + (-vy + 0.35f * vx) * tScale);
                        hx2 = this.xPtoD(xphead + (-vx + 0.35f * vy) * tScale);
                        hy2 = this.yPtoD(yphead + (-vy - 0.35f * vx) * tScale);
                        gp.moveTo(hx1, hy1);
                        gp.lineTo(headX, headY);
                        gp.lineTo(hx2, hy2);
                    }
                }
                ++count;
                g2.draw(gp);
            }
        }
        g2.setStroke(savedStroke);
        if (this.attr_.getOriginStyle() == 1) {
            g.setColor(this.attr_.getMarkColor());
            this.drawMark(g, xtail, ytail, xtail.length, this.attr_);
        }
    }

    private float xPtoD(float xp) {
        return this.slope_ * xp + this.xoff_;
    }

    private float yPtoD(float yp) {
        return this.yoff_ - this.slope_ * yp;
    }

    protected void drawMark(Graphics g, int[] xp, int[] yp, int npoints, VectorAttribute attr) {
        Layer ly = this.cg_.getLayer();
        PlotMark pm = new PlotMark(attr.getMark());
        pm.setMarkHeightP(attr.getMarkHeightP());
        for (int i = 0; i < npoints; ++i) {
            pm.paintMark(g, ly, xp[i], yp[i]);
        }
    }

    public VectorCartesianRenderer(CartesianGraph cg) {
        this(cg, (SGTVector)null, null);
    }

    public VectorCartesianRenderer(CartesianGraph cg, SGTVector vector) {
        this(cg, vector, null);
        this.cg_ = cg;
        this.vector_ = vector;
    }

    public VectorCartesianRenderer(CartesianGraph cg, SGTVector vector, VectorAttribute attr) {
        this.cg_ = cg;
        this.vector_ = vector;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
        }
    }

    public VectorCartesianRenderer(CartesianGraph cg, Collection col, VectorAttribute attr) {
        this.cg_ = cg;
        this.collection_ = col;
        this.attr_ = attr;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
        }
    }

    @Override
    public void drawDynamicData(Graphics g) {
        if (this.vector_.isDynamic()) {
            this.drawVector(g);
        }
    }

    @Override
    public void draw(Graphics g) {
        if (!this.vector_.isDynamic()) {
            this.drawVector(g);
        }
    }

    private void drawVector(Graphics g) {
        VectorAttribute attr;
        if (this.cg_.clipping_) {
            int height;
            int y;
            int width;
            int x;
            int ymax;
            int ymin;
            int xmax;
            int xmin;
            if (this.cg_.xTransform_.isSpace()) {
                xmin = this.cg_.getXUtoD(this.cg_.xClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.xClipRange_.end);
            } else {
                xmin = this.cg_.getXUtoD(this.cg_.tClipRange_.start);
                xmax = this.cg_.getXUtoD(this.cg_.tClipRange_.end);
            }
            if (this.cg_.yTransform_.isSpace()) {
                ymin = this.cg_.getYUtoD(this.cg_.yClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.yClipRange_.end);
            } else {
                ymin = this.cg_.getYUtoD(this.cg_.tClipRange_.start);
                ymax = this.cg_.getYUtoD(this.cg_.tClipRange_.end);
            }
            if (xmin < xmax) {
                x = xmin;
                width = xmax - xmin;
            } else {
                x = xmax;
                width = xmin - xmax;
            }
            if (ymin < ymax) {
                y = ymin;
                height = ymax - ymin;
            } else {
                y = ymax;
                height = ymin - ymax;
            }
            g.setClip(x, y, width, height);
        }
        if ((attr = this.attr_ == null ? new VectorAttribute(1.0, this.cg_.getPane().getComponent().getForeground()) : this.attr_).isVisible()) {
            g.setColor(attr.getVectorColor());
            if (this.collection_ == null) {
                this.drawVector(g, this.vector_, attr);
            } else {
                Enumeration li = this.collection_.elements();
                while (li.hasMoreElements()) {
                    Object vector = li.nextElement();
                    if (!(vector instanceof SGTVector)) continue;
                    this.drawVector(g, (SGTVector)vector, attr);
                }
            }
        }
        Rectangle rect = this.cg_.getLayer().getPane().getBounds();
        g.setClip(rect);
    }

    public void setVectorAttribute(VectorAttribute l) {
        this.attr_ = l;
        if (this.attr_ != null) {
            this.attr_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.attr_));
        }
    }

    public VectorAttribute getVectorAttribute() {
        return this.attr_;
    }

    public boolean hasCollection() {
        return this.collection_ != null;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public SGTVector getVector() {
        return this.vector_;
    }

    @Override
    public CartesianGraph getCartesianGraph() {
        return this.cg_;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("VectorCartesianRenderer: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public SGTData getDataAt(Point pt) {
        return null;
    }

    @Override
    public SGTData getData() {
        return this.vector_;
    }

    @Override
    public void removeData() {
        this.collection_ = null;
        this.vector_ = null;
    }
}

