/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt;

import gov.noaa.pmel.sgt.JPane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

public class ZoomRectangle
extends JComponent {
    private Color fillColor_ = new Color(255, 255, 255, 200);
    private Color lineColor_ = Color.black;
    private Point start_;
    private Point end_;

    public ZoomRectangle(JPane.ScaledMouseEvent event) {
        this.start_ = new Point(event.getX(), event.getY());
        this.end_ = new Point(event.getX() + 1, event.getY() + 1);
    }

    public void zoomTo(JPane.ScaledMouseEvent event) {
        this.end_.x = event.getX();
        this.end_.y = event.getY();
        this.revalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g);
    }

    public void draw(Graphics g) {
        Rectangle rect = this.getRectangle();
        g.setColor(this.fillColor_);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(this.lineColor_);
        g.drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    public Rectangle getRectangle() {
        int width = this.end_.x - this.start_.x;
        int x = this.start_.x;
        if (width < 0) {
            x = this.end_.x;
            width = Math.abs(width);
        }
        int height = this.end_.y - this.start_.y;
        int y = this.start_.y;
        if (height < 0) {
            y = this.end_.y;
            height = Math.abs(height);
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public String toString() {
        return this.getRectangle().toString();
    }
}

