/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import gov.noaa.pmel.util.SoTRange;
import java.awt.Color;
import java.awt.Font;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisHolder
implements Serializable {
    private Vector changeListeners;
    private DataGroup dataGroup_;
    private transient ChangeEvent changeEvent_ = new ChangeEvent(this);
    private int axisType = -1;
    private int axisOrientation = -1;
    private int transformType = 0;
    private String transformGroup = "";
    private int axisPosition = -1;
    private Point2D.Double axisOriginP = new Point2D.Double(0.0, 0.0);
    private boolean locationAtOrigin = false;
    private Color axisColor = Color.black;
    private boolean autoRange = true;
    private boolean rangeSet = false;
    private Rectangle2D boundsP = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private SoTRange userRange = new SoTRange.Double(1.0, 10.0, 1.0);
    private SoTRange timeRange = new SoTRange.Time(946684800000L, 978307200000L, 172800000L);
    private Color labelColor = Color.black;
    private Font labelFont = new Font("Helvetica", 0, 10);
    private double labelHeightP = 0.15;
    private int labelPosition = 3;
    private double largeTicHeightP = 0.1;
    private double smallTicHeightP = 0.05;
    private int numSmallTics = 0;
    private double thickTicWidth = 0.025;
    private int ticPosition = 3;
    private SGLabel title = new SGLabel("title", "", 0.2, new Point2D.Double(0.0, 0.0), 2, 0);
    private boolean titleAuto = true;
    private boolean selectable = true;
    private boolean visible = true;
    private String labelFormat = "";
    private int labelInterval = 2;
    private int labelSignificantDigits = 2;
    private String minorFormat = "MMM";
    private String majorFormat = "yyyy";
    private int minorInterval = 2;
    private int majorInterval = 1;
    private int timeAxisStyle = 0;
    private int verticalLabelOrientation = 1;
    private boolean suppressEvent_ = false;
    private boolean lon360_ = false;
    private boolean labelQuadrant_ = true;

    public AxisHolder() {
        this.title.setColor(Color.black);
        this.rangeSet = false;
    }

    public AxisHolder(int type, int dir, DataGroup dataGroup) {
        this.axisType = type;
        this.axisOrientation = dir;
        this.dataGroup_ = dataGroup;
        this.rangeSet = false;
        if (this.axisOrientation == 0) {
            this.title.setText("X Axis");
            this.axisPosition = 1;
        } else {
            this.title.setText("Y Axis");
            this.axisPosition = 2;
        }
        this.transformGroup = dataGroup.getId();
        this.title.setColor(Color.black);
    }

    public DataGroup getDataGroup() {
        return this.dataGroup_;
    }

    public void setDataGroup(DataGroup dataGroup) {
        this.dataGroup_ = dataGroup;
        this.transformGroup = this.dataGroup_.getId();
    }

    public boolean isTime() {
        return this.axisType == 3;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void removeDesignChangeListeners() {
        if (this.changeListeners != null) {
            Vector v = (Vector)this.changeListeners.clone();
            for (Object obj : v) {
                if (!(obj instanceof DesignListener)) continue;
                this.changeListeners.removeElement(obj);
            }
        }
    }

    public void removeAllChangeListeners() {
        this.changeListeners.removeAllElements();
    }

    public void fireStateChanged() {
        if (this.suppressEvent_) {
            return;
        }
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(this.changeEvent_);
            }
        }
    }

    public void setAxisType(int axisType) {
        int saved = this.axisType;
        this.axisType = axisType;
        if (saved != this.axisType) {
            this.fireStateChanged();
        }
    }

    public int getAxisType() {
        return this.axisType;
    }

    public int getAxisOrientation() {
        return this.axisOrientation;
    }

    public void setAxisOrientation(int dir) {
        this.axisOrientation = dir;
        if (this.axisOrientation == 0) {
            this.title.setText("X Axis");
            this.axisPosition = 1;
        } else {
            this.title.setText("Y Axis");
            this.axisPosition = 2;
        }
    }

    public void setAxisColor(Color axisColor) {
        Color saved = new Color(this.axisColor.getRed(), this.axisColor.getGreen(), this.axisColor.getBlue(), this.axisColor.getAlpha());
        this.axisColor = axisColor;
        if (!saved.equals(this.axisColor)) {
            this.fireStateChanged();
        }
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAutoRange(boolean autoRange) {
        boolean saved = this.autoRange;
        this.autoRange = autoRange;
        if (saved != autoRange) {
            this.fireStateChanged();
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setUserRange(SoTRange userRange) {
        if (this.axisType == 3) {
            SoTRange saved = this.timeRange.copy();
            this.timeRange = userRange;
            if (!saved.equals(this.timeRange)) {
                this.fireStateChanged();
                this.rangeSet = true;
            }
        } else {
            SoTRange saved = this.userRange.copy();
            this.userRange = userRange;
            if (!saved.equals(this.userRange)) {
                this.fireStateChanged();
                this.rangeSet = true;
            }
        }
    }

    public SoTRange getUserRange() {
        if (this.axisType == 3) {
            return this.timeRange;
        }
        return this.userRange;
    }

    public void setLabelColor(Color labelColor) {
        Color saved = new Color(this.labelColor.getRed(), this.labelColor.getGreen(), this.labelColor.getBlue(), this.labelColor.getAlpha());
        this.labelColor = labelColor;
        if (!saved.equals(this.labelColor)) {
            this.fireStateChanged();
        }
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelFont(Font labelFont) {
        Font saved = new Font(this.labelFont.getName(), this.labelFont.getStyle(), this.labelFont.getSize());
        this.labelFont = labelFont;
        if (!saved.equals(this.labelFont)) {
            this.fireStateChanged();
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelHeightP(double labelHeightP) {
        double saved = this.labelHeightP;
        this.labelHeightP = labelHeightP;
        if (saved != this.labelHeightP) {
            this.fireStateChanged();
        }
    }

    public double getLabelHeightP() {
        return this.labelHeightP;
    }

    public void setLabelPosition(int labelPosition) {
        int saved = this.labelPosition;
        this.labelPosition = labelPosition;
        if (saved != this.labelPosition) {
            this.fireStateChanged();
        }
    }

    public boolean isLabelPositionAuto() {
        return this.labelPosition == 3;
    }

    public int getLabelPosition() {
        int labPos = 1;
        if (this.isLabelPositionAuto()) {
            switch (this.axisPosition) {
                case 1: 
                case 2: 
                case 4: {
                    labPos = 1;
                    break;
                }
                case 0: 
                case 3: {
                    labPos = 0;
                }
            }
        } else {
            labPos = this.labelPosition;
        }
        return labPos;
    }

    public int getVerticalLabelOrientation() {
        return this.verticalLabelOrientation;
    }

    public void setVerticalLabelOrientation(int orient) {
        this.verticalLabelOrientation = orient;
    }

    public void setBoundsP(Rectangle2D boundsP) {
        Rectangle2D saved = this.getBoundsP();
        this.boundsP = boundsP;
        boolean changed = true;
        if (saved != null) {
            boolean bl = changed = !saved.equals(this.boundsP);
        }
        if (changed) {
            this.fireStateChanged();
        }
    }

    public Rectangle2D getBoundsP() {
        return this.boundsP;
    }

    public Range2D getRangeP() {
        Rectangle2D.Double dbl = (Rectangle2D.Double)this.boundsP;
        if (this.axisOrientation == 0) {
            return new Range2D(dbl.x, dbl.x + dbl.width);
        }
        return new Range2D(dbl.y, dbl.y + dbl.height);
    }

    public void setLargeTicHeightP(double largeTicHeightP) {
        double saved = this.largeTicHeightP;
        this.largeTicHeightP = largeTicHeightP;
        if (saved != this.largeTicHeightP) {
            this.fireStateChanged();
        }
    }

    public double getLargeTicHeightP() {
        return this.largeTicHeightP;
    }

    public void setSmallTicHeightP(double smallTicHeightP) {
        double saved = this.smallTicHeightP;
        this.smallTicHeightP = smallTicHeightP;
        if (saved != this.smallTicHeightP) {
            this.fireStateChanged();
        }
    }

    public double getSmallTicHeightP() {
        return this.smallTicHeightP;
    }

    public void setNumSmallTics(int numSmallTics) {
        int saved = this.numSmallTics;
        this.numSmallTics = numSmallTics;
        if (saved != this.numSmallTics) {
            this.fireStateChanged();
        }
    }

    public int getNumSmallTics() {
        return this.numSmallTics;
    }

    public void setThickTicWidth(double thickTicWidth) {
        double saved = this.thickTicWidth;
        this.thickTicWidth = thickTicWidth;
        if (saved != this.thickTicWidth) {
            this.fireStateChanged();
        }
    }

    public double getThickTicWidth() {
        return this.thickTicWidth;
    }

    public void setTicPosition(int ticPosition) {
        int saved = this.ticPosition;
        this.ticPosition = ticPosition;
        if (saved != this.ticPosition) {
            this.fireStateChanged();
        }
    }

    public boolean isTicPositionAuto() {
        return this.ticPosition == 3;
    }

    public int getTicPosition() {
        int ticPos = 1;
        if (this.isTicPositionAuto()) {
            switch (this.axisPosition) {
                case 1: 
                case 2: 
                case 4: {
                    ticPos = 1;
                    break;
                }
                case 0: 
                case 3: {
                    ticPos = 0;
                }
            }
        } else {
            ticPos = this.ticPosition;
        }
        return ticPos;
    }

    public void setTitle(SGLabel title) {
        SGLabel saved = (SGLabel)this.title.copy();
        this.title = title;
        if (!saved.equals(this.title)) {
            this.fireStateChanged();
        }
    }

    public SGLabel getTitle() {
        return this.title;
    }

    public void setSelectable(boolean selectable) {
        boolean saved = this.selectable;
        this.selectable = selectable;
        if (saved != this.selectable) {
            this.fireStateChanged();
        }
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setVisible(boolean visible) {
        boolean saved = this.visible;
        this.visible = visible;
        if (saved != this.visible) {
            this.fireStateChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setLabelFormat(String labelFormat) {
        String saved = this.labelFormat;
        this.labelFormat = labelFormat;
        if (!saved.equals(this.labelFormat)) {
            this.fireStateChanged();
        }
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelInterval(int labelInterval) {
        int saved = this.labelInterval;
        this.labelInterval = labelInterval;
        if (saved != this.labelInterval) {
            this.fireStateChanged();
        }
    }

    public int getLabelInterval() {
        return this.labelInterval;
    }

    public void setLabelSignificantDigits(int labelSignificantDigits) {
        int saved = this.labelSignificantDigits;
        this.labelSignificantDigits = labelSignificantDigits;
        if (saved != this.labelSignificantDigits) {
            this.fireStateChanged();
        }
    }

    public int getLabelSignificantDigits() {
        return this.labelSignificantDigits;
    }

    public void setMinorFormat(String minorFormat) {
        String saved = this.minorFormat;
        this.minorFormat = minorFormat;
        if (!saved.equals(this.minorFormat)) {
            this.fireStateChanged();
        }
    }

    public String getMinorFormat() {
        return this.minorFormat;
    }

    public void setMajorFormat(String majorFormat) {
        String saved = this.majorFormat;
        this.majorFormat = majorFormat;
        if (!saved.equals(this.majorFormat)) {
            this.fireStateChanged();
        }
    }

    public String getMajorFormat() {
        return this.majorFormat;
    }

    public void setMinorInterval(int minorInterval) {
        int saved = this.minorInterval;
        this.minorInterval = minorInterval;
        if (saved != this.minorInterval) {
            this.fireStateChanged();
        }
    }

    public int getMinorInterval() {
        return this.minorInterval;
    }

    public void setMajorInterval(int majorInterval) {
        int saved = this.majorInterval;
        this.majorInterval = majorInterval;
        if (saved != this.majorInterval) {
            this.fireStateChanged();
        }
    }

    public int getMajorInterval() {
        return this.majorInterval;
    }

    public void setTimeAxisStyle(int timeAxisStyle) {
        int saved = this.timeAxisStyle;
        this.timeAxisStyle = timeAxisStyle;
        if (saved != this.timeAxisStyle) {
            this.fireStateChanged();
        }
    }

    public int getTimeAxisStyle() {
        return this.timeAxisStyle;
    }

    public void setTransformType(int transformType) {
        int saved = this.transformType;
        this.transformType = transformType;
        if (saved != this.transformType) {
            this.fireStateChanged();
        }
    }

    public int getTransformType() {
        return this.transformType;
    }

    public void setTransformGroup(String transformGroup) {
        String saved = this.transformGroup;
        this.transformGroup = transformGroup;
        if (saved == null || !saved.equals(this.transformGroup)) {
            this.fireStateChanged();
        }
    }

    public String getTransformGroup() {
        return this.transformGroup;
    }

    public void setAxisPosition(int axisPosition) {
        int saved = this.axisPosition;
        this.axisPosition = axisPosition;
        if (saved != this.axisPosition) {
            this.fireStateChanged();
        }
    }

    public int getAxisPosition() {
        return this.axisPosition;
    }

    public void setAxisOriginP(Point2D.Double axisOriginP) {
        Point2D.Double saved = this.getAxisOriginP();
        this.axisOriginP = axisOriginP;
        boolean changed = true;
        if (saved != null) {
            boolean bl = changed = !((Object)saved).equals(this.axisOriginP);
        }
        if (changed) {
            this.fireStateChanged();
        }
    }

    public Point2D.Double getAxisOriginP() {
        return this.axisOriginP == null ? null : (Point2D.Double)this.axisOriginP.copy();
    }

    public void setLocationAtOrigin(boolean locationAtOrigin) {
        boolean saved = this.locationAtOrigin;
        this.locationAtOrigin = locationAtOrigin;
        if (saved != this.locationAtOrigin) {
            this.fireStateChanged();
        }
    }

    public boolean isLocationAtOrigin() {
        return this.locationAtOrigin;
    }

    public void setTitleAuto(boolean titleAuto) {
        boolean saved = this.titleAuto;
        this.titleAuto = titleAuto;
        if (saved != this.titleAuto) {
            this.fireStateChanged();
        }
    }

    public boolean isTitleAuto() {
        return this.titleAuto;
    }

    public void setLongitude360(boolean lon) {
        boolean saved = this.lon360_;
        this.lon360_ = lon;
        if (saved != this.lon360_) {
            this.fireStateChanged();
        }
    }

    public boolean isLongitude360() {
        return this.lon360_;
    }

    public void setLabelQuadrant(boolean label) {
        boolean saved = this.labelQuadrant_;
        this.labelQuadrant_ = label;
        if (saved != this.labelQuadrant_) {
            this.fireStateChanged();
        }
    }

    public boolean isLabelQuadrant() {
        return this.labelQuadrant_;
    }

    public boolean isRangeSet() {
        return this.rangeSet;
    }

    public void setRangeSet(boolean rangeSet) {
        this.rangeSet = rangeSet;
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(AxisHolder.class);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor pd = descriptors[i];
                if (!pd.getName().equals("dataGroup")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }
}

