/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolder;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AxisHolderDragBox
extends DragBox
implements ChangeListener {
    public static int TIC_LENGTH = 10;
    public static int TIC_SPACE = 5;
    public static int TIC_INCREMENT = 25;
    public static int TITLE_HEIGHT = 10;
    public static int TITLE_SPACE = 5;
    public static final int ORIGIN = 0;
    public static final int SIZE = 1;
    public static final int DUMMY_ORIGIN = 2;
    public static final int DUMMY_SIZE = 3;
    private AxisHolder axHolder_;
    private Rectangle boundsD_ = null;
    private Point originD_ = null;
    private String id_ = null;
    private DataGroup dg_ = null;

    public AxisHolderDragBox(AxisHolder axHolder, DataGroup dg, PanelHolder pHolder) {
        super(pHolder);
        Rectangle2D.Double bnds;
        this.axHolder_ = axHolder;
        this.axHolder_.addChangeListener(this);
        this.dg_ = dg;
        this.dg_.addChangeListener(this);
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.id_ = this.axHolder_.getDataGroup().getId() + (this.axHolder_.getAxisOrientation() == 0 ? "_X" : "_Y");
        Point2D.Double orig = this.axHolder_.getAxisOriginP();
        if (orig != null) {
            this.originD_ = this.toLocation(orig);
        }
        if ((bnds = (Rectangle2D.Double)this.axHolder_.getBoundsP()) != null) {
            this.boundsD_ = this.toRectangle(bnds);
        }
        this.update("AxisHolderDragBox.new()");
    }

    public AxisHolder getAxisHolder() {
        return this.axHolder_;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.boundsD_ = bounds;
        this.axHolder_.setBoundsP(this.toRectangle(bounds));
        this.computeHandles();
    }

    public void setOrigin(Point pt) {
        this.originD_ = pt;
        this.axHolder_.setAxisOriginP(this.toLocation(this.originD_));
        this.computeHandles();
    }

    public Point getOrigin() {
        return (Point)this.originD_.clone();
    }

    @Override
    public Point getLocation() {
        return new Point(this.boundsD_.x, this.boundsD_.y);
    }

    @Override
    public void setId(String id) {
    }

    @Override
    public void draw(Graphics g) {
        int i;
        Color savedColor = g.getColor();
        if (this.selected_) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.darkGray);
        }
        Rectangle dgBounds = this.computeDataGroupBounds();
        if (this.axHolder_.getAxisOrientation() == 0) {
            int yticEnd;
            int yticStart;
            int yorg;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        yorg = dgBounds.y + dgBounds.height;
                        break;
                    }
                    case 0: {
                        yorg = dgBounds.y;
                        break;
                    }
                }
            } else {
                yorg = this.originD_.y;
            }
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    yticStart = yorg;
                    yticEnd = yorg + TIC_LENGTH;
                    break;
                }
                case 0: {
                    yticStart = yorg - TIC_LENGTH;
                    yticEnd = yorg;
                    break;
                }
                case 2: {
                    yticStart = yorg - TIC_LENGTH;
                    yticEnd = yorg + TIC_LENGTH;
                }
            }
            if (this.axHolder_.isVisible()) {
                g.drawRect(this.boundsD_.x, this.boundsD_.y, this.boundsD_.width, this.boundsD_.height);
                g.drawLine(this.boundsD_.x, yorg, this.boundsD_.x + this.boundsD_.width, yorg);
                for (i = this.boundsD_.x; i < this.boundsD_.x + this.boundsD_.width; i += TIC_INCREMENT) {
                    g.drawLine(i, yticStart, i, yticEnd);
                }
            }
        } else {
            int xticEnd;
            int xticStart;
            int xorg;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        xorg = dgBounds.x;
                        break;
                    }
                    case 3: {
                        xorg = dgBounds.x + dgBounds.width;
                        break;
                    }
                }
            } else {
                xorg = this.originD_.x;
            }
            switch (this.axHolder_.getTicPosition()) {
                default: {
                    xticStart = xorg;
                    xticEnd = xorg - TIC_LENGTH;
                    break;
                }
                case 0: {
                    xticStart = xorg + TIC_LENGTH;
                    xticEnd = xorg;
                    break;
                }
                case 2: {
                    xticStart = xorg - TIC_LENGTH;
                    xticEnd = xorg + TIC_LENGTH;
                }
            }
            if (this.axHolder_.isVisible()) {
                g.drawRect(this.boundsD_.x, this.boundsD_.y, this.boundsD_.width, this.boundsD_.height);
                g.drawLine(xorg, this.boundsD_.y, xorg, this.boundsD_.y + this.boundsD_.height);
                for (i = this.boundsD_.y; i < this.boundsD_.y + this.boundsD_.height; i += TIC_INCREMENT) {
                    g.drawLine(xticStart, i, xticEnd, i);
                }
            }
        }
        if (this.selected_) {
            for (i = 0; i < this.handles_.length; ++i) {
                Rectangle r = this.handles_[i];
                g.fillRect(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
        g.setColor(savedColor);
    }

    private Rectangle computeDataGroupBounds() {
        Rectangle panel = this.pHolder_.getBounds();
        Margin margin = this.dg_.getMargin();
        float dpi = this.pHolder_.getPanelModel().getDpi();
        int left = (int)(margin.left * dpi);
        int right = (int)(margin.right * dpi);
        int top = (int)(margin.top * dpi);
        int bottom = (int)(margin.bottom * dpi);
        return new Rectangle(panel.x + left, panel.y + top, panel.width - (left + right), panel.height - (top + bottom));
    }

    @Override
    public void update(String message) {
        int height;
        int yOrig;
        int xOrig;
        int y;
        int x;
        int width;
        int ticPos = 1;
        int labPos = 1;
        Rectangle dgBounds = this.computeDataGroupBounds();
        if (this.axHolder_.getAxisOrientation() == 0) {
            width = dgBounds.width;
            x = dgBounds.x;
            ticPos = this.axHolder_.getTicPosition();
            labPos = this.axHolder_.getLabelPosition();
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        y = dgBounds.y + dgBounds.height;
                        break;
                    }
                    case 0: {
                        y = dgBounds.y;
                        break;
                    }
                }
            } else {
                y = this.originD_.y;
                x = this.boundsD_.x;
                width = this.boundsD_.width;
            }
            xOrig = x;
            yOrig = y;
            height = TIC_SPACE + TITLE_SPACE;
            switch (labPos) {
                case 1: {
                    height += TITLE_HEIGHT;
                    break;
                }
                case 0: {
                    height += TITLE_HEIGHT;
                    y -= TITLE_HEIGHT + TITLE_SPACE;
                    break;
                }
            }
            switch (ticPos) {
                case 1: {
                    height += TIC_LENGTH;
                    break;
                }
                case 0: {
                    height += TIC_LENGTH;
                    y -= TIC_LENGTH + TIC_SPACE;
                    break;
                }
                case 2: {
                    height += 2 * TIC_LENGTH + TIC_SPACE;
                    y -= TIC_LENGTH + TIC_SPACE;
                }
            }
        } else {
            height = dgBounds.height;
            y = dgBounds.y;
            ticPos = this.axHolder_.getTicPosition();
            labPos = this.axHolder_.getLabelPosition();
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        x = dgBounds.x;
                        break;
                    }
                    case 3: {
                        x = dgBounds.x + dgBounds.width;
                        break;
                    }
                }
            } else {
                x = this.originD_.x;
                y = this.boundsD_.y;
                height = this.boundsD_.height;
            }
            xOrig = x;
            yOrig = y;
            width = TIC_SPACE + TITLE_SPACE;
            switch (labPos) {
                case 1: {
                    width += TITLE_HEIGHT;
                    x -= TITLE_HEIGHT + TITLE_SPACE;
                    break;
                }
                case 0: {
                    width += TITLE_HEIGHT;
                    break;
                }
            }
            switch (ticPos) {
                case 1: {
                    width += TIC_LENGTH;
                    x -= TIC_LENGTH + TIC_SPACE;
                    break;
                }
                case 0: {
                    width += TIC_LENGTH;
                    break;
                }
                case 2: {
                    width += 2 * TIC_LENGTH + TIC_SPACE;
                    x -= TIC_LENGTH + TIC_SPACE;
                }
            }
        }
        this.setOrigin(new Point(xOrig, yOrig));
        this.setBounds(new Rectangle(x, y, width, height));
        this.computeHandles();
    }

    @Override
    public void setLocation(Point point) {
        this.boundsD_.x = point.x;
        this.boundsD_.y = point.y;
        this.axHolder_.setBoundsP(this.toRectangle(this.boundsD_));
        this.computeHandles();
    }

    @Override
    public Rectangle getBounds() {
        return (Rectangle)this.boundsD_.clone();
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update("AxisHolderDragBox.stateChanged()");
    }

    @Override
    protected void computeHandles() {
        if (this.boundsD_ == null) {
            return;
        }
        int ticPos = this.axHolder_.getTicPosition();
        Rectangle dgBounds = this.computeDataGroupBounds();
        if (this.axHolder_.getAxisOrientation() == 0) {
            int y;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        y = dgBounds.y + dgBounds.height;
                        break;
                    }
                    case 0: {
                        y = dgBounds.y;
                        break;
                    }
                }
            } else {
                y = this.originD_.y;
            }
            if (ticPos == 0 || ticPos == 2) {
                y -= handleSize_ + 1;
            }
            this.handles_[0].setBounds(this.boundsD_.x + 1, y, handleSize_, handleSize_);
            this.handles_[1].setBounds(this.boundsD_.x + this.boundsD_.width - handleSize_ + 1, this.boundsD_.y + (this.boundsD_.height - handleSize_) / 2, handleSize_, handleSize_);
        } else {
            int x;
            if (this.axHolder_.getAxisPosition() != 4) {
                switch (this.axHolder_.getAxisPosition()) {
                    default: {
                        x = dgBounds.x;
                        break;
                    }
                    case 3: {
                        x = dgBounds.x + dgBounds.width;
                        break;
                    }
                }
            } else {
                x = this.originD_.x;
            }
            if (ticPos == 1 || ticPos == 2) {
                x -= handleSize_;
            }
            this.handles_[0].setBounds(x, this.boundsD_.y + this.boundsD_.height - handleSize_ + 1, handleSize_, handleSize_);
            this.handles_[1].setBounds(this.boundsD_.x + (this.boundsD_.width - handleSize_) / 2, this.boundsD_.y + 1, handleSize_, handleSize_);
        }
    }

    @Override
    public void mouseOperation(int op, int dx, int dy) {
        if (op == -1) {
            return;
        }
        switch (op) {
            case 0: {
                Point pt = this.getLocation();
                pt.x += dx;
                pt.y += dy;
                this.setLocation(pt);
                pt = this.getOrigin();
                pt.x += dx;
                pt.y += dy;
                this.setOrigin(pt);
                break;
            }
            case 1: {
                Rectangle rect = this.getBounds();
                if (this.axHolder_.getAxisOrientation() == 0) {
                    rect.width += dx;
                } else {
                    rect.height -= dy;
                    rect.y += dy;
                }
                this.setBounds(rect);
                break;
            }
        }
        this.axHolder_.setAxisPosition(4);
    }
}

