/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolderDragBox;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DataGroupDragBox
extends DragBox
implements ChangeListener {
    private Rectangle boundsD_ = new Rectangle();
    private DataGroup dg_ = null;
    private AxisHolderDragBox xAxDB_ = null;
    private AxisHolderDragBox yAxDB_ = null;

    public DataGroupDragBox(DataGroup dg, PanelHolder pHolder) {
        super(pHolder);
        this.dg_ = dg;
        this.dg_.addChangeListener(this);
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.update("DataGroupDragBox.new()");
    }

    public DataGroup getDataGroup() {
        return this.dg_;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.boundsD_ = bounds;
        this.dg_.setMargin(this.computeMargin());
        this.computeHandles();
    }

    private Margin computeMargin() {
        Rectangle panel = this.pHolder_.getBounds();
        float dpi = this.pHolder_.getPanelModel().getDpi();
        float top = (float)(this.boundsD_.y - panel.y) / dpi;
        float bottom = (float)(panel.y + panel.height - (this.boundsD_.y + this.boundsD_.height)) / dpi;
        float left = (float)(this.boundsD_.x - panel.x) / dpi;
        float right = (float)(panel.x + panel.width - (this.boundsD_.x + this.boundsD_.width)) / dpi;
        return new Margin(top, left, bottom, right);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle bounds = this.getBounds();
        Color savedColor = g.getColor();
        if (this.selected_) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.green);
        }
        Rectangle2D.Float rect = new Rectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height);
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        float[] dashes = new float[]{4.0f, 4.0f};
        BasicStroke stroke = new BasicStroke(1.0f, 2, 0, 10.0f, dashes, 0.0f);
        g2.setStroke(stroke);
        g2.draw(rect);
        g2.setStroke(saved);
        if (this.selected_) {
            for (int i = 0; i < this.handles_.length; ++i) {
                Rectangle r = this.handles_[i];
                g.fillRect(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
        g.setColor(savedColor);
    }

    @Override
    public void update(String message) {
        Rectangle panel = this.pHolder_.getBounds();
        Margin margin = this.dg_.getMargin();
        float dpi = this.pHolder_.getPanelModel().getDpi();
        int left = (int)(margin.left * dpi);
        int right = (int)(margin.right * dpi);
        int top = (int)(margin.top * dpi);
        int bottom = (int)(margin.bottom * dpi);
        this.boundsD_.x = panel.x + left;
        this.boundsD_.y = panel.y + top;
        this.boundsD_.width = panel.width - (left + right);
        this.boundsD_.height = panel.height - (top + bottom);
        this.computeHandles();
    }

    @Override
    public void setLocation(Point pt) {
        this.boundsD_.x = pt.x;
        this.boundsD_.y = pt.y;
        this.dg_.setMargin(this.computeMargin());
        this.computeHandles();
    }

    @Override
    public Point getLocation() {
        return new Point(this.boundsD_.x, this.boundsD_.y);
    }

    @Override
    public Rectangle getBounds() {
        return this.boundsD_;
    }

    @Override
    public String getId() {
        return this.dg_.getId();
    }

    @Override
    public void setId(String id) {
        this.dg_.setId(id);
    }

    public void setAxisHolderDB(AxisHolderDragBox x, AxisHolderDragBox y) {
        this.xAxDB_ = x;
        this.yAxDB_ = y;
    }

    public AxisHolderDragBox getXAxisHolderDB() {
        return this.xAxDB_;
    }

    public AxisHolderDragBox getYAxisHolderDB() {
        return this.yAxDB_;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update("DataGroupDragBox.stateChanged()");
    }
}

