/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.Axis;
import gov.noaa.pmel.sgt.AxisTransform;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.ContourLevelsAccess;
import gov.noaa.pmel.sgt.DataKey;
import gov.noaa.pmel.sgt.Graph;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.LatitudeAxis;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.LogAxis;
import gov.noaa.pmel.sgt.LogTransform;
import gov.noaa.pmel.sgt.LongitudeAxis;
import gov.noaa.pmel.sgt.PaneNotFoundException;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.TransformAccess;
import gov.noaa.pmel.sgt.beans.AxisHolder;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataHolder;
import gov.noaa.pmel.sgt.beans.DataTargetMismatchException;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.MapTransform;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.OrderedList;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTDomain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class DataGroupLayer
extends Layer {
    private OrderedList<Layer> dataLayers_ = new OrderedList();
    private DataGroup dg_ = null;
    private PanelHolder pHolder_ = null;
    private Panel panel_ = null;
    private SoTRange xRange_ = null;
    private SoTRange yRange_ = null;
    private boolean clipping_ = false;
    private SoTDomain clipDomain_ = null;
    private SoTRange xZoomRange_ = null;
    private SoTRange yZoomRange_ = null;
    private boolean inZoom_ = false;
    private SGLabel xLabel_ = null;
    private SGLabel yLabel_ = null;

    public DataGroupLayer() {
        this((Panel)null, (DataGroup)null);
    }

    public DataGroupLayer(Panel panel, DataGroup dg) {
        this.panel_ = panel;
        this.setPane(panel.getPane());
        this.pHolder_ = dg.getPanelHolder();
        this.setGraph(new CartesianGraph("Graph"));
        this.dg_ = dg;
        this.setId(this.dg_.getId());
        this.update();
    }

    public Panel getPanel() {
        return this.panel_;
    }

    public DataGroup getDataGroup() {
        return this.dg_;
    }

    public Iterator<Layer> getLayerIterator() {
        return this.dataLayers_.iterator();
    }

    public List<Layer> getLayerList() {
        return this.dataLayers_;
    }

    private String getNextLayerId(SGTData d) {
        if (d.getId() == null || d.getId().length() == 0) {
            if (d.getTitle() == null || d.getTitle().length() == 0) {
                int count = this.dataLayers_.size() + 1;
                return this.getId() + "_" + count;
            }
            return this.getId() + "_" + d.getTitle();
        }
        return this.getId() + "_" + d.getId();
    }

    public void removeData(DataHolder dh, DataKey key) {
        SGTData data = null;
        CartesianRenderer rend = null;
        Layer layer = null;
        for (int i = 0; i < this.dataLayers_.size(); ++i) {
            layer = this.dataLayers_.get(i);
            rend = ((CartesianGraph)layer.getGraph()).getRenderer();
            data = rend.getData();
            if (data != dh.getData()) continue;
            this.dataLayers_.remove(layer);
            rend.removeData();
            if (i != 0) break;
            this.setGraph(new CartesianGraph("Graph"));
            break;
        }
        if (key != null) {
            key.removeGraph(rend);
        }
        this.update();
    }

    public void addData(DataHolder dh, DataKey key) throws DataTargetMismatchException {
        this.addData(-1, dh, key);
    }

    public void addData(int pos, DataHolder dh, DataKey key) throws DataTargetMismatchException {
        this.add(false, pos, dh, key);
    }

    public void addDataOrdered(int key, DataHolder dh, DataKey dkey) throws DataTargetMismatchException {
        this.add(true, key, dh, dkey);
    }

    private void add(boolean ordered, int pos, DataHolder dh, DataKey key) throws DataTargetMismatchException {
        SGTData data = dh.getData();
        Attribute attr = dh.getAttribute();
        CartesianGraph graph = (CartesianGraph)this.getGraph();
        if (graph.getXTransform().isTime() != data.isXTime() || graph.getYTransform().isTime() != data.isYTime()) {
            JOptionPane.showMessageDialog(this, "Added data does not have the\nsame axis types as the DataGroup\n\nTime or Space axis does not match.", "DataGroup Error", 0);
            throw new DataTargetMismatchException("Data - Axis Mismatch");
        }
        CartesianRenderer rend = graph.getRenderer();
        if (rend == null) {
            this.xRange_ = data.getXRange();
            this.yRange_ = data.getYRange();
            graph.setData(data, attr);
            graph.setId(this.getNextLayerId(data));
            this.dataLayers_.addFirst(this);
            SGTMetaData xmeta = data.getXMetaData();
            StringBuffer label = xmeta == null ? new StringBuffer() : new StringBuffer(xmeta.getName());
            String units = data.getXMetaData().getUnits();
            if (units != null && units.length() > 0) {
                label.append(" (").append(units).append(")");
            }
            this.xLabel_ = new SGLabel("X Axis Label", label.toString(), new Point2D.Double(0.0, 0.0));
            SGTMetaData ymeta = data.getYMetaData();
            label = ymeta == null ? new StringBuffer() : new StringBuffer(ymeta.getName());
            units = data.getYMetaData().getUnits();
            if (units != null && units.length() > 0) {
                label.append(" (").append(units).append(")");
            }
            this.yLabel_ = new SGLabel("Y Axis Label", label.toString(), new Point2D.Double(0.0, 0.0));
        } else {
            this.xRange_.add(data.getXRange());
            this.yRange_.add(data.getYRange());
            Layer ly = new Layer(this.getNextLayerId(data));
            CartesianGraph cg = new CartesianGraph("Graph_" + ly.getId(), graph.getXTransform(), graph.getYTransform());
            ly.setPane(this.getPane());
            ly.setSizeP(this.getSizeP());
            ly.setBounds(this.getBounds());
            ly.setGraph(cg);
            cg.setData(data, attr);
            if (ordered) {
                this.dataLayers_.addOrdered(pos, ly);
            } else if (pos >= 0 && pos <= this.dataLayers_.size()) {
                this.dataLayers_.add(pos, ly);
            } else {
                this.dataLayers_.add(ly);
            }
            if (this.clipping_ && this.clipDomain_ != null) {
                cg.setClip(this.clipDomain_.getXRange(), this.clipDomain_.getYRange());
            }
            graph = cg;
        }
        if (this.dg_.isZAutoScale() && attr != null && attr instanceof GridAttribute) {
            Range2D zRange = ((SGTGrid)data).getZRange();
            ColorMap cmap = ((GridAttribute)attr).getColorMap();
            if (cmap instanceof TransformAccess) {
                ((TransformAccess)((Object)cmap)).setRange(zRange);
            } else if (cmap instanceof ContourLevelsAccess) {
                int levels = this.dg_.getNumberAutoContourLevels();
                Range2D newRange = Graph.computeRange(zRange, levels);
                ((ContourLevelsAccess)((Object)cmap)).setContourLevels(ContourLevels.getDefault(newRange));
            }
        }
        if (key != null) {
            rend = graph.getRenderer();
            SGLabel label = this.getLabel(data, key);
            key.addGraph(rend, label);
        }
        this.update();
    }

    private SGLabel getLabel(SGTData data, DataKey key) {
        SGLabel lineTitle = data.getKeyTitle();
        SGLabel zLabel = null;
        if (lineTitle == null) {
            SGTMetaData zMeta;
            if (data instanceof SGTGrid && (zMeta = ((SGTGrid)data).getZMetaData()) != null) {
                StringBuffer label = new StringBuffer(zMeta.getName());
                String units = zMeta.getUnits();
                if (units != null && units.length() > 0) {
                    label.append(" (").append(units).append(")");
                }
                zLabel = new SGLabel("Z Label", label.toString(), new Point2D.Double(0.0, 0.0));
            }
            lineTitle = zLabel == null ? this.xLabel_ : zLabel;
        }
        Legend lg = this.pHolder_.findLegend(key.getId());
        lineTitle.setHeightP(lg.getKeyLabelHeightP());
        return lineTitle;
    }

    public void update() {
        SoTRange range;
        Rectangle bnds = this.pHolder_.getBounds();
        double dpi = this.pHolder_.getPanelModel().getDpi();
        double width = (double)bnds.width / dpi;
        double height = (double)bnds.height / dpi;
        SoTRange xRange = null;
        SoTRange yRange = null;
        SoTPoint xOrig = null;
        SoTPoint yOrig = null;
        boolean batch = this.getPane().isBatch();
        this.getPane().setBatch(true);
        AxisHolder xAxHolder = this.dg_.getXAxisHolder();
        AxisHolder yAxHolder = this.dg_.getYAxisHolder();
        CartesianGraph gr = (CartesianGraph)this.getGraph();
        this.setSizeP(new Dimension2D(width, height));
        if (this.inZoom_) {
            xRange = this.xZoomRange_;
            yRange = this.yZoomRange_;
        } else {
            xRange = !xAxHolder.isAutoRange() || this.xRange_ == null ? xAxHolder.getUserRange() : this.xRange_;
            yRange = !yAxHolder.isAutoRange() || this.yRange_ == null ? yAxHolder.getUserRange() : this.yRange_;
        }
        this.updateTransform(0, xRange);
        this.updateTransform(1, yRange);
        Margin marg = this.dg_.getMargin();
        if (xAxHolder.getAxisPosition() == 4) {
            xOrig = new SoTPoint(gr.getXPtoSoT(xAxHolder.getAxisOriginP().x), gr.getYPtoSoT(xAxHolder.getAxisOriginP().y));
        } else {
            SoTValue yloc = null;
            range = null;
            range = yAxHolder.getAxisPosition() == 4 ? (gr.getYTransform().isTime() ? new SoTRange.Time(gr.getYPtoLongTime(marg.bottom), gr.getYPtoLongTime(marg.top)) : new SoTRange.Double(gr.getYPtoU(marg.bottom), gr.getYPtoU(marg.top))) : yRange;
            switch (xAxHolder.getAxisPosition()) {
                case 1: {
                    yloc = range.getStart();
                    break;
                }
                case 0: {
                    yloc = range.getEnd();
                }
            }
            xOrig = new SoTPoint(xRange.getStart(), yloc);
        }
        if (yAxHolder.getAxisPosition() == 4) {
            yOrig = new SoTPoint(gr.getXPtoSoT(yAxHolder.getAxisOriginP().x), gr.getYPtoSoT(yAxHolder.getAxisOriginP().y));
        } else {
            SoTValue xloc = null;
            range = null;
            range = xAxHolder.getAxisPosition() == 4 ? (gr.getXTransform().isTime() ? new SoTRange.Time(gr.getXPtoLongTime(marg.left), gr.getXPtoLongTime(marg.right)) : new SoTRange.Double(gr.getXPtoU(marg.left), gr.getXPtoU(marg.right))) : xRange;
            switch (yAxHolder.getAxisPosition()) {
                case 2: {
                    xloc = range.getStart();
                    break;
                }
                case 3: {
                    xloc = range.getEnd();
                }
            }
            yOrig = new SoTPoint(xloc, yRange.getStart());
        }
        this.updateAxis(0, xRange, xOrig, this.xLabel_);
        this.updateAxis(1, yRange, yOrig, this.yLabel_);
        this.getPane().setBatch(batch);
    }

    public void updateTransform(int dir, SoTRange range) {
        AxisTransform at;
        AxisHolder ah;
        CartesianGraph gr = (CartesianGraph)this.getGraph();
        if (dir == 0) {
            ah = this.dg_.getXAxisHolder();
            at = gr.getXTransform();
        } else {
            ah = this.dg_.getYAxisHolder();
            at = gr.getYTransform();
        }
        switch (ah.getTransformType()) {
            case 0: {
                if (at instanceof LinearTransform) {
                    at.setRangeU(range);
                    at.setRangeP(ah.getRangeP());
                    break;
                }
                at = new LinearTransform(ah.getRangeP(), range);
                if (dir == 0) {
                    gr.setXTransform(at);
                    break;
                }
                gr.setYTransform(at);
                break;
            }
            case 1: {
                if (at instanceof LogTransform) {
                    at.setRangeU(range);
                    at.setRangeP(ah.getRangeP());
                    break;
                }
                at = new LogTransform(ah.getRangeP(), range);
                if (dir == 0) {
                    gr.setXTransform(at);
                    break;
                }
                gr.setYTransform(at);
                break;
            }
            case 3: {
                if (gr.isMapTransform()) {
                    at.setRangeU(range);
                    at.setRangeP(ah.getRangeP());
                    break;
                }
                MapTransform mt = new MapTransform();
                gr.setMapTransform(mt);
                gr.setXTransform(mt.getXTransform());
                gr.setYTransform(mt.getYTransform());
                at = dir == 0 ? mt.getXTransform() : mt.getYTransform();
                at.setRangeU(range);
                at.setRangeP(ah.getRangeP());
                break;
            }
            case 2: {
                at = this.getReferenceTransform(0, ah.getTransformGroup());
                if (dir == 0) {
                    gr.setXTransform(at);
                    break;
                }
                gr.setYTransform(at);
            }
        }
    }

    public void updateAxis(int dir, SoTRange range, SoTPoint origin, SGLabel title) {
        AxisTransform at;
        AxisHolder ah;
        String axis;
        Axis ax = null;
        boolean newAxis = true;
        CartesianGraph gr = (CartesianGraph)this.getGraph();
        if (dir == 0) {
            axis = "X Axis";
            ah = this.dg_.getXAxisHolder();
            at = gr.getXTransform();
        } else {
            axis = "Y Axis";
            ah = this.dg_.getYAxisHolder();
            at = gr.getYTransform();
        }
        ax = gr.getXAxis(axis);
        newAxis = false;
        switch (ah.getAxisType()) {
            case 4: {
                PlainAxis pax = null;
                if (ax != null) {
                    if (ax instanceof PlainAxis) {
                        pax = (PlainAxis)ax;
                    } else {
                        pax = new PlainAxis(axis);
                        newAxis = true;
                    }
                } else {
                    pax = new PlainAxis(axis);
                    newAxis = true;
                }
                ax = pax;
                pax.setRangeP(ah.getRangeP());
                pax.setRangeU(range);
                pax.setLabelFormat(ah.getLabelFormat());
                pax.setLabelInterval(ah.getLabelInterval());
                pax.setSignificantDigits(ah.getLabelSignificantDigits());
                break;
            }
            case 3: {
                TimeAxis tax = null;
                if (ax != null) {
                    if (ax instanceof TimeAxis) {
                        tax = (TimeAxis)ax;
                    } else {
                        tax = new TimeAxis(axis, ah.getTimeAxisStyle());
                        newAxis = true;
                    }
                } else {
                    tax = new TimeAxis(axis, ah.getTimeAxisStyle());
                    newAxis = true;
                }
                ax = tax;
                tax.setRangeP(ah.getRangeP());
                tax.setRangeU(range);
                if (ah.getTimeAxisStyle() == 0) break;
                tax.setLabelFormat(ah.getMinorFormat(), ah.getMajorFormat());
                tax.setLabelInterval(ah.getMinorInterval(), ah.getMajorInterval());
                break;
            }
            case 1: {
                LogAxis lax = null;
                if (ax != null) {
                    if (ax instanceof LogAxis) {
                        lax = (LogAxis)ax;
                    } else {
                        lax = new LogAxis(axis);
                        newAxis = true;
                    }
                } else {
                    lax = new LogAxis(axis);
                    newAxis = true;
                }
                ax = lax;
                lax.setRangeP(ah.getRangeP());
                lax.setRangeU(range);
                lax.setLabelFormat(ah.getLabelFormat());
                lax.setLabelInterval(ah.getLabelInterval());
                lax.setSignificantDigits(ah.getLabelSignificantDigits());
                break;
            }
            case 6: 
            case 7: {
                LatitudeAxis latax = null;
                if (ax != null) {
                    if (ax instanceof LatitudeAxis) {
                        latax = (LatitudeAxis)ax;
                    } else {
                        latax = new LatitudeAxis(axis);
                        newAxis = true;
                    }
                } else {
                    latax = new LatitudeAxis(axis);
                    newAxis = true;
                }
                ax = latax;
                latax.setRangeP(ah.getRangeP());
                latax.setRangeU(range);
                latax.setLabelFormat(ah.getLabelFormat());
                latax.setLabelInterval(ah.getLabelInterval());
                latax.setSignificantDigits(ah.getLabelSignificantDigits());
                break;
            }
            case 5: 
            case 8: {
                LongitudeAxis lonax = null;
                if (ax != null) {
                    if (ax instanceof LongitudeAxis) {
                        lonax = (LongitudeAxis)ax;
                    } else {
                        lonax = new LongitudeAxis(axis);
                        newAxis = true;
                    }
                } else {
                    lonax = new LongitudeAxis(axis);
                    newAxis = true;
                }
                ax = lonax;
                lonax.setRangeP(ah.getRangeP());
                lonax.setRangeU(range);
                lonax.setLabelFormat(ah.getLabelFormat());
                lonax.setLabelInterval(ah.getLabelInterval());
                lonax.setSignificantDigits(ah.getLabelSignificantDigits());
            }
        }
        if (dir == 0) {
            ax.setOrientation(0);
        } else {
            ax.setOrientation(1);
        }
        ax.setLocationU(origin);
        ax.setLineColor(ah.getAxisColor());
        ax.setTicPosition(ah.getTicPosition());
        ax.setLabelColor(ah.getLabelColor());
        ax.setLabelFont(ah.getLabelFont());
        ax.setLabelHeightP(ah.getLabelHeightP());
        ax.setLargeTicHeightP(ah.getLargeTicHeightP());
        ax.setNumberSmallTics(ah.getNumSmallTics());
        ax.setSmallTicHeightP(ah.getSmallTicHeightP());
        ax.setThickTicWidthP(ah.getThickTicWidth());
        ax.setLabelPosition(ah.getLabelPosition());
        ax.setVerticalLabelOrientation(ah.getVerticalLabelOrientation());
        ax.setVisible(ah.isVisible());
        ax.setSelectable(ah.isSelectable());
        if (title != null && ah.isTitleAuto()) {
            SGLabel def = ah.getTitle();
            title.setColor(def.getColor());
            title.setFont(def.getFont());
            title.setHeightP(def.getHeightP());
            title.setVisible(def.isVisible());
            ax.setTitle(title);
        } else {
            ax.setTitle(ah.getTitle());
        }
        ax.register(at);
        if (dir == 0) {
            if (gr.getNumberXAxis() > 0 && newAxis) {
                gr.removeAllXAxes();
            }
            if (newAxis) {
                gr.addXAxis(ax);
            }
        } else {
            if (gr.getNumberYAxis() > 0 && newAxis) {
                gr.removeAllYAxes();
            }
            if (newAxis) {
                gr.addYAxis(ax);
            }
        }
        if (ax instanceof LongitudeAxis) {
            ((LongitudeAxis)ax).setLongitude360(ah.isLongitude360());
            ((LongitudeAxis)ax).setLabelQuadrant(ah.isLabelQuadrant());
        }
        if (ax instanceof LatitudeAxis) {
            ((LatitudeAxis)ax).setLabelQuadrant(ah.isLabelQuadrant());
        }
    }

    @Override
    public void draw(Graphics g) throws PaneNotFoundException {
        super.draw(g);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).draw(g);
        }
    }

    @Override
    public void drawDynamicData(Graphics g) throws PaneNotFoundException {
        super.drawDynamicData(g);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).drawDynamicData(g);
        }
    }

    @Override
    public void drawDraggableItems(Graphics g) throws PaneNotFoundException {
        super.drawDraggableItems(g);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).drawDraggableItems(g);
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setBounds(x, y, w, h);
        }
    }

    @Override
    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setBounds(rect);
        }
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setLocation(x, y);
        }
    }

    @Override
    public void setLocation(Point pt) {
        super.setLocation(pt);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setLocation(pt);
        }
    }

    @Override
    public void setSize(Dimension size) {
        super.setSize(size);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setSize(size);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setSize(w, h);
        }
    }

    @Override
    public void setSizeP(Dimension2D size) {
        super.setSizeP(size);
        for (int i = 1; i < this.dataLayers_.size(); ++i) {
            this.dataLayers_.get(i).setSizeP(size);
        }
    }

    private AxisTransform getReferenceTransform(int dir, String datagroup) {
        String dgLast = datagroup;
        boolean stillLooking = true;
        int tType = -1;
        String newDG = null;
        while (stillLooking) {
            DataGroup dg = this.pHolder_.findDataGroup(dgLast);
            tType = dir == 0 ? dg.getXAxisHolder().getTransformType() : dg.getYAxisHolder().getTransformType();
            if (tType != 2) {
                CartesianGraph graph = null;
                DataGroupLayer dgl = null;
                if (dir == 0) {
                    dgl = this.panel_.findDataGroupLayer(dg.getXAxisHolder().getTransformGroup());
                    graph = (CartesianGraph)dgl.getGraph();
                    if (graph == null) {
                        return null;
                    }
                    return graph.getXTransform();
                }
                dgl = this.panel_.findDataGroupLayer(dg.getYAxisHolder().getTransformGroup());
                graph = (CartesianGraph)dgl.getGraph();
                if (graph == null) {
                    return null;
                }
                return graph.getYTransform();
            }
            newDG = dir == 0 ? dg.getXAxisHolder().getTransformGroup() : dg.getYAxisHolder().getTransformGroup();
            dgLast = newDG;
        }
        return null;
    }

    public void setClipping(boolean clip) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        this.clipping_ = clip;
        this.setAllClipping(this.clipping_);
    }

    void zoomTo(Point start, Rectangle rect) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        CartesianGraph graph = (CartesianGraph)this.getGraph();
        Rectangle bnds = this.panel_.getBounds();
        if (!bnds.contains(start)) {
            return;
        }
        this.setClipping(true);
        double xStartP = this.getXDtoP(rect.x);
        double yStartP = this.getYDtoP(rect.y + rect.height);
        double xEndP = this.getXDtoP(rect.x + rect.width);
        double yEndP = this.getYDtoP(rect.y);
        SoTRange xRangeU = null;
        SoTRange yRangeU = null;
        xRangeU = graph.getXTransform().isTime() ? new SoTRange.Time(graph.getXPtoLongTime(xStartP), graph.getXPtoLongTime(xEndP)) : new SoTRange.Double(graph.getXPtoU(xStartP), graph.getXPtoU(xEndP));
        yRangeU = graph.getYTransform().isTime() ? new SoTRange.Time(graph.getYPtoLongTime(yStartP), graph.getYPtoLongTime(yEndP)) : new SoTRange.Double(graph.getYPtoU(yStartP), graph.getYPtoU(yEndP));
        this.inZoom_ = true;
        this.setDomain(new SoTDomain(xRangeU, yRangeU));
    }

    void resetZoom(int x, int y) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        Rectangle bnds = ((CartesianGraph)this.getGraph()).getBounds();
        if (!bnds.contains(x, y)) {
            return;
        }
        this.inZoom_ = false;
        this.xZoomRange_ = null;
        this.yZoomRange_ = null;
        this.setClipping(false);
        this.update();
    }

    public void resetZoom() {
        this.inZoom_ = false;
        this.xZoomRange_ = null;
        this.yZoomRange_ = null;
        this.setClipping(false);
        this.update();
    }

    public void zoomTo(SoTDomain domain) {
        if (!this.dg_.isZoomable()) {
            return;
        }
        this.setClipping(true);
        this.inZoom_ = true;
        this.setDomain(domain);
    }

    public boolean isInZoom() {
        return this.inZoom_;
    }

    public void setInZoom(boolean zoom) {
        this.inZoom_ = zoom;
    }

    public void setDomain(SoTDomain domain) {
        this.setXRange(domain.getXRange(), domain.isXReversed());
        this.setYRange(domain.getYRange(), domain.isYReversed());
        if (this.clipping_) {
            this.clipDomain_ = domain;
            this.setAllClip(domain);
        } else {
            this.clipDomain_ = null;
            this.setAllClipping(false);
        }
        this.update();
    }

    private void setXRange(SoTRange range, boolean reversed) {
        this.xZoomRange_ = range.copy();
    }

    private void setYRange(SoTRange range, boolean reversed) {
        this.yZoomRange_ = range.copy();
    }

    private void setAllClip(SoTDomain domain) {
        for (Layer obj : this.dataLayers_) {
            if (!(obj instanceof Layer)) continue;
            Layer ly = obj;
            ((CartesianGraph)ly.getGraph()).setClip(domain.getXRange(), domain.getYRange());
        }
    }

    private void setAllClipping(boolean clip) {
        for (Layer obj : this.dataLayers_) {
            if (!(obj instanceof Layer)) continue;
            Layer ly = obj;
            ((CartesianGraph)ly.getGraph()).setClipping(clip);
        }
    }

    public SGLabel getYLabel() {
        return this.yLabel_;
    }

    public SGLabel getXLabel() {
        return this.xLabel_;
    }
}

