/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.util.SoTRange;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DataGroupPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private String[] pNames_ = new String[]{"Id", "Margin", "Zoomable", "Z AutoScale", "Z Auto Levels", "Z User Range"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private DataGroup dataGroup_ = null;
    private boolean suppressEvent_ = false;
    private int zAutoScale;
    private int zUserRange;
    private int zAutoLevels;

    public DataGroupPropertyPanel(DataGroup dg, boolean expert) {
        this.dataGroup_ = dg;
        this.dataGroup_.addChangeListener(this);
        this.expert_ = expert;
        this.create();
    }

    public void setDataGroup(DataGroup dg, boolean expert) {
        if (this.dataGroup_ != null) {
            this.dataGroup_.removeChangeListener(this);
        }
        this.dataGroup_ = dg;
        this.dataGroup_.addChangeListener(this);
        this.expert_ = expert;
        this.reset();
    }

    @Override
    void update() {
        int i = -1;
        this.suppressEvent_ = true;
        ((JTextField)this.comps_[++i]).setText(this.dataGroup_.getId());
        ((JLabel)this.comps_[++i]).setText(this.dataGroup_.getMargin().toString());
        ((JCheckBox)this.comps_[++i]).setSelected(this.dataGroup_.isZoomable());
        ((JCheckBox)this.comps_[++i]).setSelected(this.dataGroup_.isZAutoScale());
        ((JTextField)this.comps_[++i]).setText(this.format(this.dataGroup_.getNumberAutoContourLevels()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.dataGroup_.getZRangeU(), false));
        this.setFieldsEnabled();
        this.suppressEvent_ = false;
    }

    @Override
    void create() {
        int i = -1;
        String string = this.pNames_[++i];
        this.comps_[i] = this.createTextField(this.dataGroup_.getId(), string, this, !this.dataGroup_.isInstantiated());
        this.comps_[++i] = this.createLabel(this.dataGroup_.getMargin().toString());
        this.comps_[++i] = this.createCheckBox(this.dataGroup_.isZoomable(), this.pNames_[i], this);
        this.comps_[++i] = this.createCheckBox(this.dataGroup_.isZAutoScale(), this.pNames_[i], this);
        this.zAutoScale = i++;
        this.comps_[i] = this.createTextField(this.format(this.dataGroup_.getNumberAutoContourLevels()), this.pNames_[i], this, true);
        this.zAutoLevels = i++;
        this.comps_[i] = this.createTextField(this.format(this.dataGroup_.getZRangeU(), false), this.pNames_[i], this, true);
        this.zUserRange = i;
        this.setFieldsEnabled();
        for (i = 0; i < this.comps_.length; ++i) {
            this.addProperty(i + 1, this.pNames_[i], this.comps_[i], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    @Override
    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    private void setFieldsEnabled() {
        ((JTextField)this.comps_[this.zUserRange]).setEnabled(!((JCheckBox)this.comps_[this.zAutoScale]).isSelected());
        ((JTextField)this.comps_[this.zAutoLevels]).setEnabled(((JCheckBox)this.comps_[this.zAutoScale]).isSelected());
    }

    private void processEvent(Object obj, String command) {
        SoTRange range = null;
        if (command.equals("Id")) {
            String oldId = this.dataGroup_.getId();
            this.dataGroup_.getPanelHolder().getDataGroups().remove(oldId);
            this.dataGroup_.setId(((JTextField)obj).getText());
            this.dataGroup_.getPanelHolder().getDataGroups().put(this.dataGroup_.getId(), this.dataGroup_);
        } else if (command.equals("Zoomable")) {
            this.dataGroup_.setZoomable(((JCheckBox)obj).isSelected());
        } else if (command.equals("Z AutoScale")) {
            this.dataGroup_.setZAutoScale(((JCheckBox)obj).isSelected());
        } else if (command.equals("Z Auto Levels")) {
            this.dataGroup_.setNumberAutoContourLevels(Integer.parseInt(((JTextField)obj).getText()));
        } else if (command.equals("Z User Range") && (range = this.parseRange(((JTextField)obj).getText(), false)) != null) {
            this.dataGroup_.setZRangeU(range);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.suppressEvent_) {
            return;
        }
        Object obj = e.getSource();
        String command = e.getActionCommand();
        this.processEvent(obj, command);
        this.setFieldsEnabled();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            JTextField tf = (JTextField)obj;
            String name = tf.getName();
            this.processEvent(obj, name);
        }
    }

    @Override
    public void setExpert(boolean expert) {
        boolean save = this.expert_;
        this.expert_ = expert;
        if (this.expert_ != save) {
            this.reset();
        }
    }

    @Override
    public boolean isExpert() {
        return this.expert_;
    }
}

