/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataHolder;
import gov.noaa.pmel.sgt.beans.DataOperation;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.util.OrderedList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DataModel {
    private PropertyChangeSupport support_ = new PropertyChangeSupport(this);
    private OrderedList<DataHolder> dataList_;
    private Page page;
    private transient boolean batch = false;
    private transient boolean modified = false;
    private transient List events = new Vector();

    public DataModel() {
        this.dataList_ = new OrderedList();
    }

    public DataHolder addData(SGTData data, Attribute attr, PanelHolder pHolder, DataGroup dataGroup, Legend legend) {
        DataHolder dh = new DataHolder(this, data, attr, pHolder, dataGroup, legend);
        this.dataList_.add(dh);
        this.firePropertyChange("addData", null, new DataOperation(dh, 0));
        return dh;
    }

    public DataHolder addDataOrdered(int key, SGTData data, Attribute attr, PanelHolder pHolder, DataGroup dataGroup, Legend legend) {
        DataHolder dh = new DataHolder(this, data, attr, pHolder, dataGroup, legend);
        this.dataList_.addOrdered(key, dh);
        this.firePropertyChange("addDataOrderedAt", null, new DataOperation(dh, 3, key));
        return dh;
    }

    public DataHolder addData(int pos, SGTData data, Attribute attr, PanelHolder pHolder, DataGroup dataGroup, Legend legend) {
        DataHolder dh = new DataHolder(this, data, attr, pHolder, dataGroup, legend);
        this.dataList_.add(pos, dh);
        this.firePropertyChange("addDataAt", null, new DataOperation(dh, 2, pos));
        return dh;
    }

    public boolean removeData(DataHolder dh) {
        boolean result = this.dataList_.remove(dh);
        this.firePropertyChange("removeData", null, new DataOperation(dh, 1));
        return result;
    }

    public void removeAllData() {
        Vector<DataHolder> saved = new Vector<DataHolder>(this.dataList_);
        this.dataList_.clear();
        this.firePropertyChange("removeAllData", null, saved);
    }

    public Iterator dataIterator() {
        return this.dataList_.iterator();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support_.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.support_.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support_.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.support_.removePropertyChangeListener(name, l);
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public Page getPage() {
        return this.page;
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.batch) {
            this.modified = true;
            this.events.add(new PropertyChangeEvent(this, name, oldValue, newValue));
        } else {
            this.support_.firePropertyChange(name, oldValue, newValue);
        }
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
        if (!this.batch && this.modified) {
            this.modified = false;
            for (int i = 0; i < this.events.size(); ++i) {
                this.support_.firePropertyChange((PropertyChangeEvent)this.events.get(i));
            }
            this.events.clear();
        }
    }

    public OrderedList<DataHolder> getOrderedList() {
        return this.dataList_;
    }

    public String toString() {
        return "DataModel " + this.dataList_.toString();
    }
}

