/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.AxisHolderDragBox;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataGroupDragBox;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.LabelDragBox;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.LegendDragBox;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelHolderDragBox;
import gov.noaa.pmel.sgt.beans.PanelModel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DesignPanel
extends JComponent
implements MouseListener,
MouseMotionListener,
ChangeListener,
DesignListener,
PropertyChangeListener {
    public static final int ALIGN_TOP = 0;
    public static final int ALIGN_BOTTOM = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int JUSTIFY_VERTICAL = 4;
    public static final int JUSTIFY_HORIZONTAL = 5;
    private Map pDragBoxes_ = new HashMap();
    private Vector selectedBoxes_ = new Vector();
    private boolean inMove_ = false;
    private DragBox dragBox_ = null;
    private int dragState_ = -1;
    private Point move_ref_ = null;
    private PanelModel model_ = null;
    private Dimension size = new Dimension(100, 100);
    private int selectCount_ = 0;
    private Point firstSelectedPoint_ = new Point(-1, -1);
    private DragBox[] selectList_ = null;
    private static int SELECT_DISTANCE = 2;

    public DesignPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DesignPanel(PanelModel model) {
        this();
        this.setPanelModel(model);
    }

    void jbInit() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.size;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.size;
    }

    public Dimension getWorkSize() {
        return this.size;
    }

    public void setPanelModel(PanelModel model) {
        this.pDragBoxes_.clear();
        this.selectedBoxes_.clear();
        if (model != null) {
            model.removeChangeListener(this);
        }
        this.model_ = model;
        if (this.model_ == null) {
            return;
        }
        this.model_.addChangeListener(this);
        Page pg = this.model_.getPage();
        if (pg == null) {
            this.size = this.model_.getPageSize();
            System.out.println("No page found!: size = " + this.size);
            this.setSize(this.size);
        } else {
            this.size = pg.getSize();
            this.setSize(this.size);
        }
        Iterator iter = this.model_.panelIterator();
        while (iter.hasNext()) {
            PanelHolder ph = (PanelHolder)iter.next();
            ph.addChangeListener(this);
            PanelHolderDragBox pdb = new PanelHolderDragBox(ph);
            this.pDragBoxes_.put(ph, pdb);
        }
        this.repaint();
    }

    public PanelModel getPanelModel() {
        return this.model_;
    }

    public void addPanel(PanelHolderDragBox panel) {
        panel.getPanelHolder().addChangeListener(this);
        this.pDragBoxes_.put(panel.getPanelHolder(), panel);
    }

    public void addDataGroup(DataGroup dg) {
        PanelHolder ph = this.getSelectedPanel();
        if (ph == null) {
            return;
        }
        PanelHolderDragBox pdb = (PanelHolderDragBox)this.pDragBoxes_.get(ph);
        if (pdb == null) {
            return;
        }
        if (ph.getDataGroupSize() >= 1) {
            dg.getXAxisHolder().setAxisPosition(0);
            dg.getYAxisHolder().setAxisPosition(3);
        }
        pdb.addDragBox(dg);
        ph.addDataGroup(dg);
    }

    public void addLabel(Label label) {
        PanelHolder ph = this.getSelectedPanel();
        if (ph == null) {
            return;
        }
        PanelHolderDragBox pdb = (PanelHolderDragBox)this.pDragBoxes_.get(ph);
        if (pdb == null) {
            return;
        }
        pdb.addDragBox(label);
        ph.addLabel(label);
    }

    public void addLegend(Legend legend) {
        PanelHolder ph = this.getSelectedPanel();
        if (ph == null) {
            return;
        }
        PanelHolderDragBox pdb = (PanelHolderDragBox)this.pDragBoxes_.get(ph);
        pdb.addDragBox(legend);
        ph.addLegend(legend);
    }

    public void alignBoxes(int mode) {
        int count = this.getSelectedCount();
        if (count < 0) {
            return;
        }
        PanelHolderDragBox box = (PanelHolderDragBox)this.selectedBoxes_.firstElement();
        Rectangle bounds = box.getBounds();
        switch (mode) {
            case 0: {
                if (count <= 1) {
                    return;
                }
                int y = bounds.y;
                for (int i = 1; i < count; ++i) {
                    PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    pdb.setLocation(pdb.getLocation().x, y);
                }
                break;
            }
            case 1: {
                if (count <= 1) {
                    return;
                }
                int y2 = bounds.y + bounds.height;
                for (int i = 1; i < count; ++i) {
                    PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    int y = y2 - pdb.getBounds().height;
                    pdb.setLocation(pdb.getLocation().x, y);
                }
                break;
            }
            case 2: {
                if (count <= 1) {
                    return;
                }
                int x = bounds.x;
                for (int i = 1; i < count; ++i) {
                    PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    pdb.setLocation(x, pdb.getLocation().y);
                }
                break;
            }
            case 3: {
                if (count <= 1) {
                    return;
                }
                int x2 = bounds.x + bounds.width;
                for (int i = 1; i < count; ++i) {
                    PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                    int x = x2 - pdb.getBounds().width;
                    pdb.setLocation(x, pdb.getLocation().y);
                }
                break;
            }
            case 4: {
                if (count >= 2) {
                    for (int i = 1; i < count; ++i) {
                        PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                        Rectangle bnds = pdb.getBounds();
                        bnds.y = bounds.y;
                        bnds.height = bounds.height;
                        pdb.setBounds(bnds);
                    }
                    break;
                }
                Dimension sze = this.getWorkSize();
                bounds.y = 0;
                bounds.height = sze.height;
                box.setBounds(bounds);
                break;
            }
            case 5: {
                if (count >= 2) {
                    for (int i = 1; i < count; ++i) {
                        PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.elementAt(i);
                        Rectangle bnds = pdb.getBounds();
                        bnds.x = bounds.x;
                        bnds.width = bounds.width;
                        pdb.setBounds(bnds);
                    }
                    break;
                }
                Dimension sze = this.getWorkSize();
                bounds.x = 0;
                bounds.width = sze.width;
                box.setBounds(bounds);
            }
        }
        this.repaint();
    }

    public void removeSelected() {
        if (this.selectedBoxes_.size() == 1) {
            PanelHolder ph;
            PanelHolderDragBox pdb = (PanelHolderDragBox)this.selectedBoxes_.firstElement();
            pdb.getPanelHolder().removeAllChangeListeners();
            DragBox[] dbArray = pdb.getDragBoxArray();
            for (int i = 0; i < dbArray.length; ++i) {
                ph = pdb.getPanelHolder();
                if (dbArray[i] instanceof DataGroupDragBox) {
                    DataGroup ag = ((DataGroupDragBox)dbArray[i]).getDataGroup();
                    ph.removeDataGroup(ag);
                    pdb.removeDragBox((DataGroupDragBox)dbArray[i]);
                    continue;
                }
                if (dbArray[i] instanceof LegendDragBox) {
                    Legend legend = ((LegendDragBox)dbArray[i]).getLegend();
                    ph.removeLegend(legend);
                    pdb.removeDragBox((LegendDragBox)dbArray[i]);
                    continue;
                }
                if (!(dbArray[i] instanceof LabelDragBox)) continue;
                Label label = ((LabelDragBox)dbArray[i]).getLabel();
                ph.removeLabel(label);
                pdb.removeDragBox((LabelDragBox)dbArray[i]);
            }
            ph = pdb.getPanelHolder();
            this.pDragBoxes_.remove(ph);
            this.model_.removePanel(ph);
            ph.removeAllChangeListeners();
        } else {
            block1: for (PanelHolderDragBox pdb : this.pDragBoxes_.values()) {
                Iterator dbIter = pdb.getDragBoxIterator();
                while (dbIter.hasNext()) {
                    DragBox db = (DragBox)dbIter.next();
                    if (!db.isSelected()) continue;
                    PanelHolder ph = pdb.getPanelHolder();
                    if (db instanceof DataGroupDragBox) {
                        DataGroup ag = ((DataGroupDragBox)db).getDataGroup();
                        ph.removeDataGroup(ag);
                        pdb.removeDragBox((DataGroupDragBox)db);
                        continue block1;
                    }
                    if (db instanceof LegendDragBox) {
                        Legend legend = ((LegendDragBox)db).getLegend();
                        ph.removeLegend(legend);
                        pdb.removeDragBox((LegendDragBox)db);
                        continue block1;
                    }
                    if (!(db instanceof LabelDragBox)) continue block1;
                    Label label = ((LabelDragBox)db).getLabel();
                    ph.removeLabel(label);
                    pdb.removeDragBox((LabelDragBox)db);
                    continue block1;
                }
            }
        }
        this.repaint();
    }

    boolean isAxisHolderDragBoxSelected() {
        for (PanelHolderDragBox pdb : this.pDragBoxes_.values()) {
            Iterator dbIter = pdb.getDragBoxIterator();
            while (dbIter.hasNext()) {
                DragBox db = (DragBox)dbIter.next();
                if (!db.isSelected() || !(db instanceof AxisHolderDragBox)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isChildDragBoxSelected() {
        for (PanelHolderDragBox pdb : this.pDragBoxes_.values()) {
            Iterator dbIter = pdb.getDragBoxIterator();
            while (dbIter.hasNext()) {
                DragBox db = (DragBox)dbIter.next();
                if (!db.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    int getSelectedCount() {
        return this.selectedBoxes_.size();
    }

    PanelHolder getSelectedPanel() {
        if (this.selectedBoxes_.size() != 1) {
            return null;
        }
        return ((PanelHolderDragBox)this.selectedBoxes_.firstElement()).getPanelHolder();
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.model_.getPageBackgroundColor());
        g.fillRect(0, 0, this.size.width, this.size.height);
        Iterator iter = this.pDragBoxes_.values().iterator();
        while (iter.hasNext()) {
            ((PanelHolderDragBox)iter.next()).draw(g);
        }
    }

    void clearAllSelections() {
        for (PanelHolderDragBox pdb : this.pDragBoxes_.values()) {
            pdb.setSelected(false);
            Iterator dbIter = pdb.getDragBoxIterator();
            while (dbIter.hasNext()) {
                ((DragBox)dbIter.next()).setSelected(false);
            }
        }
    }

    private DragBox[] dragBoxesThatContain(Point pt) {
        Vector<DragBox> boxes = new Vector<DragBox>(4);
        for (PanelHolderDragBox pDragBox : this.pDragBoxes_.values()) {
            if (!pDragBox.contains(pt)) continue;
            Iterator dbIter = pDragBox.getDragBoxIterator();
            while (dbIter.hasNext()) {
                DragBox db = (DragBox)dbIter.next();
                if (!db.contains(pt)) continue;
                boxes.add(db);
            }
            boxes.add(pDragBox);
        }
        return boxes.toArray(new DragBox[boxes.size()]);
    }

    private void resetSelect() {
        this.selectList_ = null;
        this.selectCount_ = 0;
        this.firstSelectedPoint_.setLocation(-1, -1);
    }

    private boolean newSelectPoint(Point pt) {
        int dx = Math.abs(pt.x - this.firstSelectedPoint_.x);
        int dy = Math.abs(pt.y - this.firstSelectedPoint_.y);
        return dx > SELECT_DISTANCE || dy > SELECT_DISTANCE;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        boolean shiftctrl;
        DragBox dragBox = null;
        int mods = e.getModifiers();
        Point pt = e.getPoint();
        boolean bl = shiftctrl = (mods & 2) != 0 || (mods & 1) != 0;
        if (this.selectList_ == null || this.newSelectPoint(pt)) {
            this.selectList_ = this.dragBoxesThatContain(pt);
            if (this.selectList_.length <= 0) {
                this.resetSelect();
                this.clearAllSelections();
                this.selectedBoxes_.removeAllElements();
                this.repaint();
                this.firePropertyChange("allUnselected", null, null);
                this.inMove_ = false;
                this.dragState_ = -1;
                return;
            }
            this.selectCount_ = 0;
            this.firstSelectedPoint_.setLocation(pt);
            dragBox = this.selectList_[this.selectCount_];
        } else {
            ++this.selectCount_;
            if (this.selectCount_ >= this.selectList_.length) {
                this.selectCount_ = 0;
            }
            dragBox = this.selectList_[this.selectCount_];
        }
        if (dragBox instanceof PanelHolderDragBox) {
            if (!shiftctrl && !dragBox.isSelected()) {
                this.clearAllSelections();
                this.selectedBoxes_.removeAllElements();
            }
            dragBox.setSelected(!dragBox.isSelected());
            if (dragBox.isSelected()) {
                this.selectedBoxes_.add(dragBox);
            } else {
                this.selectedBoxes_.remove(dragBox);
            }
            this.repaint();
            this.firePropertyChange("panelSelected", null, dragBox);
            return;
        }
        this.clearAllSelections();
        this.selectedBoxes_.removeAllElements();
        dragBox.setSelected(true);
        this.repaint();
        if (dragBox instanceof DataGroupDragBox) {
            this.firePropertyChange("dataGroupSelected", null, dragBox);
        } else if (dragBox instanceof AxisHolderDragBox) {
            this.firePropertyChange("axisSelected", null, dragBox);
        } else if (dragBox instanceof LabelDragBox) {
            this.firePropertyChange("labelSelected", null, dragBox);
        } else if (dragBox instanceof LegendDragBox) {
            this.firePropertyChange("legendSelected", null, dragBox);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        PanelHolderDragBox pDragBox2 = null;
        DragBox db = null;
        this.dragState_ = -1;
        block0: for (PanelHolderDragBox pDragBox2 : this.pDragBoxes_.values()) {
            if (pDragBox2.isSelected() && pDragBox2.handlesContain(e.getPoint())) {
                this.dragBox_ = pDragBox2;
                this.dragState_ = this.dragBox_.getSelectedHandle();
                this.inMove_ = true;
                this.move_ref_ = new Point(e.getX(), e.getY());
                break;
            }
            Iterator dbIter = pDragBox2.getDragBoxIterator();
            while (dbIter.hasNext()) {
                db = (DragBox)dbIter.next();
                if (!db.isSelected() || !db.handlesContain(e.getPoint())) continue;
                this.dragBox_ = db;
                this.dragState_ = this.dragBox_.getSelectedHandle();
                this.inMove_ = true;
                this.move_ref_ = new Point(e.getX(), e.getY());
                continue block0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.inMove_ = false;
        this.dragState_ = -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.resetSelect();
        int x = e.getX();
        int y = e.getY();
        if (this.inMove_) {
            int dx = x - this.move_ref_.x;
            int dy = y - this.move_ref_.y;
            this.dragBox_.mouseOperation(this.dragState_, dx, dy);
            this.repaint();
            this.move_ref_ = new Point(x, y);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.size = this.model_.getPageSize();
        this.repaint();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + '@' + Integer.toHexString(this.hashCode());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("pageSize")) {
            this.size = this.model_.getPageSize();
            this.setSize(this.size);
            this.repaint();
        }
    }
}

