/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

abstract class DragBox
implements DesignListener {
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_LEFT = 2;
    public static final int LOWER_RIGHT = 3;
    public static final int CENTER = 4;
    protected static int handleSize_ = 8;
    protected Rectangle[] handles_ = new Rectangle[5];
    protected int selectedHandle_ = -1;
    protected boolean selected_ = false;
    protected Color selectedColor_ = Color.red;
    protected Color unSelectedColor_;
    protected Color color_ = this.unSelectedColor_ = Color.darkGray;
    protected PanelHolder pHolder_;

    public DragBox(PanelHolder ph) {
        this.pHolder_ = ph;
    }

    public void setSelected(boolean sel) {
        this.selected_ = sel;
        this.color_ = this.selected_ ? this.selectedColor_ : this.unSelectedColor_;
    }

    public boolean isSelected() {
        return this.selected_;
    }

    public boolean handlesContain(Point pt) {
        for (int i = 0; i < this.handles_.length; ++i) {
            if (!this.handles_[i].contains(pt)) continue;
            this.selectedHandle_ = i;
            return true;
        }
        this.selectedHandle_ = -1;
        return false;
    }

    protected void computeHandles() {
        Rectangle bounds = this.getBounds();
        this.handles_[0].setBounds(bounds.x, bounds.y, handleSize_, handleSize_);
        this.handles_[1].setBounds(bounds.x + bounds.width - handleSize_, bounds.y, handleSize_, handleSize_);
        this.handles_[2].setBounds(bounds.x, bounds.y + bounds.height - handleSize_, handleSize_, handleSize_);
        this.handles_[3].setBounds(bounds.x + bounds.width - handleSize_, bounds.y + bounds.height - handleSize_, handleSize_, handleSize_);
        this.handles_[4].setBounds(bounds.x + (bounds.width - handleSize_) / 2, bounds.y + (bounds.height - handleSize_) / 2, handleSize_, handleSize_);
    }

    public void mouseOperation(int op, int dx, int dy) {
        if (op == -1) {
            return;
        }
        if (op == 4) {
            Point pt = this.getLocation();
            pt.x += dx;
            pt.y += dy;
            this.setLocation(pt);
        } else {
            Rectangle rect = this.getBounds();
            int x2 = rect.x + rect.width;
            int y2 = rect.y + rect.height;
            switch (op) {
                case 0: {
                    rect.x += dx;
                    rect.y += dy;
                    break;
                }
                case 1: {
                    x2 += dx;
                    rect.y += dy;
                    break;
                }
                case 2: {
                    rect.x += dx;
                    y2 += dy;
                    break;
                }
                case 3: {
                    x2 += dx;
                    y2 += dy;
                }
            }
            rect.width = x2 - rect.x;
            rect.height = y2 - rect.y;
            this.setBounds(rect);
        }
    }

    public boolean contains(Point pt) {
        return this.getBounds().contains(pt);
    }

    public int getSelectedHandle() {
        return this.selectedHandle_;
    }

    Point2D.Double toLocation(Point pd) {
        return new Point2D.Double(this.toXLocation(pd.x), this.toYLocation(pd.y));
    }

    Point toLocation(Point2D.Double pp) {
        return new Point(this.toXLocation(pp.x), this.toYLocation(pp.y));
    }

    Rectangle2D.Double toRectangle(Rectangle rd) {
        return new Rectangle2D.Double(this.toXLocation(rd.x), this.toYLocation(rd.y + rd.height), this.transform(rd.width), this.transform(rd.height));
    }

    Rectangle toRectangle(Rectangle2D.Double rp) {
        int h = this.transform(rp.height);
        return new Rectangle(this.toXLocation(rp.x), this.toYLocation(rp.y) - h, this.transform(rp.width), h);
    }

    double toXLocation(int xd) {
        return (float)(xd - this.pHolder_.getBounds().x) / this.pHolder_.getPanelModel().getDpi();
    }

    double toYLocation(int yd) {
        return (float)(this.pHolder_.getBounds().height - yd + this.pHolder_.getBounds().y) / this.pHolder_.getPanelModel().getDpi();
    }

    int toXLocation(double xp) {
        return (int)(xp * (double)this.pHolder_.getPanelModel().getDpi() + 0.5) + this.pHolder_.getBounds().x;
    }

    int toYLocation(double yp) {
        return this.pHolder_.getBounds().height - (int)(yp * (double)this.pHolder_.getPanelModel().getDpi() + 0.5) + this.pHolder_.getBounds().y;
    }

    double transform(int dev) {
        return (float)dev / this.pHolder_.getPanelModel().getDpi();
    }

    int transform(double phy) {
        return (int)(phy * (double)this.pHolder_.getPanelModel().getDpi() + 0.5);
    }

    public abstract void draw(Graphics var1);

    public abstract void update(String var1);

    public abstract void setId(String var1);

    public abstract String getId();

    public abstract void setBounds(Rectangle var1);

    public abstract Rectangle getBounds();

    public abstract void setLocation(Point var1);

    public abstract Point getLocation();
}

