/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DragBox;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LegendDragBox
extends DragBox
implements ChangeListener {
    private Legend legend_ = null;
    private Rectangle boundsD_ = null;

    public LegendDragBox(Legend legend, PanelHolder pHolder) {
        super(pHolder);
        this.legend_ = legend;
        this.legend_.addChangeListener(this);
        this.boundsD_ = this.toRectangle(this.legend_.getBoundsP());
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.computeHandles();
    }

    public Legend getLegend() {
        return this.legend_;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.boundsD_ = bounds;
        this.legend_.setBoundsP(this.toRectangle(this.boundsD_));
        this.computeHandles();
    }

    @Override
    public void draw(Graphics g) {
        Rectangle bounds = this.getBounds();
        Color saved = g.getColor();
        g.setColor(Color.darkGray);
        g.drawString(this.getId(), bounds.x + 5, bounds.y + 12);
        g.setColor(this.color_);
        if (this.legend_.isVisible()) {
            g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
        if (this.selected_) {
            for (int i = 0; i < this.handles_.length; ++i) {
                Rectangle r = this.handles_[i];
                g.fillRect(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
        g.setColor(saved);
    }

    @Override
    public void setLocation(Point pt) {
        this.boundsD_.x = pt.x;
        this.boundsD_.y = pt.y;
        this.legend_.setBoundsP(this.toRectangle(this.boundsD_));
        this.computeHandles();
    }

    @Override
    public Point getLocation() {
        return new Point(this.boundsD_.x, this.boundsD_.y);
    }

    @Override
    public Rectangle getBounds() {
        return this.boundsD_;
    }

    @Override
    public String getId() {
        return this.legend_.getId();
    }

    @Override
    public void update(String message) {
        this.boundsD_ = this.toRectangle(this.legend_.getBoundsP());
        this.computeHandles();
    }

    @Override
    public void setId(String id) {
        this.legend_.setId(id);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update("LegendDragBox.stateChanged()");
    }
}

