/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.sgt.swing.prop.ColorDialog;
import gov.noaa.pmel.sgt.swing.prop.FontDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LegendPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private Legend legend_;
    private String[] pNames_ = new String[]{"Border", "Columns", "Height", "Id", "Key Label HeightP", "Line Length", "Location", "Orientation", "Type", "Scale Color", "Scale Label Font", "Scale Label Format", "Scale Label HeightP", "Scale Label Interval", "Scale Label Orientation", "Scale Large Tic HeightP", "Scale Num Small Tics", "Scale Significant Digits", "Scale Small Tic HeightP", "Scale Visible", "Visible", "Width"};
    private boolean[] inColor_ = new boolean[]{true, false, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    private boolean[] inColorOnly_ = new boolean[]{false, false, false, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, false, false};
    private boolean[] expertItem_ = new boolean[]{false, false, false, false, true, false, false, false, false, true, true, true, true, false, false, true, true, false, true, true, false, false};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];
    private String[] keyType = new String[]{"Line", "Color", "Vector", "Point"};
    private String[] borderType = new String[]{"Plain Line", "Raised", "No Border"};
    private static DecimalFormat format_ = new DecimalFormat("#.###");

    public LegendPropertyPanel(Legend legend, boolean expert) {
        this.legend_ = legend;
        this.expert_ = expert;
        this.legend_.addChangeListener(this);
        this.reset();
    }

    public void setLegend(Legend legend, boolean expert) {
        if (this.legend_ != null) {
            this.legend_.removeChangeListener(this);
        }
        this.legend_ = legend;
        this.legend_.addChangeListener(this);
        this.expert_ = expert;
        this.reset();
    }

    @Override
    void update() {
        int item = -1;
        int i = -1;
        switch (this.legend_.getBorderStyle()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JTextField)this.comps_[++i]).setText(Integer.toString(this.legend_.getColumns()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getHeightP(), format_));
        ((JTextField)this.comps_[++i]).setText(this.legend_.getId());
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getKeyLabelHeightP()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getLineLength()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getLocationP(), false));
        switch (this.legend_.getOrientation()) {
            default: {
                item = 1;
                break;
            }
            case 2: {
                item = 0;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        switch (this.legend_.getType()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
                break;
            }
            case 3: {
                item = 3;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        this.updateColor((JButton)this.comps_[++i], this.legend_.getScaleColor());
        this.updateFont((JButton)this.comps_[++i], this.legend_.getScaleLabelFont());
        ((JTextField)this.comps_[++i]).setText(this.legend_.getScaleLabelFormat());
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getScaleLabelHeightP()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getScaleLabelInterval()));
        switch (this.legend_.getVerticalLabelOrientation()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
            }
        }
        ((JComboBox)this.comps_[++i]).setSelectedIndex(item);
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getScaleLargeTicHeightP()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getScaleNumberSmallTics()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getScaleSignificantDigits()));
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getScaleSmallTicHeightP()));
        ((JCheckBox)this.comps_[++i]).setSelected(this.legend_.isScaleVisible());
        ((JCheckBox)this.comps_[++i]).setSelected(this.legend_.isVisible());
        ((JTextField)this.comps_[++i]).setText(this.format(this.legend_.getWidthP(), format_));
    }

    @Override
    void create() {
        int item = -1;
        int i = -1;
        switch (this.legend_.getBorderStyle()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
            }
        }
        this.comps_[++i] = this.createComboBox(this.borderType, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createTextField(Integer.toString(this.legend_.getColumns()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getHeightP(), format_), this.pNames_[i], this, true);
        String string = this.pNames_[++i];
        this.comps_[i] = this.createTextField(this.legend_.getId(), string, this, !this.legend_.isInstantiated());
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getKeyLabelHeightP()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getLineLength()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getLocationP(), false), this.pNames_[i], this, true);
        Object[] orient = new String[]{"Vertical", "Horizontal"};
        switch (this.legend_.getOrientation()) {
            default: {
                item = 1;
                break;
            }
            case 2: {
                item = 0;
            }
        }
        this.comps_[++i] = this.createComboBox(orient, item, this.pNames_[i], (ActionListener)this, true);
        switch (this.legend_.getType()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
                break;
            }
            case 2: {
                item = 2;
                break;
            }
            case 3: {
                item = 3;
            }
        }
        String string2 = this.pNames_[++i];
        this.comps_[i] = this.createComboBox(this.keyType, item, string2, (ActionListener)this, !this.legend_.isInstantiated());
        this.comps_[++i] = this.createColor(this.legend_.getScaleColor(), this.pNames_[i], this);
        this.comps_[++i] = this.createFont(this.legend_.getScaleLabelFont(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.legend_.getScaleLabelFormat(), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getScaleLabelHeightP()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getScaleLabelInterval()), this.pNames_[i], this, true);
        Object[] vertPos = new String[]{"Vertical", "Horizontal"};
        switch (this.legend_.getVerticalLabelOrientation()) {
            default: {
                item = 0;
                break;
            }
            case 1: {
                item = 1;
            }
        }
        this.comps_[++i] = this.createComboBox(vertPos, item, this.pNames_[i], (ActionListener)this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getScaleLargeTicHeightP()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getScaleNumberSmallTics()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getScaleSignificantDigits()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getScaleSmallTicHeightP()), this.pNames_[i], this, true);
        this.comps_[++i] = this.createCheckBox(this.legend_.isScaleVisible(), this.pNames_[i], this);
        this.comps_[++i] = this.createCheckBox(this.legend_.isVisible(), this.pNames_[i], this);
        this.comps_[++i] = this.createTextField(this.format(this.legend_.getWidthP(), format_), this.pNames_[i], this, true);
        for (i = 0; i < this.comps_.length; ++i) {
            if (!this.expert_ && this.expertItem_[i]) continue;
            if (this.legend_.isColor()) {
                if (!this.inColor_[i]) continue;
                this.addProperty(i + 1, this.pNames_[i], this.comps_[i], false);
                continue;
            }
            if (this.inColorOnly_[i]) continue;
            this.addProperty(i + 1, this.pNames_[i], this.comps_[i], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    @Override
    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    private void processEvent(Object obj, String command) {
        if (command.equals("Height")) {
            this.legend_.setHeightP(Float.parseFloat(((JTextField)obj).getText()));
        } else if (command.equals("Id")) {
            String oldId = this.legend_.getId();
            this.legend_.getPanelHolder().getLegends().remove(oldId);
            this.legend_.setId(((JTextField)obj).getText());
            this.legend_.getPanelHolder().getLegends().put(this.legend_.getId(), this.legend_);
        } else if (command.equals("Key Label HeightP")) {
            this.legend_.setKeyLabelHeightP(Double.parseDouble(((JTextField)obj).getText()));
        } else if (command.equals("Border")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            int item = -1;
            if (str.equals("Plain Line")) {
                item = 0;
            } else if (str.equals("Raised")) {
                item = 1;
            } else if (str.equals("No Border")) {
                item = 2;
            }
            this.legend_.setBorderStyle(item);
        } else if (command.equals("Columns")) {
            this.legend_.setColumns(Integer.parseInt(((JTextField)obj).getText()));
        } else if (command.equals("Line Length")) {
            this.legend_.setLineLength(Double.parseDouble(((JTextField)obj).getText()));
        } else if (command.equals("Location")) {
            this.legend_.setLocationP(this.parsePoint2D(((JTextField)obj).getText()));
        } else if (command.equals("Orientation")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            int item = -1;
            item = str.equals("Horizontal") ? 1 : 2;
            this.legend_.setOrientation(item);
        } else if (command.equals("Type")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            int item = -1;
            if (str.equals("Line")) {
                item = 0;
            } else if (str.equals("Color")) {
                item = 1;
            } else if (str.equals("Vector")) {
                item = 2;
            } else if (str.equals("Point")) {
                item = 3;
            }
            this.legend_.setType(item);
            this.reset();
        } else if (command.equals("Scale Color")) {
            ColorDialog cd = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            cd.setColor(this.legend_.getScaleColor());
            cd.setVisible(true);
            Color newcolor = cd.getColor();
            if (newcolor != null) {
                this.legend_.setScaleColor(newcolor);
            }
        } else if (command.equals("Scale Label Font")) {
            FontDialog fd = new FontDialog("Label Font");
            int result = fd.showDialog(this.legend_.getScaleLabelFont());
            if (result == FontDialog.OK_RESPONSE) {
                this.legend_.setScaleLabelFont(fd.getFont());
            }
        } else if (command.equals("Scale Label Format")) {
            this.legend_.setScaleLabelFormat(((JTextField)obj).getText());
        } else if (command.equals("Scale Label HeightP")) {
            this.legend_.setScaleLabelHeightP(Double.parseDouble(((JTextField)obj).getText()));
        } else if (command.equals("Scale Label Interval")) {
            this.legend_.setScaleLabelInterval(Integer.parseInt(((JTextField)obj).getText()));
        } else if (command.equals("Scale Label Orientation")) {
            String str = (String)((JComboBox)obj).getSelectedItem();
            int item = -1;
            item = str.equals("Horizontal") ? 1 : 2;
            this.legend_.setVerticalLabelOrientation(item);
        } else if (command.equals("Scale Large Tic HeightP")) {
            this.legend_.setScaleLargeTicHeightP(Double.parseDouble(((JTextField)obj).getText()));
        } else if (command.equals("Scale Num Small Tics")) {
            this.legend_.setScaleNumberSmallTics(Integer.parseInt(((JTextField)obj).getText()));
        } else if (command.equals("Scale Significant Digits")) {
            this.legend_.setScaleSignificantDigits(Integer.parseInt(((JTextField)obj).getText()));
        } else if (command.equals("Scale Small Tic HeightP")) {
            this.legend_.setScaleSmallTicHeightP(Integer.parseInt(((JTextField)obj).getText()));
        } else if (command.equals("Scale Visible")) {
            this.legend_.setScaleVisible(((JCheckBox)obj).isSelected());
        } else if (command.equals("Visible")) {
            this.legend_.setVisible(((JCheckBox)obj).isSelected());
        } else if (command.equals("Width")) {
            this.legend_.setWidthP(Float.parseFloat(((JTextField)obj).getText()));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        String command = e.getActionCommand();
        this.processEvent(obj, command);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            JTextField tf = (JTextField)obj;
            String name = tf.getName();
            this.processEvent(obj, name);
        }
    }

    @Override
    public void setExpert(boolean expert) {
        boolean save = this.expert_;
        this.expert_ = expert;
        if (this.expert_ != save) {
            this.reset();
        }
    }

    @Override
    public boolean isExpert() {
        return this.expert_;
    }
}

