/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.util.Range2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class MapTransform
implements PropertyChangeListener {
    private MapLinearTransform xTrans_ = new MapLinearTransform();
    private MapLinearTransform yTrans_ = null;
    private double yScale_ = 111.32;

    public MapTransform() {
        this.xTrans_.setId("XTrans");
        this.yTrans_ = new MapLinearTransform();
        this.yTrans_.setId("YTrans");
        this.xTrans_.addPropertyChangeListener(this);
        this.yTrans_.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        double dpy;
        double yMeters;
        double dydp;
        double dpx;
        Range2D xRange = this.xTrans_.getRangeU();
        Range2D yRange = this.yTrans_.getRangeU();
        double aLat = (yRange.start + yRange.end) * 0.5;
        double xScale = Math.cos(Math.PI / 180 * aLat) * this.yScale_;
        double xMeters = (xRange.end - xRange.start) * xScale;
        double dxdp = xMeters / (dpx = this.xTrans_.getRangeP().end - this.xTrans_.getRangeP().start);
        if (dxdp > (dydp = (yMeters = (yRange.end - yRange.start) * this.yScale_) / (dpy = this.yTrans_.getRangeP().end - this.yTrans_.getRangeP().start))) {
            double newdy = dpy / dpx * xMeters - yMeters;
            double degLat = newdy / this.yScale_;
            yRange.start -= degLat * 0.5;
            yRange.end += degLat * 0.5;
            this.yTrans_.computeMapTransform(yRange.start, yRange.end);
            this.xTrans_.computeMapTransform();
        } else {
            double newdx = dpx / dpy * yMeters - xMeters;
            double degLon = newdx / xScale;
            xRange.start -= degLon * 0.5;
            xRange.end += degLon * 0.5;
            this.xTrans_.computeMapTransform(xRange.start, xRange.end);
            this.yTrans_.computeMapTransform();
        }
    }

    public LinearTransform getXTransform() {
        return this.xTrans_;
    }

    public LinearTransform getYTransform() {
        return this.yTrans_;
    }

    class MapLinearTransform
    extends LinearTransform {
        MapLinearTransform() {
        }

        void computeMapTransform() {
            this.computeTransform();
        }

        void computeMapTransform(double u1, double u2) {
            double denom = u1 - u2;
            if (denom == 0.0) {
                this.a_ = 1.0;
                this.b_ = 0.0;
            } else {
                this.a_ = (this.p1_ - this.p2_) / denom;
                this.b_ = this.p1_ - this.a_ * u1;
            }
        }

        @Override
        public String toString() {
            return "MapLinearTransform(" + this.ident_ + "): " + this.a_ + ", " + this.b_ + "; " + this.at_ + ", " + this.bt_;
        }
    }
}

