/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.util.SoTPoint;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class MouseValue {
    private String pageName_ = null;
    private String panelId_ = null;
    private String dataGroupLayerId_ = null;
    private Point deviceLocation_ = null;
    private Point2D.Double physicalLocation_ = null;
    private SoTPoint userLocation_ = null;
    private double gridValue_ = Double.NaN;
    private DecimalFormat pFormat_ = new DecimalFormat("0.0000E0");

    public MouseValue(String page, String panel, String data, Point d, Point2D.Double p, SoTPoint u, double val) {
        this.pageName_ = page;
        this.panelId_ = panel;
        this.dataGroupLayerId_ = data;
        this.deviceLocation_ = d;
        this.physicalLocation_ = p;
        this.userLocation_ = u;
        this.gridValue_ = val;
    }

    public MouseValue(String page, String panel, String data, Point d, Point2D.Double p, SoTPoint u) {
        this(page, panel, data, d, p, u, Double.NaN);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("[");
        if (this.pageName_ != null) {
            sbuf.append(this.pageName_).append(",");
        } else {
            sbuf.append("n/a,");
        }
        if (this.panelId_ != null) {
            sbuf.append(this.panelId_).append(",");
        } else {
            sbuf.append("n/a,");
        }
        if (this.dataGroupLayerId_ != null) {
            sbuf.append(this.dataGroupLayerId_);
        } else {
            sbuf.append("n/a");
        }
        sbuf.append("] = (");
        if (this.deviceLocation_ != null) {
            sbuf.append(this.deviceLocation_.x).append(",").append(this.deviceLocation_.y);
        } else {
            sbuf.append("n/a");
        }
        sbuf.append("),(");
        if (this.physicalLocation_ != null) {
            sbuf.append(this.pFormat_.format(this.physicalLocation_.x)).append(",");
            sbuf.append(this.pFormat_.format(this.physicalLocation_.y));
        } else {
            sbuf.append("n/a");
        }
        sbuf.append("),(");
        if (this.userLocation_ != null) {
            sbuf.append(this.userLocation_.getX().toString()).append(",");
            sbuf.append(this.userLocation_.getY().toString());
        } else {
            sbuf.append("n/a");
        }
        sbuf.append(")");
        if (!Double.isNaN(this.gridValue_)) {
            sbuf.append(" = ");
            sbuf.append(this.pFormat_.format(this.gridValue_));
        }
        return sbuf.toString();
    }

    public String getPageName() {
        return this.pageName_;
    }

    public String getPanelId() {
        return this.panelId_;
    }

    public String getDataGroupLayerId() {
        return this.dataGroupLayerId_;
    }

    public Point getDeviceLocation() {
        return this.deviceLocation_;
    }

    public Point2D.Double getPhysicalLocation() {
        return this.physicalLocation_;
    }

    public SoTPoint getUserLocation() {
        return this.userLocation_;
    }

    public double getGridValue() {
        return this.gridValue_;
    }
}

