/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LayerControl;
import gov.noaa.pmel.sgt.beans.DataGroupLayer;
import gov.noaa.pmel.sgt.beans.DataHolder;
import gov.noaa.pmel.sgt.beans.DataModel;
import gov.noaa.pmel.sgt.beans.DataOperation;
import gov.noaa.pmel.sgt.beans.DataTargetMismatchException;
import gov.noaa.pmel.sgt.beans.MouseValue;
import gov.noaa.pmel.sgt.beans.MouseValueEvent;
import gov.noaa.pmel.sgt.beans.MouseValueListener;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class Page
extends JComponent
implements PropertyChangeListener,
Serializable,
Printable {
    public static final boolean DEBUG = false;
    private DataModel dataModel;
    private PanelModel panelModel;
    private JPane pane_;
    private String name;
    private transient boolean isDesignTime_ = Beans.isDesignTime();
    private Vector<MouseValueListener> mouseValueListener_ = new Vector();

    public Page() {
        this.pane_ = new JPane("SGT Bean Pane", new Dimension(200, 200));
        this.pane_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.pane_));
        this.pane_.setBackground(Color.white);
        this.pane_.setOpaque(true);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.add((Component)this.pane_, "Center");
        this.pane_.addMouseListener(new DefaultMouseAdapter(this));
        this.pane_.addMouseMotionListener(new DefaultMouseMotionListener(this));
    }

    public JPane getJPane() {
        return this.pane_;
    }

    public Dimension getJPaneSize() {
        return this.pane_.getSize();
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public void setDataModel(DataModel dataModel) {
        DataModel saved = this.dataModel;
        if (dataModel != null) {
            dataModel.addPropertyChangeListener(new WeakPropertyChangeListener(this, dataModel));
            dataModel.setPage(this);
        }
        this.dataModel = dataModel;
        if (this.isDesignTime_) {
            this.repaint();
        }
        this.firePropertyChange("dataModel", saved, this.dataModel);
    }

    public PanelModel getPanelModel() {
        return this.panelModel;
    }

    public void setPanelModel(PanelModel panelModel) {
        PanelModel saved = this.panelModel;
        this.setSize(panelModel.getPageSize());
        this.setBackground(panelModel.getPageBackgroundColor());
        this.setPreferredSize(panelModel.getPageSize());
        this.panelModel = panelModel;
        this.panelModel.repair();
        this.panelModel.setPage(this);
        this.updatePanels();
        if (this.isDesignTime_) {
            this.repaint();
        }
        this.firePropertyChange("panelModel", saved, this.panelModel);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.pane_.setBackground(color);
    }

    @Override
    public void setName(String name) {
        this.firePropertyChange("name", this.name, name);
        this.name = name;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String property = evt.getPropertyName();
        if (source instanceof PanelModel) {
            this.updatePanels();
        } else if (source instanceof DataModel) {
            Object obj = evt.getNewValue();
            boolean batch = this.pane_.isBatch();
            if (obj instanceof DataOperation) {
                if (property.equals("addData") || property.equals("removeData") || property.equals("addDataAt") || property.equals("addDataOrderedAt")) {
                    try {
                        this.pane_.setBatch(true);
                        ((DataOperation)obj).getDataHolder().notifyPanel(evt);
                        this.pane_.setModified(true, "Page");
                        this.pane_.setBatch(batch);
                    }
                    catch (DataTargetMismatchException dtme) {
                        dtme.printStackTrace();
                    }
                }
            } else if (obj instanceof List && property.equals("removeAllData")) {
                List dList = (List)obj;
                this.pane_.setBatch(true);
                for (int i = 0; i < dList.size(); ++i) {
                    try {
                        ((DataHolder)dList.get(i)).notifyPanel(evt);
                        this.pane_.setModified(true, "Page");
                        continue;
                    }
                    catch (DataTargetMismatchException ex) {
                        ex.printStackTrace();
                        this.pane_.setBatch(batch);
                    }
                }
                this.pane_.setBatch(batch);
            }
        } else if (source != this.pane_ || property.equals("objectSelected") || property.equals("zoomRectangle")) {
            // empty if block
        }
    }

    private void updatePanels() {
        this.setSize(this.panelModel.getPageSize());
        this.setBackground(this.panelModel.getPageBackgroundColor());
        this.setPrintHAlign(this.panelModel.getPrintHAlign());
        this.setPrintVAlign(this.panelModel.getPrintVAlign());
        this.setPrintOrigin(this.panelModel.getPrintOrigin());
        this.setPrintScaleMode(this.panelModel.getPrintScaleMode());
        boolean batch = this.pane_.isBatch();
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Panel pnl;
            if (!(comps[i] instanceof Panel) || this.panelModel.hasPanelHolder((pnl = (Panel)comps[i]).getName())) continue;
            this.pane_.remove(pnl);
        }
        Panel panel = null;
        Iterator phIter = this.panelModel.panelIterator();
        while (phIter.hasNext()) {
            PanelHolder ph = (PanelHolder)phIter.next();
            panel = this.findPanel(ph);
            if (panel == null) {
                panel = new Panel(ph);
                ph.setInstantiated(true);
                this.pane_.add(panel);
                continue;
            }
            panel.update();
        }
        this.revalidate();
        this.pane_.setModified(true, "Page");
        this.pane_.setBatch(batch);
    }

    public Panel findPanel(PanelHolder pHolder) {
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel) || !((Panel)comps[i]).getName().equals(pHolder.getId())) continue;
            return (Panel)comps[i];
        }
        return null;
    }

    private void pageMousePressed(MouseEvent event) {
        if (event.isPopupTrigger()) {
            // empty if block
        }
        if (!event.isControlDown()) {
            return;
        }
        if (!this.panelModel.isResetZoomOnCntrlButton1()) {
            return;
        }
        boolean batch = this.pane_.isBatch();
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel)) continue;
            Panel pnl = (Panel)comps[i];
            pnl.resetZoom(event.getX(), event.getY());
        }
        this.pane_.setBatch(batch);
    }

    public void resetToLastZoom() {
        Rectangle zm = this.pane_.getLastZoomBounds();
        if (zm != null) {
            Point zmStart = this.pane_.getLastZoomStart();
            if (zm.width <= 1 || zm.height <= 1) {
                return;
            }
            boolean batch = this.pane_.isBatch();
            this.pane_.setBatch(true);
            Component[] comps = this.pane_.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Panel)) continue;
                Panel pnl = (Panel)comps[i];
                pnl.zoomTo(zmStart, zm);
            }
            this.pane_.setBatch(batch);
        }
    }

    public void setBatch(boolean batch) {
        this.pane_.setBatch(batch);
    }

    public boolean isBatch() {
        return this.pane_.isBatch();
    }

    public void resetZoom() {
        boolean batch = this.pane_.isBatch();
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel)) continue;
            Panel pnl = (Panel)comps[i];
            pnl.resetZoom();
        }
        this.pane_.setBatch(batch);
    }

    private void pageMouseClicked(MouseEvent event) {
        if (event.isControlDown()) {
            return;
        }
        if (event.isPopupTrigger()) {
            // empty if block
        }
        if ((event.getModifiers() & 4) != 0) {
            // empty if block
        }
    }

    private void pageMouseReleased(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return;
        }
        Rectangle zm = this.pane_.getZoomBounds();
        Point zmStart = this.pane_.getZoomStart();
        if (zm.width <= 1 || zm.height <= 1) {
            return;
        }
        boolean batch = this.pane_.isBatch();
        this.pane_.setBatch(true);
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Panel)) continue;
            Panel pnl = (Panel)comps[i];
            pnl.zoomTo(zmStart, zm);
        }
        this.pane_.setBatch(batch);
    }

    public void addMouseValueListener(MouseValueListener mvl) {
        this.mouseValueListener_.add(mvl);
    }

    public void removeMouseValueListener(MouseValueListener mvl) {
        this.mouseValueListener_.remove(mvl);
    }

    public void removeAllMouseValueListeners() {
        this.mouseValueListener_.clear();
    }

    private void pageMouseMoved(MouseEvent event) {
        if (this.mouseValueListener_.isEmpty()) {
            return;
        }
        Vector<MouseValue> mValues = new Vector<MouseValue>();
        int xd = event.getX();
        int yd = event.getY();
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            Panel p;
            Rectangle pRect;
            if (!(comps[i] instanceof Panel) || !(pRect = (p = (Panel)comps[i]).getBounds()).contains(xd, yd)) continue;
            DataGroupLayer[] dgl = p.getDataGroupLayersAt(xd, yd);
            for (int k = 0; k < dgl.length; ++k) {
                ArrayList<Layer> layerList = new ArrayList<Layer>(dgl[k].getLayerList());
                for (Layer layer : layerList) {
                    double xp = layer.getXDtoP(xd);
                    double yp = layer.getYDtoP(yd);
                    CartesianGraph cg = (CartesianGraph)layer.getGraph();
                    SoTValue xu = cg.getXPtoSoT(xp);
                    SoTValue yu = cg.getYPtoSoT(yp);
                    CartesianRenderer cr = cg.getRenderer();
                    MouseValue mv = null;
                    if (cr instanceof GridCartesianRenderer) {
                        SGTGrid grid = (SGTGrid)cr.getData();
                        double value = grid.getValueAt(xu, yu);
                        mv = new MouseValue(this.name, p.getId(), layer.getId(), new Point(xd, yd), new Point2D.Double(xp, yp), new SoTPoint(xu, yu), value);
                    } else {
                        mv = new MouseValue(this.name, p.getId(), layer.getId(), new Point(xd, yd), new Point2D.Double(xp, yp), new SoTPoint(xu, yu));
                    }
                    mValues.add(mv);
                }
            }
        }
        if (!mValues.isEmpty()) {
            MouseValueEvent mve = new MouseValueEvent((Component)this, mValues.toArray(new MouseValue[0]));
            for (MouseValueListener mvl : this.mouseValueListener_) {
                mvl.mouseValue(mve);
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        int result = 1;
        Color saveColor = this.getBackground();
        if (this.panelModel.isPrintWhitePage()) {
            this.setBackground(Color.white);
        }
        if ((result = this.pane_.print(g, pf, pageIndex)) == 0 && this.panelModel.isPrintBorders()) {
            Component[] comps = this.pane_.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Panel)) continue;
                Panel pnl = (Panel)comps[i];
                Rectangle r = pnl.getBounds();
                Border bdr = pnl.getBorder();
                bdr.paintBorder(pnl, g, r.x, r.y, r.width, r.height);
            }
        }
        this.setBackground(saveColor);
        return result;
    }

    public void setPrintScaleMode(int mode) {
        this.pane_.setPageScaleMode(mode);
    }

    public int getPrintScaleMode() {
        return this.pane_.getPageScaleMode();
    }

    public void setPrintVAlign(int vert) {
        this.pane_.setPageVAlign(vert);
    }

    public void setPrintHAlign(int horz) {
        this.pane_.setPageHAlign(horz);
    }

    public int getPrintVAlign() {
        return this.pane_.getPageVAlign();
    }

    public int getPrintHAlign() {
        return this.pane_.getPageHAlign();
    }

    public void setPrintOrigin(Point pt) {
        this.pane_.setPageOrigin(pt);
    }

    public Point getPrintOrigin() {
        return this.pane_.getPageOrigin();
    }

    public void drawPdf(Graphics2D g2, float x, float y, float width, float height) {
        if (this.getParent() == null) {
            System.out.println("<< Page has no parent, fix Panel layers>>");
            this.invalidate();
            this.doLayout();
            Component[] comps = this.pane_.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof LayerControl) || !(comps[i] instanceof Panel)) continue;
                Panel panel = (Panel)comps[i];
                Layer lbLayer = panel.getLabelLayer();
                lbLayer.setBounds(panel.getBounds());
                Layer lgLayer = panel.getLegendLayer();
                lgLayer.setBounds(panel.getBounds());
                Map<String, DataGroupLayer> dgls = panel.getDataGroupLayers();
                for (DataGroupLayer dgl : dgls.values()) {
                    dgl.setBounds(comps[i].getBounds());
                }
            }
        }
        this.pane_.drawPdf(g2, x, y, width, height);
    }

    public void dispose() {
        this.pane_.dispose();
    }

    public static class DefaultMouseAdapter
    extends MouseAdapter {
        Page page;

        public DefaultMouseAdapter(Page page) {
            this.page = page;
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!this.page.pane_.isMouseEventsEnabled()) {
                return;
            }
            this.page.pageMousePressed(event);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (!this.page.pane_.isMouseEventsEnabled()) {
                return;
            }
            this.page.pageMouseClicked(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (!this.page.pane_.isMouseEventsEnabled()) {
                return;
            }
            this.page.pageMouseReleased(event);
        }
    }

    public static class DefaultMouseMotionListener
    extends MouseMotionAdapter {
        Page page;

        public DefaultMouseMotionListener(Page page) {
            this.page = page;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (!this.page.pane_.isMouseEventsEnabled()) {
                return;
            }
            this.page.pageMouseMoved(event);
        }
    }
}

