/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.ColorKey;
import gov.noaa.pmel.sgt.LayerChild;
import gov.noaa.pmel.sgt.beans.AxisHolder;
import gov.noaa.pmel.sgt.beans.AxisHolderDragBox;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataGroupLayer;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.Margin;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import javax.swing.Timer;

public class PageReSizeHelper
implements ComponentListener,
ActionListener {
    private static final long RESIZE_DELAY = 200L;
    private Page page_ = null;
    private boolean xResizable_ = true;
    private boolean yResizable_ = true;
    private Timer timer_ = null;
    private Rectangle oldPageBounds_ = new Rectangle();
    private int reSizeCounter = 0;
    private boolean useTimer_ = true;
    private long lastUpdateTime = -1L;

    public PageReSizeHelper(Page page, boolean xResizable, boolean yResizable) {
        this(page, xResizable, yResizable, true);
    }

    public PageReSizeHelper(Page page, boolean xResizable, boolean yResizable, boolean useTimer) {
        this.page_ = page;
        this.xResizable_ = xResizable;
        this.yResizable_ = yResizable;
        this.useTimer_ = useTimer;
        this.oldPageBounds_ = this.page_.getBounds();
        this.page_.addComponentListener(this);
    }

    public PageReSizeHelper(Page page) {
        this(page, true, true, true);
    }

    public PageReSizeHelper(Page page, boolean useTimer) {
        this(page, true, true, useTimer);
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        Rectangle pageB = this.page_.getBounds();
        if (pageB.width == this.oldPageBounds_.width && pageB.height == this.oldPageBounds_.height) {
            return;
        }
        this.oldPageBounds_ = pageB;
        this.lastUpdateTime = System.currentTimeMillis();
        if (this.useTimer_) {
            if (this.timer_ == null) {
                this.timer_ = new Timer(200, this);
                this.timer_.setRepeats(true);
                this.timer_.setCoalesce(true);
                this.timer_.start();
            } else {
                this.timer_.stop();
                this.timer_.start();
            }
        } else {
            this.reSize();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (System.currentTimeMillis() >= this.lastUpdateTime + 200L) {
            this.timer_.stop();
            ++this.reSizeCounter;
            PanelModel panelModel = this.page_.getPanelModel();
            this.reSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reSize() {
        Object object = this.page_.getJPane().getPaneLock();
        synchronized (object) {
            Rectangle pageB = this.page_.getBounds();
            PanelModel panelModel = this.page_.getPanelModel();
            panelModel.setBatch(true);
            Iterator phIter = panelModel.panelIterator();
            while (phIter.hasNext()) {
                PanelHolder ph = (PanelHolder)phIter.next();
                Panel panel = this.page_.findPanel(ph);
                Rectangle before = ph.getBounds();
                double dx = 0.0;
                double dy = 0.0;
                if (this.xResizable_) {
                    dx = (pageB.getWidth() - before.getWidth()) / 72.0;
                } else {
                    pageB.width = before.width;
                }
                if (this.yResizable_) {
                    dy = (pageB.getHeight() - before.getHeight()) / 72.0;
                } else {
                    pageB.height = before.height;
                }
                if (dx == 0.0 && dy == 0.0) {
                    return;
                }
                ph.setBounds(new Rectangle(before.x, before.y, pageB.width, pageB.height));
                Iterator lgIter = ph.legendIterator();
                while (lgIter.hasNext()) {
                    Legend legend = (Legend)lgIter.next();
                    if (panel.getLegendLayer() == null || legend == null) continue;
                    LayerChild child = panel.getLegendLayer().findChild(legend.getId());
                    Rectangle2D.Double loc = legend.getBoundsP();
                    switch (legend.getType()) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            ColorKey ck = (ColorKey)child;
                            if (ck.getOrientation() == 1) {
                                legend.setBoundsP(new Rectangle2D.Double(loc.x, loc.y + dy, loc.width + dx, loc.height));
                                break;
                            }
                            legend.setBoundsP(new Rectangle2D.Double(loc.x + dx, loc.y, loc.width, loc.height + dy));
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                }
                Iterator lbIter = ph.labelIterator();
                while (lbIter.hasNext()) {
                    Label label = (Label)lbIter.next();
                    Rectangle2D.Double locLb = label.getBoundsP();
                    if (dx != 0.0) {
                        block7 : switch (label.getOrientation()) {
                            case 1: {
                                break;
                            }
                            case 0: {
                                switch (label.getJustification()) {
                                    case 2: {
                                        label.setBoundsP(new Rectangle2D.Double(locLb.x + dx, locLb.y + dy, locLb.width, locLb.height));
                                        break block7;
                                    }
                                    case 0: {
                                        label.setBoundsP(new Rectangle2D.Double(locLb.x, locLb.y + dy, locLb.width, locLb.height));
                                        break block7;
                                    }
                                    case 1: {
                                        double f = locLb.x / (before.getWidth() / 72.0);
                                        label.setBoundsP(new Rectangle2D.Double(locLb.x + f * dx, locLb.y + dy, locLb.width, locLb.height));
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    label.setBoundsP(new Rectangle2D.Double(locLb.x, locLb.y + dy, locLb.width, locLb.height));
                }
                Iterator dgIter = ph.dataGroupIterator();
                while (dgIter.hasNext()) {
                    DataGroup dg = (DataGroup)dgIter.next();
                    AxisHolder xax = dg.getXAxisHolder();
                    AxisHolder yax = dg.getYAxisHolder();
                    this.updateAxisHolder(ph, dg, xax);
                    this.updateAxisHolder(ph, dg, yax);
                }
            }
            panelModel.setBatch(false);
        }
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
        System.out.println("compententShown: " + this.page_.getName());
    }

    public void updateAxisHolder(PanelHolder pHolder, DataGroup dg, AxisHolder axHolder) {
        int height;
        int yOrig;
        int xOrig;
        int y;
        int x;
        int width;
        Point2D.Double orig = axHolder.getAxisOriginP();
        Point originD = null;
        if (orig != null) {
            originD = this.toLocation(pHolder, orig);
        }
        Rectangle2D.Double bnds = (Rectangle2D.Double)axHolder.getBoundsP();
        Rectangle boundsD = null;
        if (bnds != null) {
            boundsD = this.toRectangle(pHolder, bnds);
        }
        int ticPos = 1;
        int labPos = 1;
        Rectangle dgBounds = this.computeDataGroupBounds(pHolder, dg);
        if (axHolder.getAxisOrientation() == 0) {
            width = dgBounds.width;
            x = dgBounds.x;
            ticPos = axHolder.getTicPosition();
            labPos = axHolder.getLabelPosition();
            if (axHolder.getAxisPosition() != 4) {
                switch (axHolder.getAxisPosition()) {
                    default: {
                        y = dgBounds.y + dgBounds.height;
                        break;
                    }
                    case 0: {
                        y = dgBounds.y;
                        break;
                    }
                }
            } else {
                y = originD.y;
                x = boundsD.x;
                width = boundsD.width;
            }
            xOrig = x;
            yOrig = y;
            height = AxisHolderDragBox.TIC_SPACE + AxisHolderDragBox.TITLE_SPACE;
            switch (labPos) {
                case 1: {
                    height += AxisHolderDragBox.TITLE_HEIGHT;
                    break;
                }
                case 0: {
                    height += AxisHolderDragBox.TITLE_HEIGHT;
                    y -= AxisHolderDragBox.TITLE_HEIGHT + AxisHolderDragBox.TITLE_SPACE;
                    break;
                }
            }
            switch (ticPos) {
                case 1: {
                    height += AxisHolderDragBox.TIC_LENGTH;
                    break;
                }
                case 0: {
                    height += AxisHolderDragBox.TIC_LENGTH;
                    y -= AxisHolderDragBox.TIC_LENGTH + AxisHolderDragBox.TIC_SPACE;
                    break;
                }
                case 2: {
                    height += 2 * AxisHolderDragBox.TIC_LENGTH + AxisHolderDragBox.TIC_SPACE;
                    y -= AxisHolderDragBox.TIC_LENGTH + AxisHolderDragBox.TIC_SPACE;
                }
            }
        } else {
            height = dgBounds.height;
            y = dgBounds.y;
            ticPos = axHolder.getTicPosition();
            labPos = axHolder.getLabelPosition();
            if (axHolder.getAxisPosition() != 4) {
                switch (axHolder.getAxisPosition()) {
                    default: {
                        x = dgBounds.x;
                        break;
                    }
                    case 3: {
                        x = dgBounds.x + dgBounds.width;
                        break;
                    }
                }
            } else {
                x = originD.x;
                y = boundsD.y;
                height = boundsD.height;
            }
            xOrig = x;
            yOrig = y;
            width = AxisHolderDragBox.TIC_SPACE + AxisHolderDragBox.TITLE_SPACE;
            switch (labPos) {
                case 1: {
                    width += AxisHolderDragBox.TITLE_HEIGHT;
                    x -= AxisHolderDragBox.TITLE_HEIGHT + AxisHolderDragBox.TITLE_SPACE;
                    break;
                }
                case 0: {
                    width += AxisHolderDragBox.TITLE_HEIGHT;
                    break;
                }
            }
            switch (ticPos) {
                case 1: {
                    width += AxisHolderDragBox.TIC_LENGTH;
                    x -= AxisHolderDragBox.TIC_LENGTH + AxisHolderDragBox.TIC_SPACE;
                    break;
                }
                case 0: {
                    width += AxisHolderDragBox.TIC_LENGTH;
                    break;
                }
                case 2: {
                    width += 2 * AxisHolderDragBox.TIC_LENGTH + AxisHolderDragBox.TIC_SPACE;
                    x -= AxisHolderDragBox.TIC_LENGTH + AxisHolderDragBox.TIC_SPACE;
                }
            }
        }
        axHolder.setAxisOriginP(this.toLocation(pHolder, new Point(xOrig, yOrig)));
        axHolder.setBoundsP(this.toRectangle(pHolder, new Rectangle(x, y, width, height)));
    }

    private Rectangle computeDataGroupBounds(PanelHolder pHolder, DataGroup dg) {
        Rectangle panel = pHolder.getBounds();
        Margin margin = dg.getMargin();
        float dpi = pHolder.getPanelModel().getDpi();
        int left = (int)(margin.left * dpi);
        int right = (int)(margin.right * dpi);
        int top = (int)(margin.top * dpi);
        int bottom = (int)(margin.bottom * dpi);
        return new Rectangle(panel.x + left, panel.y + top, panel.width - (left + right), panel.height - (top + bottom));
    }

    Point2D.Double toLocation(PanelHolder pHolder, Point pd) {
        return new Point2D.Double(this.toXLocation(pHolder, pd.x), this.toYLocation(pHolder, pd.y));
    }

    Point toLocation(PanelHolder pHolder, Point2D.Double pp) {
        return new Point(this.toXLocation(pHolder, pp.x), this.toYLocation(pHolder, pp.y));
    }

    Rectangle2D.Double toRectangle(PanelHolder pHolder, Rectangle rd) {
        return new Rectangle2D.Double(this.toXLocation(pHolder, rd.x), this.toYLocation(pHolder, rd.y + rd.height), this.transform(pHolder, rd.width), this.transform(pHolder, rd.height));
    }

    Rectangle toRectangle(PanelHolder pHolder, Rectangle2D.Double rp) {
        int h = this.transform(pHolder, rp.height);
        return new Rectangle(this.toXLocation(pHolder, rp.x), this.toYLocation(pHolder, rp.y) - h, this.transform(pHolder, rp.width), h);
    }

    double toXLocation(PanelHolder pHolder, int xd) {
        return (float)(xd - pHolder.getBounds().x) / pHolder.getPanelModel().getDpi();
    }

    double toYLocation(PanelHolder pHolder, int yd) {
        return (float)(pHolder.getBounds().height - yd + pHolder.getBounds().y) / pHolder.getPanelModel().getDpi();
    }

    int toXLocation(PanelHolder pHolder, double xp) {
        return (int)(xp * (double)pHolder.getPanelModel().getDpi() + 0.5) + pHolder.getBounds().x;
    }

    int toYLocation(PanelHolder pHolder, double yp) {
        return pHolder.getBounds().height - (int)(yp * (double)pHolder.getPanelModel().getDpi() + 0.5) + pHolder.getBounds().y;
    }

    double transform(PanelHolder pHolder, int dev) {
        return (float)dev / pHolder.getPanelModel().getDpi();
    }

    int transform(PanelHolder pHolder, double phy) {
        return (int)(phy * (double)pHolder.getPanelModel().getDpi() + 0.5);
    }

    public void dumpPanelModel(PanelModel panelModel, String comment) {
        if (comment != null) {
            System.out.println(comment);
        }
        Iterator pmIter = panelModel.panelIterator();
        while (pmIter.hasNext()) {
            PanelHolder ph = (PanelHolder)pmIter.next();
            System.out.println("PanelHolder: " + ph.getId() + " @ " + ph.getBounds());
            Iterator lbIter = ph.labelIterator();
            while (lbIter.hasNext()) {
                Label label = (Label)lbIter.next();
                System.out.println("  Label: " + label.getId() + " @ " + label.getBoundsP());
            }
            Iterator lgIter = ph.legendIterator();
            while (lgIter.hasNext()) {
                Legend legend = (Legend)lgIter.next();
                System.out.println("  Legend: " + legend.getId() + " @ " + legend.getBoundsP());
            }
            Iterator dgIter = ph.dataGroupIterator();
            while (dgIter.hasNext()) {
                DataGroup dg = (DataGroup)dgIter.next();
                System.out.println("  DataGroup: " + dg.getId());
                DataGroupLayer dgl = this.page_.findPanel(ph).findDataGroupLayer(dg.getId());
                System.out.println("     Layer: " + dgl.getId() + " @ " + dgl.getBounds() + ", " + dgl.getBoundsP());
                AxisHolder xax = dg.getXAxisHolder();
                System.out.println("     XAxis: " + xax.getBoundsP());
                AxisHolder yax = dg.getYAxisHolder();
                System.out.println("     YAxis: " + yax.getBoundsP());
            }
        }
        System.out.println("");
    }

    public boolean isXResizable() {
        return this.xResizable_;
    }

    public void setXResizable(boolean xResizable) {
        this.xResizable_ = xResizable;
    }

    public boolean isYResizable() {
        return this.yResizable_;
    }

    public void setYResizable(boolean yResizable) {
        this.yResizable_ = yResizable;
    }

    public Page getPage() {
        return this.page_;
    }

    public void dispose() {
        this.page_.removeComponentListener(this);
        if (this.timer_ != null) {
            this.timer_.stop();
            this.timer_.removeActionListener(this);
            this.timer_ = null;
        }
    }
}

