/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.PanelModel;
import java.awt.Color;
import java.awt.Rectangle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelHolder
implements ChangeListener,
Serializable {
    private String id = "";
    private Rectangle bounds = new Rectangle(0, 0, 100, 50);
    private Map labels_ = new HashMap(5);
    private Map dataGroups_ = new HashMap(2);
    private Map legends_ = new HashMap(1);
    private transient PanelModel pModel_ = null;
    private transient ChangeEvent changeEvent_ = new ChangeEvent(this);
    private transient Vector changeListeners;
    private boolean visible = true;
    private transient boolean instantiated = false;
    private Border border = new LineBorder(Color.gray, 2);
    private Color background = Color.white;
    private boolean usePageBackground = true;

    public PanelHolder() {
        this(null, null);
    }

    public PanelHolder(String id, PanelModel pModel) {
        this.id = id;
        this.pModel_ = pModel;
    }

    public PanelHolder(String id, PanelModel pModel, Rectangle bounds, Map labels, Map dataGroups, Map legends) {
        this.id = id;
        this.pModel_ = pModel;
        this.bounds = bounds;
        if (labels != null) {
            this.labels_ = new HashMap(labels);
        }
        if (dataGroups != null) {
            this.dataGroups_ = new HashMap(dataGroups);
        }
        if (legends != null) {
            this.legends_ = new HashMap(legends);
        }
    }

    public void setPanelModel(PanelModel pModel) {
        if (this.pModel_ != null) {
            this.removeChangeListener(this.pModel_);
        }
        this.pModel_ = pModel;
        this.addChangeListener(this.pModel_);
    }

    public PanelModel getPanelModel() {
        return this.pModel_;
    }

    public void addLabel(Label label) {
        label.addChangeListener(this);
        label.setPanelHolder(this);
        this.labels_.put(label.getId(), label);
        this.fireStateChanged();
    }

    public void removeLabel(Label label) {
        label.removeAllChangeListeners();
        this.labels_.remove(label.getId());
        this.fireStateChanged();
    }

    public void addDataGroup(DataGroup dataGroup) {
        dataGroup.addChangeListener(this);
        this.dataGroups_.put(dataGroup.getId(), dataGroup);
        this.fireStateChanged();
    }

    public void removeDataGroup(DataGroup dataGroup) {
        dataGroup.removeAllChangeListeners();
        dataGroup.getXAxisHolder().removeAllChangeListeners();
        dataGroup.getYAxisHolder().removeAllChangeListeners();
        this.dataGroups_.remove(dataGroup.getId());
        this.fireStateChanged();
    }

    public void addLegend(Legend legend) {
        legend.addChangeListener(this);
        legend.setPanelHolder(this);
        this.legends_.put(legend.getId(), legend);
        this.fireStateChanged();
    }

    public void removeLegend(Legend legend) {
        legend.removeAllChangeListeners();
        this.legends_.remove(legend.getId());
        this.fireStateChanged();
    }

    public void setId(String id) {
        String old = this.id;
        this.id = id;
        if (old == null || !old.equals(this.id)) {
            this.fireStateChanged();
        }
    }

    public String getId() {
        return this.id;
    }

    public int getLabelSize() {
        return this.labels_.size();
    }

    public int getDataGroupSize() {
        return this.dataGroups_.size();
    }

    public int getLegendSize() {
        return this.legends_.size();
    }

    public Iterator labelIterator() {
        return this.labels_.values().iterator();
    }

    public Iterator dataGroupIterator() {
        return this.dataGroups_.values().iterator();
    }

    public Iterator legendIterator() {
        return this.legends_.values().iterator();
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
        this.fireStateChanged();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void removeAllChangeListeners() {
        this.changeListeners = null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
            }
        }
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void removeDesignChangeListeners() {
        if (this.changeListeners != null) {
            Vector v = (Vector)this.changeListeners.clone();
            for (Object obj : v) {
                if (!(obj instanceof DesignListener)) continue;
                this.changeListeners.removeElement(obj);
            }
        }
    }

    protected void fireStateChanged() {
        if (this.changeEvent_ == null) {
            this.changeEvent_ = new ChangeEvent(this);
        }
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(this.changeEvent_);
            }
        }
    }

    public void setVisible(boolean visible) {
        boolean saved = this.visible;
        this.visible = visible;
        if (saved != this.visible) {
            this.fireStateChanged();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setInstantiated(boolean instantiated) {
        this.instantiated = instantiated;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public DataGroup findDataGroup(String id) {
        return (DataGroup)this.dataGroups_.get(id);
    }

    public Label findLabel(String id) {
        return (Label)this.labels_.get(id);
    }

    public Legend findLegend(String id) {
        return (Legend)this.legends_.get(id);
    }

    public boolean hasDataGroup(String id) {
        return this.dataGroups_.containsKey(id);
    }

    public boolean hasLabel(String id) {
        return this.labels_.containsKey(id);
    }

    public boolean hasLegend(String id) {
        return this.legends_.containsKey(id);
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        Border saved = this.border;
        this.border = border;
        if (saved == null || !saved.equals(this.border)) {
            this.fireStateChanged();
        }
    }

    public Map getLabels() {
        return this.labels_;
    }

    public void setLabels(Map labels) {
        this.labels_ = labels;
        Iterator iter = this.labelIterator();
        while (iter.hasNext()) {
            ((Label)iter.next()).addChangeListener(this);
        }
        this.fireStateChanged();
    }

    public Map getLegends() {
        return this.legends_;
    }

    public void setLegends(Map legends) {
        this.legends_ = legends;
        Iterator iter = this.legendIterator();
        while (iter.hasNext()) {
            ((Legend)iter.next()).addChangeListener(this);
        }
        this.fireStateChanged();
    }

    public Map getDataGroups() {
        return this.dataGroups_;
    }

    public void setDataGroups(Map dataGroups) {
        this.dataGroups_ = dataGroups;
        Iterator iter = this.dataGroupIterator();
        while (iter.hasNext()) {
            ((DataGroup)iter.next()).addChangeListener(this);
        }
        this.fireStateChanged();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        Color saved = this.background;
        this.background = background;
        if (!saved.equals(this.background)) {
            this.fireStateChanged();
        }
    }

    public boolean isUsePageBackground() {
        return this.usePageBackground;
    }

    public void setUsePageBackground(boolean pageBackground) {
        boolean saved = this.usePageBackground;
        this.usePageBackground = pageBackground;
        if (saved != this.usePageBackground) {
            this.fireStateChanged();
        }
    }

    static {
        try {
            BeanInfo info = Introspector.getBeanInfo(PanelHolder.class);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                PropertyDescriptor pd = descriptors[i];
                if (pd.getName().equals("instantiated")) {
                    pd.setValue("transient", Boolean.TRUE);
                    continue;
                }
                if (!pd.getName().equals("panelModel")) continue;
                pd.setValue("transient", Boolean.TRUE);
            }
        }
        catch (IntrospectionException ie) {
            ie.printStackTrace();
        }
    }
}

