/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.BorderDialog;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PropertyPanel;
import gov.noaa.pmel.sgt.swing.prop.ColorDialog;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PanelHolderPropertyPanel
extends PropertyPanel
implements ActionListener,
ChangeListener,
FocusListener {
    private boolean expert_ = false;
    private PanelHolder pHolder_ = null;
    private String[] pNames_ = new String[]{"Background", "Border", "Bounds", "Data Groups", "Id", "Labels", "Legends", "Page Background", "Visible"};
    private JComponent[] comps_ = new JComponent[this.pNames_.length];

    public PanelHolderPropertyPanel(PanelHolder ph, boolean expert) {
        this.pHolder_ = ph;
        this.pHolder_.addChangeListener(this);
        this.expert_ = expert;
        this.create();
    }

    public void setPanelHolder(PanelHolder ph, boolean expert) {
        if (this.pHolder_ != null) {
            this.pHolder_.removeChangeListener(this);
        }
        this.pHolder_ = ph;
        this.pHolder_.addChangeListener(this);
        this.expert_ = expert;
        this.reset();
    }

    @Override
    void create() {
        int i = -1;
        this.comps_[++i] = this.createColor(this.pHolder_.getBackground(), this.pNames_[i], this);
        this.comps_[++i] = this.createBorder(this.pHolder_.getBorder(), this.pNames_[i], this);
        Rectangle b = this.pHolder_.getBounds();
        this.comps_[++i] = this.createLabel(b.x + ", " + b.y + ", " + b.width + ", " + b.height);
        this.comps_[++i] = this.createLabel(this.pHolder_.getDataGroupSize());
        String string = this.pNames_[++i];
        this.comps_[i] = this.createTextField(this.pHolder_.getId(), string, this, !this.pHolder_.isInstantiated());
        this.comps_[++i] = this.createLabel(this.pHolder_.getLabelSize());
        this.comps_[++i] = this.createLabel(this.pHolder_.getLegendSize());
        this.comps_[++i] = this.createCheckBox(this.pHolder_.isUsePageBackground(), this.pNames_[i], this);
        this.comps_[++i] = this.createCheckBox(this.pHolder_.isVisible(), this.pNames_[i], this);
        for (i = 0; i < this.comps_.length; ++i) {
            this.addProperty(i + 1, this.pNames_[i], this.comps_[i], false);
        }
        this.addProperty(this.comps_.length + 1, " ", new JLabel(" "), true);
    }

    @Override
    void resetFields() {
        for (int i = 0; i < this.comps_.length; ++i) {
            if (this.comps_[i] instanceof JTextField) {
                ((JTextField)this.comps_[i]).removeActionListener(this);
                ((JTextField)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JCheckBox) {
                ((JCheckBox)this.comps_[i]).removeActionListener(this);
                ((JCheckBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (this.comps_[i] instanceof JComboBox) {
                ((JComboBox)this.comps_[i]).removeActionListener(this);
                ((JComboBox)this.comps_[i]).removeFocusListener(this);
                continue;
            }
            if (!(this.comps_[i] instanceof JButton)) continue;
            ((JButton)this.comps_[i]).removeActionListener(this);
            ((JButton)this.comps_[i]).removeFocusListener(this);
        }
    }

    @Override
    void update() {
        int i = -1;
        this.updateColor((JButton)this.comps_[++i], this.pHolder_.getBackground());
        this.updateBorder((JButton)this.comps_[++i], this.pHolder_.getBorder());
        Rectangle b = this.pHolder_.getBounds();
        ((JLabel)this.comps_[++i]).setText(b.x + ", " + b.y + ", " + b.width + ", " + b.height);
        ((JLabel)this.comps_[++i]).setText(Integer.toString(this.pHolder_.getDataGroupSize()));
        ((JTextField)this.comps_[++i]).setText(this.pHolder_.getId());
        ((JLabel)this.comps_[++i]).setText(Integer.toString(this.pHolder_.getLabelSize()));
        ((JLabel)this.comps_[++i]).setText(Integer.toString(this.pHolder_.getLegendSize()));
        ((JCheckBox)this.comps_[++i]).setSelected(this.pHolder_.isUsePageBackground());
        ((JCheckBox)this.comps_[++i]).setSelected(this.pHolder_.isVisible());
    }

    private void processEvent(Object obj, String command) {
        if (command.equals("Border")) {
            BorderDialog bd = new BorderDialog(null, "Select Border", true);
            bd.setBorder(this.pHolder_.getBorder());
            bd.setVisible(true);
            this.pHolder_.setBorder(bd.getBorder());
        } else if (command.equals("Id")) {
            String oldId = this.pHolder_.getId();
            this.pHolder_.getPanelModel().getPanelList().remove(oldId);
            this.pHolder_.setId(((JTextField)obj).getText());
            this.pHolder_.getPanelModel().getPanelList().put(this.pHolder_.getId(), this.pHolder_);
        } else if (command.equals("Visible")) {
            this.pHolder_.setVisible(((JCheckBox)obj).isSelected());
        } else if (command.equals("Background")) {
            ColorDialog cd = new ColorDialog(this.getFrame(), "Select Axis Color", true);
            cd.setColor(this.pHolder_.getBackground());
            cd.setVisible(true);
            Color newcolor = cd.getColor();
            if (newcolor != null) {
                this.pHolder_.setBackground(newcolor);
                this.updateColor((JButton)obj, newcolor);
            }
        } else if (command.equals("Page Background")) {
            this.pHolder_.setUsePageBackground(((JCheckBox)obj).isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        String command = e.getActionCommand();
        this.processEvent(obj, command);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.update();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JTextField) {
            JTextField tf = (JTextField)obj;
            String name = tf.getName();
            this.processEvent(obj, name);
        }
    }

    private JButton createBorder(Border value, String action, ActionListener listen) {
        JButton jb = new JButton(this.getBorderDescription(value));
        jb.setActionCommand(action);
        if (listen != null) {
            jb.addActionListener(listen);
        }
        return jb;
    }

    private void updateBorder(JButton comp, Border value) {
        comp.setText(this.getBorderDescription(value));
    }

    private String getBorderDescription(Border border) {
        String description = "None";
        if (border != null) {
            if (border instanceof BevelBorder) {
                description = "Beveled";
            } else if (border instanceof EtchedBorder) {
                description = "Etched";
            } else if (border instanceof LineBorder) {
                description = "Line";
            } else if (border instanceof TitledBorder) {
                description = "Titled";
            }
        }
        return description;
    }

    @Override
    public void setExpert(boolean expert) {
        this.expert_ = expert;
    }

    @Override
    public boolean isExpert() {
        return this.expert_;
    }
}

