/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.beans;

import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DesignListener;
import gov.noaa.pmel.sgt.beans.Label;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelModel
implements Serializable,
ChangeListener,
ComponentListener,
PropertyChangeListener {
    private transient PropertyChangeSupport support_ = new PropertyChangeSupport(this);
    private Map panelList = new HashMap(4);
    private float dpi = 72.0f;
    private Dimension pageSize = new Dimension(400, 300);
    private Color pageBackgroundColor = Color.white;
    private int printHAlign = 1;
    private int printVAlign = 0;
    private int printMode = 1;
    private Point printOrigin = new Point(0, 0);
    private boolean printBorders = false;
    private boolean printWhitePage = true;
    private boolean resetZoomOnCntrlButton1 = true;
    private transient boolean batch = false;
    private transient boolean modified = false;
    private transient ChangeEvent changeEvent_ = new ChangeEvent(this);
    private transient Vector changeListeners;
    private transient Page page;

    public static PanelModel loadFromXML(InputStream is) throws InvalidObjectException {
        PanelModel pModel = null;
        XMLDecoder xd = new XMLDecoder(is);
        Object obj = xd.readObject();
        xd.close();
        if (!(obj instanceof PanelModel)) {
            throw new InvalidObjectException("XML file does not contain a PanelModel");
        }
        pModel = (PanelModel)obj;
        pModel.repair();
        return pModel;
    }

    public void saveToXML(OutputStream os) {
        XMLEncoder xe = new XMLEncoder(os);
        xe.writeObject(this);
        xe.close();
    }

    public void addPanel(String id, Rectangle bounds, Map labels, Map dataGroups, Map legends) {
        PanelHolder ph = new PanelHolder(id, this, bounds, labels, dataGroups, legends);
        this.addPanel(ph);
    }

    public void addPanel(PanelHolder ph) {
        int sze = this.panelList.size();
        ph.addChangeListener(this);
        this.panelList.put(ph.getId(), ph);
        this.firePropertyChange("panelList", sze, this.panelList.size());
    }

    public void removePanel(PanelHolder ph) {
        int sze = this.panelList.size();
        ph.removeChangeListener(this);
        this.panelList.remove(ph.getId());
        this.firePropertyChange("panelList", sze, this.panelList.size());
    }

    public Iterator panelIterator() {
        return this.panelList.values().iterator();
    }

    public int getPanelCount() {
        return this.panelList.size();
    }

    public boolean hasPanelHolder(String id) {
        return this.findPanelHolder(id) != null;
    }

    public PanelHolder findPanelHolder(String id) {
        return (PanelHolder)this.panelList.get(id);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.support_ == null) {
            this.support_ = new PropertyChangeSupport(this);
        }
        this.support_.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        if (this.support_ == null) {
            this.support_ = new PropertyChangeSupport(this);
        }
        this.support_.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support_.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.support_.removePropertyChangeListener(name, l);
    }

    public float getDpi() {
        return this.dpi;
    }

    public void setDpi(float dpi) {
        float saved = this.dpi;
        this.dpi = dpi;
        if (saved != this.dpi) {
            this.firePropertyChange("dpi", new Float(saved), new Float(this.dpi));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        this.firePropertyChange("panel", null, source);
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.batch) {
            this.modified = true;
        } else {
            this.support_.firePropertyChange(name, oldValue, newValue);
        }
    }

    private void firePropertyChange(String name, int oldValue, int newValue) {
        if (this.batch) {
            this.modified = true;
        } else {
            this.support_.firePropertyChange(name, oldValue, newValue);
        }
    }

    private void firePropertyChange(String name, boolean oldValue, boolean newValue) {
        if (this.batch) {
            this.modified = true;
        } else {
            this.support_.firePropertyChange(name, oldValue, newValue);
        }
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
        if (!this.batch && this.modified) {
            this.modified = false;
            this.support_.firePropertyChange("batch", null, null);
        }
    }

    void repair() {
        Iterator iter = this.panelIterator();
        while (iter.hasNext()) {
            PanelHolder ph = (PanelHolder)iter.next();
            ph.removeAllChangeListeners();
            ph.addChangeListener(this);
            ph.setPanelModel(this);
            Iterator dgIter = ph.dataGroupIterator();
            while (dgIter.hasNext()) {
                DataGroup dg = (DataGroup)dgIter.next();
                dg.removeAllChangeListeners();
                dg.addChangeListener(ph);
                dg.setPanelHolder(ph);
                dg.getXAxisHolder().removeAllChangeListeners();
                dg.getXAxisHolder().addChangeListener(dg);
                dg.getXAxisHolder().setDataGroup(dg);
                dg.getYAxisHolder().removeAllChangeListeners();
                dg.getYAxisHolder().addChangeListener(dg);
                dg.getYAxisHolder().setDataGroup(dg);
            }
            Iterator lbIter = ph.labelIterator();
            while (lbIter.hasNext()) {
                Label lb = (Label)lbIter.next();
                lb.removeAllChangeListeners();
                lb.addChangeListener(ph);
                lb.setPanelHolder(ph);
            }
            Iterator lgIter = ph.legendIterator();
            while (lgIter.hasNext()) {
                Legend lg = (Legend)lgIter.next();
                lg.removeAllChangeListeners();
                lg.addChangeListener(ph);
                lg.setPanelHolder(ph);
            }
        }
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setPage(Page page) {
        if (this.page != null) {
            this.removePropertyChangeListener(this.page);
        }
        this.page = page;
        this.addPropertyChangeListener(this.page);
        page.addComponentListener(this);
        page.addPropertyChangeListener(new WeakPropertyChangeListener(this, page));
        this.pageSize = page.getSize();
    }

    public Page getPage() {
        return this.page;
    }

    public Map getPanelList() {
        return this.panelList;
    }

    public void setPanelList(Map panelList) {
        this.panelList = panelList;
        Iterator iter = this.panelIterator();
        while (iter.hasNext()) {
            PanelHolder ph = (PanelHolder)iter.next();
            ph.addChangeListener(this);
        }
        this.firePropertyChange("panelList", 0, panelList.size());
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Dimension pageSize) {
        Dimension saved = this.pageSize;
        this.pageSize = pageSize;
        if (!saved.equals(this.pageSize)) {
            this.firePropertyChange("pageSize", saved, pageSize);
            this.fireStateChanged();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.pageSize = this.page.getSize();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public Color getPageBackgroundColor() {
        return this.pageBackgroundColor;
    }

    public void setPageBackgroundColor(Color pageBackgroundColor) {
        Color saved = this.pageBackgroundColor;
        this.pageBackgroundColor = pageBackgroundColor;
        if (!saved.equals(this.pageBackgroundColor)) {
            this.firePropertyChange("pageBackgroundColor", saved, this.pageBackgroundColor);
            this.fireStateChanged();
        }
    }

    public boolean isPrintBorders() {
        return this.printBorders;
    }

    public boolean isPrintWhitePage() {
        return this.printWhitePage;
    }

    public void setPrintBorders(boolean printBorders) {
        boolean saved = this.printBorders;
        this.printBorders = printBorders;
        if (saved != this.printBorders) {
            this.firePropertyChange("printBorders", new Boolean(saved), new Boolean(this.printBorders));
        }
    }

    public void setPrintWhitePage(boolean printWhitePage) {
        boolean saved = this.printWhitePage;
        this.printWhitePage = printWhitePage;
        if (saved != this.printWhitePage) {
            this.firePropertyChange("printWhitePage", new Boolean(saved), new Boolean(this.printWhitePage));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void removeDesignChangeListeners() {
        if (this.changeListeners != null) {
            Vector v = (Vector)this.changeListeners.clone();
            for (Object obj : v) {
                if (!(obj instanceof DesignListener)) continue;
                this.changeListeners.removeElement(obj);
            }
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    protected void fireStateChanged() {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            for (int i = 0; i < count; ++i) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(this.changeEvent_);
            }
        }
    }

    public int getPrintHAlign() {
        return this.printHAlign;
    }

    public void setPrintHAlign(int printHAlign) {
        int saved = this.printHAlign;
        this.printHAlign = printHAlign;
        if (saved != this.printHAlign) {
            this.firePropertyChange("printHAlign", saved, this.printHAlign);
        }
    }

    public void setPrintOrigin(Point printOrigin) {
        Point saved = this.printOrigin;
        this.printOrigin = printOrigin;
        if (!saved.equals(this.printOrigin)) {
            this.firePropertyChange("printOrigin", saved, this.printOrigin);
        }
    }

    public Point getPrintOrigin() {
        return this.printOrigin;
    }

    public int getPrintVAlign() {
        return this.printVAlign;
    }

    public void setPrintVAlign(int printVAlign) {
        int saved = this.printVAlign;
        this.printVAlign = printVAlign;
        if (saved != this.printVAlign) {
            this.firePropertyChange("printVAlign", saved, this.printVAlign);
        }
    }

    public int getPrintScaleMode() {
        return this.printMode;
    }

    public void setPrintScaleMode(int mode) {
        int saved = this.printMode;
        this.printMode = mode;
        if (saved != this.printMode) {
            this.firePropertyChange("printScaleMode", saved, this.printMode);
        }
    }

    public void setResetZoomOnCntrlButton1(boolean onCntrl) {
        boolean saved = this.resetZoomOnCntrlButton1;
        this.resetZoomOnCntrlButton1 = onCntrl;
        if (saved != this.resetZoomOnCntrlButton1) {
            this.firePropertyChange("zoomOnCntrlButton1", saved, onCntrl);
        }
    }

    public boolean isResetZoomOnCntrlButton1() {
        return this.resetZoomOnCntrlButton1;
    }
}

