/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.contour;

import java.util.BitSet;

class Sides {
    BitSet sides_;
    int nx_;
    int ny_;
    int ny2_;

    public Sides(int nx, int ny) {
        this.nx_ = nx;
        this.ny_ = ny;
        this.ny2_ = this.ny_ * 2;
        this.sides_ = new BitSet(this.ny2_ * this.nx_);
    }

    public boolean isSideUsed(int i, int j, int side2) {
        int ind = this.index(i, j, side2);
        if (ind < 0 || ind > this.ny2_ * this.nx_ - 1) {
            return false;
        }
        return this.sides_.get(ind);
    }

    public void setSideUsed(int i, int j, int side2, boolean set) {
        int ind = this.index(i, j, side2);
        if (set) {
            this.sides_.set(ind);
        } else {
            this.sides_.clear(ind);
        }
    }

    public int getSide(int i, int j, int side2) {
        int ind = this.index(i, j, side2);
        if (ind < 0 || ind > this.ny2_ * this.nx_ - 1) {
            return 0;
        }
        return this.sides_.get(ind) ? 1 : 0;
    }

    int index(int i, int j, int side2) {
        int index = -10;
        if (side2 == 1) {
            index = 1 + j * 2 + (i + 1) * this.ny2_;
        } else if (side2 == 2) {
            index = (j + 1) * 2 + i * this.ny2_;
        } else if (side2 == 0) {
            index = j * 2 + i * this.ny2_;
        } else if (side2 == 3) {
            index = 1 + j * 2 + i * this.ny2_;
        }
        return index;
    }

    public void clear() {
        this.sides_ = new BitSet(this.ny2_ * this.nx_);
    }
}

