/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.contour;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.Cartesian;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;

public class ZGrid
extends AbstractData
implements SGTGrid,
Cartesian,
Cloneable {
    protected double[] xloc_;
    protected double[] yloc_;
    protected GeoDateArray tloc_;
    protected double[] grid_;
    protected double[] xEdges_;
    protected double[] yEdges_;
    protected GeoDateArray tEdges_;
    protected boolean hasXEdges_;
    protected boolean hasYEdges_;
    protected SGTMetaData zMetaData_ = null;
    protected SGTGrid associatedData_;
    protected SoTRange xEdgesRange_ = null;
    protected SoTRange yEdgesRange_ = null;
    protected Range2D zRange_ = null;
    private double cay_;
    private int nrng_;
    private double x1_;
    private double y1_;
    private double dx_;
    private double dy_;
    private int nx_;
    private int ny_;

    public ZGrid(int nx, int ny, double x1, double y1, double dx, double dy, double[] xp, double[] yp, double[] zp, double cay, int nrng) {
        this.nx_ = nx;
        this.ny_ = ny;
        this.x1_ = x1;
        this.y1_ = y1;
        this.dx_ = dx;
        this.dy_ = dy;
        this.cay_ = cay;
        this.nrng_ = nrng;
        this.xloc_ = new double[nx];
        this.yloc_ = new double[ny];
        this.grid_ = new double[nx * ny];
        for (int i = 0; i < nx; ++i) {
            this.xloc_[i] = x1 + (double)i * dx;
        }
        for (int j = 0; j < ny; ++j) {
            this.yloc_[j] = y1 + (double)j * dy;
        }
        this.xRange_ = this.computeSoTRange(this.xloc_);
        this.yRange_ = this.computeSoTRange(this.yloc_);
        this.createGrid(xp, yp, zp);
        this.zRange_ = this.computeRange2D(this.grid_);
    }

    @Override
    public double[] getXArray() {
        return this.xloc_;
    }

    @Override
    public int getXSize() {
        return this.xloc_.length;
    }

    @Override
    public double[] getYArray() {
        return this.yloc_;
    }

    @Override
    public int getYSize() {
        return this.yloc_.length;
    }

    @Override
    public double[] getZArray() {
        return this.grid_;
    }

    @Override
    public Range2D getZRange() {
        return this.zRange_;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return this.tloc_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return this.tloc_;
    }

    @Override
    public int getTSize() {
        return this.tloc_.getLength();
    }

    @Override
    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    @Override
    public SGTGrid getAssociatedData() {
        return this.associatedData_;
    }

    @Override
    public boolean hasAssociatedData() {
        return this.associatedData_ != null;
    }

    @Override
    public boolean hasXEdges() {
        return this.hasXEdges_;
    }

    @Override
    public double[] getXEdges() {
        return this.xEdges_;
    }

    @Override
    public SoTRange getXEdgesRange() {
        return this.xEdgesRange_;
    }

    @Override
    public boolean hasYEdges() {
        return this.hasYEdges_;
    }

    @Override
    public double[] getYEdges() {
        return this.yEdges_;
    }

    @Override
    public SoTRange getYEdgesRange() {
        return this.yEdgesRange_;
    }

    @Override
    public GeoDate[] getTimeEdges() {
        return this.tEdges_.getGeoDate();
    }

    @Override
    public GeoDateArray getGeoDateArrayEdges() {
        return this.tEdges_;
    }

    @Override
    public SGTData copy() {
        SGTGrid newGrid;
        try {
            newGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid();
        }
        return newGrid;
    }

    public void setZMetaData(SGTMetaData md) {
        this.zMetaData_ = md;
    }

    @Override
    public double getValueAt(SoTValue x, SoTValue y) {
        return Double.NaN;
    }

    public void setAssociatedData(SGTGrid assoc) {
        this.associatedData_ = assoc;
        this.changes_.firePropertyChange("associatedDataModified", null, assoc);
    }

    private SoTRange computeSoTRange(double[] array) {
        Range2D range = this.computeRange2D(array);
        return new SoTRange.Double(range.start, range.end);
    }

    private Range2D computeRange2D(double[] array) {
        if (array == null) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int count = 0;
        for (int i = 0; i < array.length; ++i) {
            if (Double.isNaN(array[i])) continue;
            start = Math.min(start, array[i]);
            end = Math.max(end, array[i]);
            ++count;
        }
        if (count == 0) {
            return new Range2D(Double.NaN, Double.NaN);
        }
        return new Range2D(start, end);
    }

    private double z(int i, int j) {
        return this.grid_[j + i * this.ny_];
    }

    private double absZ(int i, int j) {
        double abs = this.z(i, j);
        if (Double.isInfinite(abs) || Double.isNaN(abs)) {
            return Double.NaN;
        }
        return Math.abs(abs);
    }

    private void setZ(int i, int j, double val) {
        this.grid_[j + i * this.ny_] = val;
    }

    private void createGrid(double[] xp, double[] yp, double[] zp) {
        int iter;
        double zsum;
        int npt;
        int j;
        int i;
        int kk;
        int k;
        int n = xp.length;
        double[] zpij = new double[n];
        int[] knxt = new int[n];
        int[] imnew = new int[this.ny_];
        int[] kksav = new int[500];
        double dzrms8 = 1.0;
        int itmax = 100;
        double eps = 0.002;
        double zmin = Double.MAX_VALUE;
        double zmax = -1.7976931348623157E308;
        for (k = 0; k < n; ++k) {
            if (Double.isNaN(zp[k])) continue;
            if (zp[k] > zmax) {
                zmax = zp[k];
            }
            if (!(zp[k] < zmin)) continue;
            zmin = zp[k];
        }
        double zrange = zmax - zmin;
        double zbase = zrange * 20.0 - zmin;
        double hrange = Math.min(this.dx_ * (double)(this.nx_ - 1), this.dy_ * (double)(this.ny_ - 1));
        double derzm = 2.0 * zrange / hrange;
        for (kk = 1; kk <= n; ++kk) {
            k = n - kk;
            knxt[k] = 0;
            i = (int)((xp[k] - this.x1_) / this.dx_ + 0.5);
            if (i < 0 || i >= this.nx_ || (j = (int)((yp[k] - this.y1_) / this.dy_ + 0.5)) < 0 || j >= this.ny_ || Double.isNaN(this.z(i, j))) continue;
            knxt[k] = n + 1;
            if (this.z(i, j) > 0.0) {
                knxt[k] = (int)(this.z(i, j) + 0.5);
            }
            this.setZ(i, j, k);
        }
        for (k = 0; k < n; ++k) {
            if (knxt[k] <= 0) continue;
            npt = 0;
            boolean imask = false;
            zsum = 0.0;
            i = (int)((xp[k] - this.x1_) / this.dx_ + 0.5);
            j = (int)((yp[k] - this.y1_) / this.dy_ + 0.5);
            kk = k;
            do {
                kksav[++npt] = kk;
                if (Double.isNaN(zp[kk])) {
                    imask = true;
                }
                zsum += zp[kk];
                knxt[kk] = -knxt[kk];
            } while ((kk = -knxt[kk]) < n);
            if (!imask) {
                this.setZ(i, j, -zsum / (double)npt - zbase);
                continue;
            }
            this.setZ(i, j, Double.NaN);
            for (i = 0; i < npt; ++i) {
                knxt[kksav[i]] = 0;
            }
        }
        for (i = 0; i < this.nx_; ++i) {
            for (j = 0; j < this.ny_; ++j) {
                if (this.z(i, j) != 0.0) continue;
                this.setZ(i, j, Double.POSITIVE_INFINITY);
            }
        }
        int jmnew = 0;
        for (iter = 1; iter <= this.nrng_; ++iter) {
            int nnew = 0;
            for (i = 0; i < this.nx_; ++i) {
                for (j = 0; j < this.ny_; ++j) {
                    if (Double.isInfinite(this.z(i, j))) {
                        double zijn;
                        if (j >= 1 && jmnew <= 0 && !Double.isNaN(zijn = this.absZ(i, j - 1))) {
                            imnew[j] = 1;
                            jmnew = 1;
                            this.setZ(i, j, zijn);
                            ++nnew;
                            continue;
                        }
                        if (i >= 1 && imnew[j] <= 0 && !Double.isNaN(zijn = this.absZ(i - 1, j))) {
                            imnew[j] = 1;
                            jmnew = 1;
                            this.setZ(i, j, zijn);
                            ++nnew;
                            continue;
                        }
                        if (j < this.ny_ - 1 && !Double.isNaN(zijn = this.absZ(i, j + 1))) {
                            imnew[j] = 1;
                            jmnew = 1;
                            this.setZ(i, j, zijn);
                            ++nnew;
                            continue;
                        }
                        if (i >= this.nx_ - 1 || Double.isNaN(zijn = this.absZ(i + 1, j))) continue;
                        imnew[j] = 1;
                        jmnew = 1;
                        this.setZ(i, j, zijn);
                        ++nnew;
                        continue;
                    }
                    imnew[j] = 0;
                    jmnew = 0;
                }
            }
            if (nnew <= 0) break;
        }
        for (i = 0; i < this.nx_; ++i) {
            for (j = 0; j < this.ny_; ++j) {
                double abz = this.absZ(i, j);
                if (!Double.isNaN(abz)) continue;
                this.setZ(i, j, Double.NaN);
            }
        }
        double dzrmsp = zrange;
        double relax = 1.0;
        double zim = 0.0;
        double zjm = 0.0;
        for (iter = 1; iter <= itmax; ++iter) {
            double z00;
            double dzrms = 0.0;
            double dzmax = 0.0;
            int npg = 0;
            for (i = 0; i < this.nx_; ++i) {
                for (j = 0; j < this.ny_; ++j) {
                    double zjp;
                    double zip;
                    z00 = this.z(i, j);
                    if (Double.isNaN(z00) || !(z00 >= 0.0)) continue;
                    double wgt = 0.0;
                    zsum = 0.0;
                    int im = 0;
                    if (i >= 1 && !Double.isNaN(zim = this.absZ(i - 1, j))) {
                        double zimm;
                        im = 1;
                        wgt += 1.0;
                        zsum += zim;
                        if (i >= 2 && !Double.isNaN(zimm = this.absZ(i - 2, j))) {
                            wgt += this.cay_;
                            zsum -= this.cay_ * (zimm - 2.0 * zim);
                        }
                    }
                    if (this.nx_ - 1 > i && !Double.isNaN(zip = this.absZ(i + 1, j))) {
                        double zipp;
                        wgt += 1.0;
                        zsum += zip;
                        if (im > 0) {
                            wgt += 4.0 * this.cay_;
                            zsum += 2.0 * this.cay_ * (zim + zip);
                        }
                        if (this.nx_ - 2 > i && !Double.isNaN(zipp = this.absZ(i + 2, j))) {
                            wgt += this.cay_;
                            zsum -= this.cay_ * (zipp - 2.0 * zip);
                        }
                    }
                    int jm = 0;
                    if (j >= 1 && !Double.isNaN(zjm = this.absZ(i, j - 1))) {
                        double zjmm;
                        jm = 1;
                        wgt += 1.0;
                        zsum += zjm;
                        if (j >= 2 && !Double.isNaN(zjmm = this.absZ(i, j - 2))) {
                            wgt += this.cay_;
                            zsum -= this.cay_ * (zjmm - 2.0 * zjm);
                        }
                    }
                    if (this.ny_ - 1 > j && !Double.isNaN(zjp = this.absZ(i, j + 1))) {
                        double zjpp;
                        wgt += 1.0;
                        zsum += zjp;
                        if (jm > 0) {
                            wgt += 4.0 * this.cay_;
                            zsum += 2.0 * this.cay_ * (zjm + zjp);
                        }
                        if (this.ny_ - 2 > j && !Double.isNaN(zjpp = this.absZ(i, j + 2))) {
                            wgt += this.cay_;
                            zsum -= this.cay_ * (zjpp - 2.0 * zjp);
                        }
                    }
                    double dz = zsum / wgt - z00;
                    ++npg;
                    dzrms += dz * dz;
                    dzmax = Math.max(Math.abs(dz), dzmax);
                    this.setZ(i, j, z00 + dz * relax);
                }
            }
            if (iter == iter / 10 * 10) {
                for (k = 0; k < n; ++k) {
                    knxt[k] = Math.abs(knxt[k]);
                    if (knxt[k] <= 0) continue;
                    double x = (xp[k] - this.x1_) / this.dx_;
                    i = (int)(x + 0.5);
                    x -= (double)i;
                    double y = (yp[k] - this.y1_) / this.dy_;
                    j = (int)(y + 0.5);
                    y -= (double)j;
                    double zpxy = zp[k] + zbase;
                    z00 = this.absZ(i, j);
                    double zw = Double.NaN;
                    if (i >= 1) {
                        zw = this.absZ(i - 1, j);
                    }
                    double ze = Double.NaN;
                    if (i < this.nx_ - 1) {
                        ze = this.absZ(i + 1, j);
                    }
                    if (Double.isNaN(ze)) {
                        if (Double.isNaN(zw)) {
                            ze = z00;
                            zw = z00;
                        } else {
                            ze = 2.0 * z00 - zw;
                        }
                    } else if (Double.isNaN(zw)) {
                        zw = 2.0 * z00 - ze;
                    }
                    double zs = Double.NaN;
                    if (j >= 1) {
                        zs = this.absZ(i, j - 1);
                    }
                    double zn = Double.NaN;
                    if (j < this.ny_ - 1) {
                        zn = this.absZ(i, j + 1);
                    }
                    if (Double.isNaN(zn)) {
                        if (Double.isNaN(zs)) {
                            zs = z00;
                            zn = z00;
                        } else {
                            zn = 2.0 * z00 - zs;
                        }
                    } else if (Double.isNaN(zs)) {
                        zs = 2.0 * z00 - zn;
                    }
                    double a = (ze - zw) * 0.5;
                    double b = (zn - zs) * 0.5;
                    double c = (ze + zw) * 0.5 - z00;
                    double d = (zn + zs) * 0.5 - z00;
                    double zxy = z00 + a * x + b * y + c * x * x + d * y * y;
                    double delz = z00 - zxy;
                    double delzm = derzm * (Math.abs(x) * this.dx_ + Math.abs(y) * this.dy_) * 0.8;
                    if (delz > delzm) {
                        delz = delzm;
                    }
                    if (delz < -delzm) {
                        delz = -delzm;
                    }
                    zpij[k] = zpxy + delz;
                }
                for (k = 0; k < n; ++k) {
                    if (knxt[k] <= 0) continue;
                    npt = 0;
                    zsum = 0.0;
                    i = (int)((xp[k] - this.x1_) / this.dx_ + 0.5);
                    j = (int)((yp[k] - this.y1_) / this.dy_ + 0.5);
                    kk = k;
                    do {
                        ++npt;
                        zsum += zpij[kk];
                        knxt[kk] = -knxt[kk];
                    } while ((kk = -knxt[kk]) <= n);
                    this.setZ(i, j, -zsum / (double)npt);
                }
            }
            if (npg == 0) break;
            dzrms = Math.sqrt(dzrms / (double)npg);
            double root = dzrms / dzrmsp;
            dzrmsp = dzrms;
            double dzmaxf = dzmax / zrange;
            if (iter - iter / 10 * 10 == 2) {
                dzrms8 = dzrms;
            }
            if (iter != iter / 10 * 10 || !((root = Math.sqrt(Math.sqrt(Math.sqrt(dzrms / dzrms8)))) < 0.9999)) continue;
            if (dzmaxf / (1.0 - root) <= eps) break;
            if ((iter - 20) * (iter - 40) * (iter - 60) != 0 || !(relax - 1.0 < root)) continue;
            double tpy = (root + relax - 1.0) / relax;
            double rootgs = tpy * tpy / root;
            double relaxn = 2.0 / (1.0 + Math.sqrt(1.0 - rootgs));
            if (iter != 60) {
                relaxn -= 0.25 * (2.0 - relaxn);
            }
            relax = Math.max(relax, relaxn);
        }
        for (i = 0; i < this.nx_; ++i) {
            for (j = 0; j < this.ny_; ++j) {
                if (Double.isNaN(this.z(i, j))) continue;
                this.setZ(i, j, this.absZ(i, j) - zbase);
            }
        }
    }
}

