/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.beans.DataGroup;
import gov.noaa.pmel.sgt.beans.DataModel;
import gov.noaa.pmel.sgt.beans.Legend;
import gov.noaa.pmel.sgt.beans.MouseValue;
import gov.noaa.pmel.sgt.beans.MouseValueEvent;
import gov.noaa.pmel.sgt.beans.MouseValueListener;
import gov.noaa.pmel.sgt.beans.Page;
import gov.noaa.pmel.sgt.beans.Panel;
import gov.noaa.pmel.sgt.beans.PanelHolder;
import gov.noaa.pmel.sgt.beans.PanelModel;
import gov.noaa.pmel.sgt.beans.PanelModelEditor;
import gov.noaa.pmel.sgt.demo.AddDataFrame;
import gov.noaa.pmel.sgt.demo.BeanDemoValue;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.MeasurementTool;
import gov.noaa.pmel.sgt.swing.SelectionTool;
import gov.noaa.pmel.sgt.swing.ValueIcon;
import gov.noaa.pmel.sgt.swing.ValueIconFormat;
import gov.noaa.pmel.swing.JSystemPropertiesDialog;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.IllegalTimeValue;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.TimeRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyVetoException;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

class BeanDemoFrame
extends JFrame
implements MouseValueListener {
    private Page page = new Page();
    private PanelModel panelModel = new PanelModel();
    private DataModel dataModel = new DataModel();
    private SGTData timeSeries;
    private Attribute timeSeriesAttr;
    private SGTData grid;
    private Attribute gridAttr;
    private JPanel contentPane;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JMenu jMenuView = new JMenu();
    private JMenuItem jMenuViewReset = new JMenuItem();
    private JMenuItem jMenuViewTree = new JMenuItem();
    private JMenuItem jMenuViewMouse = new JMenuItem();
    private JPanel pagePanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JMenuItem jMenuHelpProps = new JMenuItem();
    private JMenu jMenuEdit = new JMenu();
    private JMenuItem jMenuEditData = new JMenuItem();
    private JMenuItem jMenuEditPM = new JMenuItem();
    private JMenuItem jMenuFilePrint = new JMenuItem();
    private JMenuItem jMenuFilePage = new JMenuItem();
    private PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
    JMenuItem jMenuEditRemoveAll = new JMenuItem();
    private BeanDemoValue beanValue = null;

    public BeanDemoFrame() {
        this.enableEvents(64L);
        this.page.getJPane().setBackground(Color.lightGray);
        this.page.setName("Demo");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.createGraphic();
        this.pack();
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setTitle("SGT Bean Demo");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jMenuView.setText("View");
        this.jMenuViewReset.setText("Reset All Zoom");
        this.jMenuViewReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuViewReset_actionPerformed(e);
            }
        });
        this.jMenuViewTree.setText("Class Tree...");
        this.jMenuViewTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuViewTree_actionPerformed(e);
            }
        });
        this.jMenuViewMouse.setText("Mouse Values...");
        this.jMenuViewMouse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuViewMouse_actionPerformed(e);
            }
        });
        this.pagePanel.setLayout(this.borderLayout2);
        this.jMenuHelpProps.setText("System Properties...");
        this.jMenuHelpProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuHelpProps_actionPerformed(e);
            }
        });
        this.jMenuEdit.setText("Edit");
        this.jMenuEditData.setText("Add Data...");
        this.jMenuEditData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuEditData_actionPerformed(e);
            }
        });
        this.jMenuEditPM.setText("PanelModel");
        this.jMenuEditPM.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuEditPM_actionPerformed(e);
            }
        });
        this.jMenuFilePrint.setText("Print...");
        this.jMenuFilePrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuFilePrint_actionPerformed(e);
            }
        });
        this.jMenuFilePage.setText("Page Layout...");
        this.jMenuFilePage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuFilePage_actionPerformed(e);
            }
        });
        this.jMenuEditRemoveAll.setText("Remove All Data");
        this.jMenuEditRemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BeanDemoFrame.this.jMenuEditRemoveAll_actionPerformed(e);
            }
        });
        this.jMenuFile.add(this.jMenuFilePage);
        this.jMenuFile.add(this.jMenuFilePrint);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpProps);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuEdit);
        this.jMenuBar1.add(this.jMenuView);
        this.jMenuBar1.add(this.jMenuHelp);
        this.jMenuView.add(this.jMenuViewMouse);
        this.jMenuView.add(this.jMenuViewReset);
        this.jMenuView.add(this.jMenuViewTree);
        this.contentPane.add((Component)this.pagePanel, "Center");
        this.jMenuEdit.add(this.jMenuEditData);
        this.jMenuEdit.add(this.jMenuEditPM);
        this.jMenuEdit.addSeparator();
        this.jMenuEdit.add(this.jMenuEditRemoveAll);
        this.setJMenuBar(this.jMenuBar1);
    }

    private void jMenuFileExit_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    private void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        JOptionPane.showMessageDialog(this, "BeanDemo: SGT version 3.5", "About BeanDemo", 1);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    private void createGraphic() {
        this.pagePanel.add((Component)this.page, "Center");
        this.page.setDataModel(this.dataModel);
        try {
            this.panelModel = PanelModel.loadFromXML(this.getClass().getResource("BeanDemoPanelModel.xml").openStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.page.setPanelModel(this.panelModel);
        PanelHolder ul = this.panelModel.findPanelHolder("UpperLeft");
        DataGroup uldg = ul.findDataGroup("Grid");
        Legend ullg = ul.findLegend("ColorKey");
        this.createGrid();
        this.dataModel.addData(this.grid, this.gridAttr, ul, uldg, ullg);
        PanelHolder bt = this.panelModel.findPanelHolder("Bottom");
        DataGroup btdg = bt.findDataGroup("TimeSeries");
        this.createTimeSeries();
        this.dataModel.addData(this.timeSeries, this.timeSeriesAttr, bt, btdg, null);
        Layer ly = this.page.getJPane().getFirstLayer();
        System.out.println("First layer = '" + ly.getId() + "'");
        Panel ulPanel = this.page.findPanel(ul);
        Layer firstDG = ulPanel.getFirstDataGroupLayer();
        System.out.println("First dataGroupLayer = '" + firstDG.getId() + "'");
        ValueIconFormat viFrmt_ = new ValueIconFormat("###.##", "###.##");
        String tFrmt_ = "MM-dd HH:mm";
        ValueIcon vi = new ValueIcon(this.getClass().getResource("query.gif"), "value");
        SelectionTool st = new SelectionTool(3);
        st.setHandleFullSized(true);
        st.setGrabColor(new Color(0.85f, 0.85f, 0.0f, 0.5f));
        MeasurementTool mtVert = new MeasurementTool();
        viFrmt_.setTimeFormat(tFrmt_);
        vi.setValueFormat(viFrmt_);
        mtVert.setValueFormat(viFrmt_);
        mtVert.setPointLabel(1);
        mtVert.setDrawRule(false);
        ly.addChild(vi);
        firstDG.addChild(st);
        firstDG.addChild(mtVert);
        vi.setId("local query");
        st.setId("selection tool");
        mtVert.setId("vert measurement tool");
        try {
            vi.setLocationU(new SoTPoint(5.0, 6.4));
            st.setLocationU(new SoTPoint(180.0, 50.0), new SoTPoint(200.0, -50.0));
            st.setConstraints(new SoTPoint(160.0, 50.0), new SoTPoint(260.0, -50.0));
            mtVert.setLocationU(new SoTPoint(200.0, 30.0), new SoTPoint(200.0, -30.0));
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
        vi.setVisible(true);
        vi.setSelectable(true);
        st.setVisible(true);
        st.setSelectable(true);
    }

    private void createTimeSeries() {
        int dir = 4;
        int type = 2;
        GeoDate start = null;
        GeoDate end = null;
        String format = "yyyy-MM-dd HH:mm";
        String min1 = "2001-02-12 00:00";
        String max1 = "2001-06-10 00:00";
        try {
            start = new GeoDate(min1, format);
            end = new GeoDate(max1, format);
        }
        catch (IllegalTimeValue itf) {
            String message = "Illegal time string '" + min1 + "' or '" + max1 + "'\nshould be of the form " + format;
            JOptionPane.showMessageDialog(this, message, "Error in Time Value", 0);
            return;
        }
        float delta = 2.0f;
        float amp = 1.0f;
        float off = 0.0f;
        float per = 5.0f;
        TestData td = new TestData(dir, new TimeRange(start, end), delta, type, amp, off, per);
        this.timeSeries = td.getSGTData();
        this.timeSeriesAttr = new LineAttribute(0, Color.blue.brighter());
    }

    void createGrid() {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int dir = 5;
        int type = 1;
        double min1 = 160.0;
        double max1 = 260.0;
        double delta1 = 2.0;
        Range2D range1 = new Range2D(min1, max1, delta1);
        double min2 = -50.0;
        double max2 = 50.0;
        double delta2 = 2.0;
        Range2D range2 = new Range2D(min2, max2, delta2);
        float amp = 0.5f;
        float off = 0.5f;
        float per = 20.0f;
        TestData td = new TestData(dir, range1, range2, type, amp, off, per);
        this.grid = td.getSGTData();
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        LinearTransform ctrans = new LinearTransform(0.0, (double)red.length, 0.0, 1.0);
        cmap.setTransform(ctrans);
        this.gridAttr = new GridAttribute(0, cmap);
    }

    void jMenuViewReset_actionPerformed(ActionEvent e) {
        this.page.resetZoom();
    }

    void jMenuViewTree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.page.getJPane());
        ct.setVisible(true);
    }

    void jMenuViewMouse_actionPerformed(ActionEvent e) {
        this.beanValue = new BeanDemoValue("Values at Mouse");
        this.beanValue.setVisible(true);
        this.page.addMouseValueListener(this);
    }

    void jMenuEditData_actionPerformed(ActionEvent e) {
        AddDataFrame adf = new AddDataFrame(this.page);
        adf.setVisible(true);
    }

    void jMenuEditPM_actionPerformed(ActionEvent e) {
        PanelModelEditor pme = new PanelModelEditor(this.panelModel);
        pme.setVisible(true);
    }

    void jMenuHelpProps_actionPerformed(ActionEvent e) {
        JSystemPropertiesDialog sysProps = new JSystemPropertiesDialog(this, "System Properties", false);
        sysProps.setVisible(true);
    }

    void jMenuFilePrint_actionPerformed(ActionEvent e) {
        JPane pane = this.page.getJPane();
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this.page, this.pageFormat);
        printJob.setJobName("BeanDemo");
        if (printJob.printDialog()) {
            try {
                RepaintManager currentManager = RepaintManager.currentManager(pane);
                currentManager.setDoubleBufferingEnabled(false);
                printJob.print();
                currentManager.setDoubleBufferingEnabled(true);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    void jMenuFilePage_actionPerformed(ActionEvent e) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        this.pageFormat = pj.pageDialog(this.pageFormat);
    }

    void jMenuEditRemoveAll_actionPerformed(ActionEvent e) {
        this.page.getDataModel().removeAllData();
    }

    @Override
    public void mouseValue(MouseValueEvent event) {
        MouseValue[] mv = event.getMouseValue();
        for (int i = 0; i < mv.length; ++i) {
            if (this.beanValue == null) continue;
            this.beanValue.setMouseValue(mv[0]);
        }
    }
}

