/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.beans.MouseValue;
import gov.noaa.pmel.util.SoTPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BeanDemoValue
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel mainPanel = null;
    private JLabel sgtTitles = null;
    private JLabel jLabel = null;
    private JLabel deviceLoc = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel physicalLoc = null;
    private JLabel userLoc = null;
    private JLabel value = null;
    private DecimalFormat pFormat = new DecimalFormat("0.0000");

    public BeanDemoValue(String title) throws HeadlessException {
        super(title);
        this.initialize();
    }

    public void setMouseValue(MouseValue mv) {
        final String title = "[" + mv.getPageName() + "," + mv.getPanelId() + "," + mv.getDataGroupLayerId() + "]";
        final String dLoc = "(" + mv.getDeviceLocation().x + ", " + mv.getDeviceLocation().y + ")";
        final String pLoc = "(" + this.pFormat.format(mv.getPhysicalLocation().x) + ", " + this.pFormat.format(mv.getPhysicalLocation().y) + ")";
        SoTPoint u = mv.getUserLocation();
        final String uLoc = u.isXTime() ? "(" + u.getX().toString() + ", " + this.pFormat.format(u.getY().getDouble()) + ")" : "(" + this.pFormat.format(u.getX().getDouble()) + ", " + this.pFormat.format(u.getY().getDouble()) + ")";
        final String val = Double.isNaN(mv.getGridValue()) ? "n/a" : this.pFormat.format(mv.getGridValue());
        if (SwingUtilities.isEventDispatchThread()) {
            this.sgtTitles.setText(title);
            this.deviceLoc.setText(dLoc);
            this.physicalLoc.setText(pLoc);
            this.userLoc.setText(uLoc);
            this.value.setText(val);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BeanDemoValue.this.sgtTitles.setText(title);
                        BeanDemoValue.this.deviceLoc.setText(dLoc);
                        BeanDemoValue.this.physicalLoc.setText(pLoc);
                        BeanDemoValue.this.userLoc.setText(uLoc);
                        BeanDemoValue.this.value.setText(val);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initialize() {
        this.setSize(350, 257);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Mouse Location Value");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getMainPanel(), "Center");
        }
        return this.jContentPane;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.insets = new Insets(15, 5, 5, 5);
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridy = 4;
            this.value = new JLabel();
            this.value.setText("");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 3;
            this.userLoc = new JLabel();
            this.userLoc.setText("");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridy = 2;
            this.physicalLoc = new JLabel();
            this.physicalLoc.setText("");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 13;
            gridBagConstraints6.insets = new Insets(15, 5, 5, 5);
            gridBagConstraints6.gridy = 4;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Z Value:");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.gridy = 3;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("User:");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridy = 2;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Physical:");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridy = 1;
            this.deviceLoc = new JLabel();
            this.deviceLoc.setText("");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 1;
            this.jLabel = new JLabel();
            this.jLabel.setText("Device:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.insets = new Insets(5, 5, 15, 5);
            gridBagConstraints1.gridy = 0;
            this.sgtTitles = new JLabel();
            this.sgtTitles.setText("");
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.sgtTitles, gridBagConstraints1);
            this.mainPanel.add((Component)this.jLabel, gridBagConstraints2);
            this.mainPanel.add((Component)this.deviceLoc, gridBagConstraints3);
            this.mainPanel.add((Component)this.jLabel1, gridBagConstraints4);
            this.mainPanel.add((Component)this.jLabel2, gridBagConstraints5);
            this.mainPanel.add((Component)this.jLabel3, gridBagConstraints6);
            this.mainPanel.add((Component)this.physicalLoc, gridBagConstraints7);
            this.mainPanel.add((Component)this.userLoc, gridBagConstraints8);
            this.mainPanel.add((Component)this.value, gridBagConstraints9);
        }
        return this.mainPanel;
    }
}

