/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.TimeAxis;
import gov.noaa.pmel.sgt.demo.JDesktopDemo_resetButton_actionAdapter;
import gov.noaa.pmel.sgt.demo.JDesktopDemo_startButton_actionAdapter;
import gov.noaa.pmel.sgt.demo.JDesktopDemo_stopButton_actionAdapter;
import gov.noaa.pmel.sgt.demo.PseudoRealTimeData;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class JDesktopDemo
extends JApplet
implements PropertyChangeListener {
    PseudoRealTimeData rtData_;
    JPane pane_;
    Layer layer_;
    TimeAxis xbot_;
    PlainAxis yleft_;
    LinearTransform xt_;
    LinearTransform yt_;
    boolean isStandalone = false;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton startButton = new JButton();
    JButton stopButton = new JButton();
    JButton resetButton = new JButton();

    @Override
    public void init() {
        this.rtData_ = new PseudoRealTimeData("rtDataSource", "Sea Level");
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rtData_.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.rtData_));
    }

    private void jbInit() throws Exception {
        this.setSize(new Dimension(800, 440));
        this.getContentPane().setLayout(this.borderLayout1);
        this.startButton.setText("start");
        this.startButton.addActionListener(new JDesktopDemo_startButton_actionAdapter(this));
        this.stopButton.setText("stop");
        this.stopButton.addActionListener(new JDesktopDemo_stopButton_actionAdapter(this));
        this.resetButton.setText("reset");
        this.resetButton.addActionListener(new JDesktopDemo_resetButton_actionAdapter(this));
        this.buttonPanel.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.startButton, null);
        this.buttonPanel.add((Component)this.stopButton, null);
        this.buttonPanel.add((Component)this.resetButton, null);
        this.pane_ = new JPane("Real Time Data Demo", new Dimension(800, 400));
        this.pane_.setBatch(true);
        this.pane_.setLayout(new StackedLayout());
        this.pane_.setBackground(Color.white);
        double xsize = 6.0;
        double xstart = 0.6;
        double xend = 5.5;
        double ysize = 3.0;
        double ystart = 0.6;
        double yend = 2.75;
        SoTRange.GeoDate xrange = (SoTRange.GeoDate)this.rtData_.getXRange();
        SoTRange.Double yrange = (SoTRange.Double)this.rtData_.getYRange();
        this.xt_ = new LinearTransform(xstart, xend, xrange.start, xrange.end);
        this.yt_ = new LinearTransform(ystart, yend, yrange.start, yrange.end);
        this.layer_ = new Layer("Layer 1", new Dimension2D(xsize, ysize));
        this.pane_.add(this.layer_);
        SGLabel title = new SGLabel("title", "Real Time Demo", new Point2D.Double((xstart + xend) / 2.0, ysize - 0.05));
        title.setAlign(0, 1);
        title.setFont(new Font("Serif", 0, 14));
        title.setHeightP(0.25);
        title.setColor(Color.blue.darker());
        this.layer_.addChild(title);
        CartesianGraph graph = new CartesianGraph("Time Graph");
        this.layer_.setGraph(graph);
        graph.setXTransform(this.xt_);
        graph.setYTransform(this.yt_);
        SoTPoint origin = new SoTPoint(xrange.start, yrange.start);
        this.xbot_ = new TimeAxis("Botton Axis", 0);
        this.xbot_.setRangeU(xrange);
        this.xbot_.setLocationU(origin);
        Font xbfont = new Font("Helvetica", 0, 14);
        this.xbot_.setLabelFont(xbfont);
        graph.addXAxis(this.xbot_);
        String yLabel = "Latitude";
        this.yleft_ = new PlainAxis("Left Axis");
        this.yleft_.setRangeU(yrange);
        this.yleft_.setLocationU(origin);
        this.yleft_.setLabelFont(xbfont);
        SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
        Font ytfont = new Font("Helvetica", 0, 14);
        ytitle.setFont(ytfont);
        ytitle.setHeightP(0.2);
        this.yleft_.setTitle(ytitle);
        graph.addYAxis(this.yleft_);
        LineAttribute attr = new LineAttribute();
        graph.setData(this.rtData_, attr);
        this.getContentPane().add((Component)this.pane_, "Center");
        if (!this.isStandalone) {
            this.pane_.setBatch(false);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.rtData_.stopData();
    }

    @Override
    public void destroy() {
        this.rtData_.stopData();
    }

    @Override
    public String getAppletInfo() {
        return "Applet Information";
    }

    public static void main(String[] args) {
        JFrame desk = new JFrame("Desktop Demo");
        desk.setDefaultCloseOperation(3);
        desk.getContentPane().setLayout(new BorderLayout());
        desk.setSize(850, 500);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        desk.setLocation((d.width - desk.getSize().width) / 2, (d.height - desk.getSize().height) / 2);
        JDesktopPane desktop = new JDesktopPane();
        desk.getContentPane().add((Component)desktop, "Center");
        JDesktopDemo applet = new JDesktopDemo();
        applet.isStandalone = true;
        JInternalFrame frame = new JInternalFrame("Real Time Data Demo", false, false, false, true);
        frame.getContentPane().add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(800, 440);
        desktop.add(frame);
        applet.pane_.setBatch(false);
        desk.setVisible(true);
        frame.setVisible(true);
    }

    void startButton_actionPerformed(ActionEvent e) {
        this.rtData_.startData();
    }

    void stopButton_actionPerformed(ActionEvent e) {
        this.rtData_.stopData();
    }

    void resetButton_actionPerformed(ActionEvent e) {
        this.rtData_.stopData();
        this.rtData_.resetData();
        this.resetRange();
    }

    private void resetRange() {
        this.pane_.setBatch(true);
        SoTRange.GeoDate xrange = (SoTRange.GeoDate)this.rtData_.getXRange();
        SoTRange.Double yrange = (SoTRange.Double)this.rtData_.getYRange();
        SoTPoint origin = new SoTPoint(xrange.start, yrange.start);
        this.xt_.setRangeU(xrange);
        this.yt_.setRangeU(yrange);
        this.xbot_.setRangeU(xrange);
        this.xbot_.setLocationU(origin);
        this.yleft_.setRangeU(yrange);
        this.yleft_.setLocationU(origin);
        this.pane_.setBatch(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("rangeModified".equals(evt.getPropertyName())) {
            this.resetRange();
        }
    }
}

