/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import gov.noaa.pmel.sgt.BooleanLookup;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ColorTableLookup;
import gov.noaa.pmel.sgt.DoubleTableLookup;
import gov.noaa.pmel.sgt.GeometryAttribute;
import gov.noaa.pmel.sgt.GeometryParameterAttribute;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.IntegerTableLookup;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.Layer;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.Logo;
import gov.noaa.pmel.sgt.PlainAxis;
import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.StackedLayout;
import gov.noaa.pmel.sgt.dm.GeometryCollection;
import gov.noaa.pmel.sgt.dm.GeometryParameter;
import gov.noaa.pmel.sgt.dm.SimpleGeometry;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Point2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class JGeometryDemo
extends JApplet {
    JButton tree_;
    JButton space_;
    JButton print_;
    JButton printSetup_;
    JButton hideSome_;
    JPane mainPane_;
    PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
    GeometryCollection wrngpts_;
    GeometryCollection lines_;

    public JGeometryDemo() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout(0, 0));
        this.setSize(553, 438);
        this.add((Component)this.makeGraph(), "Center");
    }

    public static void main(String[] args) {
        String gisdbClassName = System.getProperty("gisdb.className", "org.postgresql.Driver");
        try {
            Class.forName(gisdbClassName);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
            System.exit(1);
        }
        JGeometryDemo pd = new JGeometryDemo();
        JFrame frame = new JFrame("Geometry Demo");
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        pd.tree_ = new JButton("Tree View");
        MyAction myAction = pd.new MyAction();
        pd.tree_.addActionListener(myAction);
        button.add(pd.tree_);
        pd.space_ = new JButton("Add Mark");
        pd.space_.addActionListener(myAction);
        pd.print_ = new JButton("Print...");
        pd.print_.addActionListener(myAction);
        pd.printSetup_ = new JButton("Print Setup...");
        pd.printSetup_.addActionListener(myAction);
        pd.hideSome_ = new JButton("Hide Some");
        pd.hideSome_.addActionListener(myAction);
        button.add(pd.space_);
        button.add(pd.print_);
        button.add(pd.printSetup_);
        button.add(pd.hideSome_);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }
        });
        frame.setSize(553, 438);
        JPane graph = pd.makeGraph();
        graph.setBatch(true);
        frame.getContentPane().add((Component)graph, "Center");
        frame.getContentPane().add((Component)button, "South");
        frame.pack();
        frame.setVisible(true);
        graph.setBatch(false);
    }

    JPane makeGraph() {
        this.mainPane_ = new JPane("Geometry Demo", new Dimension(553, 438));
        this.mainPane_.setLayout(new StackedLayout());
        this.mainPane_.setBackground(Color.white);
        try {
            this.lines_ = this.getLineStrings();
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.wrngpts_ = this.getPoints();
        GeometryCollection cntry = this.getPolygons();
        SoTRange.Double xrange = new SoTRange.Double(0.0, 360.0);
        SoTRange.Double yrange = new SoTRange.Double(-72.0, 72.0);
        double xsize = 4.0;
        double xstart = 0.6;
        double xend = 3.5;
        double ysize = 3.0;
        double ystart = 0.6;
        double yend = 2.75;
        Layer cntryLayer = new Layer("Layer 1", new Dimension2D(xsize, ysize));
        this.mainPane_.add(cntryLayer);
        Layer layer = new Layer("Layer 2", new Dimension2D(xsize, ysize));
        this.mainPane_.add(layer);
        Layer lineLayer = new Layer("Layer 3", new Dimension2D(xsize, ysize));
        this.mainPane_.add(lineLayer);
        Image img = this.getToolkit().getImage(this.getClass().getResource("ncBrowse48.gif"));
        if (img != null) {
            MediaTracker mt = new MediaTracker(this);
            try {
                mt.addImage(img, 0);
                mt.waitForAll();
                if (mt.isErrorAny()) {
                    System.err.println("JGeometryDemo: Error loading image");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Logo logo = new Logo(new Point2D.Double(0.0, 0.0), 2, 0);
        logo.setId("ncBrowse logo");
        logo.setImage(img);
        layer.addChild(logo);
        CartesianGraph ptsGraph = new CartesianGraph("Warning Points");
        ptsGraph.setClip(xrange, yrange);
        layer.setGraph(ptsGraph);
        LinearTransform xt = new LinearTransform(xstart, xend, xrange.start, xrange.end);
        LinearTransform yt = new LinearTransform(ystart, yend, yrange.start, yrange.end);
        ptsGraph.setXTransform(xt);
        ptsGraph.setYTransform(yt);
        CartesianGraph cntryGraph = new CartesianGraph("Country");
        cntryGraph.setClip(xrange, yrange);
        cntryGraph.setClipping(true);
        cntryLayer.setGraph(cntryGraph);
        cntryGraph.setXTransform(xt);
        cntryGraph.setYTransform(yt);
        CartesianGraph lineGraph = new CartesianGraph("Line");
        lineLayer.setGraph(lineGraph);
        lineGraph.setXTransform(xt);
        lineGraph.setYTransform(yt);
        String xLabel = "X Label";
        PlainAxis xbot = new PlainAxis("Botton Axis");
        xbot.setRangeU(xrange);
        xbot.setLocationU(new Point2D.Double(xrange.start, yrange.start));
        Font xbfont = new Font("Helvetica", 2, 14);
        xbot.setLabelFont(xbfont);
        SGLabel xtitle = new SGLabel("xaxis title", xLabel, new Point2D.Double(0.0, 0.0));
        Font xtfont = new Font("Helvetica", 0, 14);
        xtitle.setFont(xtfont);
        xtitle.setHeightP(0.16);
        xbot.setTitle(xtitle);
        ptsGraph.addXAxis(xbot);
        String yLabel = "Y Label";
        PlainAxis yleft = new PlainAxis("Left Axis");
        yleft.setRangeU(yrange);
        yleft.setLocationU(new Point2D.Double(xrange.start, yrange.start));
        yleft.setLabelFont(xbfont);
        SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
        Font ytfont = new Font("Helvetica", 0, 14);
        ytitle.setFont(ytfont);
        ytitle.setHeightP(0.16);
        yleft.setTitle(ytitle);
        ptsGraph.addYAxis(yleft);
        double[] sizes = new double[]{0.08, 0.07, 0.06};
        Color[] colors = new Color[]{Color.red, Color.yellow, Color.green};
        int[] codes = new int[]{45, 46, 51};
        DoubleTableLookup mSize = new DoubleTableLookup(sizes);
        ColorTableLookup mColor = new ColorTableLookup(colors);
        IntegerTableLookup mCode = new IntegerTableLookup(codes);
        BooleanLookup mVisible = new BooleanLookup(0.5, 0);
        GeometryParameter[] gParam = new GeometryParameter[]{GeometryParameter.FillColor, GeometryParameter.MarkCode, GeometryParameter.MarkSize, GeometryParameter.Visible};
        GeometryParameterAttribute[] gAttribute = new GeometryParameterAttribute[]{mColor, mCode, mSize, mVisible};
        GeometryAttribute gattr = new GeometryAttribute(gParam, gAttribute);
        gattr.setDefaultFillColor(Color.red);
        gattr.setMarkOutlineColor(Color.black);
        gattr.setMarkOutline(true);
        gattr.setLabelPosition(2);
        Font pfont = new Font("Helvetica", 0, 12);
        gattr.setLabelFont(pfont);
        gattr.setLabelColor(Color.blue);
        gattr.setLabelHeightP(0.08);
        gattr.setDrawLabel(true);
        ptsGraph.setData(this.wrngpts_, gattr);
        GeometryAttribute cattr = new GeometryAttribute();
        cntryGraph.setData(cntry, cattr);
        GeometryAttribute lattr = new GeometryAttribute();
        LineAttribute la = lattr.getOutlineAttribute();
        la.setStyle(2);
        la.setColor(Color.red);
        lineGraph.setData(this.lines_, lattr);
        return this.mainPane_;
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(this.mainPane_);
        ct.setVisible(true);
    }

    void print_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this.mainPane_, this.pageFormat);
        printJob.setJobName("Grid Demo");
        if (printJob.printDialog()) {
            try {
                Color saveColor = this.mainPane_.getBackground();
                if (!saveColor.equals(Color.white)) {
                    this.mainPane_.setBackground(Color.white);
                }
                this.mainPane_.setPageAlign(0, 1);
                RepaintManager currentManager = RepaintManager.currentManager(this.mainPane_);
                currentManager.setDoubleBufferingEnabled(false);
                printJob.print();
                currentManager.setDoubleBufferingEnabled(true);
                this.mainPane_.setBackground(saveColor);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeometryCollection getPoints() {
        GeometryCollection points = new GeometryCollection();
        String hostURL = System.getProperty("gisdb.url", "jdbc:postgresql://localhost/sift_gis");
        String user = System.getProperty("gisdb.user", "sift");
        String password = System.getProperty("gisdb.password", "drowssap");
        WKTReader reader = new WKTReader();
        Connection con = null;
        try {
            con = DriverManager.getConnection(hostURL, user, password);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        SimpleGeometry sm = null;
        int count = 0;
        try {
            Statement state = con.createStatement();
            String query = "SELECT code,asText(location) FROM warningpoint ORDER BY code ASC;";
            ResultSet set = state.executeQuery(query);
            while (set.next()) {
                ++count;
                String code = set.getString("code");
                String point = set.getString(2);
                Geometry geom = reader.read(point);
                double mCode = 0.0;
                double mSize = 0.0;
                double mColor = 0.0;
                if (count % 6 == 0) {
                    mSize = 2.0;
                    mColor = 2.0;
                } else if (count % 3 == 0) {
                    mSize = 1.0;
                    mColor = 1.0;
                }
                if (count % 4 == 0) {
                    mCode = 2.0;
                } else if (count % 2 == 0) {
                    mCode = 1.0;
                }
                double[] values = new double[]{mColor, mCode, mSize, 1.0};
                sm = new SimpleGeometry(geom, values, code.trim());
                points.add(sm);
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        finally {
            this.closeConnection(con);
        }
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeometryCollection getPolygons() {
        GeometryCollection polys = new GeometryCollection();
        String hostURL = System.getProperty("gisdb.url", "jdbc:postgresql://localhost/sift_gis");
        String user = System.getProperty("gisdb.user", "sift");
        String password = System.getProperty("gisdb.password", "drowssap");
        WKTReader reader = new WKTReader();
        Connection con = null;
        try {
            con = DriverManager.getConnection(hostURL, user, password);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        SimpleGeometry sm = null;
        try {
            Statement state = con.createStatement();
            String query = "SELECT cntry_name,sqkm_cntry,asText(the_geom) FROM country;";
            ResultSet set = state.executeQuery(query);
            while (set.next()) {
                String name = set.getString("cntry_name");
                double sqkm = set.getDouble("sqkm_cntry");
                String point = set.getString(3);
                try {
                    Geometry geom = reader.read(point);
                    sm = new SimpleGeometry(geom, sqkm, name);
                    polys.add(sm);
                }
                catch (ParseException pe) {
                    System.err.println("ParseException: " + point);
                }
            }
        }
        catch (SQLException se) {
            se.printStackTrace();
        }
        finally {
            this.closeConnection(con);
        }
        return polys;
    }

    GeometryCollection getLineStrings() throws ParseException {
        GeometryCollection lines = new GeometryCollection();
        Geometry l1 = new WKTReader().read("LINESTRING (200 50, 200 40)");
        Geometry l2 = new WKTReader().read("LINESTRING (190 45, 210 45)");
        Geometry l3 = new WKTReader().read("LINESTRING (190 40, 210 50)");
        Geometry l4 = new WKTReader().read("LINESTRING (190 50, 210 40)");
        lines.add(new SimpleGeometry(l1, "LineString"));
        lines.add(new SimpleGeometry(l2, ""));
        lines.add(new SimpleGeometry(l3, ""));
        lines.add(new SimpleGeometry(l4, ""));
        lines.add(new SimpleGeometry(this.getMultiLineStrings(), "MultiLineString"));
        return lines;
    }

    LineString getLineString() {
        Geometry l1 = null;
        try {
            l1 = new WKTReader().read("LINESTRING (200 50, 200 40)");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return (LineString)l1;
    }

    MultiLineString getMultiLineStrings() {
        GeometryFactory gf = new GeometryFactory();
        LineString[] mlines = new LineString[4];
        Coordinate[] coords = new Coordinate[]{new Coordinate(200.0, 10.0), new Coordinate(200.0, 0.0)};
        mlines[0] = new LineString(new CoordinateArraySequence(coords), gf);
        coords = new Coordinate[]{new Coordinate(230.0, 5.0), new Coordinate(250.0, 5.0)};
        mlines[1] = new LineString(new CoordinateArraySequence(coords), gf);
        coords = new Coordinate[]{new Coordinate(210.0, -10.0), new Coordinate(230.0, -20.0)};
        mlines[2] = new LineString(new CoordinateArraySequence(coords), gf);
        coords = new Coordinate[]{new Coordinate(210.0, 20.0), new Coordinate(230.0, 10.0)};
        mlines[3] = new LineString(new CoordinateArraySequence(coords), gf);
        MultiLineString mls = new MultiLineString(mlines, gf);
        return mls;
    }

    private void closeConnection(Connection con) {
        if (con == null) {
            return;
        }
        try {
            con.close();
        }
        catch (SQLException ex) {
            System.err.println("Error closing database connection");
            ex.printStackTrace();
        }
    }

    ColorMap createColorMap(Range2D datar) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    private void jbInit() throws Exception {
    }

    class MyAction
    implements ActionListener {
        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JGeometryDemo.this.space_) {
                System.out.println("  <<Mark>>");
            }
            if (obj == JGeometryDemo.this.tree_) {
                JGeometryDemo.this.tree_actionPerformed(event);
            }
            if (obj == JGeometryDemo.this.print_) {
                JGeometryDemo.this.print_actionPerformed(event);
            }
            if (obj == JGeometryDemo.this.printSetup_) {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                JGeometryDemo.this.pageFormat = printJob.pageDialog(JGeometryDemo.this.pageFormat);
            }
            if (obj == JGeometryDemo.this.hideSome_) {
                System.out.println("hiding points if color value > 1");
                Iterator iter = JGeometryDemo.this.wrngpts_.iterator();
                JGeometryDemo.this.mainPane_.setBatch(true);
                while (iter.hasNext()) {
                    SimpleGeometry sg = (SimpleGeometry)iter.next();
                    double v = sg.getValue(0);
                    if (!(v >= 1.0)) continue;
                    sg.setValue(3, 0.0);
                }
                JGeometryDemo.this.mainPane_.setBatch(false);
            }
        }
    }
}

