/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.sgt.demo;

import gov.noaa.pmel.sgt.Attribute;
import gov.noaa.pmel.sgt.CartesianGraph;
import gov.noaa.pmel.sgt.CartesianRenderer;
import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.GridAttribute;
import gov.noaa.pmel.sgt.GridCartesianRenderer;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.JPane;
import gov.noaa.pmel.sgt.LineAttribute;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.sgt.demo.TestData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.sgt.dm.SimpleLine;
import gov.noaa.pmel.sgt.swing.JClassTree;
import gov.noaa.pmel.sgt.swing.JPlotLayout;
import gov.noaa.pmel.sgt.swing.prop.GridAttributeDialog;
import gov.noaa.pmel.util.Dimension2D;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.Rectangle2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RepaintManager;

public class JGridDemo
extends JApplet {
    static JPlotLayout rpl_;
    private GridAttribute gridAttr_;
    JButton edit_;
    JButton space_ = null;
    JButton tree_;
    JButton print_;
    JButton layout_;
    PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
    SimpleLine sLine_ = null;

    @Override
    public void init() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.setSize(600, 550);
        JPanel main = new JPanel();
        rpl_ = this.makeGraph();
        JPanel button = this.makeButtonPanel(false);
        rpl_.setBatch(true);
        main.add((Component)rpl_, "Center");
        JPane gridKeyPane = rpl_.getKeyPane();
        gridKeyPane.setSize(new Dimension(600, 100));
        main.add((Component)gridKeyPane, "South");
        this.getContentPane().add((Component)main, "Center");
        this.getContentPane().add((Component)button, "South");
        rpl_.setBatch(false);
    }

    JPanel makeButtonPanel(boolean mark) {
        MyAction myAction = new MyAction();
        JPanel button = new JPanel();
        button.setLayout(new FlowLayout());
        this.print_ = new JButton("Print...");
        this.print_.addActionListener(myAction);
        button.add(this.print_);
        this.layout_ = new JButton("Page Layout...");
        this.layout_.addActionListener(myAction);
        button.add(this.layout_);
        this.tree_ = new JButton("Tree View");
        this.tree_.addActionListener(myAction);
        button.add(this.tree_);
        this.edit_ = new JButton("Edit GridAttribute");
        this.edit_.addActionListener(myAction);
        button.add(this.edit_);
        if (mark) {
            this.space_ = new JButton("Add Mark");
            this.space_.addActionListener(myAction);
            button.add(this.space_);
        }
        return button;
    }

    public static void main(String[] args) {
        JGridDemo gd = new JGridDemo();
        JFrame frame = new JFrame("Grid Demo");
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        frame.setSize(600, 500);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                JFrame fr = (JFrame)event.getSource();
                fr.setVisible(false);
                fr.dispose();
                System.exit(0);
            }

            @Override
            public void windowOpened(WindowEvent event) {
                rpl_.getKeyPane().repaint();
            }
        });
        JPanel button = gd.makeButtonPanel(true);
        rpl_ = gd.makeGraph();
        rpl_.setBatch(true);
        main.add((Component)rpl_, "Center");
        JPane gridKeyPane = rpl_.getKeyPane();
        gridKeyPane.setBatch(true);
        gridKeyPane.setSize(new Dimension(600, 100));
        rpl_.setKeyLayerSizeP(new Dimension2D(6.0, 1.0));
        rpl_.setKeyBoundsP(new Rectangle2D.Double(0.0, 1.0, 6.0, 1.0));
        main.add((Component)gridKeyPane, "South");
        frame.getContentPane().add((Component)main, "Center");
        frame.getContentPane().add((Component)button, "South");
        Object foo = null;
        Object bar = null;
        Object foobutton = null;
        Object barbutton = null;
        frame.pack();
        frame.setVisible(true);
        gridKeyPane.setBatch(false);
        rpl_.setBatch(false);
    }

    void edit_actionPerformed(ActionEvent e) {
        GridAttributeDialog gad = new GridAttributeDialog();
        gad.setJPane(rpl_);
        CartesianRenderer rend = ((CartesianGraph)rpl_.getFirstLayer().getGraph()).getRenderer();
        gad.setGridCartesianRenderer((GridCartesianRenderer)rend);
        gad.setVisible(true);
    }

    void tree_actionPerformed(ActionEvent e) {
        JClassTree ct = new JClassTree();
        ct.setModal(false);
        ct.setJPane(rpl_);
        ct.setVisible(true);
    }

    void print_actionPerformed(ActionEvent e) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(rpl_, this.pageFormat);
        printJob.setJobName("Grid Demo");
        if (printJob.printDialog()) {
            try {
                Color saveColor = rpl_.getBackground();
                if (!saveColor.equals(Color.white)) {
                    rpl_.setBackground(Color.white);
                }
                rpl_.setPageAlign(0, 1);
                RepaintManager currentManager = RepaintManager.currentManager(rpl_);
                currentManager.setDoubleBufferingEnabled(false);
                printJob.print();
                currentManager.setDoubleBufferingEnabled(true);
                rpl_.setBackground(saveColor);
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    void layout_actionPerformed(ActionEvent e) {
        PrinterJob pj = PrinterJob.getPrinterJob();
        this.pageFormat = pj.pageDialog(this.pageFormat);
    }

    JPlotLayout makeGraph() {
        Range2D xr = new Range2D(190.0, 250.0, 1.0);
        Range2D yr = new Range2D(0.0, 45.0, 1.0);
        TestData td = new TestData(5, xr, yr, 3, 12.0f, 30.0f, 5.0f);
        SGTData newData = td.getSGTData();
        JPlotLayout rpl = new JPlotLayout(true, false, false, "JGridDemo Pane", null, true);
        rpl.setEditClasses(false);
        Range2D datar = new Range2D(-20.0, 45.0, 5.0);
        ContourLevels clevels = ContourLevels.getDefault(datar);
        this.gridAttr_ = new GridAttribute(clevels);
        ColorMap cmap = this.createColorMap(datar);
        this.gridAttr_.setColorMap(cmap);
        this.gridAttr_.setStyle(3);
        rpl.addData(newData, (Attribute)this.gridAttr_, "First Data");
        rpl.setTitles("Raster Plot Demo", "using a JPlotLayout", "");
        double[] x = new double[]{200.0, 210.0, 220.0, 230.0, 240.0};
        double[] y = new double[]{5.0, 15.0, 20.0, 30.0, 35.0};
        this.sLine_ = new SimpleLine(x, y, "Dynamic Line");
        this.sLine_.setXMetaData(new SGTMetaData());
        this.sLine_.setYMetaData(new SGTMetaData());
        LineAttribute lAttr = new LineAttribute(2, Color.white);
        this.sLine_.setDynamic(true);
        rpl.addData(this.sLine_, (Attribute)lAttr, "Second Data");
        rpl.setSize(new Dimension(600, 400));
        return rpl;
    }

    ColorMap createColorMap(Range2D datar) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    class MyAction
    implements ActionListener {
        int count = 0;

        MyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object obj = event.getSource();
            if (obj == JGridDemo.this.edit_) {
                JGridDemo.this.edit_actionPerformed(event);
            } else if (obj == JGridDemo.this.space_) {
                System.out.println("  <<Mark>>");
                double[][] yy = new double[][]{{5.0, 17.0, 18.0, 28.0, 35.0}, {10.0, 19.0, 14.0, 27.0, 38.0}, {12.0, 14.0, 21.0, 29.0, 35.0}, {15.0, 12.0, 25.0, 31.0, 38.0}, {17.0, 8.0, 27.0, 33.0, 35.0}};
                if (this.count >= 5) {
                    this.count = 0;
                }
                double[] y = yy[this.count++];
                JGridDemo.this.sLine_.setYArray(y);
            } else if (obj == JGridDemo.this.tree_) {
                JGridDemo.this.tree_actionPerformed(event);
            } else if (obj == JGridDemo.this.print_) {
                JGridDemo.this.print_actionPerformed(event);
            } else if (obj == JGridDemo.this.layout_) {
                JGridDemo.this.layout_actionPerformed(event);
            }
        }
    }
}

